/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.material.AbstractMaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupDetialCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupDetialInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.common.EASBizException;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;

public class MaterialInfo
extends AbstractMaterialInfo
implements Serializable,
Comparable {
    private static final long serialVersionUID = -5809782578372943999L;
    public static final String PARAM_NON_LEAF = "NonLeafAddNew";
    public static final String PARAM_MERGE_QUERY = "isMaterMergeCommonQuery";

    public MaterialInfo() {
    }

    protected MaterialInfo(String pkField) {
        super(pkField);
    }

    public String getDisplayName() {
        if (this.getMaterialGroup() == null || this.getMaterialGroup().getDisplayName() == null) {
            return this.getName();
        }
        return this.getMaterialGroup().getDisplayName() + "_" + this.getName();
    }

    public String getDisplayName(Locale locale) {
        if (this.getMaterialGroup() == null || this.getMaterialGroup().getDisplayName(locale) == null) {
            return this.getName(locale);
        }
        return this.getMaterialGroup().getDisplayName(locale) + "_" + this.getName(locale);
    }

    public int compareTo(Object arg0) {
        if (this.getNumber() != null && arg0 != null && arg0 instanceof MaterialInfo) {
            return this.getNumber().compareTo(((MaterialInfo)arg0).getNumber());
        }
        return -1;
    }

    public void checkGroupIsLeaf(Context ctx) throws BOSException, EASBizException {
        MaterialGroupDetialCollection groupDetails = this.getMaterialGroupDetails();
        MaterialGroupDetialInfo detialInfo = null;
        MaterialGroupInfo group = null;
        for (int i = 0; i < groupDetails.size(); ++i) {
            detialInfo = groupDetails.get(i);
            group = detialInfo.getMaterialGroup();
            if (group == null) continue;
            MaterialGroupInfo group2 = null;
            group2 = ctx != null ? new MaterialGroup(ctx).getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(group.getId())) : new MaterialGroup().getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(group.getId()));
            if (group2 == null || group2.isIsLeaf()) continue;
            throw new MaterialBaseException(MaterialBaseException.NONLEAFADDNEW, new Object[]{" " + group2.getNumber() + " (" + group2.getName() + ") "});
        }
    }

    public Map getMap() {
        return this.values;
    }

    public static boolean isAllowNonLeafGroup() {
        return MaterialUtil.getBooleanParam(null, PARAM_NON_LEAF, false);
    }

    public static boolean isAllowNonLeafGroup(Context ctx) {
        return MaterialUtil.getBooleanParam(ctx, PARAM_NON_LEAF, false);
    }

    public static boolean isMergeCommonQuery(String orgId) {
        return MaterialUtil.getBooleanParam(null, PARAM_MERGE_QUERY, orgId, false);
    }

    public void verify() throws BOSException, EASBizException {
        this.verify(null);
    }

    public void verify(Context ctx) throws BOSException, EASBizException {
        if (ctx != null) {
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"number", (int)80);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"name", (int)255);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"name_l1", (int)255);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"name_l2", (int)255);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"name_l3", (int)255);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"model", (int)255);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"model", (int)255);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"model", (int)255);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"pictureNumber", (int)80);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"shortName", (int)80);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"warrantnumber", (int)80);
            CSSPUtils.checMaxkLen((Context)ctx, (AbstractObjectValue)this, (String)"registeredmark", (int)80);
        }
    }
}

