/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.master.material.AsstAttrBasicTypeFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrBasicTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeDetailCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeDetailFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeDetailInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrException;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrBasicType;
import com.kingdee.eas.basedata.master.material.IAsstAttrCompondingTypeDetail;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.app.AbstractAsstAttrBasicTypeControllerBean;
import com.kingdee.eas.basedata.master.material.util.AsstAttrMappingFieldsUtil;
import com.kingdee.eas.basedata.master.material.util.AsstAttrSeparator;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class AsstAttrBasicTypeControllerBean
extends AbstractAsstAttrBasicTypeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.AsstAttrBasicTypeControllerBean");
    public static HashMap<String, HashMap<String, Integer>> defCache = new HashMap();

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AsstAttrBasicTypeInfo info = (AsstAttrBasicTypeInfo)model;
        this.checkNameAndNumber(ctx, model);
        this.checkEntryNameAndNumber(ctx, model);
        if (info.getId() != null) {
            this._checkValueReference(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
        }
        boolean isMod = false;
        if (info.getId() != null) {
            isMod = this.isAsstAttrValueModified(ctx, info);
        }
        super._submit(ctx, pk, model);
        if (isMod) {
            this.syncValueName(ctx, info);
        }
        this.updateMappingField(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AsstAttrValueCollection oldValues;
        this.checkNameAndNumber(ctx, model);
        IAsstAttrValue ivalue = AsstAttrValueFactory.getLocalInstance(ctx);
        AsstAttrBasicTypeInfo newType = (AsstAttrBasicTypeInfo)model;
        AsstAttrValueCollection newValues = newType.getValue();
        AsstAttrValueCollection asstAttrValueCollection = oldValues = newType.getId() == null ? new AsstAttrValueCollection() : ivalue.getAsstAttrValueCollection("where basictype.id = '" + newType.getId() + "'");
        if (newType.getMappingField() == null) {
            try {
                newType.setMappingField(AsstAttrMappingFieldsUtil.generateAMappingField());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        HashMap<String, AsstAttrValueCollection> data = this.checkAndReturnData(ctx, oldValues, newValues);
        AsstAttrValueCollection addData = data.get("add");
        AsstAttrValueCollection updateData = data.get("update");
        if (updateData != null && updateData.size() > 0) {
            this.syncRefrenceName(ctx, newType, updateData);
        }
        if (this.isNameModify(ctx, newType)) {
            Iterator it = newType.getValue().iterator();
            AsstAttrValueInfo value = null;
            while (it.hasNext()) {
                value = (AsstAttrValueInfo)it.next();
                value.setType(newType.getName());
            }
        }
        IObjectPK pk = super._submit(ctx, model);
        if (addData != null && addData.size() > 0) {
            this.updateMappingFieldAndType(ctx, newType, addData);
        }
        return pk;
    }

    private boolean isNameModify(Context ctx, AsstAttrBasicTypeInfo newType) throws BOSException, EASBizException {
        boolean ismodify = false;
        IAsstAttrBasicType iBasicType = AsstAttrBasicTypeFactory.getLocalInstance(ctx);
        if (newType.getId() != null) {
            AsstAttrBasicTypeInfo basicType = iBasicType.getAsstAttrBasicTypeInfo((IObjectPK)new ObjectUuidPK(newType.getId()));
            ismodify = !basicType.getName().equals(newType.getName());
        }
        return ismodify;
    }

    private void updateMappingFieldAndType(Context ctx, AsstAttrBasicTypeInfo newType, AsstAttrValueCollection addData) throws BOSException, EASBizException {
        String mappingField = newType.getMappingField();
        String typeName = newType.getName();
        String updateSql = " update t_bd_asstattrvalue set ftype = ?,f" + mappingField + " = ? where fid = ?";
        Connection cn = null;
        PreparedStatement stmt = null;
        try {
            cn = this.getConnection(ctx);
            stmt = cn.prepareStatement(updateSql);
            Iterator it = addData.iterator();
            AsstAttrValueInfo value = null;
            while (it.hasNext()) {
                value = (AsstAttrValueInfo)it.next();
                stmt.setString(1, typeName);
                stmt.setString(2, value.getId().toString());
                stmt.setString(3, value.getId().toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("updateSql is :" + updateSql));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
    }

    private HashMap<String, AsstAttrValueCollection> checkAndReturnData(Context ctx, AsstAttrValueCollection oldValues, AsstAttrValueCollection newValues) throws BOSException, EASBizException {
        AsstAttrValueCollection addValues = new AsstAttrValueCollection();
        AsstAttrValueCollection updateValues = new AsstAttrValueCollection();
        HashMap<String, AsstAttrValueCollection> result = new HashMap<String, AsstAttrValueCollection>();
        result.put("add", addValues);
        result.put("update", updateValues);
        if (oldValues.size() == 0 || newValues.size() == 0) {
            addValues.addCollection(newValues);
            return result;
        }
        HashMap<String, String> nameMap = new HashMap<String, String>(){

            @Override
            public String get(Object key) {
                return StringUtils.cnulls((String)((String)super.get(key)));
            }
        };
        HashMap<String, String> numberMap = new HashMap<String, String>(){

            @Override
            public String get(Object key) {
                return StringUtils.cnulls((String)((String)super.get(key)));
            }
        };
        AsstAttrValueInfo oldValue = null;
        for (int i = 0; i < oldValues.size(); ++i) {
            oldValue = oldValues.get(i);
            nameMap.put(oldValue.getName(), oldValue.getId().toString());
            numberMap.put(oldValue.getNumber(), oldValue.getId().toString());
        }
        AsstAttrValueInfo newValue = null;
        String newNumber = null;
        boolean isNameDul = false;
        boolean isNumberDul = false;
        boolean isNameOrNumMod = false;
        for (int i = 0; i < newValues.size(); ++i) {
            newValue = newValues.get(i);
            String newId = StringUtils.cnulls((Object)newValue.getId());
            String newName = newValue.getName();
            newNumber = newValue.getNumber();
            isNameOrNumMod = !((String)nameMap.get(newName)).equals(newId) || !((String)numberMap.get(newNumber)).equals(newId);
            isNameDul = !StringUtils.isEmpty((String)((String)nameMap.get(newName))) && !((String)nameMap.get(newName)).equals(newId);
            boolean bl = isNumberDul = !StringUtils.isEmpty((String)((String)numberMap.get(newNumber))) && !((String)numberMap.get(newNumber)).equals(newId);
            if (isNameDul || isNumberDul) {
                logger.error((Object)("newId is :" + newId));
                logger.error((Object)("isNameDul is :" + isNameDul));
                logger.error((Object)("isNumberDul is :" + isNumberDul));
                logger.error((Object)("the newName is :" + newName + " and the id in nameMap is :" + (String)nameMap.get(newName)));
                logger.error((Object)("the newNumber is :" + newName + " and the id in numberMap is :" + (String)numberMap.get(newName)));
                throw new AsstAttrException(AsstAttrException.VALUE_EXSISTS);
            }
            if (newId != null && isNameOrNumMod) {
                updateValues.add(newValue);
                continue;
            }
            if (newId != null) continue;
            addValues.add(newValue);
        }
        return result;
    }

    private void checkEntryNameAndNumber(Context ctx, IObjectValue model) throws BOSException, AsstAttrException {
        AsstAttrBasicTypeInfo infoNew = (AsstAttrBasicTypeInfo)model;
        AsstAttrValueCollection collNew = infoNew.getValue();
        IAsstAttrValue iValue = AsstAttrValueFactory.getLocalInstance(ctx);
        AsstAttrValueCollection collOld = new AsstAttrValueCollection();
        if (infoNew.getId() != null) {
            collOld = iValue.getAsstAttrValueCollection("where basictype.id='" + infoNew.getId().toString() + "'");
        }
        HashMap<String, AsstAttrValueInfo> collOldMap = new HashMap<String, AsstAttrValueInfo>();
        AsstAttrValueInfo temp = null;
        int count = collOld.size();
        for (int i = 0; i < count; ++i) {
            temp = collOld.get(i);
            collOldMap.put(temp.getId().toString(), temp);
        }
        AsstAttrValueInfo oldValue = null;
        AsstAttrValueInfo newValue = null;
        int count2 = collNew.size();
        for (int i = 0; i < count2; ++i) {
            newValue = collNew.get(i);
            if (newValue.getId() != null) {
                oldValue = (AsstAttrValueInfo)collOldMap.get(newValue.getId().toString());
                if (newValue.getName().equals(oldValue.getName()) && newValue.getNumber().equals(oldValue.getNumber())) continue;
                this.checkUpdateNewNameOrNumberDul(newValue, collNew);
                continue;
            }
            this.checkAddNewNameOrNumberDul(newValue, collNew);
        }
    }

    private void checkAddNewNameOrNumberDul(AsstAttrValueInfo newValue, AsstAttrValueCollection collNew) throws AsstAttrException {
        AsstAttrValueInfo temp = null;
        int findNameCount = 0;
        int findNumberCount = 0;
        int count = collNew.size();
        for (int i = 0; i < count; ++i) {
            temp = collNew.get(i);
            if (newValue.getName().equals(temp.getName())) {
                ++findNameCount;
            }
            if (!newValue.getNumber().equals(temp.getNumber())) continue;
            ++findNumberCount;
        }
        if (findNameCount > 1 || findNumberCount > 1) {
            throw new AsstAttrException(AsstAttrException.VALUE_EXSISTS);
        }
    }

    private void checkUpdateNewNameOrNumberDul(AsstAttrValueInfo newValue, AsstAttrValueCollection collNew) throws AsstAttrException {
        AsstAttrValueInfo temp = null;
        int count = collNew.size();
        for (int i = 0; i < count; ++i) {
            temp = collNew.get(i);
            if (newValue.getId().equals((Object)temp.getId()) || !newValue.getNumber().equals(temp.getNumber()) && !newValue.getName().equals(temp.getName())) continue;
            throw new AsstAttrException(AsstAttrException.VALUE_EXSISTS);
        }
    }

    private void checkNumberNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.get("number").toString();
        String name = model.get("name").toString();
        String id = null;
        if (model.get("id") != null) {
            id = model.get("id").toString();
        }
        Connection cn = this.getConnection(ctx);
        String lang = ctx.getLocale().toString();
        String sql = "select Top 1 FNumber,FName_" + lang + " from V_BD_AsstAttrType where FName_" + lang + "='" + name + "'and FID <> '" + id + "' or FNumber='" + number + "'";
        if (id != null) {
            sql = sql + "and FID <> '" + id + "'";
        }
        RowSet rs = null;
        try {
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            if (rs.next()) {
                if (rs.getString(1).toString().equals(number)) {
                    throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{number});
                }
                throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{name});
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        catch (EASBizException e2) {
            throw e2;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private void checkNameAndNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNumberBlank(ctx, model);
        this.checkNumberNameDup(ctx, model);
    }

    protected void updateMappingFieldAndType(Context ctx, IObjectValue model, int between) throws EASBizException, BOSException {
        IAsstAttrValue iValue = AsstAttrValueFactory.getLocalInstance(ctx);
        AsstAttrBasicTypeInfo info = (AsstAttrBasicTypeInfo)model;
        AsstAttrValueCollection coll = info.getValue();
        int newValueSzie = coll.size();
        if (between > 0) {
            for (int i = 1; i <= between; ++i) {
                AsstAttrValueInfo valueInfo = coll.get(newValueSzie - i);
                valueInfo.setString(info.getMappingField(), valueInfo.getId().toString());
                valueInfo.setType(info.toString());
                iValue.submit(valueInfo);
            }
        }
    }

    private void updateMappingField(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AsstAttrBasicTypeInfo info = (AsstAttrBasicTypeInfo)model;
        IAsstAttrValue iValue = AsstAttrValueFactory.getLocalInstance(ctx);
        AsstAttrValueCollection coll = iValue.getAsstAttrValueCollection("where basictype.id='" + info.getId().toString() + "'");
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                AsstAttrValueInfo valueInfo = coll.get(i);
                valueInfo.setString(info.getMappingField(), valueInfo.getId().toString());
                valueInfo.setType(valueInfo.getName());
                iValue.submit(valueInfo);
            }
        }
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkReference(ctx, pk);
        super.delete(ctx, pk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReference(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Connection cn;
        Statement stat2;
        ResultSet rs;
        block5: {
            rs = null;
            stat2 = null;
            boolean found = false;
            cn = this.getConnection(ctx);
            String sql = "select 1 where exists( select 1 from t_bd_material where FAssistAttr = '" + pk.toString() + "')";
            try {
                stat2 = cn.createStatement();
                rs = stat2.executeQuery(sql);
                if (rs.next()) {
                    found = true;
                }
                if (!found) break block5;
                throw new AsstAttrException(AsstAttrException.REF_BY_MATERIAL);
            }
            catch (SQLException e2) {
                try {
                    logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e2));
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    SQLUtils.cleanup((Statement)stat2);
                    SQLUtils.cleanup((Connection)cn);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs);
                SQLUtils.cleanup((Statement)stat2);
                SQLUtils.cleanup((Connection)cn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)stat2);
        SQLUtils.cleanup((Connection)cn);
    }

    private void _checkValueReference(Context ctx, IObjectPK pk, AsstAttrBasicTypeInfo model) throws BOSException, EASBizException {
        AsstAttrValueCollection newColl = model.getValue();
        IAsstAttrValue iValue = AsstAttrValueFactory.getLocalInstance(ctx);
        AsstAttrValueCollection oldColl = iValue.getAsstAttrValueCollection("where basictype.id='" + pk.toString() + "'");
        int n = oldColl.size();
        for (int i = 0; i < n; ++i) {
            AsstAttrValueInfo oldInfo = oldColl.get(i);
            String oldId = oldInfo.getId().toString();
            boolean bingo = false;
            int m = newColl.size();
            for (int j = 0; j < m; ++j) {
                String newId;
                if (newColl.get(j).getId() == null || !oldId.equals(newId = newColl.get(j).getId().toString())) continue;
                bingo = true;
                break;
            }
            if (bingo) continue;
            iValue.isReferenced((IObjectPK)new ObjectUuidPK(oldId));
        }
    }

    @Override
    protected void _synAsstAttr(Context ctx, String basicTypeID) throws BOSException, EASBizException {
        if (basicTypeID == null || basicTypeID.length() == 0) {
            return;
        }
        SQLUtil sb = new SQLUtil();
        sb.appendSql(" insert into T_BD_MaterialAsstAttrValue(FID,FMaterialID,FAsstAttrValueID) ");
        sb.appendSql(" select newbosid('AEAA1BF0'),T_BD_MATERIAL.FID,T_BD_AsstAttrValue.FID ");
        sb.appendSql(" from T_BD_MATERIAL,T_BD_AsstAttrValue ");
        sb.appendSql(" where (T_BD_MATERIAL.FAssistAttr = T_BD_AsstAttrValue.FBasictypeID ) ");
        sb.appendSql(" and not exists(select 1 from T_BD_MaterialAsstAttrValue a where a.FMaterialID=T_BD_MATERIAL.FID and a.FAsstAttrValueID = T_BD_AsstAttrValue.FID) ");
        sb.appendSql(" and  T_BD_MATERIAL.FAssistAttr = '").appendSql(basicTypeID).appendSql("'");
        sb.appendSql(" and T_BD_AsstAttrValue.FDELETEDSTATUS=1");
        sb.execute(ctx);
    }

    protected boolean isRefByCompoundingValue(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AsstAttrBasicTypeInfo asstAttrBasicTypeInfo = (AsstAttrBasicTypeInfo)model;
        if (asstAttrBasicTypeInfo.getId() == null) {
            return false;
        }
        String sAsstAttrBasicTypeId = asstAttrBasicTypeInfo.getId().toString();
        IAsstAttrCompondingTypeDetail asstDetail = AsstAttrCompondingTypeDetailFactory.getLocalInstance(ctx);
        return asstDetail.exists("where basictype.id='" + sAsstAttrBasicTypeId + "'");
    }

    protected AsstAttrValueCollection[] getAsstAttrValueModified(Context ctx, AsstAttrValueCollection collNew, AsstAttrValueCollection collOld) throws BOSException, EASBizException {
        int i;
        HashSet<String> idSet = new HashSet<String>();
        HashMap<String, AsstAttrValueInfo> oldInfoMap = new HashMap<String, AsstAttrValueInfo>();
        HashMap<String, AsstAttrValueInfo> newInfoMap = new HashMap<String, AsstAttrValueInfo>();
        AsstAttrValueCollection addData = new AsstAttrValueCollection();
        AsstAttrValueCollection updateData = new AsstAttrValueCollection();
        for (i = 0; i < collOld.size(); ++i) {
            AsstAttrValueInfo oldInfo = collOld.get(i);
            idSet.add(oldInfo.getId().toString());
            oldInfoMap.put(oldInfo.getId().toString(), oldInfo);
        }
        for (i = 0; i < collNew.size(); ++i) {
            AsstAttrValueInfo newInfo = collNew.get(i);
            if (newInfo.getId() == null) {
                addData.add(newInfo);
                continue;
            }
            newInfoMap.put(newInfo.getId().toString(), newInfo);
        }
        if (oldInfoMap.size() != newInfoMap.size()) {
            // empty if block
        }
        for (String keyID : idSet) {
            AsstAttrValueInfo oldInfo = (AsstAttrValueInfo)oldInfoMap.get(keyID);
            AsstAttrValueInfo newInfo = (AsstAttrValueInfo)newInfoMap.get(keyID);
            if (newInfo.getNumber().equals(oldInfo.getNumber()) && newInfo.getName().equals(oldInfo.getName())) continue;
            updateData.add(newInfo);
        }
        AsstAttrValueCollection[] newData = new AsstAttrValueCollection[]{addData, updateData};
        return newData;
    }

    protected boolean isAsstAttrValueModified(Context ctx, AsstAttrBasicTypeInfo asstAttrBasicTypeInfo) throws BOSException, EASBizException {
        AsstAttrValueCollection newInfos = asstAttrBasicTypeInfo.getValue();
        IAsstAttrValue iAsstAttrValue = AsstAttrValueFactory.getLocalInstance(ctx);
        AsstAttrValueCollection oldInfos = iAsstAttrValue.getAsstAttrValueCollection("where basictype.id='" + asstAttrBasicTypeInfo.getId().toString() + "'");
        for (int i = 0; i < oldInfos.size(); ++i) {
            AsstAttrValueInfo oldInfo = oldInfos.get(i);
            for (int j = 0; j < newInfos.size(); ++j) {
                AsstAttrValueInfo newInfo = newInfos.get(j);
                if (newInfo.getId() == null || !newInfo.getId().toString().equals(oldInfo.getId().toString()) || newInfo.getNumber() == null || oldInfo.getNumber() == null || newInfo.getName() == null || oldInfo.getName() == null || newInfo.getNumber().toString().equals(oldInfo.getNumber().toString()) && newInfo.getName().toString().equals(oldInfo.getName().toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected void syncRefrenceName(Context ctx, AsstAttrBasicTypeInfo basicType, AsstAttrValueCollection updataData) throws EASBizException, BOSException {
        Iterator it = updataData.iterator();
        AsstAttrValueInfo value = null;
        while (it.hasNext()) {
            value = (AsstAttrValueInfo)it.next();
            this.rebuildNumAndName(ctx, basicType, value);
        }
    }

    protected void rebuildNumAndName(Context ctx, AsstAttrBasicTypeInfo basicType, AsstAttrValueInfo info) throws EASBizException, BOSException {
        String oql;
        IAsstAttrValue iAsstValue = AsstAttrValueFactory.getLocalInstance(ctx);
        AsstAttrValueCollection multiAsstValues = iAsstValue.getAsstAttrValueCollection(oql = "SELECT * WHERE " + basicType.getMappingField() + "='" + info.getId() + "' AND COMPONDINGTYPE.ID IS NOT NULL");
        if (multiAsstValues.size() == 0) {
            return;
        }
        Connection conn = this.getConnection(ctx);
        String sql = " UPDATE T_BD_ASSTATTRVALUE SET FNAME_L2 = ?, FNUMBER = ?, FTYPE = ? WHERE FID = ?";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            Iterator it = multiAsstValues.iterator();
            AsstAttrValueInfo multiAsstValue = null;
            int seq = 0;
            while (it.hasNext()) {
                multiAsstValue = (AsstAttrValueInfo)it.next();
                seq = this.acquireTypeDef(ctx, multiAsstValue.getCompondingtype(), basicType);
                String newName = this.generateByOldData(multiAsstValue.getName(), info.getName(), seq);
                String newNum = this.generateByOldData(multiAsstValue.getNumber(), info.getNumber(), seq);
                String newType = this.generateByOldData(multiAsstValue.getType(), basicType.getName(), seq);
                stmt.setString(1, newName);
                stmt.setString(2, newNum);
                stmt.setString(3, newType);
                stmt.setString(4, multiAsstValue.getId().toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            logger.error((Object)"execute update sql error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected String generateByOldData(String src, String re, int seq) {
        String[] str = src.split("/");
        str[seq - 1] = re;
        String dest = "";
        for (int i = 0; i < str.length; ++i) {
            dest = i != str.length - 1 ? dest + str[i] + "/" : dest + str[i];
        }
        return dest;
    }

    protected int acquireTypeDef(Context ctx, AsstAttrCompondingTypeInfo compondingType, AsstAttrBasicTypeInfo basicType) throws EASBizException, BOSException {
        HashMap<String, Integer> seqs = defCache.get(compondingType.getId().toString());
        if (seqs == null) {
            seqs = new HashMap();
            defCache.put(compondingType.getId().toString(), seqs);
        }
        if (seqs.get(basicType.getId().toString()) == null) {
            IAsstAttrCompondingTypeDetail icompondingDetail = AsstAttrCompondingTypeDetailFactory.getLocalInstance(ctx);
            String oql = "WHERE Compondingtype.ID = '" + compondingType.getId() + "' AND Basictype.ID ='" + basicType.getId() + "'";
            AsstAttrCompondingTypeDetailInfo compondingDetail = icompondingDetail.getAsstAttrCompondingTypeDetailInfo(oql);
            seqs.put(basicType.getId().toString(), compondingDetail.getSeq());
            return compondingDetail.getSeq();
        }
        return seqs.get(basicType.getId().toString());
    }

    protected void syncValueName(Context ctx, AsstAttrBasicTypeInfo info) throws EASBizException, BOSException {
        IAsstAttrCompondingTypeDetail iDetail = AsstAttrCompondingTypeDetailFactory.getLocalInstance(ctx);
        AsstAttrCompondingTypeDetailCollection detailCollection = iDetail.getAsstAttrCompondingTypeDetailCollection("select *,compondingtype.* where basictype.id='" + info.getId().toString() + "'");
        if (detailCollection == null || detailCollection.size() == 0) {
            return;
        }
        for (int i = 0; i < detailCollection.size(); ++i) {
            AsstAttrCompondingTypeInfo comTypeInfo = detailCollection.get(i).getCompondingtype();
            this.regenateComName(ctx, comTypeInfo);
        }
    }

    private void regenateComName(Context ctx, AsstAttrCompondingTypeInfo info) throws BOSException, EASBizException {
        IAsstAttrCompondingTypeDetail iDetail = AsstAttrCompondingTypeDetailFactory.getLocalInstance(ctx);
        AsstAttrCompondingTypeDetailCollection detailCollection = iDetail.getAsstAttrCompondingTypeDetailCollection("select *,basictype.* where compondingtype.id='" + info.getId().toString() + "' order by seq");
        IAsstAttrValue iValue = AsstAttrValueFactory.getLocalInstance(ctx);
        AsstAttrValueCollection compValues = iValue.getAsstAttrValueCollection("where compondingtype='" + info.getId().toString() + "'");
        for (int j = 0; j < compValues.size(); ++j) {
            StringBuffer newValueNumber = new StringBuffer();
            StringBuffer newValueName = new StringBuffer();
            AsstAttrValueInfo compValue = compValues.get(j);
            for (int i = 0; i < detailCollection.size(); ++i) {
                AsstAttrCompondingTypeDetailInfo detailInfo = detailCollection.get(i);
                String mappingField = detailInfo.getBasictype().getMappingField();
                String simpleValueId = compValue.getString(mappingField);
                AsstAttrValueInfo valueInfo = iValue.getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(simpleValueId));
                if (i != 0) {
                    newValueNumber.append(AsstAttrSeparator.get());
                    newValueName.append(AsstAttrSeparator.get());
                }
                newValueNumber.append(valueInfo.getNumber());
                newValueName.append(valueInfo.getName());
                compValue.setNumber(newValueNumber.toString());
                compValue.setName(newValueName.toString());
                iValue.submit(compValue);
            }
        }
    }
}

