/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeDetailCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeDetailInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrException;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrCompondingType;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.app.AbstractAsstAttrCompondingTypeControllerBean;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class AsstAttrCompondingTypeControllerBean
extends AbstractAsstAttrCompondingTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.AsstAttrCompondingTypeControllerBean");

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AsstAttrCompondingTypeInfo info = (AsstAttrCompondingTypeInfo)model;
        this.checkData(ctx, (IObjectValue)info);
        this.handleAttrValue(ctx, info);
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AsstAttrCompondingTypeInfo info = (AsstAttrCompondingTypeInfo)model;
        this.checkData(ctx, (IObjectValue)info);
        this.handleAttrValue(ctx, info);
        return super._submit(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkReference(ctx, pk);
        super._delete(ctx, pk);
    }

    private void deleteAttrValue(Context ctx, AsstAttrValueCollection valueCollection) throws BOSException, EASBizException {
        int size = valueCollection.size();
        for (int i = 0; i < size; ++i) {
            AsstAttrValueInfo info = valueCollection.get(i);
            IAsstAttrValue asstAttrValue = AsstAttrValueFactory.getLocalInstance(ctx);
            BOSUuid id = info.getId();
            if (id == null) continue;
            asstAttrValue.delete((IObjectPK)new ObjectUuidPK(id));
        }
    }

    private void checkData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNumberBlank(ctx, model);
        this.checkDetailDataDup(ctx, model);
        this.checkNumberNameDup(ctx, model);
    }

    private void handleAttrValue(Context ctx, AsstAttrCompondingTypeInfo uiTypeInfo) throws EASBizException, BOSException {
        BOSUuid typeID = uiTypeInfo.getId();
        if (typeID == null) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("detail.basictype.*"));
        selector.add(new SelectorItemInfo("value.id"));
        AsstAttrCompondingTypeInfo dbTypeInfo = this.getAsstAttrCompondingTypeInfo(ctx, (IObjectPK)new ObjectUuidPK(typeID), selector);
        AsstAttrCompondingTypeDetailCollection uiDetailCollection = uiTypeInfo.getDetail();
        AsstAttrCompondingTypeDetailCollection dbDetailCollection = dbTypeInfo.getDetail();
        if (!this.isDetailCollectionChanged(uiDetailCollection, dbDetailCollection)) {
            return;
        }
        AsstAttrValueCollection dbValueCollection = dbTypeInfo.getValue();
        try {
            this.checkAttrValueReference(ctx, dbValueCollection);
        }
        catch (ObjectReferedException re) {
            throw new AsstAttrException(AsstAttrException.VALUE_REF_CAN_NOT_MODIFY);
        }
        AsstAttrValueCollection uiValueCollection = uiTypeInfo.getValue();
        uiValueCollection.clear();
    }

    private boolean isDetailCollectionChanged(AsstAttrCompondingTypeDetailCollection uiDetailCollection, AsstAttrCompondingTypeDetailCollection dbDetailCollection) {
        if (uiDetailCollection.size() != dbDetailCollection.size()) {
            return true;
        }
        for (int i = 0; i < uiDetailCollection.size(); ++i) {
            AsstAttrCompondingTypeDetailInfo uidetailInfo = uiDetailCollection.get(i);
            AsstAttrCompondingTypeDetailInfo dbdetailInfo = dbDetailCollection.get(i);
            if (uidetailInfo.getBasictype().getId().equals((Object)dbdetailInfo.getBasictype().getId())) continue;
            return true;
        }
        return false;
    }

    private void checkAttrValueReference(Context ctx, AsstAttrValueCollection valueCollection) throws BOSException, EASBizException {
        int size = valueCollection.size();
        for (int i = 0; i < size; ++i) {
            AsstAttrValueInfo info = valueCollection.get(i);
            IAsstAttrValue asstAttrValue = AsstAttrValueFactory.getLocalInstance(ctx);
            BOSUuid id = info.getId();
            if (id == null) continue;
            asstAttrValue.isReferenced((IObjectPK)new ObjectUuidPK(id));
        }
    }

    private void checkDetailDataDup(Context ctx, IObjectValue model) throws BOSException, AsstAttrException {
        AsstAttrCompondingTypeInfo aacti;
        AsstAttrCompondingTypeDetailCollection aactdc1;
        if (model != null && (model.get("id") == null || model.get("id").toString().equals("")) && (aactdc1 = (aacti = (AsstAttrCompondingTypeInfo)model).getDetail()) != null && aactdc1.size() != 0) {
            HashSet<String> hs1 = new HashSet<String>();
            int size1 = aactdc1.size();
            for (int i = 0; i < size1; ++i) {
                hs1.add(aactdc1.get(i).getBasictype().getId().toString());
            }
            IAsstAttrCompondingType iaact = AsstAttrCompondingTypeFactory.getLocalInstance(ctx);
            String oql = "select id,detail.id,detail.basictype.id";
            AsstAttrCompondingTypeCollection aactc = iaact.getAsstAttrCompondingTypeCollection(oql);
            AsstAttrCompondingTypeDetailCollection aactdc2 = null;
            HashSet<String> hs2 = new HashSet<String>();
            int size2 = aactc.size();
            for (int i = 0; i < size2; ++i) {
                aactdc2 = aactc.get(i).getDetail();
                hs2.clear();
                int size22 = aactdc2.size();
                for (int j = 0; j < size22; ++j) {
                    hs2.add(aactdc2.get(j).getBasictype().getId().toString());
                }
                if (!hs1.equals(hs2)) continue;
                throw new AsstAttrException(AsstAttrException.COMPONDINGTYPE_ALREADY_EXISTED);
            }
        }
    }

    private void checkNumberNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.get("number").toString();
        String name = model.get("name").toString();
        String id = null;
        if (model.get("id") != null) {
            id = model.get("id").toString();
        }
        Connection cn = this.getConnection(ctx);
        String lang = ctx.getLocale().toString();
        String sql = "select Top 1 FNumber,FName_" + lang + " from V_BD_AsstAttrType where FName_" + lang + "='" + name + "'and FID <> '" + id + "' or FNumber='" + number + "'";
        if (id != null) {
            sql = sql + "and FID <> '" + id + "'";
        }
        RowSet rs = null;
        try {
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            if (rs.next()) {
                if (rs.getString(1).equals(number)) {
                    throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{number});
                }
                throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{name});
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        catch (EASBizException e2) {
            throw e2;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReference(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Connection cn;
        Statement stat2;
        ResultSet rs;
        block5: {
            rs = null;
            stat2 = null;
            boolean found = false;
            cn = this.getConnection(ctx);
            String sql = "select 1 where exists( select 1 from t_bd_material where FAssistAttr = '" + pk.toString() + "')";
            try {
                stat2 = cn.createStatement();
                rs = stat2.executeQuery(sql);
                if (rs.next()) {
                    found = true;
                }
                if (!found) break block5;
                throw new AsstAttrException(AsstAttrException.REF_BY_MATERIAL);
            }
            catch (SQLException e2) {
                try {
                    logger.error((Object)"BizReferenceException", (Throwable)new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e2));
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    SQLUtils.cleanup((Statement)stat2);
                    SQLUtils.cleanup((Connection)cn);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs);
                SQLUtils.cleanup((Statement)stat2);
                SQLUtils.cleanup((Connection)cn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)stat2);
        SQLUtils.cleanup((Connection)cn);
    }

    @Override
    protected void _synAsstAttr(Context ctx, String CompondingTypeID) throws BOSException, EASBizException {
        if (CompondingTypeID == null || CompondingTypeID.length() == 0) {
            return;
        }
        SQLUtil sb = new SQLUtil();
        sb.appendSql(" insert into T_BD_MaterialAsstAttrValue(FID,FMaterialID,FAsstAttrValueID) ");
        sb.appendSql(" select newbosid('AEAA1BF0'),T_BD_MATERIAL.FID,T_BD_AsstAttrValue.FID ");
        sb.appendSql(" from T_BD_MATERIAL,T_BD_AsstAttrValue ");
        sb.appendSql(" where (T_BD_MATERIAL.FAssistAttr = T_BD_AsstAttrValue.FCompondingtypeID ) ");
        sb.appendSql(" and not exists(select 1 from T_BD_MaterialAsstAttrValue a where a.FMaterialID=T_BD_MATERIAL.FID and a.FAsstAttrValueID = T_BD_AsstAttrValue.FID) ");
        sb.appendSql(" and  T_BD_MATERIAL.FAssistAttr = '").appendSql(CompondingTypeID).appendSql("'");
        sb.appendSql(" and T_BD_AsstAttrValue.FDELETEDSTATUS=1");
        sb.execute(ctx);
    }
}

