/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.app.CopyAssistTask;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CopyCompanyTask
extends CopyAssistTask {
    private Logger logger = Logger.getLogger(CopyCompanyTask.class);
    private final CtrlUnitCollection centralizedPurchasingCUColl;
    private final Context ctx;
    private final String orginalMaterialID;
    private final String[] matIds;
    private final Connection conn;

    protected CopyCompanyTask(Context ctx, CtrlUnitCollection centralizedPurchasingCUColl, String orginalMaterialID, String[] matIds, Connection conn) {
        super(ctx, centralizedPurchasingCUColl, orginalMaterialID, matIds, conn);
        this.centralizedPurchasingCUColl = centralizedPurchasingCUColl;
        this.ctx = ctx;
        this.orginalMaterialID = orginalMaterialID;
        this.matIds = matIds;
        this.conn = conn;
    }

    @Override
    public Void call() throws Exception {
        CtrlUnitInfo threadCPCUInfo = null;
        MaterialCompanyInfoCollection matComColl = new MaterialCompanyInfoCollection();
        IFullOrgUnit ifullOrgCP = FullOrgUnitFactory.getLocalInstance((Context)this.ctx);
        FullOrgUnitInfo cpouInfo = null;
        String CPMaterialTempleateID = null;
        for (int i = 0; i < this.centralizedPurchasingCUColl.size(); ++i) {
            threadCPCUInfo = this.centralizedPurchasingCUColl.get(i);
            matComColl.addCollection(this.getCPmatCompanyInfo(this.ctx, this.orginalMaterialID, threadCPCUInfo));
        }
        for (int j = 0; j < matComColl.size(); ++j) {
            CPMaterialTempleateID = matComColl.get(j).getMateial().getId().toString();
            cpouInfo = ifullOrgCP.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(matComColl.get(j).getCompany().getId()));
            this.logger.error((Object)("\u6b63\u5728\u904d\u5386\u7b2c " + j + " \u4e2a\u96c6\u91c7CU\u7ec4\u7ec7,\u5206\u914d\u8d22\u52a1\u8d44\u6599 CPOU\u4e3a " + cpouInfo.getId().toString() + "\n"));
            this.batchCopyCompanyInfo(this.ctx, CPMaterialTempleateID, cpouInfo, cpouInfo, this.conn, this.matIds);
        }
        return null;
    }

    private MaterialCompanyInfoCollection getCPmatCompanyInfo(Context ctx, String originalMatId, CtrlUnitInfo CPCUInfo) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)CPCUInfo.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)originalMatId, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("company.*");
        ev.getSelector().add("CU.id");
        MaterialCompanyInfoCollection matCom = MaterialCompanyInfoFactory.getLocalInstance(ctx).getMaterialCompanyInfoCollection(ev);
        return matCom;
    }

    public void batchCopyCompanyInfo(Context ctx, String templetMatId, FullOrgUnitInfo sourceOrgUnitInfo, FullOrgUnitInfo targetOrgUnitInfo, Connection conn, String[] idsToDealWithAssist) throws BOSException, EASBizException {
        if (!targetOrgUnitInfo.isIsCompanyOrgUnit()) {
            return;
        }
        long f = System.currentTimeMillis();
        Statement stmt = null;
        String creatorId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser() == null ? "FCreatorID" : " '" + ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString() + "' FCreatorID";
        String srcCompanyId = sourceOrgUnitInfo.getId().toString();
        String destCuid = targetOrgUnitInfo.getCU().getId().toString();
        String destCompanyId = targetOrgUnitInfo.getId().toString();
        long currentTimeMillis = 0L;
        String FKAClassID = targetOrgUnitInfo.getString("FKAClassID") == null ? "FKAClassID" : " '" + targetOrgUnitInfo.getString("FKAClassID") + "' FKAClassID";
        String FISLOT = targetOrgUnitInfo.getString("isLot") == null ? "FISLOT" : "'" + targetOrgUnitInfo.getString("isLot") + "' FISLOT ";
        SQLUtil sb = new SQLUtil();
        try {
            stmt = conn.createStatement();
            long f2 = System.currentTimeMillis();
            for (int i = 0; i < idsToDealWithAssist.length; ++i) {
                sb.appendSql("if not exists (select 1 from t_bd_materialcompanyinfo where FMaterialID = '" + idsToDealWithAssist[i] + "' and FCompanyID  = '" + destCompanyId + "' )");
                sb.appendSql("insert into t_bd_materialcompanyinfo ");
                sb.appendSql(" (FID,FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FMaterial, FMaterialID, FCompanyID,FKAClassID, FAccountType, FStandardCost, FEffectedStatus, FCalculateType, FFreezeOrgUnit, FStatus,FCreateCOByOrder,FIsLot,FIsAssistProperty,FIsProject,FIsTrackNumber)  ");
                sb.appendSql(" select newbosid('D431F8BB') FID , FCreatorID , now() FCreateTime, FLastUpdateUserID , now() FLastUpdateTime, '" + destCuid + "'  FControlUnitID, FMaterial, '" + idsToDealWithAssist[i] + "' FmaterialID , '" + destCompanyId + "' FCompanyID, " + FKAClassID + ", FAccountType, FStandardCost, FEffectedStatus, FCalculateType, null FFreezeOrgUnit,1 FStatus,FCreateCOByOrder," + FISLOT + ",FIsAssistProperty,FIsProject,FIsTrackNumber");
                sb.appendSql(" from t_bd_materialcompanyinfo mc  where  mc.FStatus=1  ");
                sb.appendSql(" and mc.FMaterialID = '" + templetMatId + "' ");
                sb.appendSql(" and mc.fcompanyid='" + srcCompanyId + "'  ");
                stmt.addBatch(sb.getSql());
            }
            this.logger.error((Object)("\u62fc\u63a5\u8d22\u52a1\u8d44\u6599sql\u8017\u65f6\uff1a" + (System.currentTimeMillis() - f2)));
            stmt.executeBatch();
            this.logger.error((Object)("\u62fc\u63a5\u8d22\u52a1\u8d44\u6599sql\u81f3\u6267\u884c\u5b8c\u6210\u8017\u65f6\uff1a" + (System.currentTimeMillis() - f2)));
            this.logger.error((Object)("\u521b\u5efa\u8d22\u52a1\u8d44\u6599\uff0c\u8017\u65f6 \uff1a " + (f - System.currentTimeMillis())));
        }
        catch (SQLException e) {
            throw new BOSException(ExceptionUtil.getExcLinkStackTrace((Throwable)e));
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
    }
}

