/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.app.CopyAssistTask;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CopyInvTask
extends CopyAssistTask {
    private Logger logger = Logger.getLogger(CopyInvTask.class);
    private final CtrlUnitCollection centralizedPurchasingCUColl;
    private final Context ctx;
    private final String orginalMaterialID;
    private final String[] matIds;
    private final Connection conn;

    public CopyInvTask(Context ctx, CtrlUnitCollection centralizedPurchasingCUColl, String orginalMaterialID, String[] matIds, Connection conn) {
        super(ctx, centralizedPurchasingCUColl, orginalMaterialID, matIds, conn);
        this.centralizedPurchasingCUColl = centralizedPurchasingCUColl;
        this.ctx = ctx;
        this.orginalMaterialID = orginalMaterialID;
        this.matIds = matIds;
        this.conn = conn;
    }

    @Override
    public Void call() throws Exception {
        CtrlUnitInfo threadCPCUInfo = null;
        MaterialInventoryCollection matInvColl = new MaterialInventoryCollection();
        IFullOrgUnit ifullOrgCP = FullOrgUnitFactory.getLocalInstance((Context)this.ctx);
        FullOrgUnitInfo cpouInfo = null;
        String CPMaterialTempleateID = null;
        for (int i = 0; i < this.centralizedPurchasingCUColl.size(); ++i) {
            threadCPCUInfo = this.centralizedPurchasingCUColl.get(i);
            matInvColl.addCollection(this.getCPmatInvInfo(this.ctx, this.orginalMaterialID, threadCPCUInfo));
        }
        for (int j = 0; j < matInvColl.size(); ++j) {
            CPMaterialTempleateID = matInvColl.get(j).getMaterial().getId().toString();
            cpouInfo = ifullOrgCP.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(matInvColl.get(j).getOrgUnit().getId()));
            this.logger.error((Object)("\u6b63\u5728\u904d\u5386\u7b2c " + j + " \u4e2a\u96c6\u91c7CU\u7ec4\u7ec7,\u5206\u914d\u5e93\u5b58\u8d44\u6599 CPOU\u4e3a " + cpouInfo.getId().toString() + "\n"));
            this.batchCopyInventoryInfo(this.ctx, CPMaterialTempleateID, cpouInfo, cpouInfo, this.conn, this.matIds);
        }
        return null;
    }

    private MaterialInventoryCollection getCPmatInvInfo(Context ctx, String originalMatId, CtrlUnitInfo CPCUInfo) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)CPCUInfo.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)originalMatId, CompareType.EQUALS));
        ev.setFilter(filter);
        ev.getSelector().add("id");
        ev.getSelector().add("orgunit.*");
        ev.getSelector().add("CU.id");
        MaterialInventoryCollection matInv = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(ev);
        return matInv;
    }

    private void batchCopyInventoryInfo(Context ctx, String templetMatId, FullOrgUnitInfo sourceOrgUnitInfo, FullOrgUnitInfo targetOrgUnitInfo, Connection conn, String[] idsToDealWithAssist) throws BOSException, EASBizException {
        long f = System.currentTimeMillis();
        if (!targetOrgUnitInfo.isIsStorageOrgUnit()) {
            return;
        }
        PreparedStatement stmt = null;
        String srcOrgUnitId = sourceOrgUnitInfo.getId().toString();
        String destCuid = targetOrgUnitInfo.getCU().getId().toString();
        String destOugUnitId = targetOrgUnitInfo.getId().toString();
        SQLUtil sb = new SQLUtil();
        sb.appendSql("insert into T_BD_MATERIALINVENTORY ");
        sb.appendSql(" (FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FStatus,FOrgUnit,FFreezeOrgUnit,FMaterialID,FIsControl,FQtySafety,FQtyMin,FQtyMax,FDaysBottom,FDaysTop,FDaysTurnover,FIsNegative,FIsBatchNo,FIsSequenceNo,FIsLotNumber,FIsBarcode,FQtyMinPackage,FABCType,FIsCompages,FIssuePriorityMode,FUnitID,FEffectedStatus,FIsPeriodValid,FPeriodValid,FPeriodValidUnit,FInWarehsAhead,FOutWarehsAhead,FPrepWarnAhead,FAheadUnit,FInvPlanner,FPlanningMode,FReBookQty,FConsumeSpeed,FPurchasingAheadDate,FBatchPolicy,FFixationBatchQty,FDefaultWarehouseID,FDaysPlanTurnover,FCheapRate,FCloseDateCalMode,FisProjectNumber,FisTrackingNumber )  ");
        sb.appendSql(" select newbosid('557E499F') FID , FCreatorID, now() FCreateTime,FLastUpdateUserID,  now() FLastUpdateTime, '" + destCuid + "'  FControlUnitID,1 FStatus,  '" + destOugUnitId + "' FOrgUnit,null FFreezeOrgUnit, ?, FIsControl,FQtySafety,FQtyMin,FQtyMax,FDaysBottom,FDaysTop,FDaysTurnover,FIsNegative,FIsBatchNo,FIsSequenceNo,FIsLotNumber,FIsBarcode,FQtyMinPackage,FABCType,FIsCompages,FIssuePriorityMode,FUnitID,FEffectedStatus,FIsPeriodValid,FPeriodValid,FPeriodValidUnit,FInWarehsAhead,FOutWarehsAhead,FPrepWarnAhead,FAheadUnit,FInvPlanner,FPlanningMode,FReBookQty,FConsumeSpeed,FPurchasingAheadDate,FBatchPolicy,FFixationBatchQty,null FDefaultWarehouseID,FDaysPlanTurnover,FCheapRate,FCloseDateCalMode,FisProjectNumber,FisTrackingNumber");
        sb.appendSql(" from T_BD_MATERIALINVENTORY mc  where  mc.FStatus=1  ");
        sb.appendSql(" and mc.FMaterialID = '" + templetMatId + "' ");
        sb.appendSql(" and mc.FOrgUnit='" + srcOrgUnitId + "'  ");
        sb.appendSql(" and not exists (select 1 from T_BD_MATERIALINVENTORY where FMaterialID = ? and FOrgUnit  = '" + destOugUnitId + "' )");
        try {
            stmt = conn.prepareStatement(sb.getSql());
            long f2 = System.currentTimeMillis();
            for (int i = 0; i < idsToDealWithAssist.length; ++i) {
                stmt.setString(1, idsToDealWithAssist[i]);
                stmt.setString(2, idsToDealWithAssist[i]);
                stmt.addBatch(sb.getSql());
            }
            this.logger.error((Object)("\u62fc\u63a5\u5e93\u5b58\u8d44\u6599sql\u8017\u65f6\uff1a" + (System.currentTimeMillis() - f2)));
            stmt.executeBatch();
            this.logger.error((Object)("\u62fc\u63a5\u5e93\u5b58\u8d44\u6599sql\u81f3\u6267\u884c\u5b8c\u6210\u8017\u65f6\uff1a" + (System.currentTimeMillis() - f2)));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        this.logger.error((Object)("\u521b\u5efa\u5e93\u5b58\u8d44\u6599\uff0c\u8017\u65f6 \uff1a " + (System.currentTimeMillis() - f)));
    }
}

