/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.ViewParseUtils;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IKAClassfication;
import com.kingdee.eas.basedata.assistant.KAClassficationCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.master.material.util.FilterSqlUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataImportMaterialCompany
extends AbstractDataTransmission {
    private Set PerminsionCheckedCuIds = new HashSet();
    private Logger logger = Logger.getLogger(DataImportMaterialCompany.class);
    private Map<String, Boolean> userBizOrgRange = new HashMap<String, Boolean>();
    private boolean needUpdate = true;
    Map casheCompany = new HashMap();
    Map casheKAClass = new HashMap();
    Map casheFilterAssign = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialCompanyInfoFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        coreBaseInfo.put("isImport", (Object)"true");
        try {
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                if (!this.needUpdate) {
                    return;
                }
                coreBaseInfo.put("isImport", (Object)true);
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            return this.innerTransmit(hsData, ctx);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new TaskExternalException("", (Throwable)ex);
        }
    }

    private CoreBaseInfo innerTransmit(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        Object data = ((DataToken)hsData.get((Object)"FCompanyID")).data;
        if (data == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetCompanyOrgUnitFailed", (Context)ctx));
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = this.getCompanyByNumber(ctx, data.toString());
        if (companyOrgUnitInfo == null) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"GetCompanyOrgUnitFailed", (Context)ctx));
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        boolean hasBizOrgRange = false;
        if (this.userBizOrgRange.containsKey(userId + companyOrgUnitInfo.getId().toString())) {
            hasBizOrgRange = this.userBizOrgRange.get(userId + companyOrgUnitInfo.getId().toString());
        } else {
            hasBizOrgRange = PerminsionUtil.isUserBizOrgRange(ctx, userId, companyOrgUnitInfo.getId().toString());
            this.userBizOrgRange.put(userId + companyOrgUnitInfo.getId().toString(), hasBizOrgRange);
        }
        if (!hasBizOrgRange) {
            throw new TaskExternalException(new MaterialBaseException(MaterialBaseException.OUT_BIZ_ORG, new Object[]{companyOrgUnitInfo.getName()}).getMessage());
        }
        String CuId = companyOrgUnitInfo.getCU().getId().toString();
        if (!this.PerminsionCheckedCuIds.contains(CuId)) {
            try {
                PerminsionUtil.checkCUPerminsion(ctx, CuId, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), "bd_materialCom_import");
            }
            catch (EASBizException ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
            this.PerminsionCheckedCuIds.add(CuId);
        }
        MaterialCompanyInfoInfo info = new MaterialCompanyInfoInfo();
        MaterialCompanyInfoInfo oldInfoClone = null;
        MaterialCompanyInfoInfo infoClone = null;
        if (this.isSltImportUpdate()) {
            FilterInfo filter = new FilterInfo();
            DataImportTools.AddFilterItemInfo(filter, "company.id", companyOrgUnitInfo.getId().toString());
            DataImportTools.AddFilterItemInfo(filter, "mateial.number", this.getDataString(hsData, "FNumber"));
            filter.setMaskString("#0 and #1");
            IMaterialCompanyInfo iProperty = MaterialCompanyInfoFactory.getLocalInstance(ctx);
            MaterialCompanyInfoCollection proCollection = iProperty.getMaterialCompanyInfoCollection(DataImportTools.getViewInfo(filter));
            if (proCollection != null && proCollection.size() > 0) {
                oldInfoClone = (MaterialCompanyInfoInfo)proCollection.get(0).clone();
                info.setId(proCollection.get(0).getId());
            }
        }
        MaterialInfo materialInfo = DataImportTools.getMaterialInfo(ctx, companyOrgUnitInfo.getCU(), this.getDataString(hsData, "FNumber"));
        info.setMateial(materialInfo);
        info.setCompany(companyOrgUnitInfo);
        info.setCU(companyOrgUnitInfo.getCU());
        this.handleInfo(ctx, hsData, info);
        if (oldInfoClone != null) {
            infoClone = (MaterialCompanyInfoInfo)info.clone();
            this.excludeSomePorperties(infoClone, oldInfoClone);
            this.needUpdate = !ObjectValueUtil.objectValueEquals((Context)ctx, oldInfoClone, (AbstractObjectValue)infoClone);
        }
        return info;
    }

    private void excludeSomePorperties(MaterialCompanyInfoInfo infoClone, MaterialCompanyInfoInfo oldInfoClone) {
        infoClone.setCreator(null);
        oldInfoClone.setCreator(null);
        infoClone.setCreateTime(null);
        oldInfoClone.setCreateTime(null);
        infoClone.setLastUpdateUser(null);
        oldInfoClone.setLastUpdateUser(null);
        infoClone.setLastUpdateTime(null);
        oldInfoClone.setLastUpdateTime(null);
    }

    private void handleInfo(Context ctx, Hashtable hsData, MaterialCompanyInfoInfo info) throws TaskExternalException, BOSException {
        info.setStandardCost(this.getDataBigDecimal(hsData, "FStandardCost"));
        AccountType accountType = DataImportTools.getAccountTypeEnum(this.getDataString(hsData, "FAccountType"), ctx);
        info.setAccountType(accountType);
        if (info.getAccountType() == AccountType.STANDARDCOST && (info.getStandardCost() == null || info.getStandardCost().compareTo(new BigDecimal("0.00")) <= 0)) {
            throw new TaskExternalException(DataImportTools.getResString("com.kingdee.eas.basedata.master.material.MaterialResource", "STANDARD_NOT_NULL", ctx.getLocale()));
        }
        info.setCalculateType(DataImportTools.getCalculateTypeEnum(this.getDataString(hsData, "FCalculateType"), ctx));
        info.setKAClass(this.getKAClassInfo(ctx, this.getDataString(hsData, "FKAClass"), info.getCompany().getId().toString()));
        if (CalculateTypeEnum.SELFMANUFACTURE == info.getCalculateType()) {
            info.setCreateCOByOrder(DataImportTools.getDataboolean(hsData, "FCreateCOByOrder"));
        } else {
            info.setCreateCOByOrder(false);
        }
        if (AccountType.SPECIAL_ACCT == accountType) {
            info.setIsLot(DataImportTools.getDataboolean(hsData, "FIsLot"));
            info.setIsAssistProperty(DataImportTools.getDataboolean(hsData, "FIsAssistProperty"));
            info.setIsProject(DataImportTools.getDataboolean(hsData, "FIsProject"));
            info.setIsTrackNumber(DataImportTools.getDataboolean(hsData, "FIsTrackNumber"));
        } else {
            info.setIsLot(false);
            info.setIsAssistProperty(false);
            info.setIsProject(false);
            info.setIsTrackNumber(false);
        }
        OrgUnitInfo ou = DataImportTools.getOrgUnitInfo(ctx, this.getDataString(hsData, "FFreezeOrgUnit"));
        info.setStatus(DataImportTools.getStatusEnum(this.getDataString(hsData, "FStatus"), ctx));
        if (ou != null) {
            info.setFreezeOrgUnit(ou.castToFullOrgUnitInfo());
        } else if (info.getStatus() == UsedStatusEnum.FREEZED) {
            info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        } else {
            info.setFreezeOrgUnit(null);
        }
        info.setEffectedStatus(2);
    }

    private CompanyOrgUnitInfo getCompanyByNumber(Context ctx, String number) throws BOSException {
        Object result = this.casheCompany.get(number);
        if (result == null) {
            result = DataImportTools.getCompanyOrgUnitInfoFromNumber(ctx, number);
            this.casheCompany.put(number, result);
        }
        return (CompanyOrgUnitInfo)result;
    }

    private KAClassficationInfo getKAClassInfo(Context ctx, String number, String comOrgID) throws TaskExternalException, BOSException {
        if (number == null || "".equals(number)) {
            return null;
        }
        if (comOrgID == null) {
            return null;
        }
        String key = number + "&&" + comOrgID;
        Object result = this.casheKAClass.get(key);
        if (result == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("where number = '" + number + "'");
            stringBuffer.append("And currencyCompany = '" + comOrgID + "'");
            IKAClassfication iKa = KAClassficationFactory.getLocalInstance((Context)ctx);
            KAClassficationCollection kaCollection = iKa.getKAClassficationCollection(stringBuffer.toString());
            if (kaCollection == null || kaCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString("com.kingdee.eas.basedata.master.material.MaterialResource", "DataImport_FA_Error", ctx.getLocale()));
            }
            result = kaCollection.get(0);
            this.casheKAClass.put(key, result);
        }
        return (KAClassficationInfo)result;
    }

    public boolean isMaterialAssignForOrg(Context ctx, String materialID, String ctrlUnitID) throws BOSException, EASBizException, UuidException {
        FilterInfo filterAssign = this.getFilterAssign(ctx, ctrlUnitID);
        FilterInfo filterMaterialID = new FilterInfo();
        filterMaterialID.getFilterItems().add(new FilterItemInfo("id", (Object)new ObjectUuidPK(BOSUuid.read((String)materialID)), CompareType.EQUALS));
        filterMaterialID.mergeFilter(filterAssign, "and");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterMaterialID);
        IMaterial imaterial = MaterialFactory.getLocalInstance(ctx);
        MaterialCollection materialColl = imaterial.getMaterialCollection(viewInfo);
        return materialColl != null && materialColl.size() != 0;
    }

    private FilterInfo getFilterAssign(Context ctx, String ctrlUnitID) throws BOSException, EASBizException, UuidException {
        Object result = this.casheFilterAssign.get(ctrlUnitID);
        if (result == null) {
            FilterInfo filterAssign = MaterialFactory.getLocalInstance(ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ctrlUnitID)), "id", "adminCU.id");
            this.casheFilterAssign.put(ctrlUnitID, filterAssign);
            result = filterAssign;
        }
        return (FilterInfo)result;
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString(hsData, fieldName);
    }

    private BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataBigDecimal(hsData, fieldName);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FMaterialName", rs.getString("name"));
            this.putTable(result, "FCompanyID", rs.getString("orgUnit.number"));
            this.putTable(result, "FStandardCost", rs.getBigDecimal("AssitInfo.standardCost"));
            this.putTable(result, "FAccountType", AccountType.getEnum(rs.getInt("AssitInfo.accountType")).getAlias(ctx.getLocale()));
            this.putTable(result, "FKAClass", rs.getString("KAClass.number"));
            this.putTable(result, "FCalculateType", CalculateTypeEnum.getEnum(rs.getInt("AssitInfo.calculateType")).getAlias(ctx.getLocale()));
            this.putTable(result, "FFreezeOrgUnit", rs.getString("freezeOrgUnit.number"));
            this.putTable(result, "FStatus", UsedStatusEnum.getEnum(rs.getInt("AssitInfo.status")).getAlias(ctx.getLocale()));
            this.putTable(result, "FCreateCOByOrder", DataImportTools.boolToString(rs.getBoolean("AssitInfo.createCOByOrder")));
            this.putTable(result, "FIsLot", DataImportTools.boolToString(rs.getBoolean("AssitInfo.isLot")));
            this.putTable(result, "FIsAssistProperty", DataImportTools.boolToString(rs.getBoolean("AssitInfo.isAssistProperty")));
            this.putTable(result, "FIsProject", DataImportTools.boolToString(rs.getBoolean("AssitInfo.isProject")));
            this.putTable(result, "FIsTrackNumber", DataImportTools.boolToString(rs.getBoolean("AssitInfo.isTrackNumber")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        String filterItmesStr = (String)this.getContextMap().get("filterItems");
        FilterInfo filterInfo = null;
        ObjectUuidPK pk = null;
        if (filterItmesStr != null) {
            SqlExpr sqlExpr = null;
            try {
                if (filterItmesStr.contains("{\"subject\"")) {
                    String filterItems = FilterSqlUtils.getFilterItems(ctx, filterItmesStr);
                    filterInfo = new FilterInfo(filterItems);
                } else {
                    sqlExpr = ViewParseUtils.parseFilterExpr((String)filterItmesStr);
                    filterInfo = new FilterInfo(sqlExpr);
                }
                return filterInfo;
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        } else {
            try {
                IMaterial imat = MaterialFactory.getLocalInstance(ctx);
                pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
                filterInfo = imat.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.master.material.app.DataImpExpFIQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable(htable, key, value);
    }
}

