/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PayConditionUsageEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeEnum;
import com.kingdee.eas.basedata.assistant.StartStandardEnum;
import com.kingdee.eas.basedata.framework.DataStateEnum;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.ABCEnum;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.BatchPolicyPartitionTypeEnum;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.DemandMergeRulerEnum;
import com.kingdee.eas.basedata.master.material.EquipmentPropertyEnum;
import com.kingdee.eas.basedata.master.material.IAsstAttrType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialBaseDispersionEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialOffsetEnum;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.ReplaceModeEnum;
import com.kingdee.eas.basedata.master.material.StoreType;
import com.kingdee.eas.basedata.master.material.ThrowModeEnum;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.mm.basedata.IMaterialTrademark;
import com.kingdee.eas.mm.basedata.MaterialTrademarkCollection;
import com.kingdee.eas.mm.basedata.MaterialTrademarkFactory;
import com.kingdee.eas.mm.basedata.MaterialTrademarkInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DataImportTools {
    public static final String resClassName = "com.kingdee.eas.basedata.master.material.MaterialResource";
    public static final String resAddClassName = "com.kingdee.eas.basedata.master.material.MaterialAddResource";
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    private static Logger logger = Logger.getLogger(DataImportTools.class);
    public static final String DEFAULT_ADMIN_CU = "00000000-0000-0000-0000-000000000000CCE7AED4";

    public static void putValue(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public static String getMlData(Hashtable hsData, String fieldName) {
        String result = null;
        String value = (String)((DataToken)hsData.get((Object)new StringBuilder().append((String)fieldName).append((String)"_L1").toString())).data;
        if (value != null && value.trim().length() != 0) {
            result = value;
        }
        if ((value = (String)((DataToken)hsData.get((Object)new StringBuilder().append((String)fieldName).append((String)"_L2").toString())).data) != null && value.trim().length() != 0) {
            result = value;
        }
        if ((value = (String)((DataToken)hsData.get((Object)new StringBuilder().append((String)fieldName).append((String)"_L3").toString())).data) != null && value.trim().length() != 0) {
            result = value;
        }
        return result;
    }

    public static EntityViewInfo getNumberEntityView(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public static String getLoc(Context ctx) {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toUpperCase();
    }

    public static String getResString(String resClassName, String resName, Locale locale) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
    }

    public static void putToHashtable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public static String getDataString(Hashtable hsData, String fieldName) {
        if (hsData.get(fieldName) != null) {
            return (String)((DataToken)hsData.get((Object)fieldName)).data;
        }
        return null;
    }

    public static BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        if (hsData.get(fieldName) == null) {
            return null;
        }
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return null;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return null;
        }
        return new BigDecimal(str);
    }

    public static boolean getDataboolean(Hashtable hsData, String fieldName) {
        if (hsData.get(fieldName) == null) {
            return false;
        }
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return false;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return false;
        }
        return str.equals("Y") || str.equals("1") || str.equalsIgnoreCase("true");
    }

    public static boolean getDataboolean(Hashtable hsData, String fieldName, boolean defaultValue) {
        if (hsData.get(fieldName) == null) {
            return defaultValue;
        }
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return defaultValue;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return defaultValue;
        }
        if (str.equalsIgnoreCase("Y") || str.equalsIgnoreCase("1") || str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("N") || str.equalsIgnoreCase("0") || str.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    public static String boolToString(boolean value) {
        if (value) {
            return "Y";
        }
        return "N";
    }

    public static int getDataint(Hashtable hsData, String fieldName) {
        if (hsData.get(fieldName) == null) {
            return 0;
        }
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return 0;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return 0;
        }
        return new Integer(str);
    }

    public static Date getDataDate(Hashtable hsData, String fieldName) throws Exception {
        if (hsData.get(fieldName) == null) {
            return null;
        }
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return null;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return null;
        }
        return TypeConversionUtils.objToDate((Object)str);
    }

    public static void AddFilterItemInfo(FilterInfo filter, String fieldName, Object value) {
        filter.getFilterItems().add(new FilterItemInfo(fieldName, value));
    }

    public static EntityViewInfo getViewInfo(FilterInfo filter) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public static MeasureUnitInfo getMeasureUnitInfo(Context ctx, String number) throws TaskExternalException {
        MeasureUnitCollection unitCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            IMeasureUnit iUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            unitCollection = iUnit.getMeasureUnitCollection("where number = '" + number + "'");
            if (unitCollection == null || unitCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString(resClassName, "DataImport_MeasureUnit_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return unitCollection.get(0);
    }

    public static MeasureUnitInfo getMultiMeasureUnitInfo(Context ctx, String number, String materialId) throws TaskExternalException {
        MultiMeasureUnitCollection unitCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        DataImportTools.AddFilterItemInfo(filter, "measureUnit.number", number);
        DataImportTools.AddFilterItemInfo(filter, "material.id", materialId);
        filter.setMaskString("#0 and #1");
        try {
            IMultiMeasureUnit iUnit = MultiMeasureUnitFactory.getLocalInstance(ctx);
            EntityViewInfo ev = DataImportTools.getViewInfo(filter);
            unitCollection = iUnit.getMultiMeasureUnitCollection(ev);
            if (unitCollection == null || unitCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString(resClassName, "DataImport_MeasureUnit_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return unitCollection.get(0).getMeasureUnit();
    }

    public static MaterialTrademarkInfo getMaterialTrademark(Context ctx, CtrlUnitInfo ctrlUnit, String number) throws TaskExternalException {
        MaterialTrademarkInfo trademarkInfo = null;
        IMaterialTrademark itrademark = null;
        MaterialTrademarkCollection trademarkCollection = null;
        try {
            FilterInfo filter = null;
            IMaterialTrademark iDataBaseD = MaterialTrademarkFactory.getLocalInstance((Context)ctx);
            filter = iDataBaseD.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ctrlUnit.getId().toString()), "id", "adminCU.id");
            EntityViewInfo viewInfo = DataImportTools.getViewInfo(filter);
            itrademark = MaterialTrademarkFactory.getLocalInstance((Context)ctx);
            trademarkCollection = itrademark.getMaterialTrademarkCollection(viewInfo);
            if (trademarkCollection == null || trademarkCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString(resAddClassName, "InvalidMaterialTrademark", ctx.getLocale()));
            }
            boolean flag = true;
            for (int i = 0; i < trademarkCollection.size(); ++i) {
                trademarkInfo = trademarkCollection.get(i);
                String trademarkNumber = trademarkInfo.getNumber();
                DataStateEnum dataStateEmnu = trademarkInfo.getStatus();
                if (!number.equals(trademarkNumber) || dataStateEmnu != DataStateEnum.ENABLE) continue;
                flag = false;
                break;
            }
            if (flag) {
                throw new TaskExternalException(DataImportTools.getResString(resAddClassName, "InvalidMaterialTrademark", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportTools.getResString(resAddClassName, "InvalidMaterialTrademark", ctx.getLocale()));
        }
        catch (EASBizException e) {
            throw new TaskExternalException(DataImportTools.getResString(resAddClassName, "InvalidMaterialTrademark", ctx.getLocale()));
        }
        return trademarkInfo;
    }

    public static MaterialInfo getMaterialInfo(Context ctx, String number) throws TaskExternalException {
        return DataImportTools.getMaterialInfo(ctx, number, null);
    }

    public static MaterialInfo getMaterialInfo(Context ctx, String number, SelectorItemCollection selector) throws TaskExternalException {
        MaterialCollection matCollection;
        FilterInfo filter = new FilterInfo();
        DataImportTools.AddFilterItemInfo(filter, "number", number);
        filter.setMaskString("#0");
        try {
            IMaterial iMat;
            EntityViewInfo viewInfo = DataImportTools.getViewInfo(filter);
            if (selector != null) {
                viewInfo.setSelector(selector);
            }
            if ((matCollection = (iMat = MaterialFactory.getLocalInstance(ctx)).getMaterialCollection(viewInfo)) == null || matCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString(resClassName, "DataImport_MaterialNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return matCollection.get(0);
    }

    public static MaterialInfo getMaterialInfo(Context ctx, CtrlUnitInfo ctrlUnit, String number) throws BOSException, EASBizException, TaskExternalException {
        MaterialCollection matCollection;
        try {
            IMaterial iMat = MaterialFactory.getLocalInstance(ctx);
            if (ctrlUnit == null) {
                ctrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            }
            FilterInfo filter = iMat.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ctrlUnit.getId()), "id", "adminCU.id");
            FilterInfo filterNumber = new FilterInfo();
            filterNumber.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            filter.mergeFilter(filterNumber, "and");
            matCollection = iMat.getMaterialCollection(DataImportTools.getViewInfo(filter));
            if (matCollection == null || matCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString(resClassName, "DataImport_MaterialNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return matCollection.get(0);
    }

    public static MaterialGroupStandardInfo getMaterialGroupStandard(Context ctx, String number) throws TaskExternalException {
        MaterialGroupStandardCollection standardCollection;
        FilterInfo filter = new FilterInfo();
        DataImportTools.AddFilterItemInfo(filter, "number", number);
        filter.setMaskString("#0");
        FilterInfo filterCU = new FilterInfo();
        HashSet<String> cuIds = new HashSet<String>();
        cuIds.add(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        cuIds.add(DEFAULT_ADMIN_CU);
        filterCU.getFilterItems().add(new FilterItemInfo("CU.id", cuIds, CompareType.INCLUDE));
        try {
            filter.mergeFilter(filterCU, "and");
        }
        catch (BOSException e1) {
            logger.error((Object)("mergeFilter error, the filterCU is " + filterCU.toSql()));
            throw new TaskExternalException("mergeFilter error", (Throwable)e1);
        }
        try {
            IMaterialGroupStandard iMatGrouStandard = MaterialGroupStandardFactory.getLocalInstance(ctx);
            standardCollection = iMatGrouStandard.getMaterialGroupStandardCollection(DataImportTools.getViewInfo(filter));
            if (standardCollection == null || standardCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString(resClassName, "DataImport_GroupStandardNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return standardCollection.get(0);
    }

    public static MaterialInfo getMaterialInfo(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        IMaterial iMat = MaterialFactory.getLocalInstance(ctx);
        return iMat.getMaterialInfo((IObjectPK)new ObjectUuidPK(id));
    }

    public static String getMaterialName(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        MaterialInfo info = DataImportTools.getMaterialInfo(ctx, id);
        return info.getName();
    }

    public static MaterialGroupInfo getMaterialGroupInfo(Context ctx, String number) throws TaskExternalException {
        MaterialGroupCollection groupCollection;
        FilterInfo filter = new FilterInfo();
        DataImportTools.AddFilterItemInfo(filter, "number", number);
        filter.setMaskString("#0");
        try {
            IMaterialGroup iGroup = MaterialGroupFactory.getLocalInstance(ctx);
            groupCollection = iGroup.getMaterialGroupCollection(DataImportTools.getViewInfo(filter));
            if (groupCollection == null || groupCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString(resClassName, "DataImport_BaseGroup_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return groupCollection.get(0);
    }

    public static MaterialGroupInfo getMaterialGroup(Context ctx, String oql) throws TaskExternalException {
        EntityViewInfo viewInfo = null;
        try {
            viewInfo = new EntityViewInfo(oql);
        }
        catch (ParserException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new TaskExternalException(e1.getMessage());
        }
        try {
            IMaterialGroup iGroup = MaterialGroupFactory.getLocalInstance(ctx);
            MaterialGroupCollection groupCollection = iGroup.getMaterialGroupCollection(viewInfo);
            if (groupCollection != null && groupCollection.size() > 0) {
                return groupCollection.get(0);
            }
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    public static OrgUnitInfo getOrgUnitInfo(Context ctx, String number) throws TaskExternalException {
        FullOrgUnitCollection orgCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            IFullOrgUnit iOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            orgCollection = iOrg.getFullOrgUnitCollection("where number = '" + number + "'");
            if (orgCollection == null || orgCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString(resClassName, "DataImport_OUNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return orgCollection.get(0);
    }

    public static PersonInfo getPersonInfo(Context ctx, String number) throws TaskExternalException {
        PersonCollection perCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            perCollection = iPerson.getPersonCollection("where number = '" + number + "'");
            if (perCollection == null || perCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString(resClassName, "DataImport_InvPlannerNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return perCollection.get(0);
    }

    public static AsstAttrTypeInfo getAsstAttrTypeInfo(Context ctx, String number) throws TaskExternalException {
        AsstAttrTypeCollection asstCollection;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            IAsstAttrType iAsst = AsstAttrTypeFactory.getLocalInstance(ctx);
            asstCollection = iAsst.getAsstAttrTypeCollection("where number = '" + number + "'");
            if (asstCollection == null || asstCollection.size() <= 0) {
                throw new TaskExternalException(DataImportTools.getResString(resClassName, "DataImport_AsstNumber_Error", ctx.getLocale()));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return asstCollection.get(0);
    }

    public static UsedStatusEnum getStatusEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(DataImportTools.getResString("DataImport_UsedStatus_Error", ctx));
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)UsedStatusEnum.UNAPPROVE)) {
            return UsedStatusEnum.UNAPPROVE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)UsedStatusEnum.APPROVED)) {
            return UsedStatusEnum.APPROVED;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)UsedStatusEnum.FREEZED)) {
            return UsedStatusEnum.FREEZED;
        }
        throw new TaskExternalException(DataImportTools.getResString("DataImport_UsedStatus_Error", ctx));
    }

    public static PlanningModeEnum getPlanModeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return PlanningModeEnum.NOPLANNING;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)PlanningModeEnum.NOPLANNING)) {
            return PlanningModeEnum.NOPLANNING;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)PlanningModeEnum.REBOOKPOINT)) {
            return PlanningModeEnum.REBOOKPOINT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)PlanningModeEnum.MPS)) {
            return PlanningModeEnum.MPS;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)PlanningModeEnum.MRP)) {
            return PlanningModeEnum.MRP;
        }
        return PlanningModeEnum.NOPLANNING;
    }

    public static BatchPolicyEnum getBatchPolicyEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return BatchPolicyEnum.FIXATIONBATCH;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)BatchPolicyEnum.FIXATIONBATCH)) {
            return BatchPolicyEnum.FIXATIONBATCH;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)BatchPolicyEnum.STRAIGHTBATCH)) {
            return BatchPolicyEnum.STRAIGHTBATCH;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)BatchPolicyEnum.QTYMAXINVENTORY)) {
            return BatchPolicyEnum.QTYMAXINVENTORY;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)BatchPolicyEnum.FIXCYCLEBATCH)) {
            return BatchPolicyEnum.FIXCYCLEBATCH;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)BatchPolicyEnum.DYNAMICCYCLEBATCH)) {
            return BatchPolicyEnum.DYNAMICCYCLEBATCH;
        }
        throw new TaskExternalException(DataImportTools.getResString("DataImport_materila_bacthe", ctx));
    }

    public static BatchPolicyPartitionTypeEnum getBatchPolicyPartitionTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(DataImportTools.getResString("DataImport_BatchPolicyPartitionType_Error", ctx));
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)BatchPolicyPartitionTypeEnum.POSITIVE)) {
            return BatchPolicyPartitionTypeEnum.POSITIVE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)BatchPolicyPartitionTypeEnum.NEGATIVE)) {
            return BatchPolicyPartitionTypeEnum.NEGATIVE;
        }
        throw new TaskExternalException(DataImportTools.getResString("DataImport_BatchPolicyPartitionType_Error", ctx));
    }

    public static AccountType getAccountTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(DataImportTools.getResString("DataImport_AccountType_Error", ctx));
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)AccountType.STANDARDCOST)) {
            return AccountType.STANDARDCOST;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)AccountType.MOVE_ADD_AVERAGE)) {
            return AccountType.MOVE_ADD_AVERAGE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)AccountType.MOVE_WEIGHTED_AVERAGE)) {
            return AccountType.MOVE_WEIGHTED_AVERAGE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)AccountType.ADD_AVERAGE)) {
            return AccountType.ADD_AVERAGE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)AccountType.SPECIAL_ACCT)) {
            return AccountType.SPECIAL_ACCT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)AccountType.FIN_FOUT)) {
            return AccountType.FIN_FOUT;
        }
        throw new TaskExternalException(DataImportTools.getResString("DataImport_AccountType_Error", ctx));
    }

    public static MaterialGroupStandardTypeEnum getMaterialGroupStandardEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(DataImportTools.getResString("DataImport_GroupStandard_Error", ctx));
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialGroupStandardTypeEnum.BasicStandard)) {
            return MaterialGroupStandardTypeEnum.BasicStandard;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialGroupStandardTypeEnum.DefaultStandard)) {
            return MaterialGroupStandardTypeEnum.DefaultStandard;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialGroupStandardTypeEnum.NetOrderType)) {
            return MaterialGroupStandardTypeEnum.NetOrderType;
        }
        throw new TaskExternalException(DataImportTools.getResString("DataImport_GroupStandard_Error", ctx));
    }

    public static CalculateTypeEnum getCalculateTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(DataImportTools.getResString("DataImport_CalType_Error", ctx));
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)CalculateTypeEnum.PURCHASE)) {
            return CalculateTypeEnum.PURCHASE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)CalculateTypeEnum.CONSIGN)) {
            return CalculateTypeEnum.CONSIGN;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)CalculateTypeEnum.SELFMANUFACTURE)) {
            return CalculateTypeEnum.SELFMANUFACTURE;
        }
        throw new TaskExternalException(DataImportTools.getResString("DataImport_CalType_Error", ctx));
    }

    public static StoreType getStoreTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(DataImportTools.getResString("DataImport_StoreType_Error", ctx));
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)StoreType.SOURCE_MATERIAL)) {
            return StoreType.SOURCE_MATERIAL;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)StoreType.FINISHED_PRODUCT)) {
            return StoreType.FINISHED_PRODUCT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)StoreType.HALF_PRODUCT)) {
            return StoreType.HALF_PRODUCT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)StoreType.PACK_PRODUCT)) {
            return StoreType.PACK_PRODUCT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)StoreType.CONSUME_PRODUCT)) {
            return StoreType.CONSUME_PRODUCT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)StoreType.OTHER)) {
            return StoreType.OTHER;
        }
        throw new TaskExternalException(DataImportTools.getResString("DataImport_StoreType_Error", ctx));
    }

    public static ABCEnum getABCEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return ABCEnum.NOTSELECT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)ABCEnum.A)) {
            return ABCEnum.A;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)ABCEnum.B)) {
            return ABCEnum.B;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)ABCEnum.C)) {
            return ABCEnum.C;
        }
        throw new TaskExternalException(DataImportTools.getResString("DataImport_ABC_Error", ctx));
    }

    public static IssuePriorityEnum getIssuePriorityEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return IssuePriorityEnum.NOTSELECT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)IssuePriorityEnum.BYBATCHNO)) {
            return IssuePriorityEnum.BYBATCHNO;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)IssuePriorityEnum.BYLOTNUMBERQUEUE)) {
            return IssuePriorityEnum.BYLOTNUMBERQUEUE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)IssuePriorityEnum.BYLOTNUMBERSTACK)) {
            return IssuePriorityEnum.BYLOTNUMBERSTACK;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)IssuePriorityEnum.NEARVALIDPERIOD)) {
            return IssuePriorityEnum.NEARVALIDPERIOD;
        }
        throw new TaskExternalException(DataImportTools.getResString("DataImport_IssuePriority_Error", ctx));
    }

    public static TimeUnitEnum getTimeUnitEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return TimeUnitEnum.DAY;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)TimeUnitEnum.DAY)) {
            return TimeUnitEnum.DAY;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)TimeUnitEnum.MONTH)) {
            return TimeUnitEnum.MONTH;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)TimeUnitEnum.YEAR)) {
            return TimeUnitEnum.YEAR;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static PayConditionUsageEnum getPayConditionUsageEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)PayConditionUsageEnum.PAYMENT)) {
            return PayConditionUsageEnum.PAYMENT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)PayConditionUsageEnum.RECEIVE)) {
            return PayConditionUsageEnum.RECEIVE;
        }
        return null;
    }

    public static DeletedStatusEnum getDeletedStatusEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)DeletedStatusEnum.NORMAL)) {
            return DeletedStatusEnum.NORMAL;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)DeletedStatusEnum.DELETED)) {
            return DeletedStatusEnum.DELETED;
        }
        return null;
    }

    public static SettlementTypeEnum getSettlementTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)SettlementTypeEnum.CREDIT)) {
            return SettlementTypeEnum.CREDIT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)SettlementTypeEnum.DATE)) {
            return SettlementTypeEnum.DATE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)SettlementTypeEnum.MONTH)) {
            return SettlementTypeEnum.MONTH;
        }
        return null;
    }

    public static StartStandardEnum getStartStandardEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)StartStandardEnum.BILL_DATE)) {
            return StartStandardEnum.BILL_DATE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)StartStandardEnum.BILL_MONTHEND_DATE)) {
            return StartStandardEnum.BILL_MONTHEND_DATE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)StartStandardEnum.BIZ_DATE)) {
            return StartStandardEnum.BIZ_DATE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)StartStandardEnum.BIZ_MONTHEND_DATE)) {
            return StartStandardEnum.BIZ_MONTHEND_DATE;
        }
        return null;
    }

    public static IsolatedRuleEnum getIsolatedRuleEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return IsolatedRuleEnum.NONE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)IsolatedRuleEnum.ITEM)) {
            return IsolatedRuleEnum.ITEM;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)IsolatedRuleEnum.ITEM_TRACKNO)) {
            return IsolatedRuleEnum.ITEM_TRACKNO;
        }
        return IsolatedRuleEnum.NONE;
    }

    public static boolean EnumEqualByAlias(String value, Enum enumValue) {
        return value.equals(enumValue.getAlias(new Locale(Locale_zh))) || value.equals(enumValue.getAlias(new Locale(Locale_tw)));
    }

    public static boolean EnumAliasCompare(Context ctx, String value, Enum enumValue) {
        return value.equals(enumValue.getAlias(ctx.getOriginLocale()));
    }

    public static String getResString(String resName, Context ctx) {
        return DataImportTools.getResString(resClassName, resName, ctx.getLocale());
    }

    public static String getAddResString(String resName, Context ctx) {
        return DataImportTools.getResString(resAddClassName, resName, ctx.getLocale());
    }

    public static MaterialGroupStandardInfo getGroupStandardInfoByNumber(Context ctx, String number) throws BOSException {
        MaterialGroupStandardInfo info = null;
        if (number != null && number.trim().length() > 0) {
            EntityViewInfo viewInfo = DataImportUtils.getViewInfo((String)number);
            IMaterialGroupStandard iStandard = MaterialGroupStandardFactory.getLocalInstance(ctx);
            MaterialGroupStandardCollection collection = iStandard.getMaterialGroupStandardCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            }
        }
        return info;
    }

    public static MaterialGroupInfo getGroupInfoByNumber(Context ctx, String number, String standardNum) throws BOSException {
        MaterialGroupInfo info = null;
        if (number != null && number.trim().length() > 0) {
            EntityViewInfo viewInfo = DataImportUtils.getViewInfo((String)number);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.number", (Object)standardNum, CompareType.EQUALS));
            viewInfo.getFilter().mergeFilter(filterInfo, "and");
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("isLeaf"));
            viewInfo.getSelector().add(new SelectorItemInfo("groupStandard.*"));
            viewInfo.getSelector().add(new SelectorItemInfo("cu.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("cu.longNumber"));
            IMaterialGroup iMaterialGroup = MaterialGroupFactory.getLocalInstance(ctx);
            MaterialGroupCollection collection = iMaterialGroup.getMaterialGroupCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            }
        }
        return info;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfoFromNumber(Context ctx, String number) throws BOSException {
        ICompanyOrgUnit iCompanyOrgUnit;
        CompanyOrgUnitCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        CompanyOrgUnitInfo info = null;
        if (number != null && number.trim().length() > 0 && (collection = (iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitCollection(viewInfo)) != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static StorageOrgUnitInfo getStorageOrgUnitInfoFromNumber(Context ctx, String number) throws BOSException {
        IStorageOrgUnit iStorageOrgUnit;
        StorageOrgUnitCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitInfo info = null;
        if (number != null && number.trim().length() > 0 && (collection = (iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx)).getStorageOrgUnitCollection(viewInfo)) != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static PurchaseOrgUnitInfo getPurchaseOrgUnitInfoFromNumber(Context ctx, String number) throws BOSException {
        IPurchaseOrgUnit iPurOrgUnit;
        PurchaseOrgUnitCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        PurchaseOrgUnitInfo info = null;
        if (number != null && number.trim().length() > 0 && (collection = (iPurOrgUnit = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx)).getPurchaseOrgUnitCollection(viewInfo)) != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static SaleOrgUnitInfo getSaleOrgUnitInfoFromNumber(Context ctx, String number) throws BOSException {
        ISaleOrgUnit iSaleOrgUnit;
        SaleOrgUnitCollection collection;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SaleOrgUnitInfo info = null;
        if (number != null && number.trim().length() > 0 && (collection = (iSaleOrgUnit = SaleOrgUnitFactory.getLocalInstance((Context)ctx)).getSaleOrgUnitCollection(viewInfo)) != null && collection.size() > 0) {
            info = collection.get(0);
        }
        return info;
    }

    public static boolean isMaterialAssignForOrg(Context ctx, String materialID, CtrlUnitInfo ctrlUnitInfo) throws BOSException {
        if (ctrlUnitInfo == null) {
            return false;
        }
        return DataImportTools.isMaterialAssignForOrg(ctx, materialID, ctrlUnitInfo.getId().toString());
    }

    public static boolean isMaterialAssignForOrg(Context ctx, String materialID, String cuId) throws BOSException {
        FilterInfo filterAssign = new FilterInfo();
        try {
            filterAssign = MaterialFactory.getLocalInstance(ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuId)), "id", "adminCU.id");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        FilterInfo filterMaterialID = new FilterInfo();
        filterMaterialID.getFilterItems().add(new FilterItemInfo("id", (Object)new ObjectUuidPK(BOSUuid.read((String)materialID)), CompareType.EQUALS));
        filterAssign.mergeFilter(filterMaterialID, "and");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterAssign);
        IMaterial imaterial = MaterialFactory.getLocalInstance(ctx);
        MaterialCollection materialColl = imaterial.getMaterialCollection(viewInfo);
        return materialColl != null && materialColl.size() != 0;
    }

    public static MaterialProvideTypeEnum getMaterialProvideTypeEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialProvideTypeEnum.NONE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE)) {
            return MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialProvideTypeEnum.CURRENTORGPROVIDE)) {
            return MaterialProvideTypeEnum.CURRENTORGPROVIDE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialProvideTypeEnum.NONE)) {
            return MaterialProvideTypeEnum.NONE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialProvideTypeEnum.SPANORGPROVIDE)) {
            return MaterialProvideTypeEnum.SPANORGPROVIDE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE)) {
            return MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static MaterialAttributeEnum getMaterialAttributeEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialAttributeEnum.FABRICATEDPART;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialAttributeEnum.PHANTOMPART)) {
            return MaterialAttributeEnum.PHANTOMPART;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialAttributeEnum.FABRICATEDPART)) {
            return MaterialAttributeEnum.FABRICATEDPART;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialAttributeEnum.PURCHASEDPART)) {
            return MaterialAttributeEnum.PURCHASEDPART;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialAttributeEnum.EXTERNALPROCESSINPART)) {
            return MaterialAttributeEnum.EXTERNALPROCESSINPART;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialAttributeEnum.OTHER)) {
            return MaterialAttributeEnum.OTHER;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static MaterialCharEnum getMaterialCharEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialCharEnum.NONE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialCharEnum.NONE)) {
            return MaterialCharEnum.NONE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialCharEnum.MASTERPROP)) {
            return MaterialCharEnum.MASTERPROP;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialCharEnum.AUXILIARYPROP)) {
            return MaterialCharEnum.AUXILIARYPROP;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialCharEnum.REFERRENCEPROP)) {
            return MaterialCharEnum.REFERRENCEPROP;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static MaterialOffsetEnum getMaterialOffsetEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialOffsetEnum.NONE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialOffsetEnum.NONE)) {
            return MaterialOffsetEnum.NONE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialOffsetEnum.OFFSETFORWARD)) {
            return MaterialOffsetEnum.OFFSETFORWARD;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialOffsetEnum.OFFSETBACK)) {
            return MaterialOffsetEnum.OFFSETBACK;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialOffsetEnum.OFFSETFORWARDTOBACK)) {
            return MaterialOffsetEnum.OFFSETFORWARDTOBACK;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialOffsetEnum.OFFSETBACKTOFORWARD)) {
            return MaterialOffsetEnum.OFFSETBACKTOFORWARD;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static DemandMergeRulerEnum getDemandMergeRulerEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return DemandMergeRulerEnum.None;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)DemandMergeRulerEnum.None)) {
            return DemandMergeRulerEnum.None;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)DemandMergeRulerEnum.MERGEBYDAY)) {
            return DemandMergeRulerEnum.MERGEBYDAY;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static EquipmentPropertyEnum getEquipmentPropertyEnum(String value, Context ctx) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return EquipmentPropertyEnum.DEFAULT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)EquipmentPropertyEnum.DEFAULT)) {
            return EquipmentPropertyEnum.DEFAULT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)EquipmentPropertyEnum.EQUIPMENT)) {
            return EquipmentPropertyEnum.EQUIPMENT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)EquipmentPropertyEnum.SPARE_PART)) {
            return EquipmentPropertyEnum.SPARE_PART;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)EquipmentPropertyEnum.TOOL)) {
            return EquipmentPropertyEnum.TOOL;
        }
        throw new TaskExternalException(DataImportTools.getResString("DataImport_EquipProperty_INPUT_ERROR", ctx));
    }

    public static MaterialLeadTimeTypeEnum getMaterialLeadTimeTypeEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialLeadTimeTypeEnum.FIXBATCHTYPE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialLeadTimeTypeEnum.FIXBATCHTYPE)) {
            return MaterialLeadTimeTypeEnum.FIXBATCHTYPE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialLeadTimeTypeEnum.CHANGEBATCHTYPE)) {
            return MaterialLeadTimeTypeEnum.CHANGEBATCHTYPE;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static MaterialScrapRateExpressionEnum getMaterialScrapRateExpressionEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialScrapRateExpressionEnum.BYDIVIDE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialScrapRateExpressionEnum.BYDIVIDE)) {
            return MaterialScrapRateExpressionEnum.BYDIVIDE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialScrapRateExpressionEnum.MUTIPLE)) {
            return MaterialScrapRateExpressionEnum.MUTIPLE;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static MaterialProductEnum getMaterialProductEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        MaterialProductEnum defaultValue = MaterialProductEnum.OTHER;
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialProductEnum.MASTERPRODUCT)) {
            return MaterialProductEnum.MASTERPRODUCT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialProductEnum.RELATEDPRODUCT)) {
            return MaterialProductEnum.RELATEDPRODUCT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialProductEnum.BYPRODUCT)) {
            return MaterialProductEnum.BYPRODUCT;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialProductEnum.OTHER)) {
            return MaterialProductEnum.OTHER;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static MaterialIssueModeEnum getMaterialIssueModeEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        MaterialIssueModeEnum defaultValue = MaterialIssueModeEnum.PRODUCEISSMODE;
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialIssueModeEnum.PRODUCEISSMODE)) {
            return MaterialIssueModeEnum.PRODUCEISSMODE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialIssueModeEnum.KANBANISSMODE)) {
            return MaterialIssueModeEnum.KANBANISSMODE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialIssueModeEnum.NOTISSMODE)) {
            return MaterialIssueModeEnum.NOTISSMODE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialIssueModeEnum.STRAIGHT)) {
            return MaterialIssueModeEnum.STRAIGHT;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static MaterialBaseDispersionEnum getMaterialBaseDispersionEnum(String value, Context ctx, String errResName) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return MaterialBaseDispersionEnum.PRODUCTIONPLANQTY;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialBaseDispersionEnum.PRODUCTIONPLANQTY)) {
            return MaterialBaseDispersionEnum.PRODUCTIONPLANQTY;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)MaterialBaseDispersionEnum.FINISHEDREPORTQTY)) {
            return MaterialBaseDispersionEnum.FINISHEDREPORTQTY;
        }
        throw new TaskExternalException(DataImportTools.getResString(errResName, ctx));
    }

    public static ThrowModeEnum getThrowModeEnum(String value, Context ctx) throws TaskExternalException {
        ThrowModeEnum defaultValue = ThrowModeEnum.DISCRETE;
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)ThrowModeEnum.DISCRETE)) {
            return ThrowModeEnum.DISCRETE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)ThrowModeEnum.FLOW)) {
            return ThrowModeEnum.FLOW;
        }
        return defaultValue;
    }

    public static ReplaceModeEnum getReplaceModeEnum(String value, Context ctx) throws TaskExternalException {
        ReplaceModeEnum defaultValue = ReplaceModeEnum.NONE;
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)ReplaceModeEnum.AllREPLACE)) {
            return ReplaceModeEnum.AllREPLACE;
        }
        if (DataImportTools.EnumAliasCompare(ctx, value, (Enum)ReplaceModeEnum.PARTREPLACE)) {
            return ReplaceModeEnum.PARTREPLACE;
        }
        return defaultValue;
    }
}

