/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.material.IMaterialAsstAttrValue;
import com.kingdee.eas.basedata.master.material.MaterialAsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.MaterialAsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.MaterialAsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialAsstAttrValueControllerBean;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MaterialAsstAttrValueControllerBean
extends AbstractMaterialAsstAttrValueControllerBean {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MaterialAsstAttrValueControllerBean");
    private static final String MaterialResource = "com.kingdee.eas.basedata.master.material.MaterialResource";

    @Override
    protected boolean _saveCollection(Context ctx, MaterialAsstAttrValueCollection materialAsstAttrColl) throws BOSException, EASBizException {
        ArrayList<String> deleteInfoList = new ArrayList<String>();
        ArrayList<String> addnewInfoList = new ArrayList<String>();
        ArrayList<String> updateInfoList = new ArrayList<String>();
        MaterialAsstAttrValueCollection uiCollection = materialAsstAttrColl;
        if (uiCollection == null || uiCollection.size() == 0) {
            return false;
        }
        ArrayList<String> uiIdList = new ArrayList<String>();
        MaterialAsstAttrValueInfo valueInfo = uiCollection.get(0);
        String materialID = valueInfo.getMaterial().getId().toString();
        for (int i = 0; i < uiCollection.size(); ++i) {
            valueInfo = uiCollection.get(i);
            if (valueInfo.getId() == null || valueInfo.getId().toString().trim().length() <= 0) continue;
            uiIdList.add(valueInfo.getId().toString());
        }
        MaterialAsstAttrValueCollection dbCollection = this.getCollectionByMaterial(ctx, materialID);
        for (int i = 0; i < dbCollection.size(); ++i) {
            valueInfo = dbCollection.get(i);
            String dbId = valueInfo.getId().toString();
            if (uiIdList.contains(dbId)) continue;
            this.checkHasReference(ctx, valueInfo.getId(), valueInfo.getValue().getName());
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(dbId));
            deleteInfoList.add(valueInfo.getValue().getNumber());
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < uiCollection.size(); ++i) {
            valueInfo = uiCollection.get(i);
            if (valueInfo.getId() != null && valueInfo.getId().toString().trim().length() > 0) {
                updateInfoList.add(valueInfo.getValue().getNumber());
                continue;
            }
            addnewInfoList.add(valueInfo.getValue().getNumber());
        }
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance(ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
        sb.append(ResourceBase.getString((String)MaterialResource, (String)"material", (Locale)ctx.getOriginLocale()) + "\uff1a" + materialInfo.getNumber() + "\n");
        sb.append(ResourceBase.getString((String)MaterialResource, (String)"addnew", (Locale)ctx.getOriginLocale()) + "\uff1a" + Arrays.toString((Object[])addnewInfoList.toArray()) + "\n");
        sb.append(ResourceBase.getString((String)MaterialResource, (String)"edit", (Locale)ctx.getOriginLocale()) + "\uff1a" + Arrays.toString((Object[])updateInfoList.toArray()) + "\n");
        sb.append(ResourceBase.getString((String)MaterialResource, (String)"Delete", (Locale)ctx.getOriginLocale()) + "\uff1a" + Arrays.toString((Object[])deleteInfoList.toArray()));
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_saveCollection", (BOSObjectType)new MaterialAsstAttrValueInfo().getBOSType(), null, (String)sb.toString(), (String)"bd_material_asstattrValue", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)MaterialResource, (String)"AsstattrValueEdit", (Locale)ctx.getOriginLocale()));
        for (int i = 0; i < uiCollection.size(); ++i) {
            valueInfo = uiCollection.get(i);
            if (valueInfo.getId() != null && valueInfo.getId().toString().trim().length() > 0) {
                ObjectUuidPK pk = new ObjectUuidPK(valueInfo.getId());
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)valueInfo);
                continue;
            }
            this.addnew(ctx, (CoreBaseInfo)valueInfo);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        return true;
    }

    private void checkHasReference(Context ctx, BOSUuid id, String name) throws EASBizException, BOSException {
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)id);
        if (!rs.isFound()) {
            return;
        }
        if (rs.getException() != null) {
            throw rs.getException();
        }
        if (rs.getDetailMap() != null) {
            throw new MaterialBaseException(MaterialBaseException.REF_NOT_DELETE_ASST_ATTR, new Object[]{name});
        }
    }

    @Override
    protected boolean _removeByMaterial(Context ctx, BOSUuid materialID) throws BOSException, EASBizException {
        MaterialAsstAttrValueCollection dbCollection = this._getCollectionByMaterial(ctx, materialID.toString());
        for (int i = 0; i < dbCollection.size(); ++i) {
            MaterialAsstAttrValueInfo materialValueInfo = dbCollection.get(i);
            this.checkHasReference(ctx, materialValueInfo.getId(), materialValueInfo.getValue().getName());
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(materialValueInfo.getId()));
        }
        return true;
    }

    @Override
    public boolean removeByMaterial(Context ctx, BOSUuid materialID) throws BOSException, EASBizException {
        boolean isImport = "true".equals(ctx.get((Object)"isImport"));
        if (!isImport) {
            return super.removeByMaterial(ctx, materialID);
        }
        try {
            boolean retValue = this._removeByMaterial(ctx, materialID);
            return retValue;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }

    @Override
    protected MaterialAsstAttrValueCollection _getCollectionByMaterial(Context ctx, String materialID) throws BOSException, EASBizException {
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        entity.setFilter(filter);
        SelectorItemCollection sc = entity.getSelector();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("value.id"));
        sc.add(new SelectorItemInfo("value.number"));
        sc.add(new SelectorItemInfo("value.name"));
        sc.add(new SelectorItemInfo("material.id"));
        sc.add(new SelectorItemInfo("material.number"));
        sc.add(new SelectorItemInfo("material.name"));
        MaterialAsstAttrValueCollection collection = this.getMaterialAsstAttrValueCollection(ctx, entity);
        return collection;
    }

    private EntityViewInfo getValueEntityView(String asstAttrTypeID) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("basictype.id", (Object)asstAttrTypeID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("compondingtype.id", (Object)asstAttrTypeID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)DeletedStatusEnum.NORMAL, CompareType.EQUALS));
        filterInfo.setMaskString("(#0 or #1) and #2");
        evi.setFilter(filterInfo);
        return evi;
    }

    @Override
    protected int _addByAttrType(Context ctx, BOSUuid materialID, String asstAttrTypeID) throws BOSException, EASBizException {
        PreparedStatement stmt;
        Connection cn;
        int insertRows;
        block14: {
            if (materialID == null) {
                return 0;
            }
            IMaterialAsstAttrValue iAsstAttrValue = MaterialAsstAttrValueFactory.getLocalInstance(ctx);
            boolean update = iAsstAttrValue.exists(this.getValueFilterInfo(materialID.toString()));
            insertRows = 0;
            cn = null;
            stmt = null;
            try {
                cn = EJBFactory.getConnection((Context)ctx);
                if (update) {
                    this.logger.error((Object)"_addByAttrType enter update");
                    String getAsstAttrIds = "select FID from T_BD_AsstAttrValue where (FBasictypeID ='" + asstAttrTypeID + "' or FCompondingtypeID='" + asstAttrTypeID + "') and FDeletedStatus=1";
                    String getMaterialAsstAttrIds = "select FAsstAttrValueID from T_BD_MaterialAsstAttrValue where FMaterialID='" + materialID + "'";
                    stmt = cn.prepareStatement(getAsstAttrIds);
                    ResultSet asstResultSet = stmt.executeQuery();
                    HashSet<String> asstAttrIdSet = new HashSet<String>();
                    HashSet<String> asstAttrIdSetCopy = new HashSet<String>();
                    while (asstResultSet.next()) {
                        asstAttrIdSet.add(asstResultSet.getString(1));
                        asstAttrIdSetCopy.add(asstResultSet.getString(1));
                    }
                    stmt = cn.prepareStatement(getMaterialAsstAttrIds);
                    HashSet<String> matAsstAttrIdSet = new HashSet<String>();
                    HashSet<String> matAsstAttrIdSetCopy = new HashSet<String>();
                    ResultSet matAsstRs = stmt.executeQuery();
                    while (matAsstRs.next()) {
                        matAsstAttrIdSet.add(matAsstRs.getString(1));
                        matAsstAttrIdSetCopy.add(matAsstRs.getString(1));
                    }
                    matAsstAttrIdSet.removeAll(asstAttrIdSet);
                    if (matAsstAttrIdSet.size() > 0) {
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
                        filterInfo.getFilterItems().add(new FilterItemInfo("value.id", matAsstAttrIdSet, CompareType.INCLUDE));
                        viewInfo.setFilter(filterInfo);
                        SelectorItemCollection sic = viewInfo.getSelector();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("value.name"));
                        MaterialAsstAttrValueCollection materialAsstAttrValueCollection = MaterialAsstAttrValueFactory.getLocalInstance(ctx).getMaterialAsstAttrValueCollection(viewInfo);
                        if (materialAsstAttrValueCollection.size() > 0) {
                            for (int i = 0; i < materialAsstAttrValueCollection.size(); ++i) {
                                this.checkHasReference(ctx, materialAsstAttrValueCollection.get(i).getId(), materialAsstAttrValueCollection.get(i).getValue().getName());
                                this.delete(ctx, (IObjectPK)new ObjectUuidPK(materialAsstAttrValueCollection.get(i).getId()));
                            }
                        }
                    }
                    asstAttrIdSetCopy.removeAll(matAsstAttrIdSetCopy);
                    if (asstAttrIdSetCopy.size() > 0) {
                        String insertSql = "insert into T_BD_MaterialAsstAttrValue(FID,FSEQ,FMaterialID,FAsstAttrValueID)values (newbosid('AEAA1BF0'),?,?,?)";
                        stmt = cn.prepareStatement(insertSql);
                        int count = 0;
                        for (String asstAttrId : asstAttrIdSetCopy) {
                            stmt.setInt(1, 1);
                            stmt.setString(2, materialID.toString());
                            stmt.setString(3, asstAttrId);
                            stmt.addBatch();
                            if (++count % 1000 != 0) continue;
                            stmt.executeBatch();
                            stmt.clearBatch();
                            count = 0;
                        }
                        if (count > 0) {
                            stmt.executeBatch();
                        }
                    }
                    break block14;
                }
                String insertSql = "insert into T_BD_MaterialAsstAttrValue(FID,FSEQ,FMaterialID,FAsstAttrValueID)select newbosid('AEAA1BF0') FID,1 FSEQ,'" + materialID + "' FMaterialID,asst.FID FAsstAttrValueID from T_BD_AsstAttrValue asst where (FBasictypeID='" + asstAttrTypeID + "' or FCompondingtypeID='" + asstAttrTypeID + "') and FDeletedStatus=1";
                stmt = cn.prepareStatement(insertSql);
                insertRows = stmt.executeUpdate();
                this.logger.error((Object)("_addByAttrType insert rows:" + insertRows));
            }
            catch (SQLException e) {
                try {
                    this.logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)cn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return insertRows;
    }

    private FilterInfo getValueFilterInfo(String materialId) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        return filterInfo;
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(ctx.get((Object)"isImport"));
        if (!isImport) {
            return super.addnew(ctx, model);
        }
        try {
            return this._addnew(ctx, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }
}

