/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyApproveProcess;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialCompanyInfoControllerBean;
import com.kingdee.eas.basedata.master.material.app.MaterialSrvUtils;
import com.kingdee.eas.basedata.master.material.app.builder.MaterialCompanyProcessorBuilder;
import com.kingdee.eas.basedata.master.material.util.MaterialUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutingHelper;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class MaterialCompanyInfoControllerBean
extends AbstractMaterialCompanyInfoControllerBean {
    private static Logger logger = Logger.getLogger(MaterialCompanyInfoControllerBean.class);

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialCompanyInfoInfo info = (MaterialCompanyInfoInfo)model;
        info.setCreateTime(null);
        if (info.getCompany() == null || info.getCompany().getId().toString().equals("")) {
            throw new MaterialBaseException(MaterialBaseException.COMPANYORG_INVALID);
        }
        if (info.getCompany().getCU() != null) {
            info.setCU(info.getCompany().getCU());
        }
        info.validate();
        this.dealPrecision(ctx, info);
        this._checkComDup(ctx, (IObjectValue)info);
        info.put("MaterialNumber", MaterialSrvUtils.getMaterialLogInfo(ctx, info.getMateial().getId().toString()));
        this.checkStandCost(info);
        if (info.getCalculateType().equals((Object)CalculateTypeEnum.SELFMANUFACTURE) && info.getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
            CostObjectFactory.getLocalInstance((Context)ctx).addByMaterial(info);
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IMaterialCompanyInfo iMaterialCom = MaterialCompanyInfoFactory.getLocalInstance(ctx);
        MaterialCompanyInfoInfo oldInfo = iMaterialCom.getMaterialCompanyInfoInfo(pk, this.getSelectors());
        MaterialCompanyInfoInfo info = (MaterialCompanyInfoInfo)model;
        info.setCreateTime(oldInfo.getCreateTime());
        if (info.getCompany() != null && info.getCompany().getCU() != null) {
            info.setCU(info.getCompany().getCU());
        }
        AccountType oldAccountType = oldInfo.getAccountType();
        AccountType newAccountType = info.getAccountType();
        if (UsedStatusEnum.APPROVED == oldInfo.getStatus()) {
            if (oldAccountType != null && newAccountType != null && !oldAccountType.equals((Object)newAccountType)) {
                throw new MaterialBaseException(MaterialBaseException.COMPANY_INFO_APPROVED_CAN_NOT_UPDATE_ACCOUNT_TYPE);
            }
            if (info.get("isImport") != null && !((Boolean)info.get("isImport")).booleanValue() && oldInfo.getStandardCost() != null && info.getStandardCost() != null && oldInfo.getStandardCost().floatValue() != info.getStandardCost().floatValue()) {
                throw new MaterialBaseException(MaterialBaseException.COMPANY_INFO_APPROVED_CAN_NOT_UPDATE_STANDARD_COST);
            }
            if (info.isIsLot() != oldInfo.isIsLot() || info.isIsAssistProperty() != info.isIsAssistProperty() || info.isIsProject() != info.isIsProject() || info.isIsTrackNumber() != info.isIsTrackNumber()) {
                throw new MaterialBaseException(MaterialBaseException.MATERIAL_COMPANYINFO_APPROVED001);
            }
        }
        if (info.getCompany() == null || info.getCompany().getId().toString().equals("")) {
            throw new MaterialBaseException(MaterialBaseException.COMPANYORG_INVALID);
        }
        this.dealPrecision(ctx, info);
        this._checkComDup(ctx, (IObjectValue)info);
        if (!this.compareValue(ctx, oldInfo, info)) {
            this.checkHasReference(ctx, oldInfo, info);
        }
        ApplicationContext ac = new ApplicationContext();
        if (oldAccountType != null && newAccountType != null && AccountType.SPECIAL_ACCT.equals((Object)oldAccountType) && (AccountType.ADD_AVERAGE.equals((Object)newAccountType) || AccountType.FIN_FOUT.equals((Object)newAccountType) || AccountType.MOVE_ADD_AVERAGE.equals((Object)newAccountType) || AccountType.STANDARDCOST.equals((Object)newAccountType) || AccountType.MOVE_WEIGHTED_AVERAGE.equals((Object)newAccountType)) || AccountType.SPECIAL_ACCT.equals((Object)newAccountType) && (AccountType.ADD_AVERAGE.equals((Object)oldAccountType) || AccountType.FIN_FOUT.equals((Object)oldAccountType) || AccountType.MOVE_ADD_AVERAGE.equals((Object)oldAccountType) || AccountType.STANDARDCOST.equals((Object)oldAccountType) || AccountType.MOVE_WEIGHTED_AVERAGE.equals((Object)oldAccountType))) {
            ac.putData("info", (Object)info);
            BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{info}, (BatchActionEnum)MaterialCompanyProcessorBuilder.ACT_UPDATE, MaterialCompanyProcessorBuilder.class, (ApplicationContext)ac);
        }
        this.checkStandCost(info);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkStandCost(MaterialCompanyInfoInfo materialCompanyInfo) {
        if (!materialCompanyInfo.getAccountType().equals((Object)AccountType.STANDARDCOST) && materialCompanyInfo.getStandardCost() == null) {
            materialCompanyInfo.setStandardCost(new BigDecimal(0));
        }
    }

    private Throwable checkReference(Context ctx, BOSUuid id) {
        Exception e = null;
        try {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(id));
            BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id);
        }
        catch (Exception er) {
            e = er;
        }
        return e;
    }

    private void checkHasReference(Context ctx, MaterialCompanyInfoInfo oldVO, MaterialCompanyInfoInfo updateVO) throws EASBizException, BOSException {
        BizCheckResult rs;
        Throwable e = this.checkReference(ctx, updateVO.getId());
        String msg = null;
        if (e != null) {
            msg = e.getMessage();
        }
        logger.info((Object)("checkHasReference:001---------\n" + msg));
        String companyID = updateVO.getCompany().getId().toString().toString();
        String materialNumber = oldVO.getMateial().getNumber();
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        boolean isCostObjectRef = iCostObject.checkMaterialUsed(companyID, materialNumber, 0);
        if ((e != null || isCostObjectRef) && oldVO.getAccountType().getValue() != updateVO.getAccountType().getValue()) {
            throw new MaterialBaseException(MaterialBaseException.REF_NOT_UPDATE_ACCOUNTTYPE, e);
        }
        boolean isEdit = false;
        BigDecimal oldCost = oldVO.getStandardCost();
        BigDecimal newCost = updateVO.getStandardCost();
        if ((oldCost != null || newCost != null) && oldVO.getAccountType().equals((Object)AccountType.STANDARDCOST)) {
            if (oldCost == null && newCost != null) {
                isEdit = true;
            }
            if (oldCost != null && newCost == null) {
                isEdit = true;
            }
            if (!isEdit && oldCost.compareTo(newCost) != 0) {
                isEdit = true;
            }
        }
        logger.info((Object)("checkHasReference:002 oldVO.getAccountType();updateVO.getAccountType()---------\n" + oldVO.getAccountType().getValue() + ";" + updateVO.getAccountType().getValue()));
        if (!isEdit && !oldVO.getAccountType().equals((Object)updateVO.getAccountType())) {
            isEdit = true;
        }
        if (isEdit && (rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)updateVO.getId())).isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_UPDATE_COM);
            }
        }
    }

    private void _checkComDup(Context ctx, IObjectValue model) throws MaterialBaseException, EASBizException, BOSException {
        MaterialCompanyInfoInfo info = (MaterialCompanyInfoInfo)model;
        String comID = info.getCompany().getId().toString();
        String materialID = info.getMateial().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)comID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialID, CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filter)) {
            throw new MaterialBaseException(MaterialBaseException.COMPANYHASBEENMATERIAL);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialCompanyInfoInfo info = this.getMaterialCompanyInfoInfo(ctx, pk);
        CtrlUnitInfo curCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (!curCU.getId().toString().equals(info.getCU().getId().toString())) {
            throw new MaterialBaseException(MaterialBaseException.CANNOT_DELETE_OTHERCUASSIST);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_DELETE_COM);
            }
        }
        super._delete(ctx, pk);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("mateial.id"));
        sic.add(new SelectorItemInfo("mateial.number"));
        return sic;
    }

    @Override
    protected void _approve(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialCompanyInfo iproperty = MaterialCompanyInfoFactory.getLocalInstance(ctx);
        MaterialCompanyInfoInfo info = iproperty.getMaterialCompanyInfoInfo(pk);
        this._approve(ctx, info);
    }

    private String getDataPermissionSql(Context ctx, String cuId, String PerminsionItem) throws BOSException, EASBizException {
        ObjectUuidPK CUPK = new ObjectUuidPK(cuId);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        return iPermission.getPermissionWhereSQL((IObjectPK)userPK, (IObjectPK)CUPK, PerminsionItem, "Fid");
    }

    @Override
    protected int _approveBatch(Context ctx, List materialIds, String ouId) throws BOSException, EASBizException {
        StringBuffer updatesql = new StringBuffer();
        int updateCount = 0;
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            String materialComIdTable = this.generateTempTableToApprove(ctx, materialIds, ouId);
            updatesql.append(" update t_bd_materialcompanyinfo set FStatus = ").append(String.valueOf(1)).append(",flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=now()   where fid in ");
            updatesql.append("(select fid from ").append(materialComIdTable).append(" temp)");
            String updateSql = updatesql.toString();
            updateCount = statement.executeUpdate(updateSql);
            this.afterApproveBatch(ctx, materialComIdTable);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
        return updateCount;
    }

    private void afterApproveBatch(Context ctx, String companyInfoTable) throws BOSException, EASBizException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)this.getBOSType().toString(), IMaterialCompanyApproveProcess.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers != null) {
            String checkerName = "";
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                try {
                    MaterialCompanyInfoCollection infos = this.getMaterialCompanyInfoCollection(ctx, "where id in (select fid from " + companyInfoTable + ")");
                    for (int j = 0; j < infos.size(); ++j) {
                        MaterialCompanyInfoInfo info = infos.get(j);
                        ((IMaterialCompanyApproveProcess)Class.forName(checkerName).newInstance()).approve(ctx, info);
                    }
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private void afterUnApproveBatch(Context ctx, String companyInfoTable) throws BOSException, EASBizException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)this.getBOSType().toString(), IMaterialCompanyApproveProcess.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers != null) {
            String checkerName = "";
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                try {
                    MaterialCompanyInfoCollection infos = this.getMaterialCompanyInfoCollection(ctx, "where id in (select fid from " + companyInfoTable + ")");
                    for (int j = 0; j < infos.size(); ++j) {
                        MaterialCompanyInfoInfo info = infos.get(j);
                        ((IMaterialCompanyApproveProcess)Class.forName(checkerName).newInstance()).unApprove(ctx, info);
                    }
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected void _approve(Context ctx, MaterialCompanyInfoInfo info) throws BOSException, EASBizException {
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        if (((Boolean)(ctx.get((Object)"material_need_checkcu") == null ? Boolean.valueOf(true) : ctx.get((Object)"material_need_checkcu"))).booleanValue()) {
            MaterialUtils.checkCU(ctx, info.getCU().getId().toString());
        }
        IMaterial ima = MaterialFactory.getLocalInstance(ctx);
        MaterialInfo mainfo = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMateial().getId()));
        System.out.println("\u7269\u6599\u57fa\u672c\u8d44\u6599\u7684\u72b6\u6001:" + mainfo.getStatus().getAlias());
        if (mainfo.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
        }
        if (mainfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
        }
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        StringBuffer updatesql = new StringBuffer();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            updatesql.append(" update t_bd_materialcompanyinfo set FStatus = ").append(String.valueOf(1)).append(",flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=now()   where fid = '").append(info.getId().toString()).append("'");
            String updateSql = updatesql.toString();
            statement.execute(updateSql);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)this.getBOSType().toString(), IMaterialCompanyApproveProcess.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers != null) {
            String checkerName = "";
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                try {
                    ((IMaterialCompanyApproveProcess)Class.forName(checkerName).newInstance()).approve(ctx, info);
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected int _unApproveBatch(Context ctx, List materialIds, String ouId) throws BOSException, EASBizException {
        StringBuffer updatesql = new StringBuffer();
        int updateCount = 0;
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            String materialComIdTable = this.generateTempTableToUnApprove(ctx, materialIds, ouId);
            updatesql.append(" update t_bd_materialcompanyinfo set FStatus = ").append(String.valueOf(0)).append(",flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=now()  where fid in ");
            updatesql.append("(select fid from ").append(materialComIdTable).append(" temp)");
            String updateSql = updatesql.toString();
            updateCount = statement.executeUpdate(updateSql);
            this.afterUnApproveBatch(ctx, materialComIdTable);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
        return updateCount;
    }

    @Override
    protected void _unApprove(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialCompanyInfo iproperty = MaterialCompanyInfoFactory.getLocalInstance(ctx);
        MaterialCompanyInfoInfo info = iproperty.getMaterialCompanyInfoInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU(ctx, info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)this.getBOSType().toString(), IMaterialCompanyApproveProcess.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers != null) {
            String checkerName = "";
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                try {
                    ((IMaterialCompanyApproveProcess)Class.forName(checkerName).newInstance()).unApprove(ctx, info);
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        info.setStatus(UsedStatusEnum.UNAPPROVE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialCompanyInfo iproperty = MaterialCompanyInfoFactory.getLocalInstance(ctx);
        MaterialCompanyInfoInfo info = iproperty.getMaterialCompanyInfoInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU(ctx, info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.FREEZED);
        info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _unFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialCompanyInfo iproperty = MaterialCompanyInfoFactory.getLocalInstance(ctx);
        MaterialCompanyInfoInfo info = iproperty.getMaterialCompanyInfoInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU(ctx, info.getCU().getId().toString());
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTSAVE);
        }
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTFREEZED);
        }
        info.setStatus(UsedStatusEnum.APPROVED);
        info.setFreezeOrgUnit(null);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected MaterialCompanyInfoInfo _first(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected MaterialCompanyInfoInfo _previous(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected MaterialCompanyInfoInfo _next(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected MaterialCompanyInfoInfo _last(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, MaterialCompanyInfoInfo newInfo) throws BOSException, EASBizException {
        newInfo.validate();
        MaterialCompanyInfoInfo oldInfo = this.getMaterialCompanyInfoInfo(ctx, pk);
        String name = newInfo.getMateial().getName(ctx.getLocale());
        if (newInfo.getStatus() == UsedStatusEnum.APPROVED) {
            Object updateProperties = newInfo.get("updateProperties");
            if (updateProperties == null || updateProperties instanceof Object[] && ((Object[])updateProperties).length > 0 && !((Object[])updateProperties)[0].equals("kAClass")) {
                throw new MaterialBaseException(MaterialBaseException.APPROVE_INVALID, new Object[]{name});
            }
        } else if (newInfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.FREEZED_INVALID, new Object[]{name});
        }
        this.checkHasReference(ctx, oldInfo, newInfo);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = this.getSelectors();
        sic.add(new SelectorItemInfo("mateial.name"));
        MaterialCompanyInfoInfo info = this.getMaterialCompanyInfoInfo(ctx, pk, sic);
        MaterialInfo matInfo = (MaterialInfo)info.get("mateial");
        if (matInfo != null) {
            return matInfo.getNumber() + "  " + matInfo.getName(ctx.getLocale());
        }
        return pk.toString();
    }

    public void dealPrecision(Context ctx, MaterialCompanyInfoInfo newInfo) throws BOSException, EASBizException {
        IMaterial iMaterial = MaterialFactory.getLocalInstance(ctx);
        if (newInfo != null && newInfo.getMateial() != null && newInfo.getMateial().getId() != null) {
            MaterialInfo materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(newInfo.getMateial().getId()));
            int pricePrecision = materialInfo.getPricePrecision();
            if (newInfo.getStandardCost() != null) {
                newInfo.setStandardCost(newInfo.getStandardCost().setScale(pricePrecision, 4));
            }
        }
    }

    private boolean compareValue(Context ctx, MaterialCompanyInfoInfo oldVO, MaterialCompanyInfoInfo updateVO) {
        if (!oldVO.getId().toString().equals(updateVO.getId().toString())) {
            return false;
        }
        if (!oldVO.getCompany().getId().toString().equals(oldVO.getCompany().getId().toString())) {
            return false;
        }
        if (oldVO.getStandardCost() == null) {
            oldVO.setStandardCost(BigDecimal.valueOf(0L));
        }
        if (updateVO.getStandardCost() == null) {
            updateVO.setStandardCost(BigDecimal.valueOf(0L));
        }
        if (oldVO.getStandardCost().compareTo(updateVO.getStandardCost()) != 0) {
            return false;
        }
        if (oldVO.getCalculateType().compareTo((Object)updateVO.getCalculateType()) != 0) {
            return false;
        }
        if (oldVO.getAccountType().compareTo((Object)updateVO.getAccountType()) != 0) {
            return false;
        }
        if (oldVO.isIsLot() ^ updateVO.isIsLot()) {
            return false;
        }
        if (oldVO.isIsProject() ^ updateVO.isIsProject()) {
            return false;
        }
        if (oldVO.isIsTrackNumber() ^ updateVO.isIsTrackNumber()) {
            return false;
        }
        if (oldVO.isIsAssistProperty() ^ updateVO.isIsAssistProperty()) {
            return false;
        }
        return !(oldVO.isCreateCOByOrder() ^ updateVO.isCreateCOByOrder());
    }

    protected String createTempTable(Context ctx, String desc) throws BOSException, EASBizException {
        String tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(desc);
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("fid        varchar(44)");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        return tbl;
    }

    private String generateTempTableToApprove(Context ctx, List<String> materialBaseIds, String ouID) throws SQLDataException, BOSException, EASBizException {
        StringBuffer insertSql = new StringBuffer(50);
        String tempTable = this.createTempTable(ctx, "materialCompany");
        insertSql.append("insert into ").append(tempTable);
        insertSql.append(" select mc.fid from t_bd_materialcompanyinfo mc");
        insertSql.append("  where mc.fmaterialid = ? and mc.fcompanyid='").append(ouID).append("'");
        insertSql.append(" and mc.fstatus=0");
        insertSql.append(" and exists ");
        insertSql.append("(select 1 from t_bd_material m where m.fid=mc.fmaterialid and m.fstatus=1)");
        String datapermSql = this.getDataPermissionSql(ctx, ouID, "bd_materialCom_approve");
        if (datapermSql != null && !datapermSql.equals("1 = 1")) {
            insertSql.append(" and ").append(datapermSql);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(insertSql.toString());
            for (String data : materialBaseIds) {
                stmt.setString(1, data);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return tempTable;
    }

    private String generateTempTableToUnApprove(Context ctx, List<String> materialBaseIds, String ouID) throws SQLDataException, BOSException, EASBizException {
        StringBuffer insertSql = new StringBuffer(50);
        String tempTable = this.createTempTable(ctx, "materialCompany");
        insertSql.append("insert into ").append(tempTable);
        insertSql.append(" select mc.fid from t_bd_materialcompanyinfo mc");
        insertSql.append("  where mc.fmaterialid = ? and mc.fcompanyid='").append(ouID).append("'");
        insertSql.append(" and mc.fstatus=1");
        String datapermSql = this.getDataPermissionSql(ctx, ouID, "bd_materialCom_unApprove");
        if (datapermSql != null && !datapermSql.equals("1 = 1")) {
            insertSql.append(" and ").append(datapermSql);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(insertSql.toString());
            for (String data : materialBaseIds) {
                stmt.setString(1, data);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return tempTable;
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            return super.addnew(ctx, model);
        }
        try {
            return this._addnew(ctx, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        boolean isImport = "true".equals(model.getString("isImport"));
        if (!isImport) {
            super.update(ctx, pk, model);
            return;
        }
        try {
            this._update(ctx, pk, (IObjectValue)model);
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }
}

