/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialProfitCenterApproveProcess;
import com.kingdee.eas.basedata.master.material.IMaterialProfitCenterInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.AbstractMaterialProfitCenterInfoControllerBean;
import com.kingdee.eas.basedata.master.material.app.MaterialSrvUtils;
import com.kingdee.eas.basedata.master.material.util.MaterialUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class MaterialProfitCenterInfoControllerBean
extends AbstractMaterialProfitCenterInfoControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MaterialProfitCenterInfoControllerBean");

    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialProfitCenterInfoInfo info = (MaterialProfitCenterInfoInfo)model;
        info.setCreateTime(null);
        if (info.getProfitCenter() == null || info.getProfitCenter().getId().toString().equals("")) {
            throw new MaterialBaseException(MaterialBaseException.PC_CANT_NULL);
        }
        if (info.getProfitCenter().getCU() != null) {
            info.setCU(info.getProfitCenter().getCU());
        }
        info.validate();
        this._checkProDup(ctx, (IObjectValue)info);
        info.put("MaterialNumber", MaterialSrvUtils.getMaterialLogInfo(ctx, info.getMaterial().getId().toString()));
        return super._addnew(ctx, (IObjectValue)info);
    }

    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IMaterialProfitCenterInfo iMaterialPro = MaterialProfitCenterInfoFactory.getLocalInstance(ctx);
        MaterialProfitCenterInfoInfo oldInfo = iMaterialPro.getMaterialProfitCenterInfoInfo(pk, this.getSelectors());
        MaterialProfitCenterInfoInfo info = (MaterialProfitCenterInfoInfo)model;
        info.setCreateTime(oldInfo.getCreateTime());
        if (info.getProfitCenter() != null && info.getProfitCenter().getCU() != null) {
            info.setCU(info.getProfitCenter().getCU());
        }
        AccountType oldAccountType = oldInfo.getAccountType();
        AccountType newAccountType = info.getAccountType();
        if (UsedStatusEnum.APPROVED == oldInfo.getStatus() && oldAccountType != null && newAccountType != null && !oldAccountType.equals((Object)newAccountType)) {
            throw new MaterialBaseException(MaterialBaseException.COMPANY_INFO_APPROVED_CAN_NOT_UPDATE_ACCOUNT_TYPE);
        }
        if (info.getProfitCenter() == null || info.getProfitCenter().getId().toString().equals("")) {
            throw new MaterialBaseException(MaterialBaseException.COMPANYORG_INVALID);
        }
        this._checkProDup(ctx, (IObjectValue)info);
        if (!this.compareValue(ctx, oldInfo, info)) {
            this.checkHasReference(ctx, oldInfo, info);
        }
        ApplicationContext ac = new ApplicationContext();
        if (oldAccountType != null && newAccountType != null && AccountType.SPECIAL_ACCT.equals((Object)oldAccountType) && (AccountType.ADD_AVERAGE.equals((Object)newAccountType) || AccountType.FIN_FOUT.equals((Object)newAccountType) || AccountType.MOVE_ADD_AVERAGE.equals((Object)newAccountType) || AccountType.STANDARDCOST.equals((Object)newAccountType) || AccountType.MOVE_WEIGHTED_AVERAGE.equals((Object)newAccountType)) || !AccountType.SPECIAL_ACCT.equals((Object)newAccountType) || AccountType.ADD_AVERAGE.equals((Object)oldAccountType) || AccountType.FIN_FOUT.equals((Object)oldAccountType) || AccountType.MOVE_ADD_AVERAGE.equals((Object)oldAccountType) || AccountType.STANDARDCOST.equals((Object)oldAccountType) || AccountType.MOVE_WEIGHTED_AVERAGE.equals((Object)oldAccountType)) {
            // empty if block
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialProfitCenterInfoInfo info = this.getMaterialProfitCenterInfoInfo(ctx, pk);
        CtrlUnitInfo curCU = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (!curCU.getId().toString().equals(info.getCU().getId().toString())) {
            throw new MaterialBaseException(MaterialBaseException.CANNOT_DELETE_OTHERCUASSIST);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()));
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_DELETE_COM);
            }
        }
        super._delete(ctx, pk);
    }

    private void _checkProDup(Context ctx, IObjectValue model) throws MaterialBaseException, EASBizException, BOSException {
        MaterialProfitCenterInfoInfo info = (MaterialProfitCenterInfoInfo)model;
        String proID = info.getProfitCenter().getId().toString();
        String materialID = info.getMaterial().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("profitCenter.id", (Object)proID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        if (this.exists(ctx, filter)) {
            throw new MaterialBaseException(MaterialBaseException.MATER_EXIST_PCINFO);
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        return sic;
    }

    private void checkHasReference(Context ctx, MaterialProfitCenterInfoInfo oldVO, MaterialProfitCenterInfoInfo updateVO) throws EASBizException, BOSException {
        BizCheckResult rs;
        Throwable e = this.checkReference(ctx, updateVO.getId());
        String profitID = updateVO.getProfitCenter().getId().toString().toString();
        String materialNumber = oldVO.getMaterial().getNumber();
        ICostObject iCostObject = CostObjectFactory.getLocalInstance((Context)ctx);
        boolean isCostObjectRef = iCostObject.checkMaterialUsed(profitID, materialNumber, 0);
        if ((e != null || isCostObjectRef) && oldVO.getAccountType().getValue() != updateVO.getAccountType().getValue()) {
            throw new MaterialBaseException(MaterialBaseException.REF_NOT_UPDATE_ACCOUNTTYPE, e);
        }
        boolean isEdit = false;
        if (oldVO.getAccountType() == null) {
            return;
        }
        if (!isEdit && !oldVO.getAccountType().equals((Object)updateVO.getAccountType())) {
            isEdit = true;
        }
        if (isEdit && (rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)updateVO.getId())).isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                throw new MaterialBaseException(MaterialBaseException.REF_NOT_UPDATE_COM);
            }
        }
    }

    private Throwable checkReference(Context ctx, BOSUuid id) {
        Exception e = null;
        try {
            this._isReferenced(ctx, (IObjectPK)new ObjectUuidPK(id));
            BizCheckerUtil.isReferenced((Context)ctx, (BOSUuid)id);
        }
        catch (Exception er) {
            e = er;
        }
        return e;
    }

    private boolean compareValue(Context ctx, MaterialProfitCenterInfoInfo oldVO, MaterialProfitCenterInfoInfo updateVO) {
        if (oldVO == null || updateVO == null) {
            return false;
        }
        try {
            if (!oldVO.getId().toString().equals(updateVO.getId().toString())) {
                return false;
            }
            if (!oldVO.getProfitCenter().getId().toString().equals(oldVO.getProfitCenter().getId().toString())) {
                return false;
            }
            if (oldVO.getAccountType().compareTo((Object)updateVO.getAccountType()) != 0) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void _approve(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialProfitCenterInfo iproperty = MaterialProfitCenterInfoFactory.getLocalInstance(ctx);
        MaterialProfitCenterInfoInfo info = iproperty.getMaterialProfitCenterInfoInfo(pk);
        this._approve(ctx, info);
    }

    protected void _approve(Context ctx, MaterialProfitCenterInfoInfo info) throws BOSException, EASBizException {
        IMaterial ima;
        MaterialInfo mainfo;
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        if (((Boolean)(ctx.get((Object)"material_need_checkcu") == null ? Boolean.valueOf(true) : ctx.get((Object)"material_need_checkcu"))).booleanValue()) {
            MaterialUtils.checkCU(ctx, info.getCU().getId().toString());
        }
        if ((mainfo = (ima = MaterialFactory.getLocalInstance(ctx)).getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()))).getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
        }
        if (mainfo.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_APPROVED);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        StringBuffer updatesql = new StringBuffer();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            updatesql.append(" update t_bd_materialprofitcenterinfo set FStatus = ").append(1).append(",flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=now()   where fid = '").append(info.getId().toString()).append("'");
            String updateSql = updatesql.toString();
            statement.execute(updateSql);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)this.getBOSType().toString(), IMaterialProfitCenterApproveProcess.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers != null) {
            String checkerName = "";
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                try {
                    ((IMaterialProfitCenterApproveProcess)Class.forName(checkerName).newInstance()).approve(ctx, info);
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected void _unApprove(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialProfitCenterInfo iproperty = MaterialProfitCenterInfoFactory.getLocalInstance(ctx);
        MaterialProfitCenterInfoInfo info = iproperty.getMaterialProfitCenterInfoInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU(ctx, info.getCU().getId().toString());
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)this.getBOSType().toString(), IMaterialProfitCenterApproveProcess.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers != null) {
            String checkerName = "";
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                try {
                    ((IMaterialProfitCenterApproveProcess)Class.forName(checkerName).newInstance()).unApprove(ctx, info);
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        info.setStatus(UsedStatusEnum.UNAPPROVE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialProfitCenterInfo iproperty = MaterialProfitCenterInfoFactory.getLocalInstance(ctx);
        MaterialProfitCenterInfoInfo info = iproperty.getMaterialProfitCenterInfoInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU(ctx, info.getCU().getId().toString());
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_FREEZED);
        }
        info.setStatus(UsedStatusEnum.FREEZED);
        info.setFreezeOrgUnit(ContextUtil.getCurrentOrgUnit((Context)ctx).castToFullOrgUnitInfo());
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _unFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IMaterialProfitCenterInfo iproperty = MaterialProfitCenterInfoFactory.getLocalInstance(ctx);
        MaterialProfitCenterInfoInfo info = iproperty.getMaterialProfitCenterInfoInfo(pk);
        if (info == null) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NULL);
        }
        MaterialUtils.checkCU(ctx, info.getCU().getId().toString());
        if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTAPPROVE);
        }
        if (info.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.INFO_NOTFREEZED);
        }
        info.setStatus(UsedStatusEnum.APPROVED);
        info.setFreezeOrgUnit(null);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected IObjectValue _first(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _privious(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _next(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _last(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _updateCheck(Context ctx, IObjectPK pk, IObjectValue newInfo) throws BOSException, EASBizException {
        MaterialProfitCenterInfoInfo newInfo1 = (MaterialProfitCenterInfoInfo)newInfo;
        newInfo1.validate();
        MaterialProfitCenterInfoInfo oldInfo = this.getMaterialProfitCenterInfoInfo(ctx, pk);
        String name = newInfo1.getMaterial().getName(ctx.getLocale());
        if (newInfo1.getStatus() == UsedStatusEnum.APPROVED) {
            Object updateProperties = newInfo.get("updateProperties");
            if (updateProperties == null || updateProperties instanceof Object[] && ((Object[])updateProperties).length > 0 && !((Object[])updateProperties)[0].equals("kAClass")) {
                throw new MaterialBaseException(MaterialBaseException.APPROVE_INVALID, new Object[]{name});
            }
        } else if (newInfo1.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.FREEZED_INVALID, new Object[]{name});
        }
        this.checkHasReference(ctx, oldInfo, newInfo1);
    }

    @Override
    protected int _approveBatch(Context ctx, List materialIDs, String ouId) throws BOSException, EASBizException {
        StringBuffer updatesql = new StringBuffer();
        int updateCount = 0;
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            String materialComIdTable = this.generateTempTableToApprove(ctx, materialIDs, ouId);
            updatesql.append(" update t_bd_materialprofitcenterinfo set FStatus = ").append(String.valueOf(1)).append(",flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=now()   where fid in ");
            updatesql.append("(select fid from ").append(materialComIdTable).append(" temp)");
            String updateSql = updatesql.toString();
            updateCount = statement.executeUpdate(updateSql);
            this.afterApproveBatch(ctx, materialComIdTable);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
        return updateCount;
    }

    @Override
    protected int _unApproveBatch(Context ctx, List materialIDs, String ouId) throws BOSException, EASBizException {
        StringBuffer updatesql = new StringBuffer();
        int updateCount = 0;
        Connection conn = null;
        Statement statement = null;
        try {
            conn = super.getConnection(ctx);
            statement = conn.createStatement();
            String materialProIdTable = this.generateTempTableToUnApprove(ctx, materialIDs, ouId);
            updatesql.append(" update t_bd_materialprofitcenterinfo set FStatus = ").append(String.valueOf(0)).append(",flastupdateuserid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',flastupdatetime=now()  where fid in ");
            updatesql.append("(select fid from ").append(materialProIdTable).append(" temp)");
            String updateSql = updatesql.toString();
            updateCount = statement.executeUpdate(updateSql);
            this.afterUnApproveBatch(ctx, materialProIdTable);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)conn);
        return updateCount;
    }

    private void afterApproveBatch(Context ctx, String profitCenterInfoTable) throws BOSException, EASBizException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)this.getBOSType().toString(), IMaterialProfitCenterApproveProcess.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers != null) {
            String checkerName = "";
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                try {
                    MaterialProfitCenterInfoCollection infos = this.getMaterialProfitCenterInfoCollection(ctx, "where id in (select fid from " + profitCenterInfoTable + ")");
                    for (int j = 0; j < infos.size(); ++j) {
                        MaterialProfitCenterInfoInfo info = infos.get(i);
                        ((IMaterialProfitCenterApproveProcess)Class.forName(checkerName).newInstance()).approve(ctx, info);
                    }
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private void afterUnApproveBatch(Context ctx, String profitCenterInfoTable) throws BOSException, EASBizException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)this.getBOSType().toString(), IMaterialProfitCenterApproveProcess.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)e);
        }
        if (checkers != null) {
            String checkerName = "";
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                try {
                    MaterialProfitCenterInfoCollection infos = this.getMaterialProfitCenterInfoCollection(ctx, "where id in (select fid from " + profitCenterInfoTable + ")");
                    for (int j = 0; j < infos.size(); ++j) {
                        MaterialProfitCenterInfoInfo info = infos.get(j);
                        ((IMaterialProfitCenterApproveProcess)Class.forName(checkerName).newInstance()).unApprove(ctx, info);
                    }
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private String generateTempTableToApprove(Context ctx, List<String> materialBaseIds, String ouID) throws SQLDataException, BOSException, EASBizException {
        StringBuffer insertSql = new StringBuffer(50);
        String tempTable = this.createTempTable(ctx, "materialProfitCenter");
        insertSql.append("insert into ").append(tempTable);
        insertSql.append(" select mc.fid from t_bd_materialprofitcenterinfo mc");
        insertSql.append("  where mc.fmaterialid = ? and mc.fprofitcenterid='").append(ouID).append("'");
        insertSql.append(" and mc.fstatus=0");
        insertSql.append(" and exists ");
        insertSql.append("(select 1 from t_bd_material m where m.fid=mc.fmaterialid and m.fstatus=1)");
        String datapermSql = this.getDataPermissionSql(ctx, ouID, "bd_materialPro_approve");
        if (datapermSql != null && !datapermSql.equals("1 = 1")) {
            insertSql.append(" and ").append(datapermSql);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(insertSql.toString());
            for (String data : materialBaseIds) {
                stmt.setString(1, data);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return tempTable;
    }

    private String generateTempTableToUnApprove(Context ctx, List<String> materialBaseIds, String ouID) throws SQLDataException, BOSException, EASBizException {
        StringBuffer insertSql = new StringBuffer(50);
        String tempTable = this.createTempTable(ctx, "materialProfitCenter");
        insertSql.append("insert into ").append(tempTable);
        insertSql.append(" select mc.fid from t_bd_materialProfitCenterinfo mc");
        insertSql.append("  where mc.fmaterialid = ? and mc.fProfitCenterid='").append(ouID).append("'");
        insertSql.append(" and mc.fstatus=1");
        String datapermSql = this.getDataPermissionSql(ctx, ouID, "bd_materialPro_unApprove");
        if (datapermSql != null && !datapermSql.equals("1 = 1")) {
            insertSql.append(" and ").append(datapermSql);
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(insertSql.toString());
            for (String data : materialBaseIds) {
                stmt.setString(1, data);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return tempTable;
    }

    protected String createTempTable(Context ctx, String desc) throws BOSException, EASBizException {
        String tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(desc);
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("fid        varchar(44)");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        return tbl;
    }

    private String getDataPermissionSql(Context ctx, String cuId, String PerminsionItem) throws BOSException, EASBizException {
        ObjectUuidPK CUPK = new ObjectUuidPK(cuId);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        return iPermission.getPermissionWhereSQL((IObjectPK)userPK, (IObjectPK)CUPK, PerminsionItem, "Fid");
    }

    @Override
    protected void _approve(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        MaterialProfitCenterInfoInfo newInfo = (MaterialProfitCenterInfoInfo)info;
        this._approve(ctx, newInfo);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = this.getSelectors();
        sic.add(new SelectorItemInfo("material.name"));
        MaterialProfitCenterInfoInfo info = this.getMaterialProfitCenterInfoInfo(ctx, pk, sic);
        MaterialInfo matInfo = info.getMaterial();
        if (matInfo != null) {
            return matInfo.getNumber() + "  " + matInfo.getName(ctx.getLocale());
        }
        return pk.toString();
    }
}

