/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.AbstractMultiMeasureUnitControllerBean;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MultiMeasureUnitControllerBean
extends AbstractMultiMeasureUnitControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.master.material.app.MultiMeasureUnitControllerBean");
    private static final String MaterialResource = "com.kingdee.eas.basedata.master.material.MaterialResource";

    @Override
    protected IObjectCollection _getDataByMaterial(Context ctx, String materialID) throws BOSException, EASBizException {
        MultiMeasureUnitCollection collection = null;
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        entity.setFilter(filter);
        SelectorItemCollection sc = entity.getSelector();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("measureUnit.name"));
        sc.add(new SelectorItemInfo("measureUnit.number"));
        sc.add(new SelectorItemInfo("convsUnit.name"));
        sc.add(new SelectorItemInfo("convsUnit.number"));
        SorterItemCollection sorter = entity.getSorter();
        SorterItemInfo aSorterItemInfo = new SorterItemInfo("seq");
        aSorterItemInfo.setSortType(SortType.ASCEND);
        sorter.add(aSorterItemInfo);
        collection = this.getMultiMeasureUnitCollection(ctx, entity);
        return collection;
    }

    @Override
    protected boolean _saveDataByMaterial(Context ctx, IObjectCollection multiMeaseureUnitColl) throws BOSException, EASBizException {
        ArrayList<String> deleteInfoList = new ArrayList<String>();
        ArrayList<String> addnewInfoList = new ArrayList<String>();
        ArrayList<String> updateInfoList = new ArrayList<String>();
        MultiMeasureUnitCollection collection = (MultiMeasureUnitCollection)multiMeaseureUnitColl;
        if (collection == null || collection.size() == 0) {
            return false;
        }
        Vector<String> vid = new Vector<String>(0);
        MultiMeasureUnitInfo aMultiMeasureUnitInfo = collection.get(0);
        String materialID = aMultiMeasureUnitInfo.getMaterial().getId().toString();
        for (int i = 0; i < collection.size(); ++i) {
            aMultiMeasureUnitInfo = collection.get(i);
            if (aMultiMeasureUnitInfo.getId() == null || aMultiMeasureUnitInfo.getId().toString().trim().length() <= 0) continue;
            vid.add(aMultiMeasureUnitInfo.getId().toString());
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        entity.setFilter(filter);
        SelectorItemCollection sc = entity.getSelector();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("measureUnit.name"));
        sc.add(new SelectorItemInfo("measureUnit.number"));
        sc.add(new SelectorItemInfo("qtyPrecision"));
        sc.add(new SelectorItemInfo("baseConvsRate"));
        MultiMeasureUnitCollection coll = this.getMultiMeasureUnitCollection(ctx, entity);
        MultiMeasureUnitCollection updatecoll = new MultiMeasureUnitCollection();
        MultiMeasureUnitCollection addnewcoll = new MultiMeasureUnitCollection();
        String sid = null;
        for (int i = 0; i < coll.size(); ++i) {
            aMultiMeasureUnitInfo = coll.get(i);
            sid = aMultiMeasureUnitInfo.getId().toString();
            if (vid.contains(sid)) continue;
            this.checkHasReference(ctx, aMultiMeasureUnitInfo.getId(), aMultiMeasureUnitInfo.getMeasureUnit().getName(), 1);
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(sid));
            deleteInfoList.add(aMultiMeasureUnitInfo.getMeasureUnit().getNumber());
        }
        ObjectUuidPK pk = null;
        Object rs = null;
        int statUnitCount = 0;
        for (int i = 0; i < collection.size(); ++i) {
            aMultiMeasureUnitInfo = collection.get(i);
            String numberName = aMultiMeasureUnitInfo.getMeasureUnit().getNumber() + "[" + aMultiMeasureUnitInfo.getMeasureUnit().getName() + "]";
            if (aMultiMeasureUnitInfo.getBaseConvsRate() == null) {
                throw new MaterialBaseException(MaterialBaseException.CONVSRATENOTNULL, new Object[]{numberName});
            }
            aMultiMeasureUnitInfo.setBaseConvsRate(aMultiMeasureUnitInfo.getBaseConvsRate().setScale(10, 4));
            if (aMultiMeasureUnitInfo.getBaseConvsRate().compareTo(new BigDecimal(0)) <= 0) {
                throw new MaterialBaseException(MaterialBaseException.CONVSRATELESSTHANZERO, new Object[]{numberName});
            }
            if (aMultiMeasureUnitInfo.getConvsUnit() != null && aMultiMeasureUnitInfo.getConvsUnit().getId().equals((Object)aMultiMeasureUnitInfo.getMeasureUnit().getId())) {
                throw new MaterialBaseException(MaterialBaseException.SAMECONVSUNIT, new Object[]{numberName});
            }
            if (aMultiMeasureUnitInfo.isIsStatUnit()) {
                ++statUnitCount;
            }
            if (aMultiMeasureUnitInfo.getId() != null && aMultiMeasureUnitInfo.getId().toString().trim().length() > 0) {
                boolean isMaterialRef;
                pk = new ObjectUuidPK(aMultiMeasureUnitInfo.getId());
                MultiMeasureUnitInfo oldInfo = coll.get(aMultiMeasureUnitInfo.getId());
                if (aMultiMeasureUnitInfo.getQtyPrecision() < oldInfo.getQtyPrecision()) {
                    this.checkHasReference(ctx, aMultiMeasureUnitInfo.getId(), numberName, 0);
                }
                if (aMultiMeasureUnitInfo.getBaseConvsRate().compareTo(oldInfo.getBaseConvsRate()) != 0 && (isMaterialRef = MaterialFactory.getLocalInstance(ctx).isBizRef(aMultiMeasureUnitInfo.getMaterial().getId()))) {
                    throw new MaterialBaseException(MaterialBaseException.REF_NOT_UPDATEBASECON);
                }
                updatecoll.add(aMultiMeasureUnitInfo);
                continue;
            }
            addnewcoll.add(aMultiMeasureUnitInfo);
        }
        if (statUnitCount != 1) {
            throw new MaterialBaseException(MaterialBaseException.ONESTATUNIT);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < addnewcoll.size(); ++i) {
            MultiMeasureUnitInfo info = addnewcoll.get(i);
            addnewInfoList.add(info.getMeasureUnit().getNumber());
        }
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance(ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
        sb.append(ResourceBase.getString((String)MaterialResource, (String)"material", (Locale)ctx.getOriginLocale()) + "\uff1a" + materialInfo.getNumber() + "\n");
        sb.append(ResourceBase.getString((String)MaterialResource, (String)"addnew", (Locale)ctx.getOriginLocale()) + "\uff1a" + Arrays.toString((Object[])addnewInfoList.toArray()) + "\n");
        for (int i = 0; i < updatecoll.size(); ++i) {
            MultiMeasureUnitInfo info = updatecoll.get(i);
            updateInfoList.add(info.getMeasureUnit().getNumber());
        }
        sb.append(ResourceBase.getString((String)MaterialResource, (String)"edit", (Locale)ctx.getOriginLocale()) + "\uff1a" + Arrays.toString((Object[])updateInfoList.toArray()) + "\n");
        sb.append(ResourceBase.getString((String)MaterialResource, (String)"Delete", (Locale)ctx.getOriginLocale()) + "\uff1a" + Arrays.toString((Object[])deleteInfoList.toArray()));
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_saveDataByMaterial", (BOSObjectType)new MultiMeasureUnitInfo().getBOSType(), null, (String)sb.toString(), (String)"bd_material_mutilMeasureUnit", (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), (String)ResourceBase.getString((String)MaterialResource, (String)"MultiMeasureUnitUpdate", (Locale)ctx.getOriginLocale()));
        if (updatecoll.size() != 0) {
            this._updateBatchData(ctx, (IObjectCollection)updatecoll);
            updatecoll.clear();
        }
        if (addnewcoll.size() != 0) {
            this._addnewBatchData(ctx, (IObjectCollection)addnewcoll);
            addnewcoll.clear();
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        return true;
    }

    private void checkHasReference(Context ctx, BOSUuid id, String name, int op) throws EASBizException, BOSException {
        BizCheckResult rs = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)id);
        if (rs.isFound()) {
            if (rs.getException() != null) {
                throw rs.getException();
            }
            if (rs.getDetailMap() != null) {
                switch (op) {
                    case 0: {
                        throw new MaterialBaseException(MaterialBaseException.REF_NOT_UPDATEMUNIT, new Object[]{name});
                    }
                    case 1: {
                        throw new MaterialBaseException(MaterialBaseException.REF_NOT_DELETEMUNIT, new Object[]{name});
                    }
                }
            }
        }
    }

    @Override
    protected int _getQtyPrecision(Context ctx, String strMaterialID, String strMeasureUnitID) throws BOSException, EASBizException {
        int qtyPrecision = -1;
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)strMaterialID));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)strMeasureUnitID));
        entity.setFilter(filter);
        SelectorItemCollection sc = entity.getSelector();
        sc.add(new SelectorItemInfo("*"));
        MultiMeasureUnitCollection coll = this.getMultiMeasureUnitCollection(ctx, entity);
        if (coll != null && coll.size() != 0) {
            MultiMeasureUnitInfo aMultiMeasureUnitInfo = coll.get(0);
            qtyPrecision = aMultiMeasureUnitInfo.getQtyPrecision();
        }
        return qtyPrecision;
    }

    @Override
    protected IObjectValue _getMultiUnit(Context ctx, String strMaterialID, String strMeasureUnitID) throws BOSException, EASBizException {
        MultiMeasureUnitInfo aMultiMeasureUnitInfo = null;
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)strMaterialID));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)strMeasureUnitID));
        entity.setFilter(filter);
        SelectorItemCollection sc = entity.getSelector();
        sc.add(new SelectorItemInfo("*"));
        MultiMeasureUnitCollection coll = this.getMultiMeasureUnitCollection(ctx, entity);
        if (coll != null && coll.size() != 0) {
            aMultiMeasureUnitInfo = coll.get(0);
        }
        return aMultiMeasureUnitInfo;
    }

    protected BigDecimal getBaseConvs(Context ctx, String materialID, String measureUnitID) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)new ObjectUuidPK(BOSUuid.read((String)materialID)), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)new ObjectUuidPK(BOSUuid.read((String)measureUnitID)), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        MultiMeasureUnitCollection measureUnitColl = this.getMultiMeasureUnitCollection(ctx, viewInfo);
        if (measureUnitColl != null && measureUnitColl.size() != 0) {
            return measureUnitColl.get(0).getBaseConvsRate();
        }
        return new BigDecimal("1.00");
    }

    @Override
    protected BigDecimal[] _getConvRatesByMaterial(Context ctx, String[][] dataArrays) throws BOSException, EASBizException {
        int size = dataArrays.length;
        ArrayList<BigDecimal> returnRateList = new ArrayList<BigDecimal>();
        String materialId = null;
        String measureUnitId = null;
        String otherUnitId = null;
        BigDecimal measureUnitConv = null;
        BigDecimal otherUnitConv = null;
        BigDecimal result = null;
        for (int index = 0; index < size; ++index) {
            materialId = dataArrays[index][0];
            measureUnitId = dataArrays[index][1];
            otherUnitId = dataArrays[index][2];
            measureUnitConv = this.getBaseConvs(ctx, materialId, measureUnitId);
            otherUnitConv = this.getBaseConvs(ctx, materialId, otherUnitId);
            result = otherUnitConv.divide(measureUnitConv, 18, 4);
            returnRateList.add(result);
        }
        BigDecimal[] returnArray = new BigDecimal[returnRateList.size()];
        returnRateList.toArray(returnArray);
        return returnArray;
    }

    @Override
    protected Map _getConvRatesByMaterial(Context ctx, String[] materialIds, String[] unitsIds) throws BOSException, EASBizException {
        int materialSize = materialIds.length;
        int unitsIdsSize = unitsIds.length;
        if (materialSize != unitsIdsSize || materialSize < 1) {
            return null;
        }
        StringBuffer conditionBuffer = new StringBuffer();
        conditionBuffer.append(" (material ='" + materialIds[0] + "' And measureUnit = '" + unitsIds[0] + "') ");
        for (int index = 1; index < materialSize; ++index) {
            conditionBuffer.append(" or ");
            conditionBuffer.append(" (material ='" + materialIds[index] + "' And measureUnit ='" + unitsIds[index] + "') ");
        }
        MultiMeasureUnitCollection collection = this.getMultiMeasureUnitCollection(ctx, "Where" + conditionBuffer.toString());
        int collSize = collection.size();
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        for (int index = 0; index < collSize; ++index) {
            String keyString = collection.get(index).getMaterial().getId().toString() + collection.get(index).getMeasureUnit().getId().toString();
            BigDecimal rate = collection.get(index).getBaseConvsRate();
            returnMap.put(keyString, rate);
        }
        return returnMap;
    }

    @Override
    public boolean saveDataByMaterial(Context ctx, MultiMeasureUnitCollection multiMeaseureUnitColl) throws BOSException, EASBizException {
        boolean isImport = "true".equals(ctx.get((Object)"isImport"));
        if (!isImport) {
            return super.saveDataByMaterial(ctx, multiMeaseureUnitColl);
        }
        try {
            boolean retValue = this._saveDataByMaterial(ctx, (IObjectCollection)multiMeaseureUnitColl);
            return retValue;
        }
        catch (BOSException ex) {
            this.setRollbackOnly();
            throw ex;
        }
        catch (EASBizException ex0) {
            this.setRollbackOnly();
            throw ex0;
        }
    }
}

