/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.builder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.AbstractBusinessProcessorBuilder;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;

public class MaterialProcessorBuilder
extends AbstractBusinessProcessorBuilder {
    protected static final String SYMBOL_PUR = "pur";
    protected static final String SYMBOL_COMPANY = "company";
    protected static final String SYMBOL_COST = "cost";
    protected static final String SYMBOL_SALE = "sale";
    protected static final String SYMBOL_INV = "inv";
    protected static final String SYMBOL_PLAN = "plan";
    protected static final String SYMBOL_PROFIT = "profit";

    public MaterialProcessorBuilder(ExecuteContext executeContext) {
        super(executeContext);
    }

    public IBusinessProcessor buildProcessor(Context ctx) throws BOSException, EASBizException {
        if (this.batchAction.equals((Object)BatchActionEnum.ADDNEW)) {
            String symbol = (String)this.executeContext.getApplicationContext().getData("symbol");
            if (symbol.startsWith("mulcopy.")) {
                String subSymbol = symbol.substring(symbol.indexOf(".") + 1);
                if (subSymbol.equals(SYMBOL_COMPANY)) {
                    this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialCompanyCopyProcessor");
                } else if (subSymbol.equals(SYMBOL_PROFIT)) {
                    this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialProCenterCopyProcessor");
                } else if (subSymbol.equals(SYMBOL_COST)) {
                    this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialCostCopyProcessor");
                } else if (subSymbol.equals(SYMBOL_PUR)) {
                    this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialPurCopyProcessor");
                } else if (subSymbol.equals(SYMBOL_SALE)) {
                    this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialSaleCopyProcessor");
                } else if (subSymbol.equals(SYMBOL_INV)) {
                    this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialInvCopyProcessor");
                } else if (subSymbol.equals(SYMBOL_PLAN)) {
                    this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialPlanCopyProcessor");
                }
            } else if (symbol.equals("autoCreateCompany")) {
                this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialCompanyAutoCreateProcessor");
            } else if (symbol.equals("autoCreateProfit")) {
                this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialProAutoCreateProcessor");
            } else if (symbol.equals("autoCreateCost")) {
                this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialCostAutoCreateProcessor");
            } else if (symbol.equals("autoCreatePurchase")) {
                this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialPurAutoCreateProcessor");
            } else if (symbol.equals("autoCreateSale")) {
                this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialSaleAutoCreateProcessor");
            } else if (symbol.equals("autoCreateInventory")) {
                this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialInvAutoCreateProcessor");
            } else if (symbol.equals("autoCreatePlan")) {
                this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialPlanAutoCreateProcessor");
            } else if (symbol.equals("autoCreateProfitCenter")) {
                this.mainProcessor = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialProAutoCreateProcessor");
            }
        } else if (this.batchAction.equals((Object)BatchActionEnum.AUDIT) || this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            String symbol = (String)this.executeContext.getApplicationContext().getData("symbol");
            String subSymbol = symbol.substring(symbol.indexOf(".") + 1);
            if (symbol.startsWith("mulAppr.")) {
                if (subSymbol.equals(SYMBOL_PUR)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialPurMultiApproveProcessor");
                } else if (subSymbol.equals(SYMBOL_SALE)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialSaleMultiApproveProcessor");
                } else if (subSymbol.equals(SYMBOL_PLAN)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialPlanMultiApproveProcessor");
                } else if (subSymbol.equals(SYMBOL_COST)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialCostMultiApproveProcessor");
                } else if (subSymbol.equals(SYMBOL_INV)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialInvMultiApproveProcessor");
                } else if (subSymbol.equals(SYMBOL_PROFIT)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialProMultiApproveProcessor");
                } else if (subSymbol.equals("all")) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialPurMultiApproveProcessor");
                    IBusinessProcessor processSale = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialSaleMultiApproveProcessor");
                    IBusinessProcessor processInv = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialInvMultiApproveProcessor");
                    IBusinessProcessor processCost = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialCostMultiApproveProcessor");
                    IBusinessProcessor processPlan = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialPlanMultiApproveProcessor");
                    IBusinessProcessor processProfit = this.buildAProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialProMultiApproveProcessor");
                    this.mainProcessor.getBusinessChainSupport().addPostBusinessProcessor(processSale);
                    processSale.getBusinessChainSupport().addPostBusinessProcessor(processInv);
                    processInv.getBusinessChainSupport().addPostBusinessProcessor(processCost);
                    processCost.getBusinessChainSupport().addPostBusinessProcessor(processPlan);
                    processPlan.getBusinessChainSupport().addPostBusinessProcessor(processProfit);
                }
            } else if (symbol.startsWith("mulUnappr")) {
                if (subSymbol.equals(SYMBOL_PUR)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialPurMultiApproveProcessor");
                } else if (subSymbol.equals(SYMBOL_SALE)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialSaleMultiApproveProcessor");
                } else if (subSymbol.equals(SYMBOL_PLAN)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialPlanMultiApproveProcessor");
                } else if (subSymbol.equals(SYMBOL_COST)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialCostMultiApproveProcessor");
                } else if (subSymbol.equals(SYMBOL_INV)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialInvMultiApproveProcessor");
                } else if (subSymbol.equals(SYMBOL_PROFIT)) {
                    this.mainProcessor = this.buildMainProcessor(ctx, "com.kingdee.eas.basedata.master.material.app.processor.MaterialProMultiApproveProcessor");
                }
            }
        }
        return this.mainProcessor;
    }
}

