/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.master.cssp.CopyDataStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UserParamInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public class MaterialCompanyCopyProcessor
extends AbstractBusinessProcessor {
    public MaterialCompanyCopyProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo newMaterial = (MaterialInfo)ac.getData("newMaterial");
        EntityViewInfo viewInfo = (EntityViewInfo)ac.getData("view");
        UserParamInfo userParam = (UserParamInfo)ac.getData("userParam");
        IMaterialCompanyInfo iMaterialCompany = MaterialCompanyInfoFactory.getLocalInstance(this.ctx);
        MaterialCompanyInfoCollection materialCompanyColl = iMaterialCompany.getMaterialCompanyInfoCollection(viewInfo);
        int size = materialCompanyColl.size();
        MaterialCompanyInfoInfo materialCompanyInfo = null;
        for (int index = 0; index < size; ++index) {
            materialCompanyInfo = materialCompanyColl.get(index);
            materialCompanyInfo.setId(null);
            materialCompanyInfo.setMateial(newMaterial);
            materialCompanyInfo.setCreator(newMaterial.getCreator());
            materialCompanyInfo.setCreateTime(newMaterial.getCreateTime());
            materialCompanyInfo.setLastUpdateUser(newMaterial.getLastUpdateUser());
            materialCompanyInfo.setLastUpdateTime(newMaterial.getLastUpdateTime());
            CopyDataStatusEnum copyBaseDataStaus = userParam.getCopyCompanyDataStaus();
            UsedStatusEnum destStatus = MaterialUtil.getMaterialCopyStatus(copyBaseDataStaus, materialCompanyInfo.getStatus());
            if (destStatus == UsedStatusEnum.APPROVED) {
                try {
                    MaterialUtil.checkFunctionPermission(this.ctx, newMaterial.getCU().getId().toString(), "bd_materialCom_approve");
                }
                catch (PermissionException e) {
                    destStatus = UsedStatusEnum.UNAPPROVE;
                }
            }
            materialCompanyInfo.setStatus(destStatus);
            iMaterialCompany.addnew((CoreBaseInfo)materialCompanyInfo);
            MaterialInfo mainfo = materialCompanyInfo.getMateial();
            if (mainfo.getStatus() != UsedStatusEnum.APPROVED || materialCompanyInfo.getStatus() != UsedStatusEnum.APPROVED) continue;
            materialCompanyInfo.setStatus(UsedStatusEnum.UNAPPROVE);
            iMaterialCompany.approve(materialCompanyInfo);
        }
    }
}

