/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.app.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.master.cssp.CopyDataStatusEnum;
import com.kingdee.eas.basedata.master.cssp.UserParamInfo;
import com.kingdee.eas.basedata.master.material.IMaterialProfitCenterInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialProfitCenterInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;

public class MaterialProCenterCopyProcessor
extends AbstractBusinessProcessor {
    public MaterialProCenterCopyProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext ac = this.getExecuteContext().getApplicationContext();
        MaterialInfo newMaterial = (MaterialInfo)ac.getData("newMaterial");
        EntityViewInfo viewInfo = (EntityViewInfo)ac.getData("viewInfo");
        UserParamInfo userParam = (UserParamInfo)ac.getData("userParam");
        IMaterialProfitCenterInfo iMaterialProfitCenter = MaterialProfitCenterInfoFactory.getLocalInstance(this.ctx);
        MaterialProfitCenterInfoCollection materialProfitCenterColl = iMaterialProfitCenter.getMaterialProfitCenterInfoCollection(viewInfo);
        int size = materialProfitCenterColl.size();
        MaterialProfitCenterInfoInfo materialProfitCenterInfo = null;
        for (int index = 0; index < size; ++index) {
            materialProfitCenterInfo = materialProfitCenterColl.get(index);
            materialProfitCenterInfo.setId(null);
            materialProfitCenterInfo.setMaterial(newMaterial);
            materialProfitCenterInfo.setCreator(newMaterial.getCreator());
            materialProfitCenterInfo.setCreateTime(newMaterial.getCreateTime());
            CopyDataStatusEnum copyBaseDataStaus = userParam.getCopyProfitCenterDataStaus();
            UsedStatusEnum destStatus = MaterialUtil.getMaterialCopyStatus(copyBaseDataStaus, materialProfitCenterInfo.getStatus());
            if (destStatus == UsedStatusEnum.APPROVED) {
                try {
                    MaterialUtil.checkFunctionPermission(this.ctx, newMaterial.getCU().getId().toString(), "bd_materialPro_approve");
                }
                catch (PermissionException e) {
                    destStatus = UsedStatusEnum.UNAPPROVE;
                }
            }
            materialProfitCenterInfo.setStatus(destStatus);
            iMaterialProfitCenter.addnew((CoreBaseInfo)materialProfitCenterInfo);
            MaterialInfo mainfo = materialProfitCenterInfo.getMaterial();
            if (mainfo.getStatus() != UsedStatusEnum.APPROVED || materialProfitCenterInfo.getStatus() != UsedStatusEnum.APPROVED) continue;
            materialProfitCenterInfo.setStatus(UsedStatusEnum.UNAPPROVE);
            iMaterialProfitCenter.approve(materialProfitCenterInfo);
        }
    }
}

