/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.util;

import com.kingdee.eas.basedata.master.util.StringUtil;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CustomThreadFactory
implements ThreadFactory {
    private final AtomicInteger atomicInteger = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean isDaemon;

    public CustomThreadFactory(String namePrefix, boolean isDaemon) {
        this.namePrefix = !StringUtil.isEmpty((String)namePrefix) ? namePrefix : "thread_pool";
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r, this.namePrefix + "-" + this.atomicInteger.getAndIncrement());
        thread.setDaemon(this.isDaemon);
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }
}

