/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilterSqlUtils {
    public static String getFilterItems(Context ctx, String filterItems) throws BOSException {
        if (filterItems == null || filterItems.trim().length() == 0) {
            return null;
        }
        String[] splitFilterItems = FilterSqlUtils.splitFilterItems(filterItems);
        if (splitFilterItems[1] == null || splitFilterItems[1].trim().length() <= 0) {
            return filterItems;
        }
        filterItems = FilterSqlUtils.parseFilter(JSONUtils.convertJsonToObject((Context)ctx, (String)splitFilterItems[1]));
        if (splitFilterItems[0] != null && splitFilterItems[0].trim().length() > 0) {
            filterItems = splitFilterItems[0] + filterItems;
        }
        if (splitFilterItems[2] != null && splitFilterItems[2].trim().length() > 0) {
            filterItems = filterItems + splitFilterItems[2];
        }
        return filterItems;
    }

    private static String parseFilter(Map map) {
        List list = (List)map.get("subject");
        String mask = (String)map.get("mask");
        Pattern p = Pattern.compile("(and|or)", 2);
        Matcher matcher = p.matcher(mask);
        boolean result = matcher.find();
        StringBuffer filterSql = new StringBuffer();
        for (Object o : list) {
            Map m = (Map)o;
            String filter = "";
            if (m.get("subject") != null) {
                filter = FilterSqlUtils.parseFilter(m);
                filterSql.append("(").append(filter).append(")");
            } else {
                List<Object> r;
                if (m.get("left") == null) continue;
                String left = m.get("left").toString().trim();
                String link = m.get("link").toString().trim();
                Object right = "";
                if ("in".equalsIgnoreCase(link) || "not in".equalsIgnoreCase(link)) {
                    r = (List)m.get("right");
                    StringBuilder sb = new StringBuilder("(");
                    if (r.size() > 0 && r.get(0) instanceof String) {
                        for (Object value : r) {
                            sb.append("'").append(value.toString().trim()).append("'").append(",");
                        }
                    } else if (r.size() > 0 && r.get(0) instanceof Boolean) {
                        for (Object value : r) {
                            sb.append(value).append(",");
                        }
                    } else if (r.size() > 0) {
                        for (Object value : r) {
                            sb.append(new DecimalFormat("###################.###########").format(value)).append(",");
                        }
                    }
                    right = sb.length() > 1 ? sb.substring(0, sb.length() - 1) + ")" : sb.toString() + ")";
                } else {
                    right = "between".equalsIgnoreCase(link) || "not between".equalsIgnoreCase(link) ? ((r = (List)m.get("right")).get(0) instanceof String ? "'" + r.get(0) + "' " + "and " + "'" + r.get(1) + "' " : "'" + new DecimalFormat("###################.###########").format(r.get(0)) + "and " + new DecimalFormat("###################.###########").format(r.get(1))) : ("null".equalsIgnoreCase((r = m.get("right")).toString()) ? null : (r instanceof String ? "'" + r.toString() + "'" : (r instanceof Boolean ? r.toString() : new DecimalFormat("###################.###########").format(r))));
                }
                filter = left + " " + link + " " + (String)right + " ";
                filterSql.append(filter);
            }
            if (!result) continue;
            filterSql.append(" " + matcher.group(0) + " ");
            result = matcher.find();
        }
        return filterSql.toString();
    }

    private static String[] splitFilterItems(String filterItems) {
        int firstIndex = filterItems.indexOf("{");
        int lastIndex = filterItems.lastIndexOf("}");
        String[] result = new String[3];
        if (firstIndex > -1) {
            result[0] = filterItems.substring(0, firstIndex);
            result[1] = filterItems.substring(firstIndex, lastIndex + 1);
            result[2] = filterItems.substring(lastIndex + 1);
        }
        return result;
    }
}

