/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.DeletedStatusEnum;
import com.kingdee.eas.basedata.person.PersonAccountException;
import com.kingdee.eas.basedata.person.PersonAccountInfo;
import com.kingdee.eas.basedata.person.app.AbstractPersonAccountControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class PersonAccountControllerBean
extends AbstractPersonAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.person.app.PersonAccountControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonAccountInfo info = (PersonAccountInfo)model;
        this.checkInfo(ctx, info);
        if (info.isIsDefault()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_BD_PersonAccount SET FIsDefault = 0 WHERE FPersonID='" + info.getPerson().getId() + "'"));
        }
        if (info.getCreator() == null || info.getCreator().getId() == null) {
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        if (info.getDeletedStatus() == null) {
            info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        }
        return super._addnew(ctx, model);
    }

    private void checkInfo(Context ctx, PersonAccountInfo info) throws EASBizException, BOSException {
        if (info.getPerson() == null) {
            throw new PersonAccountException(PersonAccountException.PERSON_CANNOT_NULL);
        }
        if (info.getBank() == null) {
            throw new PersonAccountException(PersonAccountException.BANK_CANNOT_NULL);
        }
        if (StringUtils.isEmpty((String)info.getBankAccount())) {
            throw new PersonAccountException(PersonAccountException.BANKACCOUNT_CANNOT_NULL);
        }
        String oql = "where bankAccount = '" + info.getBankAccount() + "'";
        if (info.getId() != null) {
            oql = oql + " and id != '" + info.getId().toString() + "'";
        }
        if (this.exists(ctx, oql)) {
            throw new PersonAccountException(PersonAccountException.BANKACCOUNT_REPEAT);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.checkCreatorIsOthers(ctx, pk)) {
            throw new PersonAccountException(PersonAccountException.CANNOT_DELETE_WITH_OTHERS);
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonAccountInfo info = (PersonAccountInfo)model;
        PersonAccountInfo oldInfo = this.getPersonAccountInfo(ctx, pk);
        this.checkInfo(ctx, info);
        if (info.isIsDefault() && !oldInfo.isIsDefault()) {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_BD_PersonAccount SET FIsDefault = 0 WHERE FPersonID='" + info.getPerson().getId() + "'"));
        }
        super._update(ctx, pk, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.checkCreatorIsOthers(ctx, pk)) {
            throw new PersonAccountException(PersonAccountException.CANNOT_DISABLE_WITH_OTHERS);
        }
        if (model == null) {
            model = this.getPersonAccountInfo(ctx, pk);
        }
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.checkCreatorIsOthers(ctx, pk)) {
            throw new PersonAccountException(PersonAccountException.CANNOT_ENABLE_WITH_OTHERS);
        }
        if (model == null) {
            model = this.getPersonAccountInfo(ctx, pk);
        }
        super._cancelCancel(ctx, pk, model);
    }

    private boolean checkCreatorIsOthers(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        UserInfo billUserInfo = this.getPersonAccountInfo(ctx, pk).getCreator();
        return billUserInfo != null && !billUserInfo.getId().toString().equals(currentUserInfo.getId().toString());
    }
}

