/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.hraux.init.HRInitForBaseFactory;
import com.kingdee.eas.basedata.hraux.init.IHRInitForBase;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.app.AbstractPersonEditUIHandler;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;

public class PersonEditUIHandler
extends AbstractPersonEditUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.isFinishInit(context);
        super._handleInit(request, response, context);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)context);
        iPermission.getFieldPermission(request.getBosType(), request.getUserPK(), null);
        iPermission.getFieldPermission(request.getBosType(), request.getUserPK(), request.getOrg());
        if ("ADDNEW".equals(request.getState())) {
            this.getPositionInfo(request, context);
        }
        this.executeQuery(request, context);
    }

    private void getPositionInfo(RequestContext request, Context context) throws BOSException, EASBizException {
        PositionInfo positionNode = (PositionInfo)request.get("PositionNode");
        if (null != positionNode) {
            BOSUuid positionNodeId = positionNode.getId();
            SelectorItemCollection viewInfo = new SelectorItemCollection();
            viewInfo.add(new SelectorItemInfo("id"));
            viewInfo.add(new SelectorItemInfo("name"));
            viewInfo.add(new SelectorItemInfo("job.id"));
            viewInfo.add(new SelectorItemInfo("job.name"));
            viewInfo.add(new SelectorItemInfo("adminOrgUnit.id"));
            viewInfo.add(new SelectorItemInfo("adminOrgUnit.name"));
            PositionFactory.getLocalInstance((Context)context).getPositionInfo((IObjectPK)new ObjectUuidPK(positionNodeId), viewInfo);
        }
    }

    private void isFinishInit(Context context) throws BOSException, EASBizException {
        IHRInitForBase iHR = HRInitForBaseFactory.createInstance((Context)context);
        boolean isInit = iHR.isFinishInit();
    }

    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.checkPermission(request, context);
        PersonInfo personInfo = new PersonInfo();
        personInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)context));
        super._handleActionSubmit(request, response, context);
        this.executeQuery(request, context);
    }

    protected void checkPermission(RequestContext request, Context context) throws BOSException, EASBizException {
        if (null != request.get("NO_PERMISSION")) {
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)context);
            iPermission.checkFunctionPermission(request.getUserPK(), request.getOrg(), null, null, request.getItemAction().getClass().getName(), request.getOrgExt());
        }
    }

    protected IObjectPK runSubmit(RequestContext request, Context context) throws Exception {
        if ("ADDNEW".equals(request.getState()) && this.checkNameDup(request, context)) {
            return null;
        }
        if ("ADDNEW".equals(request.getState())) {
            this.getPositionInfo(request, context);
        }
        return super.runSubmit(request, context);
    }

    private boolean checkNameDup(RequestContext request, Context context) throws Exception {
        if (null == request.getValue()) {
            return false;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app.AdminUnitByPersonQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = (EntityViewInfo)request.get("viewInfo");
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        return rows.size() > 0;
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        PersonInfo info = new PersonInfo();
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)context));
        return info;
    }

    private void executeQuery(RequestContext request, Context context) throws BOSException {
        EntityViewInfo personOfPositions = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if ("ADDNEW".equalsIgnoreCase(request.getState())) {
            filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)"nodata"));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)request.getId().toString()));
        }
        personOfPositions.setFilter(filter);
        if (null != personOfPositions) {
            MetaDataPK personOfPositionsPK = new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonOfPositions");
            IQueryExecutor exec = this.getQueryExecutor(context, (IMetaDataPK)personOfPositionsPK, personOfPositions);
            exec.executeQuery(0, Integer.MAX_VALUE);
        }
    }

    protected IQueryExecutor getQueryExecutor(Context context, IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        return exec;
    }
}

