/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.ISecurity;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.agentuser.PersonHelper;
import com.kingdee.eas.base.permission.util.UserInfoHelper;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.IPositionHierarchy;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonException;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.PersonStates;
import com.kingdee.eas.basedata.person.app.AbstractPersonFacadeControlBean;
import com.kingdee.eas.basedata.person.app.processor.PersonBeforeBusinessProcessorBuilder;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutingHelper;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class PersonFacadeControlBean
extends AbstractPersonFacadeControlBean {
    private static Logger logger = Logger.getLogger((String)PersonFacadeControlBean.class.getName());
    private IPerson iPerson = null;

    @Override
    protected boolean _enable(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        this.iPerson = PersonFactory.getLocalInstance(ctx);
        PersonInfo model = (PersonInfo)this.iPerson.getValue((IObjectPK)new ObjectUuidPK(personId));
        boolean enable = false;
        ObjectUuidPK pk = new ObjectUuidPK(model.getId());
        model.setState(PersonStates.Enable);
        this.iPerson.update((IObjectPK)pk, (CoreBaseInfo)model);
        enable = true;
        return enable;
    }

    @Override
    protected boolean _disable(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        this.iPerson = PersonFactory.getLocalInstance(ctx);
        PersonInfo model = (PersonInfo)this.iPerson.getValue((IObjectPK)new ObjectUuidPK(personId));
        boolean enable = false;
        model.setState(PersonStates.Disable);
        this.iPerson = PersonFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(model.getId());
        this.iPerson.update((IObjectPK)pk, (CoreBaseInfo)model);
        enable = true;
        return enable;
    }

    @Override
    protected IObjectCollection _getSupervisor(Context ctx, BOSUuid hierarchyId, BOSUuid personId) throws BOSException, EASBizException {
        return this.getPersonColl(ctx, hierarchyId, personId, false);
    }

    @Override
    protected IObjectCollection _getSupervisor(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        return this.getPersonColl(ctx, null, personId, false);
    }

    @Override
    protected IObjectCollection _getColleague(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        this.iPerson = PersonFactory.getLocalInstance(ctx);
        PersonInfo model = (PersonInfo)this.iPerson.getValue((IObjectPK)new ObjectUuidPK(personId));
        PersonCollection personColl = new PersonCollection();
        PersonCollection superColl = (PersonCollection)this._getSupervisor(ctx, personId);
        PersonCollection subColl = null;
        for (int i = 0; i < superColl.size(); ++i) {
            subColl = (PersonCollection)this._getSubordinate(ctx, superColl.get(i).getId());
            subColl.remove(model);
            for (int j = 0; j < subColl.size(); ++j) {
                personColl.add(subColl.get(j));
            }
        }
        return personColl;
    }

    @Override
    protected IObjectCollection _getColleague(Context ctx, BOSUuid hierarchyId, BOSUuid personId) throws EASBizException, BOSException {
        this.iPerson = PersonFactory.getLocalInstance(ctx);
        PersonInfo model = (PersonInfo)this.iPerson.getValue((IObjectPK)new ObjectUuidPK(personId));
        PersonCollection personColl = new PersonCollection();
        PersonCollection subColl = null;
        PersonCollection superColl = (PersonCollection)this._getSupervisor(ctx, hierarchyId, personId);
        for (int i = 0; i < superColl.size(); ++i) {
            subColl = (PersonCollection)this._getSubordinate(ctx, hierarchyId, superColl.get(i).getId());
            subColl.remove(model);
            for (int j = 0; j < subColl.size(); ++j) {
                personColl.add(subColl.get(j));
            }
        }
        return personColl;
    }

    @Override
    protected IObjectCollection _getSubordinate(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        return this.getPersonColl(ctx, null, personId, true);
    }

    @Override
    protected IObjectCollection _getSubordinate(Context ctx, BOSUuid hierarchyId, BOSUuid personId) throws BOSException, EASBizException {
        return this.getPersonColl(ctx, hierarchyId, personId, true);
    }

    @Override
    protected IObjectCollection _getDirector(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        PersonCollection personColl = new PersonCollection();
        PersonCollection dirColl = null;
        PersonCollection superColl = (PersonCollection)this._getSupervisor(ctx, personId);
        for (int i = 0; i < superColl.size(); ++i) {
            dirColl = (PersonCollection)this._getSupervisor(ctx, superColl.get(i).getId());
            for (int j = 0; j < dirColl.size(); ++j) {
                personColl.add(dirColl.get(j));
            }
        }
        return personColl;
    }

    @Override
    protected IObjectCollection _getDirector(Context ctx, BOSUuid hierarchyId, BOSUuid personId) throws BOSException, EASBizException {
        PersonCollection personColl = new PersonCollection();
        PersonCollection dirColl = null;
        PersonCollection superColl = (PersonCollection)this._getSupervisor(ctx, hierarchyId, personId);
        for (int i = 0; i < superColl.size(); ++i) {
            dirColl = (PersonCollection)this._getSupervisor(ctx, superColl.get(i).getId());
            for (int j = 0; j < dirColl.size(); ++j) {
                personColl.add(dirColl.get(j));
            }
        }
        return personColl;
    }

    @Override
    protected IObjectValue _getPrimarySupervisor(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        PersonCollection superPersonColl = this.getPrimaryPerson(ctx, null, personId, false);
        PersonInfo superPerson = null;
        if (superPersonColl != null && superPersonColl.size() > 0) {
            superPerson = superPersonColl.get(0);
        }
        return superPerson;
    }

    @Override
    protected IObjectValue _getPrimarySupervisor(Context ctx, BOSUuid hierarchyId, BOSUuid personId) throws BOSException, EASBizException {
        PersonCollection superPersonColl = this.getPrimaryPerson(ctx, hierarchyId, personId, false);
        PersonInfo superPerson = null;
        if (superPersonColl != null && superPersonColl.size() > 0) {
            superPerson = superPersonColl.get(0);
        }
        return superPerson;
    }

    @Override
    protected IObjectValue _getPrimaryDirector(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        PersonInfo superPerson = (PersonInfo)this._getPrimarySupervisor(ctx, personId);
        return this._getPrimarySupervisor(ctx, superPerson.getId());
    }

    @Override
    protected IObjectValue _getPrimaryDirector(Context ctx, BOSUuid hierarchyId, BOSUuid personId) throws EASBizException, BOSException {
        PersonInfo superPerson = (PersonInfo)this._getPrimarySupervisor(ctx, hierarchyId, personId);
        return this._getPrimarySupervisor(ctx, superPerson.getId());
    }

    @Override
    protected IObjectCollection _getPrimaryColleague(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        this.iPerson = PersonFactory.getLocalInstance(ctx);
        PersonInfo model = (PersonInfo)this.iPerson.getValue((IObjectPK)new ObjectUuidPK(personId));
        PersonInfo superPerson = (PersonInfo)this._getPrimarySupervisor(ctx, personId);
        PersonCollection superColl = (PersonCollection)this._getPrimarySubordinate(ctx, superPerson.getId());
        superColl.remove(model);
        return superColl;
    }

    @Override
    protected IObjectCollection _getPrimaryColleague(Context ctx, BOSUuid hierarchyId, BOSUuid personId) throws EASBizException, BOSException {
        this.iPerson = PersonFactory.getLocalInstance(ctx);
        PersonInfo model = (PersonInfo)this.iPerson.getValue((IObjectPK)new ObjectUuidPK(personId));
        PersonInfo superPerson = (PersonInfo)this._getPrimarySupervisor(ctx, hierarchyId, personId);
        PersonCollection superColl = (PersonCollection)this._getPrimarySubordinate(ctx, hierarchyId, superPerson.getId());
        superColl.remove(model);
        return superColl;
    }

    @Override
    protected IObjectCollection _getPrimarySubordinate(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        return this.getPrimaryPerson(ctx, null, personId, true);
    }

    @Override
    protected IObjectCollection _getPrimarySubordinate(Context ctx, BOSUuid hierarchyId, BOSUuid personId) throws BOSException, EASBizException {
        return this.getPrimaryPerson(ctx, hierarchyId, personId, true);
    }

    @Override
    protected IObjectCollection _getNoPositionPerson(Context ctx) throws EASBizException, BOSException {
        PersonCollection personColl = null;
        PositionMemberCollection pMColl = null;
        IPerson iPerson = PersonFactory.getLocalInstance(ctx);
        personColl = iPerson.getPersonCollection();
        IPositionMember iPH = PositionMemberFactory.getLocalInstance((Context)ctx);
        pMColl = iPH.getPositionMemberCollection();
        for (int i = 0; i < pMColl.size(); ++i) {
            for (int j = 0; j < personColl.size(); ++j) {
                if (!personColl.get(j).getId().toString().equalsIgnoreCase(pMColl.get(i).getPerson().getId().toString())) continue;
                personColl.removeObject(j);
            }
        }
        return personColl;
    }

    private PersonCollection getPersonColl(Context ctx, BOSUuid hierarchyId, BOSUuid personId, boolean isFindByParent) throws EASBizException, BOSException {
        PersonCollection personColl = new PersonCollection();
        IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
        IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection posiMemberColl = this.getPersonPosiMember(ctx, personId);
        PositionHierarchyCollection positionHierColl = null;
        for (int i = 0; i < posiMemberColl.size(); ++i) {
            PositionMemberInfo posiMemInfo = posiMemberColl.get(i);
            PositionInfo positionInfo = posiMemInfo.getPosition();
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(this.getPHEntityViewInfo(hierarInfo.getId(), positionInfo.getId(), isFindByParent));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(this.getPHEntityViewInfo(hierarchyId, positionInfo.getId(), isFindByParent));
            }
            personColl.addCollection(this.getPersonCOllByPM(ctx, positionHierColl, isFindByParent));
        }
        return personColl;
    }

    private PositionMemberCollection getPersonPosiMember(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        PositionMemberCollection posiMemberColl = null;
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        posiMemberColl = iPosiMember.getPositionMemberCollection(this.getPMEntityViewInfo(ctx, personId));
        return posiMemberColl;
    }

    private EntityViewInfo getPMEntityViewInfo(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        this.iPerson = PersonFactory.getLocalInstance(ctx);
        FilterItemInfo filterItemPosi = new FilterItemInfo("person.id", (Object)personId.toString().trim());
        filter.getFilterItems().add(filterItemPosi);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("isPrimary"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        return viewInfo;
    }

    private EntityViewInfo getPHEntityViewInfo(BOSUuid hierarchyId, BOSUuid positionId, boolean isParent) {
        FilterItemInfo filterItem;
        FilterInfo filter = new FilterInfo();
        if (!isParent) {
            filterItem = new FilterItemInfo("child.id", (Object)positionId.toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("parent.id", (Object)positionId.toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        FilterItemInfo filterItemHier = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItemHier);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        if (!isParent) {
            viewInfo.getSelector().add(new SelectorItemInfo("parent.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("parent.name"));
        } else {
            viewInfo.getSelector().add(new SelectorItemInfo("child.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("child.name"));
        }
        return viewInfo;
    }

    private PersonCollection getPersonCOllByPM(Context ctx, PositionHierarchyCollection positionHierColl, boolean isFindByParent) throws BOSException {
        PersonCollection personColl = new PersonCollection();
        PositionInfo positionInfo = null;
        IPositionMember iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        for (int k = 0; k < positionHierColl.size(); ++k) {
            positionInfo = !isFindByParent ? positionHierColl.get(k).getParent() : positionHierColl.get(k).getChild();
            PositionMemberCollection superPMColl = iPosiMember.getPositionMemberCollection(this.getOtherPMEntityViewInfo(positionInfo));
            for (int j = 0; j < superPMColl.size(); ++j) {
                personColl.add(superPMColl.get(j).getPerson());
            }
        }
        return personColl;
    }

    private EntityViewInfo getOtherPMEntityViewInfo(PositionInfo positionInfo) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("position.id", (Object)positionInfo.getId().toString().trim());
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.name"));
        return viewInfo;
    }

    private PersonCollection getPrimaryPerson(Context ctx, BOSUuid hierarchyId, BOSUuid personId, boolean isFindByParent) throws EASBizException, BOSException {
        PersonCollection personColl = null;
        IPositionHierarchy iPositionHier = PositionHierarchyFactory.getLocalInstance((Context)ctx);
        IHierarchy iHierar = HierarchyFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection posiMemberColl = this.getPersonPosiMember(ctx, personId);
        PositionHierarchyCollection positionHierColl = null;
        PositionInfo positionInfo = null;
        PositionMemberInfo posiMemInfo = null;
        for (int i = 0; i < posiMemberColl.size(); ++i) {
            posiMemInfo = posiMemberColl.get(i);
            if (!posiMemInfo.isIsPrimary()) continue;
            positionInfo = posiMemInfo.getPosition();
            if (hierarchyId == null) {
                HierarchyInfo hierarInfo = iHierar.getDefaultHierarchy();
                positionHierColl = iPositionHier.getPositionHierarchyCollection(this.getPHEntityViewInfo(hierarInfo.getId(), positionInfo.getId(), isFindByParent));
            } else {
                positionHierColl = iPositionHier.getPositionHierarchyCollection(this.getPHEntityViewInfo(hierarchyId, positionInfo.getId(), isFindByParent));
            }
            personColl = this.getPersonCOllByPM(ctx, positionHierColl, isFindByParent);
            break;
        }
        return personColl;
    }

    @Override
    protected IObjectCollection _getAdminOrgUnitByPerson(Context ctx, BOSUuid personId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("person.id", (Object)personId.toString());
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.name"));
        IPositionMember iPM = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection pmColl = iPM.getPositionMemberCollection(viewInfo);
        AdminOrgUnitCollection adminColl = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminInfo = null;
        IAdminOrgUnit iAdminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = null;
        for (int i = 0; i < pmColl.size(); ++i) {
            pk = new ObjectUuidPK(pmColl.get(i).getPosition().getAdminOrgUnit().getId());
            adminInfo = iAdminOrg.getAdminOrgUnitInfo((IObjectPK)pk);
            adminColl.add(adminInfo);
        }
        return adminColl;
    }

    @Override
    protected IRowSet _getAllUnderlingUserByPerson(Context ctx, String personId) throws BOSException, EASBizException {
        this.iPerson = PersonFactory.getLocalInstance(ctx);
        PositionInfo positionInfo = this.iPerson.getPrimaryPosition(BOSUuid.read((String)personId));
        if (positionInfo == null) {
            return null;
        }
        HierarchyInfo hierInfo = HierarchyFactory.getLocalInstance((Context)ctx).getDefaultHierarchy();
        if (hierInfo == null) {
            return null;
        }
        IPositionHierarchy iPH = PositionHierarchyFactory.getLocalInstance((Context)ctx);
        String oql = "where child='" + positionInfo.getId() + "' and hierarchy='" + hierInfo.getId() + "'";
        PositionHierarchyCollection phColl = iPH.getPositionHierarchyCollection(oql);
        PositionHierarchyInfo phInfo = null;
        if (phColl == null || phColl.size() <= 0) {
            return null;
        }
        phInfo = phColl.get(0);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.UnderlingUserByPersonQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("PH.longNumber", (Object)phInfo.getLongNumber()));
        filter.getFilterItems().add(new FilterItemInfo("PH.longNumber", (Object)(phInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)this.getCurrCUID(ctx)));
        filter.setMaskString("#0 and (#1 or #2) and #3");
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        return queryExec.executeQuery();
    }

    @Override
    protected IRowSet _getAllUnderlingUserByAdmin(Context ctx, String adminId) throws BOSException, EASBizException {
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo adminInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)adminId)));
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.UnderlingUserByAdminQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AdminOrg.longNumber", (Object)adminInfo.getLongNumber()));
        filter.getFilterItems().add(new FilterItemInfo("AdminOrg.longNumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)this.getCurrCUID(ctx)));
        filter.setMaskString("#0 and #1 and #3");
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        return queryExec.executeQuery();
    }

    private String getCurrCUID(Context ctx) {
        CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx).getCU();
        return cuInfo.getId().toString();
    }

    @Override
    protected boolean _isAdminPerson(Context ctx, String personId, String orgId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT 1 FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_ORG_Position ON T_ORG_Admin.FResponPositionID = T_ORG_Position.FID ");
        sql.append(" INNER JOIN T_ORG_PositionMember ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append(" WHERE T_ORG_Admin.FID ='");
        sql.append(orgId);
        sql.append("' AND T_ORG_PositionMember.FPersonID ='");
        sql.append(personId);
        sql.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rows == null) {
            return false;
        }
        return rows.size() > 0;
    }

    @Override
    protected String _getAddressList(Context ctx, String name) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.PersonQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        StringBuffer info = null;
        try {
            while (rows.next()) {
                if (info == null) {
                    info = new StringBuffer("");
                }
                info.append(rows.getString("name"));
                info.append("\n");
                if (rows.getString("email") != null) {
                    info.append(rows.getString("email"));
                    info.append("\n");
                }
                if (rows.getString("officePhone") != null) {
                    info.append(rows.getString("officePhone"));
                    info.append("\n");
                }
                if (rows.getString("cell") == null) continue;
                info.append(rows.getString("cell"));
                info.append("\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (info != null) {
            return info.toString();
        }
        return null;
    }

    @Override
    protected IRowSet _getAllUnderlingPersonByPerson(Context ctx, String personId) throws BOSException, EASBizException {
        this.iPerson = PersonFactory.getLocalInstance(ctx);
        PositionInfo positionInfo = this.iPerson.getPrimaryPosition(BOSUuid.read((String)personId));
        if (positionInfo == null) {
            return null;
        }
        HierarchyInfo hierInfo = HierarchyFactory.getLocalInstance((Context)ctx).getDefaultHierarchy();
        if (hierInfo == null) {
            return null;
        }
        IPositionHierarchy iPH = PositionHierarchyFactory.getLocalInstance((Context)ctx);
        String oql = "where child='" + positionInfo.getId() + "' and hierarchy='" + hierInfo.getId() + "'";
        PositionHierarchyCollection phColl = iPH.getPositionHierarchyCollection(oql);
        PositionHierarchyInfo phInfo = null;
        if (phColl == null || phColl.size() <= 0) {
            return null;
        }
        phInfo = phColl.get(0);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.UnderlingPersonByPersonQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("PH.longNumber", (Object)(phInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        return queryExec.executeQuery();
    }

    @Override
    protected HashSet _getUserByPerson(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        return this._getUserByPerson(ctx, personId.toString());
    }

    @Override
    protected HashSet _getUserByPerson(Context ctx, String personId) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userColl = iUser.getUserCollection("select id where person.id = '" + personId + "'");
        HashSet<String> hashSet = new HashSet<String>();
        int size = userColl.size();
        for (int i = 0; i < size; ++i) {
            hashSet.add(userColl.get(i).getId().toString());
        }
        return hashSet;
    }

    @Override
    protected void _initPersonIndex(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT T1.FID ");
        sql.append("FROM T_BD_Person T1 ");
        sql.append("LEFT OUTER JOIN T_HR_PersonPosition T2 ");
        sql.append("ON T1.FID = T2.FPersonID ");
        sql.append("LEFT OUTER JOIN T_ORG_Admin T3 ");
        sql.append("ON T2.FPersonDep = T3.FID ");
        sql.append("LEFT OUTER JOIN T_ORG_Position T4 ");
        sql.append("ON T2.FPrimaryPositionID = T4.FID ");
        sql.append("ORDER BY T3.FSortCode,T4.FIndex,T1.FNumber");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            sql = new StringBuffer("UPDATE T_BD_Person SET FIndex = ? WHERE FID = ? ");
            int i = 1;
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rows.next()) {
                paramsList.add(new Object[]{new Integer(i), rows.getString(1)});
                ++i;
            }
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _updatePersonIndex(Context ctx, HashMap personList) throws BOSException, EASBizException {
        if (personList == null || personList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("UPDATE T_BD_Person SET FIndex = ? WHERE FID = ? ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Iterator iter = personList.keySet().iterator();
        Integer key = null;
        while (iter.hasNext()) {
            key = Integer.valueOf(iter.next().toString());
            paramsList.add(new Object[]{key, personList.get(key.toString())});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }

    @Override
    protected String _getNewNumber(Context ctx, String cuId) throws BOSException, EASBizException {
        return this.readNewNumber(ctx, cuId, new PersonInfo(), 1);
    }

    protected String readNewNumber(Context ctx, String cuId, PersonInfo info, int count) throws BOSException, EASBizException {
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        number = iCodingRuleManager.readNumber((IObjectValue)info, cuId);
        if (number == null || number.length() == 0) {
            return number;
        }
        if (count < 100) {
            String oql = "select id where number='" + number + "'";
            if (PersonFactory.getLocalInstance(ctx).exists(oql)) {
                iCodingRuleManager.getNumber((IObjectValue)info, cuId);
                number = this.readNewNumber(ctx, cuId, info, count + 1);
            }
        }
        return number;
    }

    @Override
    protected Set _getReceiversByRoleNumberAndPersonNumber(Context ctx, String roleNumber, String personNumber) throws BOSException, EASBizException {
        HashSet userHashSet = null;
        RoleCollection roleCol = RoleFactory.getLocalInstance((Context)ctx).getRoleCollection("where number = '" + roleNumber + "'");
        String adminSql = "SELECT ADMINN.FID FROM T_BD_PERSON PERSON\tLEFT OUTER JOIN T_HR_PersonPosition PP ON PERSON.FID = PP.FPERSONID LEFT OUTER JOIN T_ORG_ADMIN ADMINN ON PP.FPERSONDEP = ADMINN.FID\tLEFT OUTER JOIN T_HR_BDEMPLOYEETYPE TYPE ON TYPE.FID = PERSON.FEMPLOYEETYPEID LEFT OUTER JOIN T_ORG_PositionMember PM ON PM.FPERSONID = PERSON.FID LEFT OUTER JOIN T_ORG_Position POSITION ON POSITION.FID = PM.FPOSITIONID LEFT OUTER JOIN T_ORG_ADMIN ADMINP ON ADMINP.FID = POSITION.FADMINORGUNITID WHERE PERSON.FNumber = '" + personNumber + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)adminSql);
        String adminId = "";
        try {
            while (rs.next()) {
                adminId = rs.getString(1);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (roleCol.size() != 0) {
            RoleInfo roleInfo = roleCol.get(0);
            ApplicationContext applicationContext = new ApplicationContext();
            applicationContext.putData("adminId", (Object)adminId.toString());
            BatchActionResults batchResults = BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{roleInfo.getId().toString()}, (BatchActionEnum)PersonBeforeBusinessProcessorBuilder.ACT_GETRECEIVERS, PersonBeforeBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
            batchResults.throwExceptions();
            userHashSet = (HashSet)batchResults.getResponse().get((Object)"userHashSet");
        }
        return userHashSet;
    }

    @Override
    protected Set _getSupervisorByPersonId(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        HashSet<String> userHashSet = new HashSet<String>();
        if (personId == null) {
            return userHashSet;
        }
        PersonCollection personCol = this.getPersonColl(ctx, null, personId, false);
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userCollection = null;
        String userID = "";
        UserInfo userInfo = null;
        int size = personCol.size();
        for (int i = 0; i < size; ++i) {
            PersonInfo personInfo = personCol.get(i);
            String supPersonId = personInfo.getId().toString();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)supPersonId, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            userCollection = iUser.getUserCollection(viewInfo);
            if (userCollection.size() == 0 || userHashSet.contains(userID = (userInfo = userCollection.get(0)).getId().toString())) continue;
            userHashSet.add(userID);
        }
        return userHashSet;
    }

    @Override
    protected Set _getIndirectorByPersonID(Context ctx, BOSUuid personID) throws BOSException, EASBizException {
        HashSet<String> userHashSet = new HashSet<String>();
        if (personID == null) {
            return userHashSet;
        }
        PersonCollection personCol = this.getPersonColl(ctx, null, personID, false);
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userCollection = null;
        String userID = "";
        UserInfo userInfo = null;
        int size = personCol.size();
        for (int i = 0; i < size; ++i) {
            PersonInfo personInfo = personCol.get(i);
            PersonCollection indirectPersonCol = this.getPersonColl(ctx, null, personInfo.getId(), false);
            int length = indirectPersonCol.size();
            for (int j = 0; j < length; ++j) {
                PersonInfo indirectPersonInfo = indirectPersonCol.get(j);
                String indirectPersonId = indirectPersonInfo.getId().toString();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)indirectPersonId, CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                userCollection = iUser.getUserCollection(viewInfo);
                if (userCollection.size() == 0 || userHashSet.contains(userID = (userInfo = userCollection.get(0)).getId().toString())) continue;
                userHashSet.add(userID);
            }
        }
        return userHashSet;
    }

    @Override
    protected Set _getReceiversByRoleNumberAndAdminId(Context ctx, String roleNumber, BOSUuid adminId) throws BOSException, EASBizException {
        HashSet userHashSet = null;
        RoleCollection roleCol = RoleFactory.getLocalInstance((Context)ctx).getRoleCollection("where number = '" + roleNumber + "'");
        if (roleCol != null && roleCol.size() > 0) {
            RoleInfo roleInfo = roleCol.get(0);
            ApplicationContext applicationContext = new ApplicationContext();
            applicationContext.putData("adminId", (Object)adminId.toString());
            BatchActionResults batchResults = BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{roleInfo.getId().toString()}, (BatchActionEnum)PersonBeforeBusinessProcessorBuilder.ACT_GETRECEIVERS, PersonBeforeBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
            batchResults.throwExceptions();
            userHashSet = (HashSet)batchResults.getResponse().get((Object)"userHashSet");
        }
        return userHashSet;
    }

    @Override
    protected Set _getReceiversByRoleNumberAndPositionId(Context ctx, String roleNumber, BOSUuid positionId) throws BOSException, EASBizException {
        String sql = "SELECT FAdminOrgUnitID FROM T_ORG_Position WHERE FID = '" + positionId.toString() + "'";
        BOSUuid adminID = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                adminID = BOSUuid.read((String)rs.getString(1));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return this._getReceiversByRoleNumberAndAdminId(ctx, roleNumber, adminID);
    }

    @Override
    protected Set _getReceiversByPositionNumber(Context ctx, String positionNumber) throws BOSException, EASBizException {
        HashSet<String> userHashSet = new HashSet<String>();
        String[] positionNum = positionNumber.split("\\$\\$");
        StringBuffer positionStr = new StringBuffer();
        int length = positionNum.length;
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                positionStr.append("'");
                positionStr.append(positionNum[i]);
                positionStr.append("'");
                continue;
            }
            positionStr.append("'");
            positionStr.append(positionNum[i]);
            positionStr.append("',");
        }
        String sql = "SELECT FPersonID FROM T_ORG_PositionMember WHERE FPositionID in (SELECT FID FROM T_ORG_Position WHERE FNumber IN (" + positionStr + "))";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userCollection = null;
        String userID = "";
        UserInfo userInfo = null;
        try {
            while (rs.next()) {
                String personId = rs.getString(1);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                userCollection = iUser.getUserCollection(viewInfo);
                if (userCollection.size() == 0 || userHashSet.contains(userID = (userInfo = userCollection.get(0)).getId().toString())) continue;
                userHashSet.add(userID);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return userHashSet;
    }

    @Override
    protected boolean _createUserByPerson(Context ctx, IObjectValue person, boolean isUseName) throws BOSException, EASBizException {
        PersonInfo personInfo = (PersonInfo)person;
        if (personInfo == null) {
            return false;
        }
        if (StringUtils.isEmpty((String)personInfo.getNumber()) || StringUtils.isEmpty((String)personInfo.getName())) {
            throw new PersonException(PersonException.PERSON_NUMBER_ISNULL);
        }
        UserInfo userInfo = UserInfoHelper.createNewDefaultUserInfo();
        if (isUseName) {
            userInfo.setNumber(personInfo.getNumber() + personInfo.getName());
        } else if (!StringUtils.isEmpty((String)personInfo.getNumber())) {
            userInfo.setNumber(personInfo.getNumber());
        } else {
            throw new PersonException(PersonException.PERSON_NUMBER_ISNULL);
        }
        userInfo.setName(personInfo.getName(), new Locale("L2"));
        String name_l3 = STConverter.sc2tc((String)personInfo.getName());
        userInfo.setName(name_l3, new Locale("L3"));
        userInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        userInfo.setAgentUser(false);
        userInfo.setPerson(personInfo);
        PositionMemberInfo positionMemberInfo = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberInfo("select position.* where person = '" + personInfo.getId().toString() + "' and isPrimary =1");
        if (positionMemberInfo != null && positionMemberInfo.getPosition() != null && positionMemberInfo.getPosition().getHrOrgUnit() != null) {
            userInfo.setDefOrgUnit(positionMemberInfo.getPosition().getHrOrgUnit().castToFullOrgUnitInfo());
        }
        try {
            userInfo.setPassword(CryptoTean.encrypt((String)personInfo.getNumber(), (String)personInfo.getNumber()));
        }
        catch (CryptException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("CryptException.encrypt() error!", (Throwable)e);
        }
        String securityId = "00000000-0000-0000-0000-0000000000013EE2C673";
        ISecurity iSecurity = SecurityFactory.getLocalInstance((Context)ctx);
        SecurityInfo securityInfo = iSecurity.getSecurityInfo((IObjectPK)new ObjectStringPK(securityId));
        userInfo.setSecurity(securityInfo);
        IObjectPK newUserPK = UserFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)userInfo);
        userInfo.setId(BOSUuid.read((String)newUserPK.toString()));
        PersonHelper helper = new PersonHelper();
        FullOrgUnitCollection fullOrgUnit = helper.addUserOrgRange(ctx, newUserPK, personInfo);
        UserFactory.getLocalInstance((Context)ctx).saveRoleInfo(userInfo, fullOrgUnit, "YW3xsAEJEADgAAcrwKgTBxO2cyo=");
        return true;
    }

    protected List _getPersonByPersonIDAndOrg(Context ctx, List idList, HashMap adminMap) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT person.FID id, person.FNumber number, person.FName_l2 pname, org.FName_l2 oname, person.FDeletedStatus deletedStatus ");
        sql.append("FROM T_BD_Person person  INNER JOIN T_ORG_PositionMember positionMember ON person.FID = positionMember.FPersonID ");
        sql.append("INNER JOIN T_ORG_Position position ON positionMember.FPositionID = position.FID ");
        sql.append("INNER JOIN T_ORG_Admin org  ON position.FAdminOrgUnitID = org.FID ");
        String adminName = "";
        String personid = "";
        boolean beginWhereExp = true;
        for (int i = 0; i < idList.size(); ++i) {
            personid = idList.get(i).toString();
            if (!adminMap.containsKey(personid)) continue;
            adminName = adminMap.get(personid).toString();
            if (beginWhereExp) {
                sql.append("where (person.FID = '" + personid + "' and org.FName_l2 = '" + adminName + "' )");
                beginWhereExp = false;
                continue;
            }
            sql.append("or (person.FID = '" + personid + "' and org.FName_l2 = '" + adminName + "' )");
        }
        sql.append("ORDER BY person.FNumber ASC");
        if (beginWhereExp) {
            return null;
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rows != null && rows.size() > 0) {
            ArrayList<IRowSet> retValue = new ArrayList<IRowSet>();
            retValue.add(rows);
            return retValue;
        }
        return null;
    }

    protected String _getAdminOrgNameByPerson(Context ctx, BOSUuid personId) throws BOSException, EASBizException {
        String adminSql = "SELECT ADMIN.FNAME_L2 FROM T_HR_PersonPosition PP  LEFT OUTER JOIN T_ORG_ADMIN ADMIN ON PP.FPERSONDEP = ADMIN.FID\t WHERE PP.FPERSONID = '" + personId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)adminSql);
        String adminName = "";
        try {
            while (rs.next()) {
                adminName = rs.getString(1);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return adminName;
    }

    @Override
    protected boolean _isStartSHR(Context ctx) throws BOSException, EASBizException {
        String sql = "select FValue from T_HR_HRInit where FKey ='IS_SHRGROUPMANAGE_UPDATE'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_isStartSHR executesql error!");
        }
        return false;
    }

    @Override
    protected boolean _updatePersonNCell(Context ctx) throws BOSException, EASBizException {
        return false;
    }
}

