/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCheckException;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;

public class PersonInfoCheck {
    public static void checkInfo(Context ctx, String personId) throws BOSException, EASBizException {
        IPerson ip = PersonFactory.getLocalInstance(ctx);
        PersonInfo pInfo = ip.getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)personId)));
        if (pInfo.getBirthday() == null) {
            throw new PersonCheckException(PersonCheckException.BASEINFO_BIRTHDAY_NOT_NULL);
        }
        if (pInfo.getPoliticalFace() == null) {
            throw new PersonCheckException(PersonCheckException.BASEINFO_POLITICALFACE_NOT_NULL);
        }
    }

    public static String[] checkInfo(Context ctx, String[] personIds) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        boolean pass = false;
        for (int i = 0; i < personIds.length; ++i) {
            pass = true;
            try {
                PersonInfoCheck.checkInfo(ctx, personIds[i]);
            }
            catch (PersonCheckException e) {
                pass = false;
            }
            if (!pass) continue;
            list.add(personIds[i]);
        }
        String[] passIds = new String[list.size()];
        for (int i = 0; i < passIds.length; ++i) {
            passIds[i] = list.get(i).toString();
        }
        return passIds;
    }
}

