/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.core.IBotExtSetRuleProvider;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.botp.util.BOTObjectCache;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.dap.app.DAPFIVoucherTransformer;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Null;
import com.kingdee.util.StringUtils;
import com.kingdee.util.ThreadLocalCache;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DAPAssistant
implements IBotExtSetRuleProvider {
    private static Logger logger = Logger.getLogger(DAPFIVoucherTransformer.class);
    private static final String ASST_ACT_TYPE = "AsstActTypeRegin";

    public static AssistantHGInfo getAssistantHG(Context ctx, AccountViewInfo accountViewInfo, HashMap map) throws EASBizException, BOSException {
        if (accountViewInfo == null || accountViewInfo.getId() == null) {
            return null;
        }
        return DAPAssistant.getAssistantHG2(ctx, accountViewInfo.getId().toString(), map);
    }

    public static AssistantHGInfo getAssistantHG2(Context ctx, String accountViewId, Map map) throws EASBizException, BOSException {
        IAssistantHG iAssistantHG;
        IAsstAccount iAsstAccount;
        AssistantHGInfo assHGInfo;
        if (accountViewId == null || accountViewId.equalsIgnoreCase("")) {
            return null;
        }
        String acctHGRegion = "||-Obj-||AcctHGInfo";
        String acctCAARegion = accountViewId + "||-Obj-||AcctCAA";
        Vector asstTypes = (Vector)BOTObjectCache.getInstance((Context)ctx).getObject(acctCAARegion);
        String asstTypeAsign = "";
        if (asstTypes != null) {
            for (int i = 0; i < asstTypes.size(); ++i) {
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstTypes.get(i);
                String attribute = asstActTypeInfo.getAsstHGAttribute();
                Object assInfo = map.get(attribute);
                if (assInfo != null) {
                    if (assInfo instanceof IObjectValue) {
                        asstTypeAsign = asstTypeAsign + "||" + attribute + ":" + ((IObjectValue)map.get(attribute)).get("id");
                        continue;
                    }
                    asstTypeAsign = asstTypeAsign + "||" + attribute + ":" + assInfo;
                    continue;
                }
                asstTypeAsign = asstTypeAsign + "||" + attribute + ":";
            }
            assHGInfo = (AssistantHGInfo)BOTObjectCache.getInstance((Context)ctx).getObject(acctHGRegion + "||" + asstTypeAsign);
            if (assHGInfo != null) {
                return assHGInfo;
            }
        }
        asstTypeAsign = "";
        AccountViewInfo actViewInfo = null;
        if (ctx == null) {
            IAccountView iAccountView = AccountViewFactory.getRemoteInstance();
            ObjectUuidPK actViewPK = new ObjectUuidPK(accountViewId);
            actViewInfo = iAccountView.getAccountViewInfo((IObjectPK)actViewPK);
            iAsstAccount = AsstAccountFactory.getRemoteInstance();
            iAssistantHG = AssistantHGFactory.getRemoteInstance();
        } else {
            actViewInfo = (AccountViewInfo)BOTObjectCache.getInstance((Context)ctx).get(accountViewId);
            iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
            iAssistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        }
        Date bookDate = null;
        CompanyOrgUnitInfo companyInfo = null;
        PeriodInfo periodInfo = null;
        String caaId = "";
        try {
            AccountViewInfo actViewInfoTemp;
            bookDate = (Date)ThreadLocalCache.getRegion((String)ASST_ACT_TYPE).get("bookedDate");
            companyInfo = (CompanyOrgUnitInfo)ThreadLocalCache.getRegion((String)ASST_ACT_TYPE).get("company");
            if (bookDate != null && companyInfo != null && (actViewInfoTemp = (AccountViewInfo)DAPAssistant.BOTgetAccountInSpecifiedFiOrg(ctx, actViewInfo.getNumber(), companyInfo)) != null) {
                String caaIdCacheKey = bookDate.toString() + "||" + actViewInfoTemp.getNumber() + "||" + companyInfo.getNumber();
                Object cacheCaaObj = BOTObjectCache.getInstance((Context)ctx).getObject(caaIdCacheKey);
                if (cacheCaaObj != null) {
                    if (!Null.NULL.equals(cacheCaaObj)) {
                        caaId = cacheCaaObj.toString();
                    }
                } else {
                    periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)companyInfo, (SystemEnum)SystemEnum.GENERALLEDGER);
                    if (periodInfo != null) {
                        actViewInfo = actViewInfoTemp;
                        caaId = AccountFacadeFactory.getLocalInstance((Context)ctx).getCAAIdByPeriod(actViewInfo.getId().toString(), periodInfo.getNumber());
                        BOTObjectCache.getInstance((Context)ctx).putObject(caaIdCacheKey, (Object)caaId);
                    } else {
                        BOTObjectCache.getInstance((Context)ctx).putObject(caaIdCacheKey, (Object)Null.NULL);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"[DAPAssistant]:fail to get count CAA in current company! ");
            logger.error((Object)("[DAPAssistant]: params ->  bookDate:" + bookDate + "; companyInfo:" + companyInfo + "; actViewInfo:" + actViewInfo + "; periodInfo:" + periodInfo), (Throwable)((Object)new DAPException(DAPException.ACCOUNTNULL, e)));
        }
        if (StringUtils.isEmpty((String)caaId)) {
            if (actViewInfo.getCAA() == null || actViewInfo.getCAA().getId() == null) {
                return null;
            }
            caaId = actViewInfo.getCAA().getId().toString();
        }
        if (asstTypes == null) {
            asstTypes = iAsstAccount.getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(caaId));
            BOTObjectCache.getInstance((Context)ctx).putObject(acctCAARegion, (Object)asstTypes);
        }
        AssistantHGInfo hgInfo = new AssistantHGInfo();
        AsstActTypeCollection types = new AsstActTypeCollection();
        String[] propNames = new String[asstTypes.size()];
        if (logger.isDebugEnabled()) {
            logger.error((Object)("DAPattributeAccount:" + actViewInfo.getId().toString()));
        }
        for (int i = 0; i < asstTypes.size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstTypes.get(i);
            String attribute = asstActTypeInfo.getAsstHGAttribute();
            Object assInfo = map.get(attribute);
            hgInfo.put(attribute, assInfo);
            if (logger.isDebugEnabled()) {
                if (assInfo instanceof IObjectValue) {
                    logger.error((Object)("\r\nDAPattribute:" + attribute + ":(IObjectValue):" + ((IObjectValue)assInfo).get("id")));
                } else {
                    logger.error((Object)("\r\nDAPattribute:" + attribute + "::" + assInfo));
                }
            }
            propNames[i] = attribute;
            types.add(asstActTypeInfo);
            if (assInfo != null) {
                if (assInfo instanceof IObjectValue) {
                    asstTypeAsign = asstTypeAsign + "||" + attribute + ":" + ((IObjectValue)map.get(attribute)).get("id");
                    continue;
                }
                asstTypeAsign = asstTypeAsign + "||" + attribute + ":" + assInfo.toString();
                continue;
            }
            asstTypeAsign = asstTypeAsign + "||" + attribute + ":";
        }
        if (types.size() == 0) {
            return null;
        }
        assHGInfo = iAssistantHG.getAssistantHG(hgInfo, caaId, types);
        BOTObjectCache.getInstance((Context)ctx).putObject(acctHGRegion + "||" + asstTypeAsign, (Object)assHGInfo);
        return assHGInfo;
    }

    private static String getCAAfromAccount(AccountViewInfo actViewInfo) {
        AsstAccountInfo caa = actViewInfo.getCAA();
        String caaId = "";
        if (caa != null) {
            caaId = caa.getId().toString();
        }
        return caaId;
    }

    public IObjectValue newInstance(Context ctx, Map refParams, Map params) throws EASBizException, BOSException {
        String accountViewId = (String)refParams.get(this.getRefPropertys());
        String asstHGAttribute = (String)params.get("asstActType");
        if (asstHGAttribute != null) {
            Object asstActTypeValue = params.get("refObject");
            params.put(asstHGAttribute, asstActTypeValue);
        }
        AssistantHGInfo obj = DAPAssistant.getAssistantHG2(ctx, accountViewId, params);
        return obj;
    }

    public String getDestPropertyName() {
        return "entries.assistRecords.assGrp";
    }

    public String getRefPropertys() {
        return "entries.account";
    }

    private static Object BOTgetAccountInSpecifiedFiOrg(Context ctx, String acctNumber, CompanyOrgUnitInfo fiOrg) throws InterpreterException {
        String key = acctNumber + "||" + fiOrg.getId();
        Object cacheObject = BOTObjectCache.getInstance((Context)ctx).getObject(key);
        if (cacheObject != null) {
            return cacheObject;
        }
        String acctTblId = null;
        String companyID = null;
        if (fiOrg.getAccountTable() != null && fiOrg.getAccountTable().getId() != null && fiOrg.getAccountTable().getId().toString().length() > 0) {
            acctTblId = fiOrg.getAccountTable().getId().toString();
        }
        if (fiOrg.getId() != null && fiOrg.getId().toString().length() > 0) {
            companyID = fiOrg.getId().toString();
        }
        if (acctTblId == null && fiOrg.getId() != null && fiOrg.getId().toString().length() > 0) {
            String sqlToGetAcctTblId = "SELECT TOP 1 FAccountTableID FROM T_ORG_OUPartFI WHERE FUNITID = ?";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAcctTblId, (Object[])new Object[]{fiOrg.getId().toString()});
                if (rs.next()) {
                    acctTblId = rs.getString("FAccountTableID");
                }
            }
            catch (BOSException e) {
                throw new InterpreterException(e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                throw new InterpreterException(e.getMessage(), (Throwable)e);
            }
        }
        if (acctTblId != null && companyID != null) {
            try {
                IAccountView iAcct = AccountViewFactory.getLocalInstance((Context)ctx);
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                evi.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)acctNumber));
                filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTblId));
                filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyID));
                AccountViewCollection acctCols = iAcct.getAccountViewCollection(evi);
                if (acctCols != null && acctCols.size() > 0) {
                    BOTObjectCache.getInstance((Context)ctx).putObject(key, (Object)acctCols.get(0));
                    return acctCols.get(0);
                }
            }
            catch (BOSException e) {
                throw new InterpreterException(e.getMessage(), (Throwable)e);
            }
        }
        logger.error((Object)"[DAPAssistant] fail to reCount Account!");
        return null;
    }
}

