/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.dap.AbstractDAPVoucherStrategy;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherCollection;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DAPFIVoucherStrategy
extends AbstractDAPVoucherStrategy {
    @Override
    public CoreBillBaseInfo getVoucherInfo() {
        return new VoucherInfo();
    }

    @Override
    public String getVoucherEditUIClass() {
        return "com.kingdee.eas.fi.gl.client.VoucherEditUI";
    }

    @Override
    public String getVoucherListUIClass() {
        return "com.kingdee.eas.fi.gl.client.VoucherListUI";
    }

    @Override
    public String getDefaultVoucherEditRule() {
        return "com.kingdee.eas.fi.gl.client.DefaultVoucherEditRule";
    }

    @Override
    public boolean _isHaveVoucher(Context ctx, String srcBillId, String companyOrgId) throws BOSException {
        String VOUCHERTYPE = "2652E01E";
        IBOTRelation iBTPRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcBillId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)VOUCHERTYPE, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        BOTRelationCollection relations = iBTPRelation.getCollection(viewInfo);
        if (relations == null || relations.size() == 0) {
            return false;
        }
        if (companyOrgId == null) {
            return relations != null && relations.size() != 0;
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("id");
        sic.add("number");
        sic.add("bizStatus");
        sic.add("company.*");
        SorterItemInfo createTimeSorter = new SorterItemInfo("createTime");
        createTimeSorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(createTimeSorter);
        FilterInfo voucherIdFilter = new FilterInfo();
        if (relations.size() > 0) {
            int voucherIndex = 0;
            StringBuffer voucherFilterMask = new StringBuffer();
            Iterator iter2 = relations.iterator();
            StringBuffer strVchIdLists = new StringBuffer();
            while (iter2.hasNext()) {
                BOTRelationInfo relationInfo = (BOTRelationInfo)iter2.next();
                String voucherId = relationInfo.getDestObjectID();
                if (voucherIndex > 0) {
                    strVchIdLists.append(",");
                }
                strVchIdLists.append(voucherId);
                ++voucherIndex;
            }
            voucherFilterMask.append("#" + String.valueOf(voucherIdFilter.getFilterItems().size()));
            voucherIdFilter.getFilterItems().add(new FilterItemInfo("id", (Object)strVchIdLists.toString(), CompareType.INCLUDE));
            voucherIdFilter.setMaskString(voucherFilterMask.toString());
        }
        evi.setFilter(voucherIdFilter);
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection voucherCols = null;
        voucherCols = iVoucher.getVoucherCollection(evi);
        for (int i = 0; i < voucherCols.size(); ++i) {
            VoucherInfo info = voucherCols.get(i);
            if (!info.getCompany().getId().toString().equals(companyOrgId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getVoucherEditUIEditRule() {
        return "EDITRULE";
    }

    @Override
    public boolean isTempVoucher(CoreBillBaseInfo voucher) {
        return VoucherStatusEnum.TEMP.equals((Object)((BaseVoucherInfo)voucher).getBizStatus());
    }

    public BaseVoucherCollection getVoucherCollection(EntityViewInfo evi) throws BOSException {
        IVoucher iVoucher = VoucherFactory.getRemoteInstance();
        return iVoucher.getBaseVoucherCollection(evi);
    }

    @Override
    public void setCompanyAndSourceType(CoreBillBaseInfo coreBillBaseInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)coreBillBaseInfo;
        ICompanyOrgUnit cu = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo companyInfo = cu.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(voucherInfo.getId()));
        voucherInfo.put("company", (Object)companyInfo);
        voucherInfo.setSourceType(SourceType.getEnum((int)4));
    }

    public BaseVoucherCollection getVoucherCollection(BOTRelationCollection relationCollection) throws BOSException {
        IVoucher iVoucher = VoucherFactory.getRemoteInstance();
        EntityViewInfo evi = this.getVoucherEntityViewInfo(relationCollection);
        BaseVoucherCollection voucherCols = null;
        voucherCols = iVoucher.getBaseVoucherCollection(evi);
        return voucherCols;
    }

    @Override
    public List<String> _getDestVoucherColsNumber(Context ctx, IObjectCollection srcBillCols, boolean isOnlyShowLast) throws BOSException {
        ArrayList<String> voucherNumberList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer("SELECT VOUCHER.FNUMBER, VOUCHER.FCREATETIME FROM T_GL_VOUCHER VOUCHER INNER JOIN T_BOT_RELATION RELATION ON VOUCHER.FID = RELATION.FDESTOBJECTID ");
        int size = srcBillCols.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sb.append(" AND (");
            } else {
                sb.append(" OR");
            }
            sb.append(" FSRCOBJECTID = '");
            sb.append(srcBillCols.getObject(i).get("id").toString());
            sb.append("'");
        }
        sb.append(" ) ORDER BY VOUCHER.FCREATETIME DESC");
        IRowSet rsToGetVoucherNumber = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            Timestamp lastCreateTime = null;
            while (rsToGetVoucherNumber.next()) {
                String voucherNumber = rsToGetVoucherNumber.getString("FNUMBER");
                Timestamp voucherCreateTime = rsToGetVoucherNumber.getTimestamp("FCREATETIME");
                if (lastCreateTime == null) {
                    lastCreateTime = voucherCreateTime;
                    voucherNumberList.add(voucherNumber);
                    continue;
                }
                if (!isOnlyShowLast) {
                    voucherNumberList.add(voucherNumber);
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return voucherNumberList;
    }

    @Override
    public String getDestVoucherInfoListFullOrgSql(String strIdList) {
        String sql = "SELECT voucher.FID FID,voucher.FNumber FNUMBER, period.FNumber as Period,ctrlunit.FName_L2 FNAME_L2, ctrlunit.FSimpleName ORG  FROM T_BOT_Relation as RELATION  INNER JOIN T_GL_Voucher VOUCHER ON RELATION.FDestObjectID = VOUCHER.FID  INNER JOIN T_BD_Period  PERIOD ON VOUCHER.FPeriodID = PERIOD.FID  INNER JOIN T_ORG_CtrlUnit ctrlunit ON voucher.FControlUnitID = ctrlunit.FID  WHERE relation.FSrcObjectID in (" + strIdList + ")  ORDER BY voucher.FNumber desc";
        return sql;
    }

    @Override
    public String innerIsExistVoucherOrgSql(String srcIDList) {
        String sql = "SELECT REL.FID FROM T_BOT_RELATION REL   INNER JOIN T_GL_VOUCHER VOUCHER ON REL.FDESTOBJECTID=VOUCHER.FID  WHERE VOUCHER.FCOMPANYID = ? AND REL.FDESTENTITYID = ?  AND REL.FSRCOBJECTID IN (" + srcIDList + ")";
        return sql;
    }
}

