/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.dap.AbstractDAPVoucherStrategy;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DAPUtils {
    public static final String strResource = "com.kingdee.eas.base.dap.DAPResource.";

    private DAPUtils() {
    }

    public static boolean hasBOTPRelation(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IBOTRelation iBotRelation = ctx == null ? BOTRelationFactory.getRemoteInstance() : BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("srcObjectID");
        evi.setFilter(filter);
        BOTRelationCollection botRelationCols = iBotRelation.getCollection(evi);
        return botRelationCols != null && botRelationCols.size() > 0;
    }

    public static void preCheckVoucherExist(Context ctx, CoreBillBaseCollection srcBillCols, BOTMappingCollection botMappingCols, String voucherBosType) throws BOSException, EASBizException {
        if (srcBillCols == null || srcBillCols.size() <= 0) {
            return;
        }
        ArrayList<String> srcBillIDList = new ArrayList<String>(srcBillCols.size());
        int n = srcBillCols.size();
        for (int i = 0; i < n; ++i) {
            String newID = srcBillCols.get(i).getId().toString();
            if (StringUtils.isEmpty((String)newID)) {
                throw new BOSException("billID=[" + newID + "]", (Throwable)new IllegalArgumentException());
            }
            srcBillIDList.add(newID);
        }
    }

    public static boolean checkVoucherExist(Context ctx, List srcBillIDList, BOTMappingCollection botMappingCols, String voucherBosType) throws BOSException, EASBizException {
        if (srcBillIDList == null || srcBillIDList.size() <= 0 || botMappingCols == null || botMappingCols.size() <= 0) {
            return false;
        }
        HashMap<CompanyOrgUnitInfo, CompanyOrgUnitInfo> orgInfoMap = new HashMap<CompanyOrgUnitInfo, CompanyOrgUnitInfo>();
        int n = botMappingCols.size();
        for (int j = 0; j < n; ++j) {
            BOTMappingInfo mappingInfo = botMappingCols.get(j);
            CompanyOrgUnitInfo orgInfo = mappingInfo.getExtRule().getOrg();
            if (orgInfo == null || orgInfoMap.containsKey(orgInfo)) continue;
            orgInfoMap.put(orgInfo, orgInfo);
        }
        if (orgInfoMap.size() <= 0) {
            return false;
        }
        ArrayList<String> orgIDList = new ArrayList<String>();
        for (CompanyOrgUnitInfo orgInfo : orgInfoMap.values()) {
            orgIDList.add(orgInfo.getId().toString());
        }
        return DAPUtils.isExistVoucherOrg(ctx, orgIDList, voucherBosType, srcBillIDList);
    }

    public static boolean isExistVoucherOrg(Context ctx, List orgIDList, String voucherBosType, List srcBillIDList) throws BOSException, EASBizException {
        int iStep;
        int iMax = 300;
        int iTotal = srcBillIDList.size();
        if (iTotal > (iStep = iTotal / iMax) * iMax) {
            ++iStep;
        }
        FilterInfo filterEntity = new FilterInfo();
        filterEntity.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)voucherBosType, CompareType.EQUALS));
        for (int k = 1; k <= iStep; ++k) {
            int lCurrStart = (k - 1) * iMax;
            int lCurrEnd = k * iMax;
            if (lCurrEnd > iTotal) {
                lCurrEnd = iTotal;
            }
            StringBuffer strBuffer = new StringBuffer();
            for (int i = lCurrStart; i < lCurrEnd; ++i) {
                String id = (String)srcBillIDList.get(i);
                if (strBuffer.length() > 0) {
                    strBuffer.append(",");
                }
                strBuffer.append("'" + id + "'");
            }
            String srcIDList = strBuffer.toString();
            int n = orgIDList.size();
            for (int i = 0; i < n; ++i) {
                String orgID = (String)orgIDList.get(i);
                if (!DAPUtils.innerIsExistVoucherOrg(ctx, orgID, voucherBosType, srcIDList)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean innerIsExistVoucherOrg(Context ctx, String orgID, String voucherBosType, String srcIDList) throws BOSException, EASBizException {
        String sql = "";
        try {
            IRowSet rs = null;
            if (orgID != null && !"".equals(orgID)) {
                sql = AbstractDAPVoucherStrategy.getInstanceof("fi").innerIsExistVoucherOrgSql(srcIDList);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgID, voucherBosType});
            } else {
                sql = "SELECT REL.FID FROM T_BOT_RELATION REL  WHERE REL.FDESTENTITYID = ?  AND REL.FSRCOBJECTID IN (" + srcIDList + ")";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherBosType});
            }
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException("error, sql=" + sql, (Throwable)e);
        }
        return false;
    }
}

