/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTExtMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class DAPAppTools {
    private static Logger logger = Logger.getLogger(DAPAppTools.class);

    public static void execDataFilterMultiEntry(Context ctx, CoreBillBaseCollection srcCoreBillCollection, BOTMappingInfo mappingInfo) throws BOSException {
        if (srcCoreBillCollection == null || srcCoreBillCollection.size() <= 0 || mappingInfo == null || mappingInfo.getExtRule() == null) {
            return;
        }
        BOTExtMappingInfo extMappingInfo = mappingInfo.getExtRule();
        String dataFilter = extMappingInfo.getDataFilter();
        if (dataFilter == null || "".equals(dataFilter)) {
            return;
        }
        boolean hasEntryFilter = false;
        if (dataFilter.indexOf("EntryWhere") > -1) {
            hasEntryFilter = true;
        }
        ArrayList<String> entriesNameList = new ArrayList<String>();
        EntityViewInfo evi = null;
        try {
            evi = BOTPTools.getEntityViewInfoFromMapping((BOTMappingInfo)mappingInfo, (int)1);
            FilterCollection filterCol = evi.getEntryFilters();
            for (int i = 0; i < filterCol.size(); ++i) {
                FilterInfo filter = filterCol.get(i);
                entriesNameList.add(filter.getEntryName());
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        List<String> dataFilterList = DAPAppTools.getDataFilterCombStr(ctx, srcCoreBillCollection, mappingInfo, entriesNameList);
        CoreBillBaseCollection filteredCollection = new CoreBillBaseCollection();
        for (int index = 0; index < dataFilterList.size(); ++index) {
            String dataFilterStr = dataFilterList.get(index);
            IDynamicObject iDynObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
            IObjectCollection billCollection = iDynObj.getCollection(srcCoreBillCollection.get(0).getBOSType(), dataFilterStr);
            filteredCollection.addObjectCollection(billCollection);
        }
        if (srcCoreBillCollection.size() == filteredCollection.size() && !hasEntryFilter) {
            return;
        }
        HashMap<BOSUuid, CoreBillBaseInfo> filteredBillBillMap = new HashMap<BOSUuid, CoreBillBaseInfo>();
        for (int i = 0; i < filteredCollection.size(); ++i) {
            CoreBillBaseInfo filteredBill = filteredCollection.get(i);
            filteredBillBillMap.put(filteredBill.getId(), filteredBill);
        }
        int srcBillCount = srcCoreBillCollection.size();
        for (int i = 0; i < srcBillCount; ++i) {
            CoreBillBaseInfo srcBill = srcCoreBillCollection.get(i);
            if (!filteredBillBillMap.containsKey(srcBill.getId())) {
                srcCoreBillCollection.removeObject(i);
                --i;
                --srcBillCount;
                continue;
            }
            if (entriesNameList == null || entriesNameList.size() <= 0 || !hasEntryFilter) continue;
            boolean bExistEntry = false;
            for (int k = 0; k < entriesNameList.size(); ++k) {
                String entriesName = (String)entriesNameList.get(k);
                CoreBillBaseInfo filteredInfo = (CoreBillBaseInfo)filteredBillBillMap.get(srcBill.getId());
                CoreBillBaseInfo srcBillInfo = srcBill;
                IObjectCollection billEntries = (IObjectCollection)srcBillInfo.get(entriesName);
                IObjectCollection filterEntries = (IObjectCollection)filteredInfo.get(entriesName);
                int beCount = billEntries.size();
                for (int z = 0; z < beCount; ++z) {
                    IObjectValue billEntry = billEntries.getObject(z);
                    boolean flag = false;
                    int fBeCount = filterEntries.size();
                    for (int fz = 0; fz < fBeCount; ++fz) {
                        IObjectValue feBillEntry = filterEntries.getObject(fz);
                        if (!billEntry.get("id").toString().equals(feBillEntry.get("id").toString())) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    billEntries.removeObject(z);
                    --z;
                    --beCount;
                }
                if (billEntries.size() <= 0) continue;
                bExistEntry = true;
            }
            if (bExistEntry) continue;
            srcCoreBillCollection.removeObject(i);
            --i;
            --srcBillCount;
        }
        logger.info((Object)("DataFilter End.  size=" + srcCoreBillCollection.size()));
    }

    private static List<String> getDataFilterCombStr(Context ctx, CoreBillBaseCollection srcCoreBillCollection, BOTMappingInfo mappingInfo, List entriesNameList) throws BOSException {
        String dataFilter = mappingInfo.getExtRule().getDataFilter();
        int maxSize = 1000;
        ArrayList<String> filterList = new ArrayList<String>();
        ArrayList<CoreBillBaseCollection> billColList = new ArrayList<CoreBillBaseCollection>();
        if (StringUtils.isEmpty((String)dataFilter)) {
            return filterList;
        }
        if (srcCoreBillCollection.size() < maxSize) {
            billColList.add(srcCoreBillCollection);
        } else {
            CoreBillBaseCollection billCol = new CoreBillBaseCollection();
            for (int i = 0; i < srcCoreBillCollection.size(); ++i) {
                CoreBillBaseInfo billInfo = srcCoreBillCollection.get(i);
                billCol.add(billInfo);
                if (billCol.size() != maxSize - 1) continue;
                billColList.add(billCol);
                billCol = new CoreBillBaseCollection();
            }
            if (billCol.size() > 0) {
                billColList.add(billCol);
            }
        }
        EntityViewInfo evi = null;
        CoreBillBaseCollection billCol = null;
        FilterInfo filterInfo = null;
        StringBuffer filterMask = null;
        StringBuffer strIdLists = null;
        for (int index = 0; index < billColList.size(); ++index) {
            billCol = (CoreBillBaseCollection)billColList.get(index);
            try {
                evi = BOTPTools.getEntityViewInfoFromMapping((BOTMappingInfo)mappingInfo, (int)1);
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
            filterInfo = new FilterInfo();
            filterMask = new StringBuffer();
            strIdLists = new StringBuffer();
            int size = billCol.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    strIdLists.append(",");
                }
                strIdLists.append(billCol.get(i).getId().toString());
            }
            if (strIdLists.length() > 0) {
                filterMask.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists.toString(), CompareType.INCLUDE));
            }
            if (filterMask.length() > 0) {
                filterInfo.setMaskString(filterMask.toString());
            }
            if (evi.getFilter() != null && evi.getFilter().getFilterItems().size() > 0) {
                evi.getFilter().mergeFilter(filterInfo, "and");
            } else {
                evi.setFilter(filterInfo);
            }
            filterList.add(evi.toString());
        }
        return filterList;
    }

    public static List getSrcEntriesNameList(Context ctx, CoreBillBaseCollection srcCoreBillCollection) {
        ArrayList<String> list = new ArrayList<String>();
        CoreBillBaseInfo baseInfo = null;
        if (srcCoreBillCollection != null && srcCoreBillCollection.size() > 0) {
            baseInfo = srcCoreBillCollection.get(0);
            BOSObjectType bosType = baseInfo.getBOSType();
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo bo = loader.getEntity(bosType);
            PropertyCollection flds = bo.getInheritedPropertiesRuntime();
            int n = flds.size();
            for (int j = 0; j < n; ++j) {
                RelationshipInfo relation;
                PropertyInfo fld = flds.get(j);
                if (!(fld instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ((LinkPropertyInfo)fld).getRelationship()).getType()) || CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo)) || !CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo))) continue;
                list.add(fld.getName());
            }
        }
        return list;
    }

    protected static void checkBillExistVoucher(Context ctx, IObjectPK[] srcBillIDs, String destType) throws BOSException, DAPException {
        if (srcBillIDs == null || srcBillIDs.length <= 0) {
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer strSrcIDs = new StringBuffer();
        for (int i = 0; i < srcBillIDs.length; ++i) {
            if (i > 0) {
                strSrcIDs.append(",");
            }
            strSrcIDs.append("'" + srcBillIDs[i].toString() + "'");
        }
        StringBuffer strSql = new StringBuffer("SELECT count(*) FROM T_BOT_RELATION WHERE");
        strSql.append(" FSRCOBJECTID in (");
        strSql.append(strSrcIDs);
        strSql.append(")");
        strSql.append(" and FDESTENTITYID=?");
        params.add(destType);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])params.toArray());
        try {
            rs.next();
            if (rs.getInt(1) > 0) {
                throw new DAPException(DAPException.VOUCHER_EXIST);
            }
        }
        catch (SQLException e) {
            throw new BOSException("checkBillExistVoucher Error!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeBatch(Context ctx, List sqlList) throws SQLException {
        int[] nArray;
        Connection conn = null;
        Statement stmt = null;
        try {
            int[] val;
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            int n = sqlList.size();
            for (int i = 0; i < n; ++i) {
                if (StringUtils.isEmpty((String)((String)sqlList.get(i)))) continue;
                stmt.addBatch((String)sqlList.get(i));
            }
            nArray = val = stmt.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeBatchUpdate(Context ctx, List sqlList) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        int iMax = 2000;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            int iTempSize = 0;
            int n = sqlList.size();
            for (int i = 0; i < n; ++i) {
                if (StringUtils.isEmpty((String)((String)sqlList.get(i)))) continue;
                stmt.addBatch((String)sqlList.get(i));
                if (++iTempSize < iMax) continue;
                stmt.executeBatch();
                iTempSize = 0;
            }
            stmt.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }
}

