/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTAggregateCollection;
import com.kingdee.bos.metadata.bot.BOTGroupingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.app.DAPFIVoucherTransformer;
import com.kingdee.eas.base.dap.app.DAPMAVoucherTransformer;
import com.kingdee.eas.base.dap.app.DAPPCVoucherTransformer;
import com.kingdee.eas.base.dap.app.IDAPInnerTransformer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import java.util.HashSet;
import java.util.List;
import org.dom4j.DocumentException;

public class DAPTransformUtils {
    protected static void takeAttachmentOnRelations(Context ctx, IObjectCollection botRelationCols) throws BOSException, EASBizException {
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String botMappingId = ((BOTRelationInfo)botRelationCols.getObject(0)).getBOTMappingID();
        if (botMappingId == null || botMappingId.equals("")) {
            return;
        }
        BOTMappingInfo botMappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(botMappingId, ctx);
        String extconfig = botMappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = null;
        BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
        if (extconfig != null && !extconfig.equals("")) {
            BOTRelationInfo relation;
            int i;
            HashSet<String> ids;
            try {
                info = processor.marshallingExtConfig(extconfig);
            }
            catch (DocumentException e) {
                throw new BOSException((Throwable)e);
            }
            boolean headAttachment = true;
            boolean detailAttachment = true;
            if (info.getHasHeadAttachment() == null || info.getHasHeadAttachment().equals("") || info.getHasHeadAttachment().equals("0")) {
                headAttachment = false;
            }
            if (info.getHasDetailAttachment() == null || info.getHasDetailAttachment().equals("") || info.getHasDetailAttachment().equals("0")) {
                detailAttachment = false;
            }
            if (headAttachment) {
                ids = new HashSet<String>();
                for (i = 0; i < botRelationCols.size(); ++i) {
                    relation = (BOTRelationInfo)botRelationCols.getObject(i);
                    String destObjId = relation.getDestObjectID();
                    ids.add(destObjId);
                    asm.copyBizRelation(relation.getSrcObjectID(), destObjId);
                }
                for (i = 0; i < ids.size(); ++i) {
                    DAPTransformUtils.uniteAttachment(ctx, ids.toArray()[i].toString());
                }
            }
            if (detailAttachment) {
                ids = new HashSet();
                for (i = 0; i < botRelationCols.size(); ++i) {
                    relation = (BOTRelationInfo)botRelationCols.getObject(i);
                    BOTRelationEntryCollection entries = relation.getRelationEntries();
                    if (entries == null) continue;
                    for (int j = 0; j < entries.size(); ++j) {
                        BOTRelationEntryInfo relationEntry = (BOTRelationEntryInfo)entries.getObject(j);
                        String destObjEntryId = relationEntry.getDestEntryID();
                        ids.add(destObjEntryId);
                        asm.copyBizRelation(relationEntry.getSrcEntryID(), destObjEntryId);
                    }
                }
                for (i = 0; i < ids.size(); ++i) {
                    DAPTransformUtils.uniteAttachment(ctx, ids.toArray()[i].toString());
                }
            }
        }
    }

    protected static void uniteAttachment(Context ctx, String boid) throws BOSException, EASBizException {
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String[] attchIds = asm.getAttachmentIDsByBoID(boid);
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < attchIds.length; ++i) {
            String attchId = attchIds[i];
            ids.add(attchId);
        }
        String[] aids = new String[ids.size()];
        Object[] temp = ids.toArray();
        for (int i = 0; i < temp.length; ++i) {
            String attchId;
            aids[i] = attchId = (String)temp[i];
        }
        asm.deleteAttachemtsByBoID(boid);
        asm.addAssociations(boid, aids);
    }

    protected static void save(Context ctx, IObjectCollection sourceBillCollection, DAPTransformResult result, boolean isCheckPermission) throws BOSException, EASBizException {
        if (sourceBillCollection == null) {
            return;
        }
        if (result == null || sourceBillCollection.size() < 1) {
            return;
        }
        IDAPInnerTransformer inner = DAPTransformUtils.getInnerTransformer(ctx, result.getVoucherType());
        inner.isCheckPermission(isCheckPermission);
        inner.save(ctx, (CoreBillBaseCollection)sourceBillCollection, result);
    }

    protected static void save(Context ctx, IObjectCollection sourceBillCollection, List resultList) throws BOSException, EASBizException {
        if (sourceBillCollection == null) {
            return;
        }
        if (resultList.size() == 0 || sourceBillCollection.size() < 1) {
            return;
        }
        IDAPInnerTransformer inner = DAPTransformUtils.getInnerTransformer(ctx, ((DAPTransformResult)resultList.get(0)).getVoucherType());
        inner.save(ctx, (CoreBillBaseCollection)sourceBillCollection, resultList);
    }

    protected static void preview(Context ctx, IObjectCollection sourceBillCollection, DAPTransformResult result) throws BOSException, EASBizException {
        if (sourceBillCollection == null) {
            return;
        }
        if (result == null || sourceBillCollection.size() < 1) {
            return;
        }
        IDAPInnerTransformer inner = DAPTransformUtils.getInnerTransformer(ctx, result.getVoucherType());
        inner.preview(ctx, (CoreBillBaseCollection)sourceBillCollection, result);
    }

    protected static void save(Context ctx, IObjectPK[] srcBillIDList, DAPTransformResult result, SelectorItemCollection selectors) throws BOSException, EASBizException {
        if (srcBillIDList == null) {
            return;
        }
        if (result == null || srcBillIDList.length < 1) {
            return;
        }
        IDAPInnerTransformer inner = DAPTransformUtils.getInnerTransformer(ctx, result.getVoucherType());
        inner.saveSQLE(ctx, srcBillIDList, result, selectors);
    }

    protected static boolean transformCheck(Context ctx, CoreBillBaseCollection sourceBillCollection, DAPVoucherTypeEnum voucherType) throws BOSException, DAPException {
        if (sourceBillCollection == null || sourceBillCollection.size() < 1) {
            return false;
        }
        return voucherType != null;
    }

    protected static boolean undoTransformCheck(Context ctx, IObjectValue voucher) throws BOSException, EASBizException {
        return voucher != null;
    }

    protected static IDAPInnerTransformer getInnerTransformer(Context ctx, DAPVoucherTypeEnum voucherType) throws EASBizException {
        if (voucherType.getValue() == 0) {
            return new DAPFIVoucherTransformer();
        }
        if (voucherType.getValue() == 1) {
            return new DAPMAVoucherTransformer();
        }
        if (voucherType.getValue() == 2) {
            return new DAPPCVoucherTransformer();
        }
        assert (false);
        return null;
    }

    protected static BOTMappingInfo getMappingByPK(Context ctx, IObjectPK botMappingPK) throws BOSException {
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botMappingInfo = botMapping.getMappingInfoByPK(botMappingPK);
        return botMappingInfo;
    }

    public static void adjustGroupAndAggregate(BOTMappingCollection botMappingCols) {
        int i;
        if (botMappingCols.size() > 1) {
            return;
        }
        BOTMappingInfo standardBotMappingInfo = botMappingCols.get(0);
        BOTAggregateCollection stBotAggregateCols = standardBotMappingInfo.getAggregateCollection();
        BOTGroupingCollection stBotGroupCols = null;
        BOTRuleCollection botRuleCols = standardBotMappingInfo.getRules();
        int count = botRuleCols.size();
        for (i = 0; i < count; ++i) {
            BOTRuleInfo botRuleInfo = botRuleCols.get(i);
            stBotGroupCols = botRuleInfo.getGroups();
        }
        count = botMappingCols.size();
        for (i = 0; i < count; ++i) {
            BOTMappingInfo botMappingInfo = botMappingCols.get(i);
            BOTAggregateCollection aggregateCols = botMappingInfo.getAggregateCollection();
            aggregateCols.clear();
            aggregateCols.addCollection(stBotAggregateCols);
            BOTRuleCollection ruleCols = botMappingInfo.getRules();
            int count2 = botRuleCols.size();
            for (int j = 0; j < count2; ++j) {
                BOTRuleInfo ruleInfo = ruleCols.get(j);
                stBotGroupCols = ruleInfo.getGroups();
                stBotGroupCols.clear();
                stBotGroupCols.addCollection(stBotGroupCols);
            }
        }
    }
}

