/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.bot.engine.common.GzCompressionUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.MappingUtil;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.openapi.third.exception.BizException;
import com.kingdee.bos.openapi.third.exception.InvokeNetworkException;
import com.kingdee.bos.openapi.third.exception.LoginException;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.bot.trace.TraceConstants;
import com.kingdee.eas.base.bot.trace.TraceManagerFactory;
import com.kingdee.eas.base.bot.trace.TraceParamInfo;
import com.kingdee.eas.base.bot.trace.core.ITraceManager;
import com.kingdee.eas.base.bot.trace.impl.BotpTraceObject;
import com.kingdee.eas.base.bot.trace.util.TraceConfigurator;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.botp.util.BOTPDBlockTools;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.botp.util.BotpUtils;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.app.BOTPConfigInfo;
import com.kingdee.eas.base.dap.AbstractDAPVoucherStrategy;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPUtils;
import com.kingdee.eas.base.dap.DAPVoucherOrgInfo;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.dap.app.AbstractDAPTransformerControllerBean;
import com.kingdee.eas.base.dap.app.DAPAppTools;
import com.kingdee.eas.base.dap.app.DAPTransformSQLE;
import com.kingdee.eas.base.dap.app.DAPTransformUtils;
import com.kingdee.eas.base.dap.app.IDAPInnerTransformer;
import com.kingdee.eas.base.dap.util.DAPCommonUtils;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.app.CoreBillBaseController;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DAPTransformerControllerBean
extends AbstractDAPTransformerControllerBean {
    private static final String VOUCHERFLAG = "fiVouchered";
    private static Logger logger = Logger.getLogger(DAPTransformerControllerBean.class);
    protected ITraceManager trace = TraceManagerFactory.newInstance((int)TraceConstants.TRACETYPE_BOTP);
    private static final String btpResName = "com.kingdee.eas.base.btp.btpResource";

    @Override
    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        CoreBillBaseInfo billInfo = (CoreBillBaseInfo)BotpHelper.getSrcObjectById((Context)ctx, (String)sourceBillPk.toString());
        return this._undoTransformFromBill(ctx, (IObjectValue)billInfo, DAPVoucherTypeEnum.FIVoucher);
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectPK sourceBillPk, IObjectCollection selectorItemCollection) throws BOSException, EASBizException {
        this._generateVoucher(ctx, new IObjectPK[]{sourceBillPk}, selectorItemCollection);
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectCollection selectorItemCollection) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer();
        BOSObjectType bosType = null;
        for (int index = 0; index < sourceBillPkList.length; ++index) {
            String id = sourceBillPkList[index].toString();
            if (index == 0) {
                BOSUuid uuid = BOSUuid.read((String)id);
                bosType = uuid.getType();
            }
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)id);
            if (index != 0) {
                sbMaskString.append(" or ");
            }
            sbMaskString.append("#");
            sbMaskString.append(String.valueOf(index));
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        filterInfo.setMaskString(sbMaskString.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        if (selectorItemCollection != null) {
            entityViewInfo.put("selector", (Object)selectorItemCollection);
        }
        IDynamicObject iDynamicObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
        if (bosType == null) {
            return;
        }
        IObjectCollection srcBillCols = iDynamicObj.getCollection(bosType, entityViewInfo);
        CoreBillBaseCollection srcCoreBillCols = new CoreBillBaseCollection();
        int count = srcBillCols.size();
        for (int index = 0; index < count; ++index) {
            srcCoreBillCols.add((CoreBillBaseInfo)srcBillCols.getObject(index));
        }
        if (srcCoreBillCols.size() == 1) {
            this._generateVoucher(ctx, (IObjectValue)srcCoreBillCols.get(0), DAPVoucherTypeEnum.FIVoucher);
        } else {
            this._generateVoucher(ctx, (IObjectCollection)srcCoreBillCols, DAPVoucherTypeEnum.FIVoucher);
        }
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectValue sourceBill, DAPVoucherTypeEnum voucherType) throws BOSException, EASBizException {
        DAPTransformResult dapTransformResult = null;
        dapTransformResult = this._transform(ctx, (IObjectValue)((CoreBillBaseInfo)sourceBill), voucherType);
        this._save(ctx, (IObjectValue)((CoreBillBaseInfo)sourceBill), dapTransformResult);
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, DAPVoucherTypeEnum voucherType) throws BOSException, EASBizException {
        DAPTransformResult dapTransformResult = null;
        dapTransformResult = this._transform(ctx, (IObjectCollection)((CoreBillBaseCollection)sourceBillCollection), voucherType);
        this._save(ctx, (IObjectCollection)((CoreBillBaseCollection)sourceBillCollection), dapTransformResult);
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectValue mappingInfo) throws BOSException, EASBizException {
        BOTMappingInfo mapping = (BOTMappingInfo)mappingInfo;
        CoreBillBaseCollection billBaseCollection = null;
        DAPVoucherTypeEnum voucherType = DAPVoucherTypeEnum.FIVoucher;
        BOSObjectType bosObjectType = mapping.getSrcEntity().getBOSType();
        EntityViewInfo evi = BOTMappingHelper.getBOTMappingFilter((Context)ctx, (BOTMappingInfo)mapping);
        IDynamicObject ido = DynamicObjectFactory.getLocalInstance((Context)ctx);
        billBaseCollection = (CoreBillBaseCollection)ido.getCollection(bosObjectType, evi);
        this._generateVoucher(ctx, (IObjectCollection)billBaseCollection, voucherType);
    }

    @Override
    protected void _undoTransformFromVoucher(Context ctx, IObjectValue voucher) throws BOSException, EASBizException {
        if (!DAPTransformUtils.undoTransformCheck(ctx, voucher)) {
            return;
        }
        DAPVoucherTypeEnum voucherType = DAPVoucherTypeEnum.FIVoucher;
        if (voucher != null && voucher instanceof PcVoucherInfo) {
            voucherType = DAPVoucherTypeEnum.PCVoucher;
        }
        IDAPInnerTransformer inner = DAPTransformUtils.getInnerTransformer(ctx, voucherType);
        CoreBillBaseInfo voucherInfo = (CoreBillBaseInfo)voucher;
        inner.undoTransformFromVoucher(ctx, voucherInfo);
    }

    @Override
    protected DAPTransformResult _transform(Context ctx, IObjectValue sourceBill, DAPVoucherTypeEnum voucherType) throws BOSException, EASBizException {
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add((CoreBillBaseInfo)sourceBill);
        return this._transform(ctx, (IObjectCollection)sourceBillCollection, voucherType);
    }

    @Override
    protected DAPTransformResult _transform(Context ctx, IObjectCollection sourceBillCollection, DAPVoucherTypeEnum voucherType) throws BOSException, EASBizException {
        BOTMappingInfo botMappingInfo = this.getMapping(ctx, (CoreBillBaseCollection)sourceBillCollection, voucherType);
        return this._transformForBotp(ctx, sourceBillCollection, voucherType, (IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()));
    }

    @Override
    protected void _transformAutoToFIVoucher(Context ctx, IObjectPK srcBillPK) throws BOSException, EASBizException {
        BOSObjectType type = ((ObjectUuidPK)srcBillPK).getObjectType();
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)type);
        ICoreBillBase iBillBase = (ICoreBillBase)obj;
        CoreBillBaseInfo billInfo = iBillBase.getCoreBillBaseInfo(srcBillPK);
        this._transformAuto(ctx, (IObjectValue)billInfo, DAPVoucherTypeEnum.FIVoucher);
    }

    @Override
    protected IObjectValue _transformAuto(Context ctx, IObjectValue srcBillInfo, DAPVoucherTypeEnum voucherType) throws BOSException, EASBizException {
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add((CoreBillBaseInfo)srcBillInfo);
        IObjectCollection vouchers = this._transformAuto(ctx, (IObjectCollection)sourceBillCollection, voucherType);
        if (vouchers.size() > 0) {
            return vouchers.getObject(0);
        }
        return null;
    }

    @Override
    protected IObjectCollection _transformAuto(Context ctx, IObjectCollection sourceBillCollection, DAPVoucherTypeEnum voucherType) throws BOSException, EASBizException {
        BOTMappingInfo botMappingInfo = this.getMapping(ctx, (CoreBillBaseCollection)sourceBillCollection, voucherType);
        DAPTransformResult result = this._transformForBotp(ctx, sourceBillCollection, voucherType, (IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()));
        this._save(ctx, (IObjectCollection)((CoreBillBaseCollection)sourceBillCollection), result);
        return result.getVoucherCollection();
    }

    @Override
    protected void _save(Context ctx, IObjectValue sourceBill, DAPTransformResult result) throws BOSException, EASBizException {
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add((CoreBillBaseInfo)sourceBill);
        IDAPInnerTransformer inner = DAPTransformUtils.getInnerTransformer(ctx, result.getVoucherType());
        inner.save(ctx, sourceBillCollection, result);
    }

    private BOTMappingInfo getMapping(Context ctx, CoreBillBaseCollection sourceBillBaseCollection, DAPVoucherTypeEnum dapVoucherTypeEnum) throws BOSException, EASBizException {
        VoucherInfo voucherInfo;
        BOTMappingInfo botMappingInfo = null;
        String voucherType = null;
        if (dapVoucherTypeEnum.getValue() == 0) {
            voucherInfo = new VoucherInfo();
            voucherType = voucherInfo.getBOSType().toString();
            botMappingInfo = BOTMappingHelper.getMapping((Context)ctx, (IObjectCollection)sourceBillBaseCollection, (String)voucherType, (DefineSysEnum)DefineSysEnum.DAP);
        } else if (dapVoucherTypeEnum.getValue() == 2) {
            voucherInfo = new PcVoucherInfo();
            voucherType = voucherInfo.getBOSType().toString();
            botMappingInfo = BOTMappingHelper.getMapping((Context)ctx, (IObjectCollection)sourceBillBaseCollection, (String)voucherType, (DefineSysEnum)DefineSysEnum.DAPPC);
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        MappingUtil.initMappingEntity(botMappingInfo, (IMetaDataLoader)loader);
        return botMappingInfo;
    }

    private boolean saveCheck(Context ctx, List srcBillColsList, DAPTransformResult result) {
        if (srcBillColsList == null) {
            return false;
        }
        return result != null && srcBillColsList.size() >= 1;
    }

    @Override
    protected void _generateVoucher(Context ctx, String mappingID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(mappingID);
        BOTMappingInfo botMappingInfo = (BOTMappingInfo)BOTMappingFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk);
        this._generateVoucher(ctx, (IObjectValue)botMappingInfo);
    }

    @Override
    protected boolean _undoTransformFromBill(Context ctx, IObjectValue sourceBill, DAPVoucherTypeEnum voucherType) throws BOSException, EASBizException {
        return DAPTransformUtils.getInnerTransformer(ctx, voucherType).undoTransformFromBill(ctx, (CoreBillBaseInfo)sourceBill);
    }

    private void handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        CoreBillBaseInfo baseinfo = (CoreBillBaseInfo)collection.getObject(0);
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)baseinfo.getBOSType());
        ICoreBillBase iBillBase = (ICoreBillBase)obj;
        iBillBase.handleAfterTransform(action, collection);
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectCollection srcBillCollection, DAPVoucherTypeEnum voucherType, IObjectPK botMappingPK) throws BOSException, EASBizException {
        this._transform(ctx, (IObjectCollection)((CoreBillBaseCollection)srcBillCollection), voucherType, botMappingPK);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected DAPTransformResult _transform(Context ctx, IObjectCollection sourceBillCollection, DAPVoucherTypeEnum voucherType, IObjectPK botMappingPK) throws EASBizException, BOSException {
        DAPTransformResult dAPTransformResult;
        BOTMappingInfo mappingInfo;
        block21: {
            List idList = new ArrayList();
            DAPTransformResult dapTransformResult = null;
            mappingInfo = null;
            try {
                block20: {
                    mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(botMappingPK, ctx);
                    ArrayList<IObjectCollection> tempSrcList = new ArrayList<IObjectCollection>();
                    tempSrcList.add(sourceBillCollection);
                    idList = this.requestMutex(ctx, tempSrcList);
                    dapTransformResult = this._transformForBotp(ctx, sourceBillCollection, voucherType, botMappingPK);
                    LowTimer t = new LowTimer();
                    t.reset();
                    try {
                        this.trace.start("DAP AfterTransform");
                        if (mappingInfo.getIsTempSave() == 1 || mappingInfo.getIsTempSave() == 2) {
                            this.trace.newSub("handleAfterTransform");
                            this.handleAfterTransform(ctx, "SAVE", dapTransformResult.getVoucherCollection());
                            this.trace.log("*****after Voucher handleAfterTransform*****");
                            this.trace.log(new TraceParamInfo(new Object[]{dapTransformResult.getVoucherCollection()}));
                            this.trace.endSub();
                            this.trace.newSub("saveVoucher");
                            this._save(ctx, (IObjectCollection)((CoreBillBaseCollection)sourceBillCollection), dapTransformResult);
                            this.trace.endSub();
                            break block20;
                        }
                        if (mappingInfo.getIsTempSave() == 0) {
                            this.trace.newSub("handleAfterTransform");
                            this.handleAfterTransform(ctx, "SUBMIT", dapTransformResult.getVoucherCollection());
                            this.trace.log("*****after Voucher handleAfterTransform*****");
                            this.trace.log(new TraceParamInfo(new Object[]{dapTransformResult.getVoucherCollection()}));
                            this.trace.endSub();
                            this.trace.newSub("saveVoucher");
                            this._save(ctx, (IObjectCollection)((CoreBillBaseCollection)sourceBillCollection), dapTransformResult);
                            this.trace.endSub();
                        } else {
                            this.trace.newSub("handleAfterTransform");
                            if (dapTransformResult != null) {
                                this.handleAfterTransform(ctx, "NOTSAVE", dapTransformResult.getVoucherCollection());
                                this.trace.log("*****after Voucher handleAfterTransform*****");
                                this.trace.log(new TraceParamInfo(new Object[]{dapTransformResult.getVoucherCollection()}));
                                this.trace.endSub();
                                this.trace.newSub("takeAttachmentOnRelation");
                                DAPTransformUtils.takeAttachmentOnRelations(ctx, (IObjectCollection)dapTransformResult.getRelationCollection());
                            }
                            this.trace.endSub();
                        }
                    }
                    catch (BOSException e) {
                        this.trace.error((Throwable)e);
                        throw e;
                    }
                    catch (EASBizException e) {
                        this.trace.error((Throwable)e);
                        throw e;
                    }
                    finally {
                        this.trace.end();
                    }
                }
                if (BOTPTools.isEnableDAPCrossSystem((Context)ctx)) {
                    this.saveRelation4CrossSystem(ctx, dapTransformResult.getRelationCollection());
                }
                dAPTransformResult = dapTransformResult;
                if (idList.size() <= 0) break block21;
            }
            catch (BOSException e) {
                try {
                    this.trace.error((Throwable)e);
                    throw e;
                    catch (EASBizException e2) {
                        this.trace.error((Throwable)e2);
                        throw e2;
                    }
                    catch (Exception e3) {
                        logger.error((Object)"fail to transform bill", (Throwable)e3);
                        throw new BOSException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (idList.size() > 0) {
                        BTPManagerFactory.getLocalInstance((Context)ctx).releaseMutexAndDBLock(idList);
                    }
                    Thread thread = Thread.currentThread();
                    String name = thread.getId() + "_" + thread.getName();
                    String mappingName = mappingInfo.getName();
                    if (name.equals(BotpTraceObject.getLoggerLocal().get())) {
                        new Thread(new Runnable(name, mappingName){
                            final /* synthetic */ String val$name;
                            final /* synthetic */ String val$mappingName;
                            {
                                this.val$name = string;
                                this.val$mappingName = string2;
                            }

                            @Override
                            public void run() {
                                String tempInstanceHome = System.getProperty(BOTPDBlockTools.EAS_INSTANCE_HOME);
                                String sourceFolder = (tempInstanceHome + "/logs/botpTrace").replace("/", File.separator);
                                String tarGzPath = (tempInstanceHome + "/logs/botpTraceTar").replace("/", File.separator);
                                GzCompressionUtils.compress((String)sourceFolder, (String)tarGzPath, (String)this.val$name, (String)this.val$mappingName);
                            }
                        }).start();
                    }
                    BotpTraceObject.getLoggerLocal().remove();
                    throw throwable;
                }
            }
            BTPManagerFactory.getLocalInstance((Context)ctx).releaseMutexAndDBLock(idList);
        }
        Thread thread = Thread.currentThread();
        String name = thread.getId() + "_" + thread.getName();
        String mappingName = mappingInfo.getName();
        if (name.equals(BotpTraceObject.getLoggerLocal().get())) {
            new Thread(new /* invalid duplicate definition of identical inner class */).start();
        }
        BotpTraceObject.getLoggerLocal().remove();
        return dAPTransformResult;
    }

    @Override
    protected List _transform(Context ctx, List sourceBillColList, DAPVoucherTypeEnum voucherType, IObjectPK[] botMappingPKList) throws BOSException, EASBizException {
        List idList = new ArrayList();
        try {
            idList = this.requestMutex(ctx, sourceBillColList);
            ArrayList<DAPTransformResult> resultList = new ArrayList<DAPTransformResult>();
            boolean isSave = false;
            for (int i = 0; i < botMappingPKList.length; ++i) {
                BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(botMappingPKList[i], ctx);
                DAPTransformResult dapTransformResult = null;
                dapTransformResult = this._transformForBotp(ctx, (IObjectCollection)sourceBillColList.get(i), voucherType, botMappingPKList[i]);
                resultList.add(dapTransformResult);
                if (mappingInfo.getIsTempSave() == 1 || mappingInfo.getIsTempSave() == 2) {
                    this.trace.newSub("handleAfterTransform");
                    this.handleAfterTransform(ctx, "SAVE", dapTransformResult.getVoucherCollection());
                    this.trace.endSub();
                    this.trace.newSub("saveVoucher");
                    isSave = true;
                    this.trace.endSub();
                    this.trace.newSub("takeAttachmentOnRelation");
                    this.trace.endSub();
                    continue;
                }
                if (mappingInfo.getIsTempSave() == 0) {
                    this.trace.newSub("handleAfterTransform");
                    this.handleAfterTransform(ctx, "SUBMIT", dapTransformResult.getVoucherCollection());
                    this.trace.endSub();
                    this.trace.newSub("saveVoucher");
                    isSave = true;
                    this.trace.endSub();
                    this.trace.newSub("takeAttachmentOnRelation");
                    this.trace.endSub();
                    continue;
                }
                this.trace.newSub("handleAfterTransform");
                if (dapTransformResult != null) {
                    this.handleAfterTransform(ctx, "NOTSAVE", dapTransformResult.getVoucherCollection());
                    this.trace.endSub();
                    this.trace.newSub("takeAttachmentOnRelation");
                    DAPTransformUtils.takeAttachmentOnRelations(ctx, (IObjectCollection)dapTransformResult.getRelationCollection());
                }
                this.trace.endSub();
            }
            if (isSave) {
                this._save(ctx, (IObjectCollection)sourceBillColList.get(0), resultList);
            }
            ArrayList<DAPTransformResult> arrayList = resultList;
            return arrayList;
        }
        catch (BOSException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"fail to transform bill.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (idList.size() > 0) {
                BTPManagerFactory.getLocalInstance((Context)ctx).releaseMutexAndDBLock(idList);
            }
        }
    }

    @Override
    protected DAPTransformResult _transformForPreview(Context ctx, IObjectCollection sourceBillCollection, DAPVoucherTypeEnum voucherType, IObjectPK botMappingPK) throws BOSException, EASBizException {
        BOTMappingInfo mappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(botMappingPK, ctx);
        DAPTransformResult dapTransformResult = null;
        dapTransformResult = this._transformForBotp(ctx, sourceBillCollection, voucherType, botMappingPK);
        LowTimer t = new LowTimer();
        t.reset();
        try {
            this.trace.start("DAP AfterTransform");
            if (mappingInfo.getIsTempSave() == 1 || mappingInfo.getIsTempSave() == 2) {
                this.trace.newSub("handleAfterTransform");
                this.handleAfterTransform(ctx, "SAVE", dapTransformResult.getVoucherCollection());
                this.trace.endSub();
                this.trace.newSub("saveVoucher");
                this._preview(ctx, (IObjectCollection)((CoreBillBaseCollection)sourceBillCollection), dapTransformResult);
                this.trace.endSub();
                this.trace.newSub("takeAttachmentOnRelation");
                this.trace.endSub();
            } else if (mappingInfo.getIsTempSave() == 0) {
                this.trace.newSub("handleAfterTransform");
                this.handleAfterTransform(ctx, "SUBMIT", dapTransformResult.getVoucherCollection());
                this.trace.endSub();
                this.trace.newSub("saveVoucher");
                this._preview(ctx, (IObjectCollection)((CoreBillBaseCollection)sourceBillCollection), dapTransformResult);
                this.trace.endSub();
                this.trace.newSub("takeAttachmentOnRelation");
                this.trace.endSub();
            } else {
                this.trace.newSub("handleAfterTransform");
                if (dapTransformResult != null) {
                    this.handleAfterTransform(ctx, "NOTSAVE", dapTransformResult.getVoucherCollection());
                    this.trace.endSub();
                    this.trace.newSub("takeAttachmentOnRelation");
                    DAPTransformUtils.takeAttachmentOnRelations(ctx, (IObjectCollection)dapTransformResult.getRelationCollection());
                }
                this.trace.endSub();
            }
            DAPTransformResult dAPTransformResult = dapTransformResult;
            return dAPTransformResult;
        }
        catch (BOSException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            this.trace.error((Throwable)e);
            throw e;
        }
        finally {
            this.trace.end();
        }
    }

    @Override
    protected DAPTransformResult _generateVoucher(Context ctx, List srcBillColList, DAPVoucherTypeEnum fiType, List botMappingPks) throws BOSException, EASBizException {
        for (int i = 0; i < srcBillColList.size(); ++i) {
            boolean needReGetBill = false;
            if (!needReGetBill && !(srcBillColList.get(i) instanceof CoreBillBaseCollection)) continue;
            needReGetBill = true;
            CoreBillBaseCollection currentBillList = (CoreBillBaseCollection)srcBillColList.get(i);
            IObjectPK[] sourceBillPkList = new IObjectPK[currentBillList.size()];
            String srcBillType = "";
            for (int j = 0; j < currentBillList.size(); ++j) {
                CoreBillBaseInfo billInfo = currentBillList.get(j);
                BOSUuid billId = billInfo.getId();
                if (StringUtils.isEmpty((String)srcBillType)) {
                    srcBillType = billInfo.getBOSType().toString();
                }
                sourceBillPkList[j] = new ObjectUuidPK(billId);
            }
            srcBillColList.set(i, this.innerGetSrcBillCollection(ctx, srcBillType, sourceBillPkList, null));
        }
        IDAPInnerTransformer inner = DAPTransformUtils.getInnerTransformer(ctx, fiType);
        DAPTransformResult result = this._transformForBotp(ctx, srcBillColList, fiType, botMappingPks);
        if (!this.saveCheck(ctx, srcBillColList, result)) {
            return null;
        }
        inner.save(ctx, srcBillColList, result);
        return result;
    }

    @Override
    protected DAPTransformResult _innerTransform(Context ctx, List srcBillColsList, DAPVoucherTypeEnum voucherEnum, List botMappingPkList) throws BOSException, DAPException, EASBizException {
        DAPTransformResult result = new DAPTransformResult();
        if (srcBillColsList.size() == botMappingPkList.size()) {
            ArrayList<CoreBillBaseCollection> filteredSrcBillColsListForTrans = new ArrayList<CoreBillBaseCollection>();
            BOTMappingCollection botMappingCols = new BOTMappingCollection();
            boolean needLog = BotpUtils.needLog((Context)ctx);
            StringBuffer sb = new StringBuffer(new Date().toString());
            sb.append("\tDAP transform begin...\n");
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            IDAPInnerTransformer inner = DAPTransformUtils.getInnerTransformer(ctx, voucherEnum);
            int count = srcBillColsList.size();
            for (int i = 0; i < count; ++i) {
                String dataFilter;
                IObjectCollection currentSrcBillCols = (IObjectCollection)srcBillColsList.get(i);
                if (needLog) {
                    int n = currentSrcBillCols.size();
                    for (int j = 0; j < n; ++j) {
                        sb.append(currentSrcBillCols.getObject(j)).append("\n");
                    }
                }
                ObjectUuidPK botMappingPK = new ObjectUuidPK(botMappingPkList.get(i).toString());
                BOTMappingInfo botMappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo((IObjectPK)botMappingPK, ctx);
                if (botMappingInfo == null) {
                    throw new DAPException(DAPException.BOTMAPPINGISNULL);
                }
                MappingUtil.initMappingEntity((BOTMappingInfo)botMappingInfo, (IMetaDataLoader)loader);
                botMappingCols.add(botMappingInfo);
                if (needLog) {
                    sb.append(botMappingInfo.toXml()).append("\n");
                }
                CoreBillBaseCollection currentFilteredSrcCollection = new CoreBillBaseCollection();
                currentFilteredSrcCollection.addObjectCollection(currentSrcBillCols);
                DAPAppTools.execDataFilterMultiEntry(ctx, currentFilteredSrcCollection, botMappingInfo);
                currentSrcBillCols.clear();
                currentSrcBillCols.addObjectCollection((IObjectCollection)currentFilteredSrcCollection);
                if (needLog && (dataFilter = botMappingInfo.getExtRule().getDataFilter()) != null) {
                    sb.append("Data Filter:" + botMappingInfo.getExtRule().getDataFilter().toString()).append("\n");
                    sb.append("Execute filter success!").append("\n\n");
                }
                if (count == 1 && currentFilteredSrcCollection.size() == 0) {
                    throw new BTPException(BTPException.SRCBILLCOLSIZEISZERO, new Object[]{botMappingInfo.getSrcEntityAlias()});
                }
                filteredSrcBillColsListForTrans.add(currentFilteredSrcCollection);
            }
            if (needLog) {
                BotpUtils.createUserBOTPLog((Context)ctx, (String)sb.toString(), (boolean)true);
            }
            if (botMappingCols.size() > 1) {
                DAPTransformUtils.adjustGroupAndAggregate(botMappingCols);
            }
            try {
                String destBillBosTypeStr = "";
                destBillBosTypeStr = DAPVoucherTypeEnum.PCVoucher.equals((Object)voucherEnum) ? "D6952559" : "2652E01E";
                for (int i = 0; i < filteredSrcBillColsListForTrans.size(); ++i) {
                    CoreBillBaseCollection billCol = (CoreBillBaseCollection)filteredSrcBillColsListForTrans.get(i);
                    BOTMappingInfo mappingInfo = botMappingCols.get(i);
                    if (mappingInfo == null || billCol.size() == 0) continue;
                    BOSObjectType bostype = billCol.get(0).getId().getType();
                    CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)bostype);
                    boolean needCheckRebuild4DAP = controller.needCheckRebuild4DAP(ctx);
                    logger.error((Object)("DAPTest: needCheckRebuild4DAP" + needCheckRebuild4DAP));
                    if (!needCheckRebuild4DAP) continue;
                    controller.rebuildCheck4DAP(ctx, billCol, destBillBosTypeStr, (IObjectPK)new ObjectUuidPK(mappingInfo.getId()));
                }
                result = inner.transform(ctx, filteredSrcBillColsListForTrans, botMappingCols);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            if (needLog) {
                BotpUtils.createUserBOTPLog((Context)ctx, (DAPTransformResult)result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List requestMutex(Context ctx, List filteredSrcBillColsListForTrans) throws BOSException {
        BOTPConfigInfo botpConfigInfo = BOTPConfigInfo.getConfigInstance();
        boolean isUseMutex = botpConfigInfo.isUseMutex();
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList<String> idList = new ArrayList<String>();
        boolean flag = false;
        int errorFlag = 0;
        String errorMsg = "";
        IMetaDataLoader loader = null;
        Class<DAPTransformerControllerBean> clazz = DAPTransformerControllerBean.class;
        synchronized (DAPTransformerControllerBean.class) {
            for (int i = 0; i < filteredSrcBillColsListForTrans.size(); ++i) {
                CoreBillBaseCollection srcBillBaseCollection = (CoreBillBaseCollection)filteredSrcBillColsListForTrans.get(i);
                for (int j = 0; j < srcBillBaseCollection.size(); ++j) {
                    String srcID = ((CoreBillBaseInfo)srcBillBaseCollection.getObject(j)).getId().toString();
                    srcID = srcID + "/DAP";
                    if (isUseMutex) {
                        try {
                            flag = mutexService.requestObjIDForUpdate(srcID);
                            if (!flag) {
                                errorFlag = 1;
                                logger.error((Object)"error to request Mutex Lock.");
                            }
                        }
                        catch (Exception e) {
                            mutexService.releaseObjIDForUpdate(srcID);
                            logger.error((Object)e);
                        }
                    } else {
                        flag = true;
                        logger.error((Object)"disable Mutex Lock when transform DAP.");
                    }
                    if (flag && !idList.contains(srcID) && !(flag = this.requestDBLock(ctx, srcID))) {
                        errorFlag = 2;
                        logger.error((Object)"error to request DBLock.");
                        mutexService.releaseObjIDForUpdate(srcID);
                    }
                    if (flag && !idList.contains(srcID) && botpConfigInfo.isLockSrcTable()) {
                        if (loader == null) {
                            loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
                        }
                        if (!(flag = BOTPDBlockTools.getInstance().requestDBLockOnSrcTable(ctx, loader, srcID))) {
                            errorFlag = 3;
                            logger.error((Object)"error to request DBLock on Src Table.");
                            mutexService.releaseObjIDForUpdate(srcID);
                        }
                    }
                    if (!flag) {
                        String billNumber = ((CoreBillBaseInfo)srcBillBaseCollection.getObject(j)).getId().toString();
                        if (idList != null && idList.size() != 0) {
                            BTPManagerFactory.getLocalInstance((Context)ctx).releaseMutexAndDBLock(idList);
                        }
                        if (1 == errorFlag) {
                            errorMsg = EASResource.getString((String)btpResName, (String)"mutexLockError") + "\n" + srcID + ctx.getAIS();
                        } else if (2 == errorFlag) {
                            errorMsg = EASResource.getString((String)btpResName, (String)"DBLockError") + "\n" + srcID;
                        } else if (3 == errorFlag) {
                            errorMsg = EASResource.getString((String)btpResName, (String)"srcTableDBLock") + "\n" + srcID;
                        }
                        logger.error((Object)errorMsg);
                        throw new BOSException(errorMsg);
                    }
                    idList.add(srcID);
                }
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            return idList;
        }
    }

    @Override
    protected DAPTransformResult _transformForBotp(Context ctx, IObjectCollection srcBillCols, DAPVoucherTypeEnum voucherEnum, IObjectPK botMappingId) throws BOSException, EASBizException {
        ArrayList<IObjectCollection> srcBillColsList = new ArrayList<IObjectCollection>();
        srcBillColsList.add(srcBillCols);
        ArrayList<IObjectPK> botMappingIdList = new ArrayList<IObjectPK>();
        botMappingIdList.add(botMappingId);
        BOTMappingInfo botMappingInfo = MappingCache.getInstance((Context)ctx).getMappingInfo(botMappingId, ctx);
        String destEntity = botMappingInfo.getDestEntityName();
        if ("2652E01E".equals(destEntity)) {
            voucherEnum = DAPVoucherTypeEnum.FIVoucher;
        } else if ("D6952559".equals(destEntity)) {
            voucherEnum = DAPVoucherTypeEnum.PCVoucher;
        }
        return this._innerTransform(ctx, srcBillColsList, voucherEnum, botMappingIdList);
    }

    @Override
    protected DAPTransformResult _transformForBotp(Context ctx, List srcBillColsList, DAPVoucherTypeEnum voucherEnum, List botMappingPkList) throws BOSException, EASBizException {
        return this._innerTransform(ctx, srcBillColsList, voucherEnum, botMappingPkList);
    }

    @Override
    public DAPTransformResult _generateVoucherForOrg(Context ctx, String srcBillType, IObjectPK[] sourceBillPkList, SelectorItemCollection botpSelectors, IObjectPK[] botMappingPkList) throws BOSException, EASBizException {
        if (botMappingPkList == null || botMappingPkList.length <= 0 || sourceBillPkList == null || sourceBillPkList.length <= 0) {
            return null;
        }
        ArrayList<String> mappingIDList = new ArrayList<String>(botMappingPkList.length);
        int n = botMappingPkList.length;
        for (int i = 0; i < n; ++i) {
            mappingIDList.add(((ObjectUuidPK)botMappingPkList[i]).getKeyValue().toString());
        }
        BOTMappingCollection botMappings = BOTMappingHelper.getBOTMappingCollection((Context)ctx, mappingIDList);
        this.checkExistVoucherForOrg(ctx, sourceBillPkList, botMappings);
        CoreBillBaseCollection sourceBillCollection = this.innerGetSrcBillCollection(ctx, srcBillType, sourceBillPkList, botpSelectors);
        return this.innerGenerateVoucherForOrg(ctx, sourceBillCollection, botMappings);
    }

    protected void checkExistVoucherForOrg(Context ctx, IObjectPK[] sourceBillPkList, BOTMappingCollection botMappings) throws BOSException, EASBizException {
        ArrayList<String> sourceBillIDList = new ArrayList<String>(sourceBillPkList.length);
        int n = sourceBillPkList.length;
        for (int i = 0; i < n; ++i) {
            sourceBillIDList.add(((ObjectUuidPK)sourceBillPkList[i]).getKeyValue().toString());
        }
        DAPVoucherTypeEnum voucherType = DAPVoucherTypeEnum.FIVoucher;
        DAPUtils.checkVoucherExist(ctx, sourceBillIDList, botMappings, voucherType.toString());
    }

    protected CoreBillBaseCollection innerGetSrcBillCollection(Context ctx, String srcBillType, IObjectPK[] sourceBillPkList, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer();
        String strIdLists = StringUtils.arrayToString((Object[])sourceBillPkList, (String)",");
        sbMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        filterInfo.setMaskString(sbMaskString.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        if (botpSelectors != null) {
            entityViewInfo.put("selector", (Object)botpSelectors);
        }
        CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
        CoreBillBaseCollection sourceBillCollection = null;
        try {
            sourceBillCollection = controller.getCoreBillBaseCollection(ctx, entityViewInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sourceBillCollection;
    }

    protected DAPTransformResult innerGenerateVoucherForOrg(Context ctx, CoreBillBaseCollection sourceBillCollection, BOTMappingCollection botMappings) throws BOSException, EASBizException {
        ArrayList<DAPTransformResult> returnResult = new ArrayList<DAPTransformResult>();
        for (int i = 0; i < botMappings.size(); ++i) {
            BOTMappingInfo mappingInfo = botMappings.get(i);
            ObjectUuidPK botMappingPK = new ObjectUuidPK(mappingInfo.getId().toString());
            DAPTransformResult dapTransformResult = null;
            dapTransformResult = this._transformForBotp(ctx, (IObjectCollection)sourceBillCollection, DAPVoucherTypeEnum.FIVoucher, (IObjectPK)botMappingPK);
            if (mappingInfo.getIsTempSave() == 1) {
                this.handleAfterTransform(ctx, "SAVE", dapTransformResult.getVoucherCollection());
                this._save(ctx, (IObjectCollection)sourceBillCollection, dapTransformResult);
                continue;
            }
            if (mappingInfo.getIsTempSave() == 0) {
                this.handleAfterTransform(ctx, "SUBMIT", dapTransformResult.getVoucherCollection());
                this._save(ctx, (IObjectCollection)sourceBillCollection, dapTransformResult);
                continue;
            }
            if (dapTransformResult != null) {
                this.handleAfterTransform(ctx, "NOTSAVE", dapTransformResult.getVoucherCollection());
                DAPTransformUtils.takeAttachmentOnRelations(ctx, (IObjectCollection)dapTransformResult.getRelationCollection());
            }
            returnResult.add(dapTransformResult);
        }
        if (returnResult.size() == 0) {
            return null;
        }
        DAPTransformResult dapTransformResult = new DAPTransformResult();
        CoreBillBaseCollection vouchers = new CoreBillBaseCollection();
        BOTRelationCollection relations = new BOTRelationCollection();
        DAPVoucherTypeEnum voucherType = null;
        for (int m = 0; m < returnResult.size(); ++m) {
            DAPTransformResult temp = (DAPTransformResult)returnResult.get(m);
            voucherType = temp.getVoucherType();
            IObjectCollection voucherCol = temp.getVoucherCollection();
            for (int k = 0; k < voucherCol.size(); ++k) {
                vouchers.add((CoreBillBaseInfo)voucherCol.getObject(k));
            }
            BOTRelationCollection relationCol = temp.getRelationCollection();
            for (int l = 0; l < relationCol.size(); ++l) {
                relations.add(relationCol.get(l));
            }
        }
        dapTransformResult.setVoucherCollection((IObjectCollection)vouchers);
        dapTransformResult.setRelationCollection(relations);
        dapTransformResult.setVoucherType(voucherType);
        return dapTransformResult;
    }

    @Override
    protected boolean _isHaveVoucher(Context ctx, String srcBillId, String companyOrgId) throws BOSException {
        return AbstractDAPVoucherStrategy.getInstanceof("fi")._isHaveVoucher(ctx, srcBillId, companyOrgId);
    }

    @Override
    protected boolean _isCanVoucher(Context ctx, String sourceBillType) throws BOSException, BOTPException {
        return BOTMappingHelper.isCanVoucher((Context)ctx, (String)sourceBillType);
    }

    @Override
    protected void _transformerAutoToFIVoucher(Context ctx, String mappingId) throws EASBizException, BOSException {
        BOTMappingInfo botMappingInfo = (BOTMappingInfo)this._getMappingInfoByPK(ctx, (IObjectPK)new ObjectUuidPK(mappingId));
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        MappingUtil.initMappingEntity((BOTMappingInfo)botMappingInfo, (IMetaDataLoader)loader);
        if (botMappingInfo.getDefineSys().equals((Object)DefineSysEnum.DAP)) {
            EntityViewInfo evi = null;
            try {
                evi = this.getEviByBotMappingInfo(botMappingInfo);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new BOSException((Throwable)e);
            }
            CoreBillBaseCollection srcBillCols = this.getSrcBillCollection(ctx, botMappingInfo, evi);
            if (srcBillCols != null && srcBillCols.size() > 1) {
                IDAPTransformer dap = DAPTransformerFactory.getLocalInstance(ctx);
                dap.generateVoucher(srcBillCols, DAPVoucherTypeEnum.FIVoucher, (IObjectPK)new ObjectUuidPK(mappingId));
            }
        }
    }

    @Override
    protected IObjectCollection _getDAPMappingsForSelectUseRuleFilter(Context ctx, String srcBillType, String targetBosType, DefineSysEnum defineSys, Map transmitContext, String[] idList) throws BOSException, BOTPException {
        BOTMappingInfo info;
        BOTMappingCollection botMappingCols = BOTMappingHelper.getMappingForSelect((Context)ctx, (String)srcBillType, (String)targetBosType, (DefineSysEnum)defineSys, (Map)transmitContext);
        if (botMappingCols.size() == 0) {
            return botMappingCols;
        }
        CoreBillBaseCollection bills = null;
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer();
        String strIdLists = BOTMappingHelper.objectArray2String((Object[])idList, (String)",");
        sbMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        filterInfo.setMaskString(sbMaskString.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
        try {
            bills = controller.getCoreBillBaseCollection(ctx, entityViewInfo);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        BOTMappingCollection errMappingCols = new BOTMappingCollection();
        for (int i = 0; i < botMappingCols.size(); ++i) {
            info = botMappingCols.get(i);
            if (!this.isErrorMapping(ctx, bills, info)) continue;
            errMappingCols.add(info);
        }
        for (int j = 0; j < errMappingCols.size(); ++j) {
            info = errMappingCols.get(j);
            botMappingCols.removeObject((IObjectValue)info);
        }
        return botMappingCols;
    }

    protected boolean isErrorMapping(Context ctx, CoreBillBaseCollection sourceBillCollection, BOTMappingInfo mappingInfo) throws BOSException {
        Map result = this.getRuleFilter((IObjectCollection)sourceBillCollection, mappingInfo);
        if (result.isEmpty()) {
            return false;
        }
        EntityViewInfo evi = (EntityViewInfo)result.get("EntityViewInfo");
        CoreBillBaseCollection filteredCols = this.getSrcBillCollection(ctx, sourceBillCollection.get(0).getBOSType().toString(), evi);
        return this.isErrorMapping((IObjectCollection)sourceBillCollection, (IObjectCollection)filteredCols, result);
    }

    private Map getRuleFilter(IObjectCollection sourceBillCollection, BOTMappingInfo mappingInfo) throws BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean hasEntryFilter = false;
        EntityViewInfo evi = this.getBOTMappingFilter(mappingInfo);
        evi.getSelector().add("id");
        FilterInfo filterInfo = evi.getFilter();
        if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
            int count = evi.getEntryFilters().size();
            for (int i = 0; i < count; ++i) {
                FilterInfo entryFilter = evi.getEntryFilters().get(i);
                String entryName = entryFilter.getEntryName();
                evi.getSelector().add(entryName + ".id");
            }
        }
        if (!(filterInfo != null && filterInfo.getFilterItems().size() != 0 || evi.getEntryFilters() != null && evi.getEntryFilters().size() != 0)) {
            return new HashMap();
        }
        ArrayList<Object> billIdList = new ArrayList<Object>();
        int count = sourceBillCollection.size();
        for (int i = 0; i < count; ++i) {
            billIdList.add(sourceBillCollection.getObject(i).get("id"));
        }
        FilterInfo newHeadFilterInfo = this.mergeFilterWithIdList(billIdList, filterInfo);
        if (filterInfo == null) {
            filterInfo = newHeadFilterInfo;
            evi.setFilter(filterInfo);
        }
        if (hasEntryFilter) {
            int es = evi.getEntryFilters().size();
            for (int e = 0; e < es; ++e) {
                FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                String entryName = entryFilterInfo.getEntryName();
                ArrayList<Object> entryIdList = new ArrayList<Object>();
                int count2 = sourceBillCollection.size();
                for (int i = 0; i < count2; ++i) {
                    IObjectValue srcBillInfo = sourceBillCollection.getObject(i);
                    if (srcBillInfo.get(entryName) == null || !(srcBillInfo.get(entryName) instanceof IObjectCollection)) continue;
                    IObjectCollection entryCols = (IObjectCollection)srcBillInfo.get(entryName);
                    int entryCount = entryCols.size();
                    for (int j = 0; j < entryCount; ++j) {
                        entryIdList.add(entryCols.getObject(j).get("id"));
                    }
                }
                this.mergeFilterWithIdList(entryIdList, entryFilterInfo);
            }
        }
        result.put("hasEntryFilter", hasEntryFilter);
        result.put("EntityViewInfo", (Boolean)evi);
        return result;
    }

    private CoreBillBaseCollection getSrcBillCollection(Context ctx, BOTMappingInfo botMappingInfo, EntityViewInfo evi) throws BOSException {
        CoreBillBaseCollection srcBillCols = new CoreBillBaseCollection();
        IDynamicObject iDyn = DynamicObjectFactory.getLocalInstance((Context)ctx);
        BOSObjectType bosObjectType = botMappingInfo.getSrcEntity().getBOSType();
        IObjectCollection dynCols = evi == null ? iDyn.getCollection(bosObjectType) : iDyn.getCollection(bosObjectType, evi);
        for (CoreBillBaseInfo billInfo : dynCols) {
            srcBillCols.add(billInfo);
        }
        return srcBillCols;
    }

    protected CoreBillBaseCollection getSrcBillCollection(Context ctx, String srcBillType, EntityViewInfo evi) throws BOSException {
        CoreBillBaseCollection sourceBillCollection;
        CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
        try {
            sourceBillCollection = controller.getCoreBillBaseCollection(ctx, evi);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return sourceBillCollection;
    }

    protected boolean isErrorMapping(IObjectCollection sourceBillCollection, IObjectCollection filteredColsTMP, Map result) {
        if (result.isEmpty()) {
            return false;
        }
        boolean hasEntryFilter = (Boolean)result.get("hasEntryFilter");
        EntityViewInfo evi = (EntityViewInfo)result.get("EntityViewInfo");
        ArrayList<CoreBillBaseInfo> errorBillCollection = new ArrayList<CoreBillBaseInfo>();
        IObjectCollection filteredCols = filteredColsTMP;
        ArrayList<String> filteredIdList = new ArrayList<String>();
        int count = filteredCols.size();
        for (int i = 0; i < count; ++i) {
            IObjectValue filteredInfo = filteredCols.getObject(i);
            boolean flag = true;
            if (hasEntryFilter) {
                int es = evi.getEntryFilters().size();
                for (int e = 0; e < es; ++e) {
                    FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                    String entryName = entryFilterInfo.getEntryName();
                    if (filteredInfo.get(entryName) != null && filteredInfo.get(entryName) instanceof IObjectCollection && ((IObjectCollection)filteredInfo.get(entryName)).size() > 0) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                filteredIdList.add(filteredInfo.get("id").toString());
                continue;
            }
            filteredIdList.add(filteredInfo.get("id").toString());
        }
        HashMap pkListMap = new HashMap();
        for (int i = 0; i < filteredIdList.size(); ++i) {
            pkListMap.put(filteredIdList.get(i), null);
        }
        for (CoreBillBaseInfo sourceBillInfo : sourceBillCollection) {
            if (pkListMap.containsKey(sourceBillInfo.getId().toString())) continue;
            errorBillCollection.add(sourceBillInfo);
        }
        return errorBillCollection.size() > 0;
    }

    private EntityViewInfo getEviByBotMappingInfo(BOTMappingInfo botMappingInfo) throws ParserException, BOSException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        EntityViewInfo evi;
        if (botMappingInfo.getExtRule().getFilter() != null) {
            evi = BOTPTools.getEntityViewInfoFromMapping((BOTMappingInfo)botMappingInfo, (int)0);
        } else {
            evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
        }
        FilterInfo otherFilter = new FilterInfo();
        otherFilter.getFilterItems().add(new FilterItemInfo("CU", (Object)botMappingInfo.getCU().getId().toString()));
        otherFilter.getFilterItems().add(new FilterItemInfo(VOUCHERFLAG, (Object)false));
        otherFilter.setMaskString("#0 and #1");
        if (evi.getFilter().size() > 0) {
            evi.getFilter().mergeFilter(otherFilter, "AND");
        } else {
            evi.setFilter(otherFilter);
        }
        EntityObjectInfo srcEntity = botMappingInfo.getSrcEntity();
        String f7ListUIName = srcEntity.getExtendedProperty("listUI");
        if (f7ListUIName != null && f7ListUIName.length() > 0) {
            SelectorItemCollection sic = null;
            try {
                sic = BotpHelper.getBOTPSelectors((BOTMappingInfo)botMappingInfo);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            evi.put("selector", (Object)sic);
        }
        return evi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectValue _getMappingInfoByPK(Context ctx, IObjectPK botMappingPK) throws BOSException {
        Connection conn = null;
        BOTMappingInfo mappingInfo = null;
        if (botMappingPK != null) {
            try {
                conn = this.getConnection(ctx);
                IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)new DAPTransformerControllerBean().getBOSType(), (Context)ctx, (Connection)conn);
                mappingInfo = (BOTMappingInfo)dao.getValue(botMappingPK);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return mappingInfo;
    }

    private EntityViewInfo getBOTMappingFilter(BOTMappingInfo mappingInfo) throws BOSException {
        EntityViewInfo entityViewInfo;
        if (StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter())) {
            entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            entityViewInfo.setFilter(filterInfo);
        } else {
            try {
                entityViewInfo = BOTPTools.getEntityViewInfoFromMapping((BOTMappingInfo)mappingInfo, (int)0);
            }
            catch (BOSException exc) {
                throw new BOSException(exc.getMessage(), (Throwable)exc);
            }
        }
        return entityViewInfo;
    }

    private FilterInfo mergeFilterWithIdList(List idList, FilterInfo filterInfo) {
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            Iterator iterFilter = filterInfo.getFilterItems().iterator();
            while (iterFilter.hasNext()) {
                if (index != 0) {
                    sbMaskString.append(" and ");
                }
                iterFilter.next();
                sbMaskString.append("#" + String.valueOf(index));
                ++index;
            }
            filterInfo.setMaskString(sbMaskString.toString());
        }
        StringBuffer sbNewMaskString = new StringBuffer();
        index = 0;
        String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
        sbNewMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            filterInfo.setMaskString(sbNewMaskString.toString());
        } else {
            filterInfo.setMaskString("(" + filterInfo.getMaskString() + ") and (" + sbNewMaskString.toString() + ")");
        }
        return filterInfo;
    }

    @Override
    protected List _getDestVoucherInfoListFullOrg(Context ctx, List srcIDList) throws BOSException, EASBizException {
        ArrayList<DAPVoucherOrgInfo> result = new ArrayList<DAPVoucherOrgInfo>();
        String strIdList = DAPCommonUtils.idListToString(srcIDList, ",");
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String sql = AbstractDAPVoucherStrategy.getInstanceof("fi").getDestVoucherInfoListFullOrgSql(strIdList);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[0]);
            while (rs.next()) {
                String voucherID = rs.getString("FID");
                if (map.containsKey(voucherID)) continue;
                DAPVoucherOrgInfo info = new DAPVoucherOrgInfo();
                info.setId(voucherID);
                info.setNumber(rs.getString("FNumber"));
                info.setPeriod(rs.getString("Period"));
                info.setOrg(rs.getString("ORG"));
                result.add(info);
                map.put(voucherID, voucherID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public void _removeVoucherRelationOrg(Context ctx, List vouhcherIDList, DAPVoucherTypeEnum voucherType) throws BOSException, EASBizException {
        IDAPInnerTransformer inner = DAPTransformUtils.getInnerTransformer(ctx, voucherType);
        inner.removeVoucherRelationOrg(ctx, vouhcherIDList);
    }

    @Override
    protected boolean _isExistVoucherOrg(Context ctx, List orgIDList, String voucherBosType, List srcBillIDList) throws BOSException, BOTPException, EASBizException {
        return DAPUtils.isExistVoucherOrg(ctx, orgIDList, voucherBosType, srcBillIDList);
    }

    @Override
    protected void _save(Context ctx, IObjectCollection sourceBillCollection, DAPTransformResult result) throws BOSException, EASBizException {
        DAPTransformUtils.save(ctx, sourceBillCollection, result, true);
    }

    @Override
    protected void _save(Context ctx, IObjectCollection sourceBillCollection, DAPTransformResult result, boolean isCheckPermission) throws BOSException, EASBizException {
        DAPTransformUtils.save(ctx, sourceBillCollection, result, isCheckPermission);
    }

    protected void _preview(Context ctx, IObjectCollection sourceBillCollection, DAPTransformResult result) throws BOSException, EASBizException {
        DAPTransformUtils.preview(ctx, sourceBillCollection, result);
    }

    @Override
    protected void _save(Context ctx, IObjectCollection sourceBillCollection, List resultList) throws BOSException, EASBizException {
        DAPTransformUtils.save(ctx, sourceBillCollection, resultList);
    }

    private void saveRelation4CrossSystem(Context ctx, BOTRelationCollection botRelationCollection) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            Iterator iter = botRelationCollection.iterator();
            int tmpRelationSize = 0;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            String sql = "insert into T_BOT_RELATION4CrossSys (FID,FSRCENTITYID,FDESTENTITYID,FSRCOBJECTID,FDESTOBJECTID,FDATE,FOPERATORID,FISEFFECTED,FBOTMAPPINGID,FTYPE) values (?,?,?,?,?,?,?,?,?,?)";
            while (iter.hasNext()) {
                BOTRelationInfo dapRelationInfo = (BOTRelationInfo)iter.next();
                Object[] params = new Object[]{dapRelationInfo.getId().toString(), dapRelationInfo.getSrcEntityID(), dapRelationInfo.getDestEntityID(), dapRelationInfo.getSrcObjectID(), dapRelationInfo.getDestObjectID(), dapRelationInfo.getDate(), dapRelationInfo.getOperatorID(), dapRelationInfo.isIsEffected(), dapRelationInfo.getBOTMappingID(), dapRelationInfo.getType()};
                paramList.add(params);
                tmpRelationSize = paramList.size();
                if (tmpRelationSize <= 2000) continue;
                DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
                paramList.clear();
                tmpRelationSize = 0;
            }
            if (tmpRelationSize != 0) {
                DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
                paramList.clear();
            }
        }
        catch (Exception e) {
            throw new DAPException(DAPException.RELATION_NOT_ADD, e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected DAPTransformResult _transformSQLE(Context ctx, IObjectPK[] srcBillIDList, DAPVoucherTypeEnum voucherType, IObjectPK botMappingPK, SelectorItemCollection selectors) throws BOSException, EASBizException {
        IBOTMapping iBOTMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo mappingInfo = iBOTMapping.getMappingInfoByPK(botMappingPK);
        return this._transformSQLE(ctx, srcBillIDList, voucherType, (IObjectValue)mappingInfo, selectors);
    }

    @Override
    protected DAPTransformResult _transformSQLE(Context ctx, IObjectPK[] srcBillIDList, DAPVoucherTypeEnum voucherType, IObjectValue botMappingInfo, SelectorItemCollection selectors) throws BOSException, EASBizException {
        return new DAPTransformSQLE().transformSQLE(ctx, srcBillIDList, voucherType, botMappingInfo, selectors);
    }

    @Override
    protected boolean _saveTransformResult4CrossSystem(Context ctx, DAPTransformResult dapTransformResult) throws BOSException {
        Iterator voucherColIter = dapTransformResult.getVoucherCollection().iterator();
        ArrayList<String> voucherIdList = new ArrayList<String>();
        while (voucherColIter.hasNext()) {
            String voucherId = ((VoucherInfo)voucherColIter.next()).getId().toString();
            voucherIdList.add(voucherId);
        }
        ArrayList<DAPTransformResult> invokeDatas = new ArrayList<DAPTransformResult>();
        invokeDatas.add(dapTransformResult);
        String resultStr = null;
        HashMap tempData = new HashMap();
        try {
            resultStr = BOTPTools.invokeMethod4CrossSys((Context)ctx, (String)"3D99EB01", (String)"saveTransformResult", (String)"111", voucherIdList, (boolean)true, (boolean)true, invokeDatas, tempData);
        }
        catch (BizException e) {
            logger.error((Object)"\u8de8\u7cfb\u7edf\u4fdd\u5b58\u5355\u636e\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38");
            e.printStackTrace();
            throw new BOSException("\u8de8\u7cfb\u7edf\u4fdd\u5b58\u5355\u636e\u53d1\u751f\u4e1a\u52a1\u5f02\u5e38" + (StringUtils.isEmpty((String)e.getMessage()) ? "" : "(" + e.getMessage() + ")"));
        }
        catch (LoginException e) {
            logger.error((Object)"\u8de8\u7cfb\u7edf\u4fdd\u5b58\u5355\u636e\u53d1\u751f\u767b\u5f55\u5f02\u5e38");
            e.printStackTrace();
            throw new BOSException("\u8de8\u7cfb\u7edf\u4fdd\u5b58\u5355\u636e\u53d1\u751f\u767b\u5f55\u5f02\u5e38" + (StringUtils.isEmpty((String)e.getMessage()) ? "" : "(" + e.getMessage() + ")"));
        }
        catch (InvokeNetworkException e) {
            logger.error((Object)"\u8de8\u7cfb\u7edf\u4fdd\u5b58\u5355\u636e\u53d1\u751f\u7f51\u7edc\u8d85\u65f6\u5f02\u5e38");
            e.printStackTrace();
            HashMap tempData2 = new HashMap();
            String makeUpResult = this.rollBackSaveTransformResult(ctx, dapTransformResult, tempData2);
            if (new Boolean(makeUpResult).booleanValue()) {
                throw new BOSException("\u8de8\u7cfb\u7edf\u4fdd\u5b58\u5355\u636e\u53d1\u751f\u7f51\u7edc\u8d85\u65f6\u5f02\u5e38\uff0c\u4f46\u8865\u507f\u5df2\u751f\u6548" + (StringUtils.isEmpty((String)e.getMessage()) ? "" : "(" + e.getMessage() + ")"));
            }
            throw new BOSException("\u8de8\u7cfb\u7edf\u4fdd\u5b58\u5355\u636e\u53d1\u751f\u7f51\u7edc\u8d85\u65f6\u5f02\u5e38\uff0c\u4e14\u8865\u507f\u5931\u6548\uff0c\u8bf7\u624b\u5de5\u5904\u7406" + (StringUtils.isEmpty((String)e.getMessage()) ? "" : "(" + e.getMessage() + ")"));
        }
        catch (Exception e) {
            logger.error((Object)"\u8de8\u7cfb\u7edf\u4fdd\u5b58\u5355\u636e\u53d1\u751f\u672a\u77e5\u5f02\u5e38");
            e.printStackTrace();
            HashMap tempData2 = new HashMap();
            String makeUpResult = this.rollBackSaveTransformResult(ctx, dapTransformResult, tempData2);
            if (new Boolean(makeUpResult).booleanValue()) {
                throw new BOSException("\u8de8\u7cfb\u7edf\u4fdd\u5b58\u5355\u636e\u53d1\u751f\u7f51\u7edc\u672a\u77e5\u5f02\u5e38\uff0c\u4f46\u8865\u507f\u5df2\u751f\u6548" + (StringUtils.isEmpty((String)e.getMessage()) ? "" : "(" + e.getMessage() + ")"));
            }
            throw new BOSException("\u8de8\u7cfb\u7edf\u4fdd\u5b58\u5355\u636e\u53d1\u751f\u7f51\u7edc\u672a\u77e5\u5f02\u5e38\uff0c,\u4e14\u8865\u507f\u5931\u6548\uff0c\u8bf7\u624b\u5de5\u5904\u7406" + (StringUtils.isEmpty((String)e.getMessage()) ? "" : "(" + e.getMessage() + ")"));
        }
        return new Boolean(resultStr);
    }

    private String rollBackSaveTransformResult(Context ctx, DAPTransformResult dapTransformResult, Map params) throws BOSException {
        Iterator voucherColIter = dapTransformResult.getVoucherCollection().iterator();
        ArrayList<String> voucherIdList = new ArrayList<String>();
        while (voucherColIter.hasNext()) {
            String voucherId = ((VoucherInfo)voucherColIter.next()).getId().toString();
            voucherIdList.add(voucherId);
        }
        ArrayList<DAPTransformResult> invokeDatas = new ArrayList<DAPTransformResult>();
        invokeDatas.add(dapTransformResult);
        String result = null;
        HashMap tempData = new HashMap();
        try {
            result = BOTPTools.invokeMethod4CrossSys((Context)ctx, (String)"3D99EB01", (String)"rollbackSaveTransformResult", (String)"111", voucherIdList, (boolean)true, (boolean)true, invokeDatas, (Map)params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "false";
        }
        return result;
    }

    @Override
    protected void _deleteRelationByID4CrossSystem(Context ctx, List relationIDs) throws BOSException, EASBizException {
        String sql = "delete from T_BOT_RELATION4CrossSys where FID in (";
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < relationIDs.size(); ++i) {
            BOTRelationFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(relationIDs.get(i).toString()));
            sql = sql + "?";
            if (i < relationIDs.size() - 1) {
                sql = sql + ",";
            }
            params.add(relationIDs.get(i).toString());
        }
        sql = sql + ")";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params.toArray());
    }

    @Override
    protected BOTMappingInfo _getBOTMappingInfoById(Context ctx, IObjectPK botMappingId) throws BOSException {
        if (botMappingId == null) {
            return null;
        }
        return MappingCache.getInstance((Context)ctx).getMappingInfo(botMappingId, ctx);
    }

    @Override
    protected String _saveInvokeLog(Context ctx, Map params, List voucherIdList) throws BOSException {
        Connection cn = null;
        String uuid = null;
        try {
            cn = this.getConnection(ctx);
            int tmpRelationSize = 0;
            String sql = "insert into T_BOT_INVOKELog (FID,FSERVERURL,FPORT,FUSERNSME,FDCNAME,FLANGUAGE,FAPINUMBER,FMETHOD,FINVOKETIME,FSTATE,FSERVER_CONSUMER) values (?,?,?,?,?,?,?,?,?,?,?)";
            String sqlEntry = "insert into T_BOT_INVOKELogEntry (FID,FPARENTID,FVOUCHERID) values (?,?,?)";
            String updateSql = "update T_BOT_INVOKELog set FSTATE = 1 where FID = ?";
            String updateExceptionSql = "update T_BOT_INVOKELog set FSTATE = ?  where FID = ?";
            if (params.get("uuid") == null) {
                uuid = Uuid.randomUUID().toString();
                params.put("uuid", uuid);
                Object[] paramsObject = new Object[]{uuid, params.get("DAPServerUrl") == null ? "" : params.get("DAPServerUrl").toString(), params.get("port") == null ? "" : params.get("port").toString(), ctx.getUserName(), params.get("DAPDcName").toString(), params.get("DAPLanguage").toString(), params.get("api").toString(), params.get("method").toString(), new Timestamp(System.currentTimeMillis()), 0, params.get("SERVER_CONSUMER").toString()};
                ArrayList<Object[]> paramEntryList = new ArrayList<Object[]>();
                for (int i = 0; i < voucherIdList.size(); ++i) {
                    String voucherId = voucherIdList.get(i).toString();
                    Object[] paramsObjectEntry = new Object[]{Uuid.randomUUID().toString(), uuid, voucherId};
                    paramEntryList.add(paramsObjectEntry);
                    tmpRelationSize = paramEntryList.size();
                    if (tmpRelationSize <= 2000) continue;
                    DbUtil.executeBatch((Context)ctx, (String)sql, paramEntryList);
                    paramEntryList.clear();
                    tmpRelationSize = 0;
                }
                if (tmpRelationSize != 0) {
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])paramsObject);
                    DbUtil.executeBatch((Context)ctx, (String)sqlEntry, paramEntryList);
                    paramEntryList.clear();
                }
            } else if (params.get("uuid") != null && params.get("status") == null) {
                Object[] paramsObject = new Object[]{params.get("uuid").toString()};
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])paramsObject);
            } else {
                Object[] paramsObject = new Object[]{params.get("status").toString(), params.get("uuid").toString()};
                DbUtil.execute((Context)ctx, (String)updateExceptionSql, (Object[])paramsObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException("\u8bb0\u5f55\u8c03\u7528\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25");
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return uuid;
    }

    @Override
    protected boolean _isExistCrossSysRelation(Context ctx, String billIdStr) throws BOSException {
        try {
            return BOTPTools.isExistCrossSysRelation((Context)ctx, (String)billIdStr);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getParamFromBOTPConfig(Context ctx) throws BOSException {
        return BOTPTools.getParamFromBOTPConfig((Context)ctx);
    }

    private synchronized boolean requestDBLock(Context ctx, String srcID) {
        boolean enableDBLock = BOTPTools.isEnableDBLock((Context)ctx);
        BOTPConfigInfo botpConfigInfo = BOTPConfigInfo.getConfigInstance();
        boolean isUseMutex = botpConfigInfo.isUseMutex();
        if (!enableDBLock && isUseMutex) {
            return true;
        }
        boolean result = false;
        try {
            result = BTPManagerFactory.getLocalInstance((Context)ctx).requestDBLock(srcID);
        }
        catch (BOSException e2) {
            logger.error((Object)"fail to request DBLock!", (Throwable)e2);
        }
        catch (EASBizException e) {
            logger.error((Object)"fail to request DBLock!", (Throwable)e);
        }
        return result;
    }

    protected IObjectCollection getBillList(Context ctx, String[] idList, String srcBillType, SelectorItemCollection botpSelectors, FilterInfo dataFilter, BOTMappingInfo mappingInfo) throws BOSException, BTPException {
        this.trace.setTraceLevel(TraceConfigurator.getTraceLevel((BOTMappingInfo)mappingInfo));
        this.trace.start("BOTP getBillList");
        this.trace.log(new TraceParamInfo(new Object[]{Arrays.asList(idList)}));
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer();
        String strIdLists = BOTMappingHelper.objectArray2String((Object[])idList, (String)",");
        sbMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        filterInfo.setMaskString(sbMaskString.toString());
        if (dataFilter != null) {
            filterInfo.mergeFilter(dataFilter, "AND");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        if (botpSelectors != null) {
            entityViewInfo.put("selector", (Object)botpSelectors);
        }
        CoreBillBaseController controller = (CoreBillBaseController)EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBillType));
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        try {
            this.trace.newSub("innerGetCoreBillBaseCollection");
            sourceBillCollection = controller.getCoreBillBaseCollection(ctx, entityViewInfo);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            this.trace.endSub();
        }
        if (sourceBillCollection.size() == 0) {
            throw new BTPException(BTPException.SRCBILLCOLSIZEISZERO, new Object[]{mappingInfo.getSrcEntityAlias()});
        }
        this.trace.end();
        return sourceBillCollection;
    }

    static {
        try {
            BOTPDBlockTools instance = BOTPDBlockTools.getInstance();
            instance.releaseOvertimeDBLock();
        }
        catch (Throwable e) {
            logger.error((Object)"[DAPTransformerControllerBean]fail to initialize!", e);
        }
    }
}

