/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.sql.shell.trace.TraceInfo;
import com.kingdee.eas.base.dbclean.DatabaseVO;
import com.kingdee.eas.base.dbclean.IDatabase;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class AbstractDB
implements IDatabase {
    protected DatabaseVO dbvo;

    @Override
    public KDConnection getPhysicalKDConnection() throws SQLException {
        Connection conn = this.getPhysicalDBConnection();
        int dbType = this.getDBType(this.dbvo);
        return this.getKDConnection(conn, dbType);
    }

    private KDConnection getKDConnection(Connection conn, int dbType) {
        TraceInfo traceInfo = new TraceInfo(dbType);
        if (conn instanceof KDConnection) {
            return (KDConnection)conn;
        }
        return new KDConnection(conn, dbType, traceInfo);
    }

    public int getDBType(DatabaseVO dbvo) throws SQLException {
        int dbType;
        if ("Oracle".equals(dbvo.getDBType())) {
            dbType = 7;
        } else if ("MS SqlServer".equals(dbvo.getDBType())) {
            dbType = 3;
        } else if ("DB2".equals(dbvo.getDBType())) {
            dbType = 1;
        } else if ("Sybase".equals(dbvo.getDBType())) {
            dbType = 4;
        } else if ("DB2/400".equals(dbvo.getDBType())) {
            dbType = 9;
        } else if ("MySQL".equals(dbvo.getDBType())) {
            dbType = 6;
        } else {
            throw new SQLException("Unsupported dbtype[" + dbvo.getDBType() + "]!", dbvo.getDBType());
        }
        return dbType;
    }
}

