/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean;

import com.kingdee.eas.base.dbclean.AbstractDB;
import com.kingdee.eas.base.dbclean.DatabaseVO;
import com.kingdee.eas.base.dbclean.IDatabase;
import com.kingdee.eas.base.dbclean.OracleVO;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import oracle.jdbc.driver.OracleDriver;

public class Oracle
extends AbstractDB
implements IDatabase {
    public Oracle(OracleVO dbvo) {
        this.dbvo = dbvo;
    }

    @Override
    public Connection getPhysicalDBConnection() throws SQLException {
        Properties props = new Properties();
        props.setProperty("user", this.dbvo.getDbUserName());
        props.setProperty("password", this.dbvo.getDbPassword());
        if ("sys".equalsIgnoreCase(this.dbvo.getDbUserName())) {
            props.put("internal_logon", "sysdba");
        }
        Connection conn = null;
        conn = this.connect(this.getJDBCUrl(this.dbvo), props);
        return conn;
    }

    private Connection connect(String url, Properties props) throws SQLException {
        OracleDriver oracleDriver = new OracleDriver();
        Connection conn = oracleDriver.connect(url, props);
        return conn;
    }

    private String getJDBCUrl(DatabaseVO dbvo) {
        OracleVO oracle = (OracleVO)dbvo;
        ArrayList addrList = oracle.getAddrList();
        if (addrList.size() > 1) {
            StringBuffer urlBuffer = new StringBuffer("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=");
            for (int i = 0; i < addrList.size(); ++i) {
                String addrPort = (String)addrList.get(i);
                String[] addrs = addrPort.split(":");
                urlBuffer.append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(addrs[0]).append(")(PORT=").append(addrs[1]).append("))");
            }
            if (oracle.isDBBalance()) {
                urlBuffer.append("(LOAD_BALANCE=yes)(FAILOVER=on))(CONNECT_DATA=(SERVICE_NAME=").append(oracle.getInstanceName()).append(")))");
            } else {
                urlBuffer.append("(LOAD_BALANCE=no)(FAILOVER=on))(CONNECT_DATA=(SERVICE_NAME=").append(oracle.getInstanceName()).append(")))");
            }
            return urlBuffer.toString();
        }
        return "jdbc:oracle:thin:@//" + oracle.getDbAddress() + ":" + oracle.getDbPort() + "/" + oracle.getInstanceName();
    }
}

