/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean;

import com.kingdee.eas.base.dbclean.AbstractDB;
import com.kingdee.eas.base.dbclean.DatabaseVO;
import com.kingdee.eas.base.dbclean.IDatabase;
import com.kingdee.eas.base.dbclean.SqlServerVO;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import net.sourceforge.jtds.jdbc.Driver;

public class SqlServer
extends AbstractDB
implements IDatabase {
    public SqlServer(SqlServerVO dbvo) {
        this.dbvo = dbvo;
    }

    @Override
    public Connection getPhysicalDBConnection() throws SQLException {
        Properties props = new Properties();
        props.setProperty("user", this.dbvo.getDbUserName());
        props.setProperty("password", this.dbvo.getDbPassword());
        Connection conn = null;
        conn = this.connect(this.getJDBCUrl(this.dbvo), props);
        return conn;
    }

    private Connection connect(String url, Properties props) throws SQLException {
        Driver jtdsDriver = new Driver();
        Connection conn = jtdsDriver.connect(url, props);
        return conn;
    }

    private String getJDBCUrl(DatabaseVO dbvo) {
        SqlServerVO sqlserver = (SqlServerVO)dbvo;
        return this.getJDBCUrl(sqlserver.getDbAddress(), sqlserver.getDbPort(), sqlserver.getDbName(), sqlserver.getInstanceName());
    }

    private String getJDBCUrl(String dbaddress, int dbport, String dbName, String instanceName) {
        if (instanceName != null && instanceName.length() > 0) {
            return "jdbc:jtds:sqlserver://" + dbaddress + ":" + dbport + "/" + dbName + ";prepareSQL=2;instance=" + instanceName + ";useCursors=true";
        }
        return "jdbc:jtds:sqlserver://" + dbaddress + ":" + dbport + "/" + dbName + ";prepareSQL=2;useCursors=true";
    }
}

