/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.IJZService;
import com.kingdee.eas.base.dbclean.JZModule;
import com.kingdee.eas.base.dbclean.JZModuleItem;
import com.kingdee.eas.base.dbclean.JZProcessOrg;
import com.kingdee.eas.base.dbclean.JZProcessReport;
import com.kingdee.eas.base.dbclean.JZProcessTask;
import com.kingdee.eas.base.dbclean.JZProcessTaskItem;
import com.kingdee.eas.base.dbclean.client.JZUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class JZServiceImpl
implements IJZService {
    private static Logger logger = Logger.getLogger(JZServiceImpl.class);

    public String getMaxProcId() throws SQLException {
        String procId = null;
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy");
        String curYear = dtFormat.format(new Date());
        String maxProcIdSql = "SELECT MAX(SUBSTRING(fnumber,10,4)) FROM T_BAS_CleanTask WHERE SUBSTRING(fnumber,6,4) = '" + curYear + "'";
        Statement idst = JZUtil.getConnection().createStatement();
        ResultSet idRowSet = idst.executeQuery(maxProcIdSql);
        if (idRowSet.next()) {
            String sTmpId = idRowSet.getString(1);
            if (sTmpId == null || sTmpId.length() <= 0) {
                procId = "ZTJZ_" + curYear + "0001";
            } else {
                int iTempId = Integer.parseInt(sTmpId);
                if (++iTempId < 10) {
                    procId = "ZTJZ_" + curYear + "000" + iTempId;
                } else if (iTempId < 100) {
                    procId = "ZTJZ_" + curYear + "00" + iTempId;
                } else if (iTempId < 100) {
                    procId = "ZTJZ_" + curYear + "0" + iTempId;
                }
            }
        } else {
            procId = "ZTJZ_" + curYear + "0001";
        }
        return procId;
    }

    @Override
    public JZProcessTask createProcessTask(int periodNumber, String[] orgFIds, KDConnection dbConn) throws Exception {
        try {
            String procId = null;
            procId = this.getMaxProcId();
            dbConn.setAutoCommit(false);
            JZProcessTask procTask = new JZProcessTask();
            StringBuffer orgWhere = new StringBuffer("(");
            int orgCount = orgFIds.length;
            for (int i = 0; i < orgFIds.length; ++i) {
                String orgFId = orgFIds[i];
                orgWhere.append("'" + orgFId + "'");
                if (i >= orgCount - 1) continue;
                orgWhere.append(",");
            }
            orgWhere.append(")");
            String insOrgSql = "INSERT INTO T_BAS_CleanOrg(FprocId,FOrgFId,FOrgNumber,FOrgName, FPeriodType,FPeriodFId,FPeriodNumber,FPeriodBeginDt) select '" + procId + "',A.FID, A.FNumber, A.FName_L2, B.FTypeId,B.FID, B.FNumber, B.FBeginDate FROM T_ORG_COMPANY A LEFT JOIN T_BD_PERIOD B ON A.FACCOUNTPERIODID = B.FTypeId WHERE A.FID in " + orgWhere.toString() + " AND b.FNumber = " + periodNumber;
            PreparedStatement orgPstm = dbConn.prepareStatement(insOrgSql);
            int retCount = orgPstm.executeUpdate();
            procTask.setProcId(procId);
            procTask.setModules("FI&SCM&MM");
            procTask.setStatus(0);
            procTask.setCreateDt(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            procTask.setPeriodNumber(periodNumber);
            String insertSql = "INSERT INTO T_BAS_CleanTask(FNUMBER,FCREATEDT,FMODULE,FPeriodNumber,FSTATUS) values(?,?,?,?,?)";
            PreparedStatement procPstm = dbConn.prepareStatement(insertSql);
            procPstm.setString(1, procId);
            procPstm.setString(2, procTask.getCreateDt());
            procPstm.setString(3, procTask.getModules());
            procPstm.setInt(4, procTask.getPeriodNumber());
            procPstm.setInt(5, procTask.getStatus());
            procPstm.execute();
            for (int i = 0; i < orgFIds.length; ++i) {
                String orgFId = orgFIds[i];
                String insItemSql = "INSERT INTO T_BAS_CleanTaskItem(FprocId,FOrgFId,FmoduleId,FCMODULEID,FNumber,Fname,FCodeType,FExecType,FORDER,FStartDt,FCost,FStatus,FError) SELECT '" + procId + "','" + orgFId + "',fmoduleid, FCMODULEID,fnumber,fname, fcodetype, fexectype, FORDER, null, null,0,null FROM T_BAS_CleanModuleItem WHERE FSTATUS = 0";
                PreparedStatement pstm = dbConn.prepareStatement(insItemSql);
                int rowCount = pstm.executeUpdate();
                if (rowCount <= 0) {
                    throw new Exception("\u6ca1\u6709\u6267\u884c\u4efb\u52a1");
                }
                String orgExitSQL = "SELECT COUNT(FOrgFId) FROM T_BAS_CleanOrgStatus WHERE FOrgFId = '" + orgFId + "'";
                Statement st = dbConn.createStatement();
                ResultSet existRs = st.executeQuery(orgExitSQL);
                existRs.next();
                int orgRowCount = existRs.getInt(1);
                if (orgRowCount > 0) {
                    String orgUpdateSql = "UPDATE T_BAS_CleanOrgStatus SET FPrePeriodNumber = FPeriodNumber, FPeriodNumber = " + periodNumber + " WHERE FOrgFId = '" + orgFId + "' ";
                    PreparedStatement updatePstm = dbConn.prepareStatement(orgUpdateSql);
                    updatePstm.executeUpdate();
                    continue;
                }
                String orgInsertSql = "INSERT T_BAS_CleanOrgStatus(FOrgFId, FPeriodNumber, FPrePeriodNumber) VALUES('" + orgFId + "'," + periodNumber + ", null)";
                PreparedStatement insertPstm = dbConn.prepareStatement(orgInsertSql);
                insertPstm.executeUpdate();
            }
            dbConn.commit();
            dbConn.setAutoCommit(true);
            return procTask;
        }
        catch (Exception ex) {
            dbConn.rollback();
            dbConn.setAutoCommit(true);
            throw ex;
        }
    }

    @Override
    public JZProcessTask loadProccessTask(String procId, KDConnection dbConn) throws Exception {
        String taskSql;
        JZProcessTask procTask = new JZProcessTask();
        Statement stmt = dbConn.createStatement();
        ResultSet taskRs = stmt.executeQuery(taskSql = "SELECT FNUMBER, FCREATEDT, FMODULE, FPeriodNumber, FSTATUS FROM T_BAS_CleanTask WHERE FNUMBER = '" + procId + "'");
        if (taskRs.next()) {
            procTask.setProcId(taskRs.getString("FNUMBER"));
            procTask.setCreateDt(taskRs.getString("FCREATEDT"));
            procTask.setModules(taskRs.getString("FMODULE"));
            procTask.setPeriodNumber(taskRs.getInt("FPeriodNumber"));
            procTask.setStatus(taskRs.getInt("FSTATUS"));
        } else {
            logger.info((Object)("\u627e\u4e0d\u5230\u7ed3\u8f6c\u4efb\u52a1\u4fe1\u606f\uff0c\u4efb\u52a1procId = " + procId));
        }
        String orgSql = "select FprocId, FOrgFId, FOrgNumber, FOrgName, FPeriodType, FPeriodFId, FPeriodNumber, FPeriodBeginDt from T_BAS_CleanOrg WHERE FprocId = '" + procId + "'";
        ResultSet orgRs = stmt.executeQuery(orgSql);
        ArrayList<JZProcessOrg> orgList = new ArrayList<JZProcessOrg>();
        while (orgRs.next()) {
            JZProcessOrg org = new JZProcessOrg();
            org.setProcId(orgRs.getString("FprocId"));
            org.setOrgFId(orgRs.getString("FOrgFId"));
            org.setOrgNumber(orgRs.getString("FOrgNumber"));
            org.setOrgName(orgRs.getString("FOrgName"));
            org.setPeriodType(orgRs.getString("FPeriodType"));
            org.setPeriodFid(orgRs.getString("FPeriodFId"));
            org.setPeriodNumber(orgRs.getInt("FPeriodNumber"));
            org.setPeriodBeginDt(orgRs.getDate("FPeriodBeginDt"));
            orgList.add(org);
        }
        if (orgList.size() == 0) {
            logger.info((Object)("\u627e\u4e0d\u5230\u7ed3\u8f6c\u4efb\u52a1\u7684\u7ec4\u7ec7\uff0c\u4efb\u52a1procId = " + procId));
        }
        procTask.setOrgs(orgList);
        String moduleSql = "select FNumber, FNAME, FORDER from T_BAS_CleanModule";
        PreparedStatement moduleStmt = dbConn.prepareStatement(moduleSql);
        ResultSet moduleRs = moduleStmt.executeQuery();
        ArrayList<JZModule> moduleList = new ArrayList<JZModule>();
        while (moduleRs.next()) {
            JZModule module = new JZModule();
            module.setModuleId(moduleRs.getString("FNumber"));
            module.setModuleName(moduleRs.getString("FNAME"));
            module.setOrder(moduleRs.getInt("FORDER"));
            List taskItems = this.getTaskItemsByModule(procId, module.getModuleId(), dbConn);
            module.setTaskList(taskItems);
            moduleList.add(module);
        }
        if (orgList.size() == 0) {
            logger.info((Object)("\u627e\u4e0d\u5230\u7ed3\u8f6c\u4efb\u52a1\u7684\u6a21\u5757(\u5982SCM,FI\u7b49)\uff0c\u4efb\u52a1procId = " + procId));
        }
        procTask.setModuleTask(moduleList);
        return procTask;
    }

    private List getTaskItemsByModule(String procId, String moduleId, KDConnection dbConn) throws Exception {
        String querySql = "SELECT A.FprocId,A.FOrgFId,A.FmoduleId,A.FCMODULEID,A.FNumber,A.FName,A.FCodeType,A.FExecType,A.FORDER, A.FStartDt,A.FCost,A.FStatus,A.FError, B.FCODE FROM T_BAS_CleanTaskItem A LEFT JOIN T_BAS_CleanModuleItem B ON A.FmoduleId = B.FmoduleId AND  A.FNUMBER = B.FNUMBER WHERE A.FprocId = '" + procId + "' AND A.FmoduleId = '" + moduleId + "'";
        PreparedStatement stmt = dbConn.prepareStatement(querySql);
        ResultSet rs = stmt.executeQuery();
        ArrayList<JZProcessTaskItem> itemList = new ArrayList<JZProcessTaskItem>();
        while (rs.next()) {
            JZProcessTaskItem taskItem = new JZProcessTaskItem();
            taskItem.setProcId(rs.getString("FprocId"));
            taskItem.setOrgFId(rs.getString("FOrgFId"));
            taskItem.setModuleId(rs.getString("FmoduleId"));
            taskItem.setCModuleId(rs.getString("FCMODULEID"));
            taskItem.setItemId(rs.getString("FNumber"));
            taskItem.setItemName(rs.getString("FName"));
            taskItem.setCodeType(rs.getInt("FCodeType"));
            taskItem.setExecType(rs.getInt("FExecType"));
            taskItem.setOrder(rs.getInt("FORDER"));
            taskItem.setStartDt(rs.getString("FStartDt"));
            taskItem.setCost(rs.getInt("FCost"));
            taskItem.setStatus(rs.getInt("FStatus"));
            taskItem.setError(rs.getString("FError"));
            taskItem.setCode(rs.getString("FCODE"));
            itemList.add(taskItem);
        }
        return itemList;
    }

    @Override
    public List queryAllProcessTask(KDConnection dbConn) throws Exception {
        String querySql = "SELECT FNUMBER,FCREATEDT,FMODULE,FPeriodNumber,FSTATUS FROM T_BAS_CleanTask order by FNUMBER";
        PreparedStatement stmt = dbConn.prepareStatement(querySql);
        ResultSet rs = stmt.executeQuery();
        ArrayList<JZProcessTask> processTask = new ArrayList<JZProcessTask>();
        while (rs.next()) {
            JZProcessTask procTask = new JZProcessTask();
            procTask.setProcId(rs.getString("FNUMBER"));
            procTask.setCreateDt(rs.getString("FCREATEDT"));
            procTask.setModules(rs.getString("FMODULE"));
            procTask.setPeriodNumber(rs.getInt("FPeriodNumber"));
            procTask.setStatus(rs.getInt("FSTATUS"));
            processTask.add(procTask);
        }
        return processTask;
    }

    @Override
    public void updateTaskItem(JZProcessTaskItem taskItem, KDConnection dbConn) throws Exception {
        String updateSql = "UPDATE T_BAS_CleanTaskItem SET FStartDt = ?, FCost = ?, FStatus = ?, FError = ?  WHERE FprocId = '" + taskItem.getProcId() + "' AND FOrgFId = '" + taskItem.getOrgFId() + "' AND FmoduleId = '" + taskItem.getModuleId() + "' AND FNumber = '" + taskItem.getItemId() + "'";
        PreparedStatement stmt = dbConn.prepareStatement(updateSql);
        stmt.setString(1, taskItem.getStartDt());
        stmt.setInt(2, taskItem.getCost());
        stmt.setInt(3, taskItem.getStatus());
        stmt.setString(4, taskItem.getError());
        stmt.executeUpdate();
    }

    @Override
    public void updateProccessTaskStatus(JZProcessTask processTask, int status, KDConnection dbConn) throws Exception {
        String updateSql = "UPDATE T_BAS_CleanTask SET FStatus = " + status + " WHERE FNUMBER = '" + processTask.getProcId() + "'";
        PreparedStatement stmt = dbConn.prepareStatement(updateSql);
        stmt.executeUpdate();
    }

    @Override
    public String getMaxModuleItemId(JZModuleItem moduleItem, KDConnection dbConn) throws Exception {
        String maxIdSql = "SELECT MAX(FNumber) FROM T_BAS_CleanModuleItem WHERE FmoduleId = '" + moduleItem.getModuleId() + "'";
        Statement idStm = dbConn.createStatement();
        ResultSet idRowSet = idStm.executeQuery(maxIdSql);
        String sTmpId = "10001";
        if (idRowSet.next()) {
            sTmpId = idRowSet.getString(1);
            sTmpId = sTmpId != null && sTmpId.length() > 0 ? String.valueOf(Integer.parseInt(sTmpId) + 1) : "10001";
        }
        return sTmpId;
    }

    @Override
    public void createModuleItem(JZModuleItem moduleItem, KDConnection dbConn) throws Exception {
        String maxItemId = this.getMaxModuleItemId(moduleItem, dbConn);
        moduleItem.setItemId(maxItemId);
        moduleItem.setStatus(0);
        String insertSql = "INSERT INTO T_BAS_CleanModuleItem(FNumber,FmoduleId,FCmoduleId,Fname,FCodeType,FExecType,FCODE,FCONTENT,FORDER,FStatus) VALUES(?,?,?,?,?, ?,?,?,?,?)";
        PreparedStatement stmt = dbConn.prepareStatement(insertSql);
        stmt.setString(1, moduleItem.getItemId());
        stmt.setString(2, moduleItem.getModuleId());
        stmt.setString(3, moduleItem.getCModuleId());
        stmt.setString(4, moduleItem.getItemName());
        stmt.setInt(5, moduleItem.getCodeType());
        stmt.setInt(6, moduleItem.getExecType());
        stmt.setString(7, moduleItem.getCode());
        stmt.setString(8, moduleItem.getContent());
        stmt.setInt(9, moduleItem.getOrder());
        stmt.setInt(10, moduleItem.getStatus());
        stmt.executeUpdate();
    }

    @Override
    public void updateModuleItem(JZModuleItem moduleItem, KDConnection dbConn) throws Exception {
        String itemId = moduleItem.getItemId();
        if (itemId != null) {
            String updateSql = "UPDATE T_BAS_CleanModuleItem SET FmoduleId =? ,FCModuleId=?,Fname =? ,FCodeType =? ,FExecType =? ,FCODE =? ,FCONTENT =? ,FORDER =?  WHERE  FModuleId = '" + moduleItem.getModuleId() + "' AND FNumber = '" + moduleItem.getItemId() + "'";
            PreparedStatement stmt = dbConn.prepareStatement(updateSql);
            stmt.setString(1, moduleItem.getModuleId());
            stmt.setString(2, moduleItem.getCModuleId());
            stmt.setString(3, moduleItem.getItemName());
            stmt.setInt(4, moduleItem.getCodeType());
            stmt.setInt(5, moduleItem.getExecType());
            stmt.setString(6, moduleItem.getCode());
            stmt.setString(7, moduleItem.getContent());
            stmt.setInt(8, moduleItem.getOrder());
            stmt.executeUpdate();
        }
    }

    @Override
    public void disabledModuleItems(List itemList, KDConnection dbConn) throws Exception {
        for (JZModuleItem moduleItem : itemList) {
            String updateSql = "UPDATE T_BAS_CleanModuleItem SET FStatus = 1 WHERE FName = '" + moduleItem.getItemName() + "' AND FModuleId = '" + moduleItem.getModuleId() + "' AND FNumber = '" + moduleItem.getItemId() + "'";
            PreparedStatement stmt = dbConn.prepareStatement(updateSql);
            stmt.executeUpdate();
        }
    }

    @Override
    public void enAbledModuleItems(List itemList, KDConnection dbConn) throws Exception {
        for (JZModuleItem moduleItem : itemList) {
            String updateSql = "UPDATE T_BAS_CleanModuleItem SET FStatus = 0 WHERE FName = '" + moduleItem.getItemName() + "' AND FModuleId = '" + moduleItem.getModuleId() + "'AND FNumber = '" + moduleItem.getItemId() + "'";
            PreparedStatement stmt = dbConn.prepareStatement(updateSql);
            stmt.executeUpdate();
        }
    }

    @Override
    public void removeModuleItems(List itemList, KDConnection dbConn) throws Exception {
        for (JZModuleItem moduleItem : itemList) {
            String deleteSql = "DELETE FROM T_BAS_CleanModuleItem WHERE FName = '" + moduleItem.getItemName() + "' AND FModuleId = '" + moduleItem.getModuleId() + "' AND FCModuleId = '" + moduleItem.getCModuleId() + "' AND FNumber = '" + moduleItem.getItemId() + "'";
            PreparedStatement stmt = JZUtil.getConnection().prepareStatement(deleteSql);
            stmt.executeUpdate();
        }
    }

    @Override
    public List queryModuleItems(String moduleId, String cModuleId, int execType, String itemName, KDConnection dbConn) throws Exception {
        String querySql = "SELECT FNumber,FmoduleId,FCModuleId,Fname,FCodeType,FExecType,FCODE,FORDER,FStatus FROM T_BAS_CleanModuleItem WHERE FmoduleId like '" + moduleId + "' and FCModuleId like '" + cModuleId + "' ";
        if (execType == 1 || execType == 2 || execType == 3) {
            querySql = querySql + " AND FEXECTYPE = " + execType + " ";
        }
        if (itemName != null && itemName.length() > 0) {
            querySql = querySql + " AND Fname LIKE '%" + itemName + "%'";
        }
        querySql = querySql + "ORDER BY FORDER ASC";
        PreparedStatement stmt = dbConn.prepareStatement(querySql);
        ResultSet rst = stmt.executeQuery();
        ArrayList<JZModuleItem> queryList = new ArrayList<JZModuleItem>();
        while (rst.next()) {
            JZModuleItem moduleItem = new JZModuleItem();
            moduleItem.setItemId(rst.getString("FNumber"));
            moduleItem.setModuleId(rst.getString("FmoduleId"));
            moduleItem.setCModuleId(rst.getString("FCModuleId"));
            moduleItem.setItemName(rst.getString("Fname"));
            moduleItem.setCodeType(rst.getInt("FCodeType"));
            moduleItem.setExecType(rst.getInt("FExecType"));
            moduleItem.setCode(rst.getString("FCODE"));
            moduleItem.setOrder(rst.getInt("FORDER"));
            moduleItem.setStatus(rst.getInt("FStatus"));
            queryList.add(moduleItem);
        }
        return queryList;
    }

    @Override
    public List queryAllTaskLog(String procId, KDConnection dbConn) throws Exception {
        String querySql = "SELECT A.FprocId,A.FOrgFId,A.FmoduleId,A.FCMODULEID,A.FNumber,A.FName,A.FCodeType,A.FExecType,A.FORDER, A.FStartDt,A.FCost,A.FStatus,A.FError, B.FName_L2  FROM T_BAS_CleanTaskItem A LEFT JOIN T_ORG_COMPANY B ON A.FOrgFId = B.FID WHERE A.FprocId = '" + procId + "' ORDER BY A.FmoduleId ASC,A.FCMODULEID ASC";
        PreparedStatement stmt = dbConn.prepareStatement(querySql);
        ResultSet rs = stmt.executeQuery();
        ArrayList<JZProcessTaskItem> logList = new ArrayList<JZProcessTaskItem>();
        while (rs.next()) {
            JZProcessTaskItem taskItem = new JZProcessTaskItem();
            taskItem.setProcId(rs.getString("FprocId"));
            taskItem.setOrgFId(rs.getString("FOrgFId"));
            taskItem.setModuleId(rs.getString("FmoduleId"));
            taskItem.setCModuleId(rs.getString("FCMODULEID"));
            taskItem.setItemId(rs.getString("FNumber"));
            taskItem.setItemName(rs.getString("FName"));
            taskItem.setCodeType(rs.getInt("FCodeType"));
            taskItem.setExecType(rs.getInt("FExecType"));
            taskItem.setOrder(rs.getInt("FORDER"));
            taskItem.setStartDt(rs.getString("FStartDt"));
            taskItem.setCost(rs.getInt("FCost"));
            taskItem.setStatus(rs.getInt("FStatus"));
            taskItem.setError(rs.getString("FError"));
            taskItem.setOrgName(rs.getString("FName_L2"));
            logList.add(taskItem);
        }
        return logList;
    }

    @Override
    public List queryTaskLog(String procId, String moduleId, String cModuleId, String orgName, int execStatus, KDConnection dbConn) throws Exception {
        String querySql = "SELECT A.FprocId,A.FOrgFId,A.FmoduleId,A.FCMODULEID,A.FNumber,A.FName,A.FCodeType,A.FExecType,A.FORDER, A.FStartDt,A.FCost,A.FStatus,A.FError, B.FName_L2  FROM T_BAS_CleanTaskItem A LEFT JOIN T_ORG_COMPANY B ON A.FOrgFId = B.FID WHERE A.FprocId = '" + procId + "' AND A.FmoduleId like '" + moduleId + "' and A.FCModuleId like '" + cModuleId + "' ";
        if (execStatus == 0 || execStatus == 1 || execStatus == 2) {
            querySql = querySql + " AND A.FStatus = " + execStatus + " ";
        }
        if (orgName != null && orgName.length() > 0) {
            querySql = querySql + " AND B.FName_L2 LIKE '%" + orgName + "%'";
        }
        PreparedStatement stmt = dbConn.prepareStatement(querySql);
        ResultSet rs = stmt.executeQuery();
        ArrayList<JZProcessTaskItem> logList = new ArrayList<JZProcessTaskItem>();
        while (rs.next()) {
            JZProcessTaskItem taskItem = new JZProcessTaskItem();
            taskItem.setProcId(rs.getString("FprocId"));
            taskItem.setOrgFId(rs.getString("FOrgFId"));
            taskItem.setModuleId(rs.getString("FmoduleId"));
            taskItem.setCModuleId(rs.getString("FCMODULEID"));
            taskItem.setItemId(rs.getString("FNumber"));
            taskItem.setItemName(rs.getString("FName"));
            taskItem.setCodeType(rs.getInt("FCodeType"));
            taskItem.setExecType(rs.getInt("FExecType"));
            taskItem.setOrder(rs.getInt("FORDER"));
            taskItem.setStartDt(rs.getString("FStartDt"));
            taskItem.setCost(rs.getInt("FCost"));
            taskItem.setStatus(rs.getInt("FStatus"));
            taskItem.setError(rs.getString("FError"));
            taskItem.setOrgName(rs.getString("FName_L2"));
            logList.add(taskItem);
        }
        return logList;
    }

    @Override
    public List queryOrg(String queryType, String queryText, int isCheckBox, String periodNumber, KDConnection dbConn) throws Exception {
        String orgQuerySql = "SELECT DISTINCT A.FNAME_L2,A.FNUMBER,A.FCode,A.FID,B.FPeriodNumber FROM T_ORG_COMPANY A LEFT JOIN T_BAS_CleanOrgStatus B on A.FID = B.ForgFid LEFT JOIN T_BD_SYSTEMSTATUSCTROL C on A.FID = C.FCompanyID LEFT JOIN T_BD_PERIOD D on D.FID = C.FCurrentPeriodID  WHERE A.FId NOT IN (SELECT ForgFid FROM T_BAS_CleanOrgStatus WHERE FperiodNumber >= " + periodNumber + "  OR ForgFid in(  SELECT T1.ForgFid FROM T_BAS_CleanOrgStatus T1 LEFT JOIN T_BAS_CleanOrg T2 ON T1.FORGFID = T2.FORGFID AND T1.FPeriodNumber = T2.FPeriodNumber LEFT JOIN t_bas_cleantask t3 ON T2.FprocId = T3.FNumber\tWHERE (T3.fstatus <> 1 AND T1.FPeriodNumber <= " + periodNumber + ") AND T1.FPeriodNumber IS NOT NULL  ) )  AND A.FIsBizUnit = 1  AND C.FisStart = 1  AND " + periodNumber + " > (select min(E.FNumber) from T_BD_SYSTEMSTATUSCTROL F left outer join t_bd_period E on F.FStartPeriodID = E.Fid where F.FCompanyID = A.FID)  AND " + periodNumber + " <= (select min(E.FNumber) from T_BD_SYSTEMSTATUSCTROL F left outer join t_bd_period E on F.FCurrentPeriodID = E.Fid where F.FCompanyID = A.FID) ";
        if (!queryText.equalsIgnoreCase("") && queryType.equalsIgnoreCase("\u7f16\u7801+\u540d\u79f0")) {
            orgQuerySql = isCheckBox == 32 ? orgQuerySql + "and (A.FNAME_L2 LIKE '%" + queryText + "%'or A.FNUMBER LIKE '%" + queryText + "%')" : orgQuerySql + "and (A.FNAME_L2 = '" + queryText + "' or A.FNUMBER = '" + queryText + "' )";
        }
        if (!queryText.equalsIgnoreCase("") && queryType.equalsIgnoreCase("\u7ec4\u7ec7\u7f16\u7801")) {
            orgQuerySql = isCheckBox == 32 ? orgQuerySql + "and A.FNUMBER LIKE '%" + queryText + "%'" : orgQuerySql + "and A.FNUMBER = '" + queryText + "'";
        }
        if (!queryText.equalsIgnoreCase("") && queryType.equalsIgnoreCase("\u7ec4\u7ec7\u540d\u79f0")) {
            orgQuerySql = isCheckBox == 32 ? orgQuerySql + "and A.FNAME_L2 LIKE '%" + queryText + "%'" : orgQuerySql + "and A.FNAME_L2 = '" + queryText + "'";
        }
        if (!queryText.equalsIgnoreCase("") && queryType.equalsIgnoreCase("\u52a9\u8bb0\u7801")) {
            orgQuerySql = isCheckBox == 32 ? orgQuerySql + "and A.FCODE LIKE '%" + queryText + "%'" : orgQuerySql + "and A.FCODE = '" + queryText + "'";
        }
        PreparedStatement stmt = dbConn.prepareStatement(orgQuerySql);
        ResultSet rs = stmt.executeQuery();
        ArrayList<JZProcessOrg> orgList = new ArrayList<JZProcessOrg>();
        while (rs.next()) {
            JZProcessOrg orgItem = new JZProcessOrg();
            orgItem.setOrgNumber(rs.getString("FNUMBER"));
            orgItem.setOrgName(rs.getString("FName_L2"));
            orgItem.setOrgCode(rs.getString("FCode"));
            orgItem.setPeriodNumber(rs.getInt("FPeriodNumber"));
            orgItem.setOrgFId(rs.getString("FID"));
            orgList.add(orgItem);
        }
        return orgList;
    }

    @Override
    public List queryProcessTaskReport(String procId, KDConnection dbConn) throws Exception {
        String querySql = "select A.FOrgName, B.FStatus, count(*) from t_bas_cleanOrg A left join t_bas_cleanTaskItem B on a.FOrgFId = b.FOrgFId where B.FProcId = '" + procId + "' and B.FStatus <> 2group by A.FOrgName, B.FStatus order by B.FStatus";
        PreparedStatement stmt = dbConn.prepareStatement(querySql);
        ResultSet rs = stmt.executeQuery();
        ArrayList<JZProcessReport> rptList = new ArrayList<JZProcessReport>();
        while (rs.next()) {
            JZProcessReport rptItem = new JZProcessReport();
            rptItem.setOrgName(rs.getString("ForgName"));
            rptItem.setStatus(rs.getInt("FStatus"));
            rptItem.setCount(rs.getInt(3));
            rptList.add(rptItem);
        }
        return rptList;
    }

    @Override
    public boolean removeTask(JZProcessTask procTask, KDConnection connection) throws Exception {
        boolean isOK = false;
        Statement stmt = null;
        Statement stmt1 = null;
        Statement stmt2 = null;
        Statement stmt3 = null;
        Statement stmt4 = null;
        ResultSet rs = null;
        try {
            String procId = procTask.getProcId();
            String querySql = "select * from T_bas_cleanTask A,T_bas_cleanTaskItem B where A.FNUMBER = '" + procId + "' and B.FStatus = 2 and A.FNUMBER = B.FprocId ;";
            stmt = connection.prepareStatement(querySql);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                String deleteSql1 = "UPDATE t_bas_cleanorgstatus SET FPeriodNumber = FPrePeriodNumber WHERE FOrgFId in (select A.FOrgFId from t_bas_cleanorgstatus B left join t_bas_cleanorg A on A.FOrgFId = B.FOrgFId  and A.FprocId = '" + procId + "' )";
                String deleteSql2 = "DELETE FROM T_bas_cleanTask WHERE FNUMBER = '" + procId + "' ";
                String deleteSql3 = "delete from t_bas_cleanorg where FprocId ='" + procId + "'";
                String deleteSql4 = "DELETE FROM T_bas_cleanTaskItem WHERE FprocId = '" + procId + "' ";
                connection.setAutoCommit(false);
                stmt1 = connection.prepareStatement(deleteSql1);
                stmt1.executeUpdate();
                stmt2 = connection.prepareStatement(deleteSql2);
                stmt2.executeUpdate();
                stmt3 = connection.prepareStatement(deleteSql3);
                stmt3.executeUpdate();
                stmt4 = connection.prepareStatement(deleteSql4);
                stmt4.executeUpdate();
                connection.commit();
                connection.setAutoCommit(true);
            } else {
                isOK = true;
            }
        }
        catch (Exception ex) {
            isOK = false;
            if (connection != null) {
                connection.rollback();
                connection.setAutoCommit(true);
            }
            throw ex;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (stmt1 != null) {
                stmt1.close();
            }
            if (stmt2 != null) {
                stmt2.close();
            }
            if (stmt3 != null) {
                stmt3.close();
            }
            if (stmt4 != null) {
                stmt4.close();
            }
        }
        return isOK;
    }
}

