/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean.app;

import com.kingdee.bos.sql.shell.KDStatement;
import com.kingdee.eas.base.dbclean.IJZLogger;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.AbstractJZTask;
import java.util.StringTokenizer;

public final class SqlJZTask
extends AbstractJZTask {
    @Override
    public boolean doTask(JZContext context) throws JZTaskException {
        try {
            IJZLogger logger = context.getLogger();
            String ksql = context.getTaskConfig().getSQL();
            String[] sqlArray = this.parseSQL(ksql);
            KDStatement pst = (KDStatement)context.getDbConn().createStatement();
            for (int i = 0; i < sqlArray.length; ++i) {
                String sql = sqlArray[i];
                if (sql == null || sql.trim().length() <= 0) continue;
                sql = sql.replaceAll("\\$ORGID", context.getOrgFId());
                logger.print(sql);
                pst.addBatch(sql);
            }
            pst.executeBatch();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JZTaskException("\u9519\u8bef:" + ex.getMessage());
        }
    }

    private String[] parseSQL(String ksql) {
        StringTokenizer st = new StringTokenizer(ksql, ";");
        String[] retSQL = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            String sql = st.nextToken();
            retSQL[index] = sql = sql.replaceAll("\n", "");
            ++index;
        }
        return retSQL;
    }
}

