/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.forewarn.IForewarnDeal;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class SimpleForewarnDeal
implements IForewarnDeal,
Serializable {
    private static Logger logger = Logger.getLogger(SimpleForewarnDeal.class);
    private String forewarnRes = "com.kingdee.eas.base.forewarn.client.Forewarn";

    @Override
    public void show(String objIDs, Component owner) {
        this.showListUI(objIDs, owner);
    }

    private void showListUI(String objIDs, Component comp) {
        if (objIDs == null || objIDs.length() == 0) {
            return;
        }
        logger.info((Object)("......... objIDs :" + objIDs));
        int startPosition = objIDs.indexOf("'");
        int endPosition = 0;
        endPosition = objIDs.indexOf("'", startPosition + 1);
        if (startPosition == -1 || endPosition == -1) {
            return;
        }
        Context ctx = null;
        String tmpID = objIDs.substring(startPosition + 1, endPosition);
        BOSUuid uu = BOSUuid.read((String)tmpID);
        BOSObjectType bosType = uu.getType();
        EntityObjectInfo info = MetaDataLoader.getEntity(ctx, (BOSObjectType)bosType);
        if (info == null) {
            return;
        }
        logger.info((Object)("entity is:" + info.getName()));
        logger.info((Object)("entity is:" + info.getEJBName()));
        String listUI = info.getExtendedProperty("listUI");
        if (listUI == null || listUI.trim().length() == 0) {
            boolean debug = false;
            if (debug) {
                listUI = "com.kingdee.eas.basedata.hraux.client.DiplomaListUI";
            } else {
                MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)this.forewarnRes, (String)"canNotFindUI"));
                return;
            }
        }
        logger.info((Object)("listUI is:" + listUI));
        this.createListUI(objIDs, listUI, comp);
    }

    private void createListUI(String objIDs, String uiName, Component comp) {
        ListUI ui = null;
        try {
            Class<?> c = Class.forName(uiName);
            Object o = c.newInstance();
            if (o instanceof ListUI) {
                ui = (ListUI)o;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (Exception exc) {
            logger.error((Object)exc);
        }
        if (ui == null) {
            return;
        }
        ui.initLayout();
        try {
            Frame tempFrame;
            ui.onLoad();
            EntityViewInfo evi = ui.getMainQuery();
            FilterInfo oldFilter = null;
            StringBuffer newFilter = null;
            if (evi.getFilter() != null) {
                oldFilter = evi.getFilter();
                FilterInfo filter = new FilterInfo();
                FilterItemCollection items = filter.getFilterItems();
                Collection col = this.getFormatString(objIDs);
                if (col.size() > 0) {
                    items.add(new FilterItemInfo("id", (Object)col, CompareType.INNER));
                    filter.setMaskString("#0");
                }
                oldFilter.mergeFilter(filter, "AND");
                evi.setFilter(oldFilter);
            } else {
                newFilter = new StringBuffer("(").append("id in ").append(objIDs).append(")");
                evi.setFilter(newFilter.toString());
            }
            ui.refreshList();
            HashMap<String, Component> uiContext = new HashMap<String, Component>();
            uiContext.put("Owner", comp);
            Dimension d = new Dimension();
            d.setSize(ui.getBounds().width, ui.getBounds().height);
            UIDialog dlg = null;
            if (comp instanceof Frame) {
                tempFrame = (Frame)comp;
                dlg = new UIDialog((IUIObject)ui, tempFrame, true);
            } else if (comp instanceof Dialog) {
                Dialog tempDialog = (Dialog)comp;
                dlg = new UIDialog((IUIObject)ui, tempDialog, true);
            } else {
                logger.info((Object)"......... not found the frame or dialog ,create new Frame");
                tempFrame = new Frame();
                dlg = new UIDialog((IUIObject)ui, tempFrame, true);
            }
            JPanel tmp = (JPanel)dlg.getContentPane();
            tmp.setPreferredSize(d);
            dlg.setVisible(true);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private Collection getFormatString(String ids) {
        ArrayList<String> col = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)ids)) {
            ids = ids.replaceAll("\\(", "");
            ids = ids.replaceAll("\\)", "");
            ids = ids.replaceAll("\uff0c", ",");
            String[] tempList = ids.split(",");
            for (int i = 0; i < tempList.length; ++i) {
                String obj = null;
                obj = tempList[i];
                col.add(obj);
            }
        }
        return col;
    }
}

