/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.forewarn.app.AbstractDataCenterFacadeControllerBean;
import com.kingdee.eas.base.forewarn.dataDeal.DataBaseInfo;
import com.kingdee.eas.base.forewarn.dataDeal.DataDealCenter;
import com.kingdee.eas.base.forewarn.dataDeal.DataExportImplHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.ServerEnvironment;
import com.kingdee.eas.common.app.ServerSysEnvLoader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataCenterFacadeControllerBean
extends AbstractDataCenterFacadeControllerBean {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.forewarn.app.DataCenterFacadeControllerBean");

    @Override
    protected void _exportData(Context ctx, List tableList, DataBaseInfo dataBaseInfo) throws BOSException, EASBizException {
        if (tableList == null || tableList.isEmpty()) {
            this.logger.info((Object)"........ tableList is null,return null");
            return;
        }
        String sqlFilePath = DataBaseInfo.getSqlFilePath();
        this.logger.info((Object)("the export sql file in server is: " + sqlFilePath));
        File tempFile = new File(sqlFilePath);
        if (tempFile.exists()) {
            tempFile.delete();
        }
        Connection con = null;
        BufferedWriter out = null;
        try {
            if (dataBaseInfo == null || "CONNECT_TYPE_SYSTEM".equals(dataBaseInfo.getConnType())) {
                con = this.getConnection(ctx);
            } else {
                this.logger.info((Object)" user userDefine con");
                con = dataBaseInfo.getConnection();
            }
            if (con == null) {
                throw new BOSException("connection is null, please check advance setting! ");
            }
            dataBaseInfo.fidStr = DataBaseInfo.addSeperator(DataExportImplHelper.getFidByNumber(tableList, dataBaseInfo.numberStr, dataBaseInfo.ExportDataType, con));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile, true), "utf-8"));
            String[] delStr = DataExportImplHelper.getDelStr(tableList, dataBaseInfo.fidStr, dataBaseInfo.numberStr, dataBaseInfo.ExportDataType, con);
            if (delStr != null) {
                for (int i = 0; i < delStr.length; ++i) {
                    out.write(delStr[i]);
                    out.newLine();
                }
            }
            DataDealCenter dataCenter = new DataDealCenter(dataBaseInfo);
            dataCenter.deal(tableList, out, con);
        }
        catch (IOException e) {
            this.logger.info((Object)e);
            throw new BOSException(e.getMessage());
        }
        catch (SQLException e) {
            this.logger.info((Object)e);
            throw new BOSException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logger.info((Object)e);
                    throw new BOSException(e.getMessage());
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    this.logger.info((Object)e);
                    throw new BOSException(e.getMessage());
                }
            }
        }
    }

    @Override
    protected Set _getDynCollection(Context ctx, String objID) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        set.add("/u8oeAELEADgAPO3wKgQDRO33n8=");
        set.add("/u8oeAELEADgAa77wKgQDRO33n8=");
        set.add("256c221a-0106-1000-e000-10d7c0a813f413B7DE7F");
        return set;
    }

    @Override
    protected HashMap _getServerSysProp(Context ctx) throws BOSException {
        HashMap<String, String> props = new HashMap<String, String>();
        ServerSysEnvLoader.initSysEnv();
        props.put("EASHome", ServerEnvironment.getEASHome());
        props.put("EASWebClientPath", ServerEnvironment.getEASWebClientPath());
        props.put("InstanceConfigPath", ServerEnvironment.getInstanceConfigPath());
        props.put("InstanceName", ServerEnvironment.getInstanceName());
        props.put("InstanceWorkspace", ServerEnvironment.getInstanceWorkspace());
        props.put("RPCPort", String.valueOf(ServerEnvironment.getRPCPort()));
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getSqlFromServerFile(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String sqlFilePath = DataBaseInfo.getSqlFilePath();
        File myFile = new File(sqlFilePath);
        if (!myFile.exists()) {
            this.logger.error((Object)("Can't Find " + sqlFilePath));
        }
        BufferedReader reader = null;
        try {
            String str;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(myFile), "utf-8"));
            while ((str = reader.readLine()) != null) {
                sb.append(str).append("\n");
            }
        }
        catch (IOException ie) {
            this.logger.error((Object)"_getSqlFromServerFile IOException", (Throwable)ie);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

