/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.app.CommonQueryUtil;
import com.kingdee.eas.base.forewarn.ForewarnConditionInfo;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnObjectInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectType;
import com.kingdee.eas.base.forewarn.ForewarnThresholdCollection;
import com.kingdee.eas.base.forewarn.MetadataType;
import com.kingdee.eas.base.forewarn.app.ForewarnData;
import com.kingdee.eas.base.forewarn.app.ForewarnHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

public class ForewarnForTest {
    Logger logger = Logger.getLogger(ForewarnForTest.class.getName());
    private final int RUN_TIME_FOR_TEST = 10;
    private ForewarnItemInfo forewarnItemInfo = null;
    private Map businessEntities = null;
    private Context currentCtx = null;

    public void init(ForewarnItemInfo forewarnItemInfo, Map businessEntities, Context currentCtx) {
        this.forewarnItemInfo = forewarnItemInfo;
        this.businessEntities = businessEntities;
        this.currentCtx = currentCtx;
    }

    private void release() {
    }

    public ArrayList getInstanceCombination(ArrayList pkCombination, Connection connection) throws BOSException {
        ArrayList<IObjectValue> instanceCombination = new ArrayList<IObjectValue>();
        int runTimes = this.getRunTimes(this.forewarnItemInfo.getObjects());
        int size = pkCombination.size();
        try {
            if (size > runTimes) {
                for (int i = 0; i < runTimes; ++i) {
                    ForewarnData data = (ForewarnData)pkCombination.get(this.getRandomIndex(size));
                    ObjectUuidPK objectPK = (ObjectUuidPK)data.getPk();
                    ORMappingDAO mappingDAO = new ORMappingDAO(data.getBosType(), this.currentCtx, connection);
                    IObjectValue objectValue = mappingDAO.getValue((IObjectPK)objectPK);
                    objectValue.setExtendedProperty("ForwarnObjectAlias", data.getAlias());
                    instanceCombination.add(objectValue);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    ForewarnData data = (ForewarnData)pkCombination.get(i);
                    ObjectUuidPK objectPK = (ObjectUuidPK)data.getPk();
                    ORMappingDAO mappingDAO = new ORMappingDAO(data.getBosType(), this.currentCtx, connection);
                    IObjectValue objectValue = mappingDAO.getValue((IObjectPK)objectPK);
                    objectValue.setExtendedProperty("ForwarnObjectAlias", data.getAlias());
                    instanceCombination.add(objectValue);
                }
            }
        }
        catch (DataAccessException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
        return instanceCombination;
    }

    public ForewarnItemInfo createTestItem(String script, ForewarnObjectCollection forewarnObjects, ForewarnThresholdCollection forewarnThresholds) {
        ForewarnItemInfo testItem = new ForewarnItemInfo();
        ForewarnConditionInfo conditionInfo = new ForewarnConditionInfo();
        testItem.setCondition(conditionInfo);
        testItem.getObjects().clear();
        testItem.getObjects().addCollection(forewarnObjects);
        testItem.getCondition().setContentScript(script);
        testItem.getCondition().getThresholdCollection().clear();
        testItem.getCondition().getThresholdCollection().addCollection(forewarnThresholds);
        return testItem;
    }

    public ArrayList getRandomPKCombinations(ArrayList pkCombinations) {
        ArrayList randomPKCombinations = new ArrayList();
        int runTimes = this.getRunTimes(this.forewarnItemInfo.getObjects());
        int size = pkCombinations.size();
        if (size > runTimes) {
            for (int i = 0; i < runTimes; ++i) {
                randomPKCombinations.add(pkCombinations.get(this.getRandomIndex(size)));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                randomPKCombinations.add(pkCombinations.get(i));
            }
        }
        return randomPKCombinations;
    }

    public ArrayList getPKCombinations(ForewarnObjectCollection forewarnObjects, Connection connection) throws Exception {
        ArrayList pkCombinations = new ArrayList();
        ArrayList bizPKs = this.getBizPKs(forewarnObjects, connection);
        ForewarnHelper helper = new ForewarnHelper(this.forewarnItemInfo);
        pkCombinations = helper.combinate(bizPKs);
        return pkCombinations;
    }

    private int getRunTimes(ForewarnObjectCollection forewarnObjects) {
        int size = forewarnObjects.size();
        return 10 / size == 0 ? 1 : 10 / size;
    }

    private int getRandomIndex(int size) {
        int randomIndex = 0;
        int length = String.valueOf(size).length();
        int range = 0;
        String str = "1";
        for (int i = 0; i < length; ++i) {
            str = str + "0";
        }
        range = Integer.parseInt(str);
        String sRandom = String.valueOf(Math.random() * (double)range);
        int index = sRandom.indexOf(".");
        if (index != -1) {
            randomIndex = Integer.parseInt(sRandom.substring(0, index));
        }
        if (randomIndex >= size) {
            return this.getRandomIndex(size);
        }
        return randomIndex;
    }

    private ArrayList getBizPKs(ForewarnObjectCollection forewarnObjects, Connection connection) throws Exception {
        ArrayList bizPKs = new ArrayList();
        int size = forewarnObjects.size();
        for (int i = 0; i < size; ++i) {
            ForewarnObjectInfo forewarnObjectInfo = forewarnObjects.get(i);
            if (forewarnObjectInfo.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT) || !forewarnObjectInfo.getMetadataType().equals((Object)MetadataType.ENTITY)) continue;
            ArrayList<ForewarnData> arrayList = new ArrayList<ForewarnData>();
            String oql = "";
            if (forewarnObjectInfo.getEntityViewInfo() != null) {
                oql = new String(CommonQueryUtil.getInnerFilterInfo((Context)this.currentCtx, (String)forewarnObjectInfo.getEntityViewInfo()));
            }
            ForewarnHelper helper = new ForewarnHelper(this.forewarnItemInfo);
            BOSObjectType type = ((EntityObjectInfo)this.businessEntities.get(forewarnObjectInfo.getName())).getType();
            IObjectPK[] objectPKs = helper.getPKList(this.businessEntities, this.currentCtx, connection, forewarnObjectInfo.getName(), oql);
            int length = objectPKs.length;
            ForewarnData data = new ForewarnData();
            for (int j = 0; j < length; ++j) {
                data.setAlias(forewarnObjectInfo.getAlias());
                data.setPk(objectPKs[j]);
                data.setBosType(type);
                arrayList.add(data);
            }
            bizPKs.add(arrayList);
        }
        return bizPKs;
    }

    private boolean isSimpleForewarn() {
        ForewarnHelper helper = new ForewarnHelper(this.forewarnItemInfo);
        return helper.isSimpleForewarn(this.businessEntities);
    }
}

