/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.forewarn.BaseForewarnAppException;
import com.kingdee.eas.base.forewarn.ForewarnConditionInfo;
import com.kingdee.eas.base.forewarn.ForewarnItemCollection;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnMessageInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnObjectInfo;
import com.kingdee.eas.base.forewarn.ForewarnReceiverCollection;
import com.kingdee.eas.base.forewarn.ForewarnReceiverInfo;
import com.kingdee.eas.base.forewarn.ForewarnScheduleInfo;
import com.kingdee.eas.base.forewarn.ForewarnThresholdCollection;
import com.kingdee.eas.base.forewarn.ForewarnThresholdInfo;
import com.kingdee.eas.base.forewarn.ForewarnUserDefineReceiversCollection;
import com.kingdee.eas.base.forewarn.ForewarnUserDefineReceiversInfo;
import com.kingdee.eas.base.forewarn.ItemState;
import com.kingdee.eas.base.forewarn.MutiLangeTool;
import com.kingdee.eas.base.forewarn.OrgUserInfo;
import com.kingdee.eas.base.forewarn.ReceiverType;
import com.kingdee.eas.base.forewarn.RightnowForewarnActionCollection;
import com.kingdee.eas.base.forewarn.RightnowForewarnActionInfo;
import com.kingdee.eas.base.forewarn.TouchType;
import com.kingdee.eas.base.forewarn.Type;
import com.kingdee.eas.base.forewarn.app.AbstractForewarnItemControllerBean;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ForewarnItemControllerBean
extends AbstractForewarnItemControllerBean {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.forewarn.app.ForewarnItemControllerBean");

    @Override
    protected ArrayList _getStaticReceiverAliases(Context ctx, IObjectCollection forewarnReceivers) throws BOSException, BaseForewarnAppException {
        ArrayList<DataObject> names = new ArrayList<DataObject>();
        Set receiverSet = this.getReceiverSet(forewarnReceivers);
        if (receiverSet == null || receiverSet.size() <= 0) {
            return names;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.forewarn.OrgUserQuery");
        IQueryExecutor executor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)receiverSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        executor.setObjectView(evi);
        IRowSet rowSet = executor.executeQuery();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("ID");
                String value = rowSet.getString("NAME") + "(" + rowSet.getString("NUMBER") + ")";
                DataObject dobj = new DataObject();
                dobj.setValue(id);
                dobj.setName(value);
                names.add(dobj);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getCause());
            throw new BaseForewarnAppException(BaseForewarnAppException.GET_RECEIVER_NAME_FAIL);
        }
        return names;
    }

    private EntityViewInfo getFilter(Set receiverSet) {
        EntityViewInfo evInfo = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        String ids = StringUtils.arrayToString((Object[])receiverSet.toArray(new String[0]), (String)",");
        if (StringUtils.isEmpty((String)ids)) {
            return evInfo;
        }
        fInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        evInfo.setFilter(fInfo);
        return evInfo;
    }

    private Set getReceiverSet(IObjectCollection forewarnReceivers) {
        HashSet<String> set = new HashSet<String>();
        int size = forewarnReceivers.size();
        ForewarnReceiverCollection receiverCollection = (ForewarnReceiverCollection)forewarnReceivers;
        for (int i = 0; i < size; ++i) {
            if (!receiverCollection.get(i).getReceiverType().equals((Object)ReceiverType.STATIC_USER) && !receiverCollection.get(i).getReceiverType().equals((Object)ReceiverType.STATIC_ORG)) continue;
            set.add(new String(receiverCollection.get(i).getValue()));
        }
        return set;
    }

    @Override
    protected boolean _setItemState(Context ctx, IObjectPK itemPK, ItemState state) throws BOSException, BaseForewarnAppException {
        try {
            ForewarnItemInfo forewarnItemInfo = this.getForewarnItemInfo(ctx, itemPK);
            forewarnItemInfo.setState(state);
            this.update(ctx, itemPK, (CoreBaseInfo)forewarnItemInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getCause());
            throw new BaseForewarnAppException(BaseForewarnAppException.SET_FOREWARN_ITEM_FAIL);
        }
        return true;
    }

    protected boolean existSameName(Context ctx, ForewarnItemInfo model) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("name", (Object)model.getName());
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("type", (Object)String.valueOf(model.getType().getValue()));
        filterInfo.getFilterItems().add(filterItemInfo);
        if (model.getId() != null) {
            filterItemInfo = new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 ");
        } else {
            filterInfo.setMaskString(" #0 AND #1 ");
        }
        entityViewInfo.setFilter(filterInfo);
        ForewarnItemCollection collection = this.getForewarnItemCollection(ctx, entityViewInfo);
        return collection != null && collection.size() > 0;
    }

    protected boolean existSameNumber(Context ctx, ForewarnItemInfo model) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("number", (Object)model.getNumber());
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("type", (Object)String.valueOf(model.getType().getValue()));
        filterInfo.getFilterItems().add(filterItemInfo);
        if (model.getId() != null) {
            filterItemInfo = new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 ");
        } else {
            filterInfo.setMaskString(" #0 AND #1 ");
        }
        entityViewInfo.setFilter(filterInfo);
        ForewarnItemCollection collection = this.getForewarnItemCollection(ctx, entityViewInfo);
        return collection != null && collection.size() > 0;
    }

    protected void checkIntegrity(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        if (model == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.ITEM_CAN_NOT_BE_NULL);
        }
        this.checkItemIntegrity(ctx, model);
        this.checkScheduleIntegrity(ctx, model);
        this.checkMessageIntegrity(ctx, model);
        this.checkObjectIntegrity(ctx, model);
        this.checkConditionIntegrity(ctx, model);
        this.checkReceiverIntegrity(ctx, model);
    }

    private void checkItemIntegrity(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        if (model.getName() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.NAME_CAN_BE_NULL);
        }
        if (model.getNumber() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.NUMBER_CAN_NOT_BE_NULL);
        }
        if (model.getState() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.STATE_CAN_NOT_BE_NULL);
        }
        if (model.getType() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.IS_TEMPLATE_CAN_NOT_BE_NULL);
        }
        if (model.getState().equals((Object)ItemState.ACTIVE) && model.getType().equals((Object)Type.ITEM) && TouchType.SCHEDULE_TYPE.equals((Object)model.getTouchType()) && model.getProcessDefID() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.PROCESS_DEF_ID_CAN_NOT_BE_NULL);
        }
        if (model.getType().equals((Object)Type.ITEM) && model.getTemplet() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.TEMPLATE_CAN_NOT_BE_NULL);
        }
    }

    private void checkScheduleIntegrity(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        TouchType tt = model.getTouchType();
        if (tt == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.TOUCHTYPE_IS_NULL);
        }
        if (tt.equals((Object)TouchType.SCHEDULE_TYPE) && (model.getSchedule() == null || model.getSchedule().getContent() == null)) {
            throw new BaseForewarnAppException(BaseForewarnAppException.SCHEDULE_CAN_NOT_BE_NULL);
        }
        if (tt.equals((Object)TouchType.RIGHTNOW_TYPE) && (model.getTouchAction() == null || model.getTouchAction().size() <= 0)) {
            throw new BaseForewarnAppException(BaseForewarnAppException.RIGHTNOWTOUCH_IS_NULL);
        }
    }

    private void checkMessageIntegrity(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        if (model.getMessage() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.MSG_CAN_NOT_BE_NULL);
        }
        if (model.getMessage().getTitleScript() == null && model.getMessage().getTitle() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.MSG_TITLE_CAN_NOT_BE_NULL);
        }
        if (model.getType().equals((Object)Type.ITEM) && model.getMessage().getBodyScript() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.MSG_CONTENT_CAN_NOT_BE_NULL);
        }
        if (model.getMessage().getPriority() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.MSG_PRIORITY_CAN_NOT_BE_NULL);
        }
    }

    private void checkObjectIntegrity(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        if (model.getObjects() == null || model.getObjects().size() == 0) {
            throw new BaseForewarnAppException(BaseForewarnAppException.OBJECT_CAN_NOT_BE_NULL);
        }
        int size = model.getObjects().size();
        for (int i = 0; i < size; ++i) {
            ForewarnObjectInfo objectInfo = model.getObjects().get(i);
            if (objectInfo.getName() == null) {
                throw new BaseForewarnAppException(BaseForewarnAppException.OBJECT_NAME_CAN_NOT_BE_NULL);
            }
            if (objectInfo.getAlias() == null) {
                throw new BaseForewarnAppException(BaseForewarnAppException.OBJECT_ALIAS_CAN_NOT_BE_NULL);
            }
            if (objectInfo.getType() == null) {
                throw new BaseForewarnAppException(BaseForewarnAppException.OBJECT_TYPE_CAN_NOT_BE_NULL);
            }
            if (objectInfo.getMetadataType() != null) continue;
            throw new BaseForewarnAppException(BaseForewarnAppException.OBJECT_METADATA_TYPE_CAN_NOT_BE_NULL);
        }
    }

    private void checkConditionIntegrity(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        if (model.getCondition() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.CONDITION_CAN_NOT_BE_NULL);
        }
        if (model.getCondition().getContentScript() == null) {
            throw new BaseForewarnAppException(BaseForewarnAppException.CONDITION_CONTENT_SCRIPT_CAN_NOT_BE_NULL);
        }
        if (model.getCondition().getThresholdCollection() != null) {
            this.checkThresholdIntegrity(ctx, model);
        }
    }

    private void checkThresholdIntegrity(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        if (model.getCondition().getThresholdCollection() != null) {
            Locale l2 = new Locale("L2");
            Locale l3 = new Locale("L3");
            int size = model.getCondition().getThresholdCollection().size();
            for (int i = 0; i < size; ++i) {
                ForewarnThresholdInfo thresholdInfo = model.getCondition().getThresholdCollection().get(i);
                if (thresholdInfo.getName() == null) {
                    throw new BaseForewarnAppException(BaseForewarnAppException.THRESHOLD_NAME_CAN_NOT_BE_NULL);
                }
                if (!l2.equals(ctx.getLocale()) && !l3.equals(ctx.getLocale())) {
                    thresholdInfo.setAlias(thresholdInfo.getAlias(), l2);
                    thresholdInfo.setAlias(thresholdInfo.getAlias(), l3);
                } else {
                    if (thresholdInfo.getAlias(l2) == null && thresholdInfo.getAlias(l3) == null) {
                        throw new BaseForewarnAppException(BaseForewarnAppException.THRESHOLD_ALIAS_CAN_NOT_BE_NULL);
                    }
                    if (thresholdInfo.getAlias(l2) == null && thresholdInfo.getAlias(l3) != null) {
                        thresholdInfo.setAlias(STConverter.tc2sc((String)thresholdInfo.getAlias(l3)), l2);
                    } else if (thresholdInfo.getAlias(l3) == null && thresholdInfo.getAlias(l2) != null) {
                        thresholdInfo.setAlias(STConverter.sc2tc((String)thresholdInfo.getAlias(l2)), l3);
                    }
                }
                if (thresholdInfo.getDataType() == null) {
                    throw new BaseForewarnAppException(BaseForewarnAppException.THRESHOLD_DATATYPE_CAN_NOT_BE_NULL);
                }
                if (thresholdInfo.getValue() != null) continue;
                throw new BaseForewarnAppException(BaseForewarnAppException.THRESHOLD_VALUE_NOT_BE_NULL);
            }
        }
    }

    private void checkReceiverIntegrity(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        if (model.getType().equals((Object)Type.ITEM)) {
            if (model.getReceivers() == null) {
                throw new BaseForewarnAppException(BaseForewarnAppException.RECEIVERS_CAN_NOT_BE_NULL);
            }
            int size = model.getReceivers().size();
            for (int i = 0; i < size; ++i) {
                ForewarnReceiverInfo receiverInfo = model.getReceivers().get(i);
                if (receiverInfo.getReceiverType() == null) {
                    throw new BaseForewarnAppException(BaseForewarnAppException.RECEIVER_TYPE_CAN_NOT_BE_NULL);
                }
                if (receiverInfo.getValue() != null) continue;
                throw new BaseForewarnAppException(BaseForewarnAppException.RECEIVER_VALUE_CAN_NOT_BE_NULL);
            }
        }
    }

    private void checkDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ForewarnItemInfo info = this.getForewarnItemInfo(ctx, pk);
        if (info.getType().equals((Object)Type.SYS_TEMPLATE)) {
            throw new BaseForewarnAppException(BaseForewarnAppException.SYS_TEMPLATE_CAN_NOT_DEL);
        }
        if (info.getType().equals((Object)Type.TEMPLATE) && this.checkHasItem(ctx, info)) {
            throw new BaseForewarnAppException(BaseForewarnAppException.TEMPLATE_IS_USING);
        }
    }

    private boolean checkHasItem(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("templet.id", (Object)model.getId().toString());
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("type", (Object)String.valueOf(0));
        filterInfo.getFilterItems().add(filterItemInfo);
        filterInfo.setMaskString("#0 and #1");
        entityViewInfo.setFilter(filterInfo);
        ForewarnItemCollection forewarnItemCollection = this.getForewarnItemCollection(ctx, entityViewInfo);
        return forewarnItemCollection.size() > 0;
    }

    private void checkName(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        if (this.existSameName(ctx, model)) {
            this.logger.info((Object)(" name is:" + model.getName()));
            throw new BaseForewarnAppException(BaseForewarnAppException.NAME_IS_EXISTED);
        }
    }

    private void checkNumber(Context ctx, ForewarnItemInfo model) throws BOSException, EASBizException {
        if (this.existSameNumber(ctx, model)) {
            this.logger.info((Object)(" number is:" + model.getNumber()));
            throw new BaseForewarnAppException(BaseForewarnAppException.NUMBER_IS_EXISTED);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ForewarnItemInfo info = (ForewarnItemInfo)model;
        this.checkIntegrity(ctx, info);
        this.checkName(ctx, info);
        this.checkNumber(ctx, info);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ForewarnItemInfo info = (ForewarnItemInfo)model;
        this.checkIntegrity(ctx, info);
        this.checkName(ctx, info);
        this.checkNumber(ctx, info);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ForewarnItemInfo info = (ForewarnItemInfo)model;
        if (!this.isEnableOrDisable(ctx, pk, model)) {
            this.checkIntegrity(ctx, info);
            this.checkName(ctx, info);
            this.checkNumber(ctx, info);
        }
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    @Override
    protected IRowSet _getUserOrg(Context ctx) throws BOSException {
        StringBuffer sbSql = new StringBuffer();
        IQueryExecutor userExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.forewarn.UserQuery"));
        EntityViewInfo userEntityView = new EntityViewInfo();
        FilterInfo userFilter = new FilterInfo();
        userFilter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)String.valueOf(1), CompareType.NOTEQUALS));
        userFilter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)String.valueOf(1), CompareType.NOTEQUALS));
        userFilter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), CompareType.LESS_EQUALS));
        userFilter.getFilterItems().add(new FilterItemInfo("invalidationDate", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), CompareType.GREATER));
        userFilter.setMaskString(" #0 and #1 and ( #2 and #3 ) ");
        userEntityView.setFilter(userFilter);
        userExecutor.setObjectView(userEntityView);
        sbSql.append(userExecutor.getSQL()).append(" UNION ");
        IQueryExecutor orgExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.forewarn.OrgQuery"));
        orgExecutor.setObjectView(new EntityViewInfo());
        sbSql.append(orgExecutor.getSQL()).append(" ORDER BY \"NAME\" ASC");
        return DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
    }

    @Override
    protected Set _getInvalidUsers(Context ctx) throws BOSException {
        HashSet<String> invalidUsers = new HashSet<String>();
        IUser user = UserFactory.getLocalInstance((Context)ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)String.valueOf(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isLocked", (Object)String.valueOf(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("invalidationDate", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), CompareType.LESS_EQUALS));
        filterInfo.setMaskString(" #0 or #1 or ( #2 and #3 ) ");
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        UserCollection collection = user.getUserCollection(entityViewInfo);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            invalidUsers.add(collection.get(i).getId().toString());
        }
        return invalidUsers;
    }

    @Override
    protected OrgUserInfo[] _getOrgUserCollection(Context ctx) throws BOSException, BaseForewarnAppException {
        String sqlCU = "SELECT FID FROM T_ORG_ADMIN WHERE FPARENTID IS NULL ";
        IRowSet rsCU = DbUtil.executeQuery((Context)ctx, (String)sqlCU);
        String cuId = null;
        try {
            if (rsCU.next()) {
                cuId = rsCU.getString("FID");
            }
        }
        catch (SQLException e1) {
            this.logger.error((Object)e1);
        }
        return this.getOrgUserCollection(ctx, cuId);
    }

    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ForewarnItemInfo info = this.getForewarnItemInfo(ctx, pk);
        if (info != null) {
            return StringUtils.cnulls((String)info.getNumber()) + "  " + StringUtils.cnulls((String)info.getName());
        }
        return "";
    }

    private boolean isEnableOrDisable(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, BaseForewarnAppException, EASBizException {
        ForewarnItemInfo info = this.getForewarnItemInfo(ctx, pk);
        return !info.getState().equals((Object)((ForewarnItemInfo)model).getState());
    }

    @Override
    protected IObjectPK _saveAs(Context ctx, IObjectValue forewarnTemplate) throws BOSException, BaseForewarnAppException, EASBizException {
        ForewarnItemInfo info = (ForewarnItemInfo)forewarnTemplate;
        String id = forewarnTemplate.get("id").toString();
        ObjectStringPK pk = new ObjectStringPK(id);
        ForewarnItemInfo origin = this.getForewarnItemInfo(ctx, (IObjectPK)pk);
        ForewarnItemInfo dest = (ForewarnItemInfo)origin.clone();
        dest.setId(null);
        MutiLangeTool.copyMultiLangProperty(ctx, (IObjectValue)info, (IObjectValue)dest, "name");
        dest.setNumber(info.getNumber());
        dest.setCU(null);
        dest.setCreator(null);
        dest.setCreateTime(null);
        dest.setType(Type.TEMPLATE);
        ForewarnScheduleInfo scheduleInfo = null;
        if (origin.getSchedule() != null) {
            scheduleInfo = (ForewarnScheduleInfo)origin.getSchedule().clone();
            scheduleInfo.setId(null);
            scheduleInfo.setCU(null);
        }
        dest.setSchedule(scheduleInfo);
        ForewarnMessageInfo messageInfo = (ForewarnMessageInfo)origin.getMessage().clone();
        messageInfo.setId(null);
        messageInfo.setCU(null);
        dest.setMessage(messageInfo);
        ForewarnConditionInfo conditionInfo = (ForewarnConditionInfo)origin.getCondition().clone();
        conditionInfo.setId(null);
        ForewarnThresholdCollection thresholdCol = conditionInfo.getThresholdCollection();
        for (int i = 0; i < thresholdCol.size(); ++i) {
            ForewarnThresholdInfo thresholdInfo = thresholdCol.get(i);
            thresholdInfo.setId(null);
        }
        dest.setCondition(conditionInfo);
        ForewarnReceiverCollection receiverCol = dest.getReceivers();
        for (int i = 0; i < receiverCol.size(); ++i) {
            ForewarnReceiverInfo receiverInfo = receiverCol.get(i);
            receiverInfo.setId(null);
        }
        ForewarnUserDefineReceiversCollection dynReceiverCol = dest.getDynReceivers();
        if (dynReceiverCol != null && dynReceiverCol.size() > 0) {
            for (int i = 0; i < dynReceiverCol.size(); ++i) {
                ForewarnUserDefineReceiversInfo dynReciverInfo = dynReceiverCol.get(i);
                dynReciverInfo.setId(null);
            }
        }
        ForewarnObjectCollection objectCol = dest.getObjects();
        for (int i = 0; i < objectCol.size(); ++i) {
            ForewarnObjectInfo objectInfo = objectCol.get(i);
            objectInfo.setId(null);
        }
        RightnowForewarnActionCollection rightnowFwActionCol = dest.getTouchAction();
        for (int j = 0; j < rightnowFwActionCol.size(); ++j) {
            RightnowForewarnActionInfo rightnowFwActionInfo = rightnowFwActionCol.get(j);
            rightnowFwActionInfo.setId(null);
        }
        IObjectPK objectPK = this.addnew(ctx, (CoreBaseInfo)dest);
        return objectPK;
    }

    @Override
    protected OrgUserInfo[] _getOrgUserCollection(Context ctx, String orgId) throws BOSException, BaseForewarnAppException {
        String postfix = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer("SELECT a.FID as orgUserID,b.FLongNumber as longNumber,a.FNumber as number,a.FName_" + postfix + " as orgUserName,a.FDefOrgUnitID as parentID,1 as isLeaf,'1' as userOrOrg,10000 as orgUserLevel").append(" FROM T_PM_User a inner join t_org_admin b on a.FDefOrgUnitID = b.FId where a.FIsDelete != 1 and a.FForbidden != 1 and a.FType != 60 and a.FAgentUser != 1 ").append(" union all ").append(" SELECT FID as orgUserID,FLongNumber as longNumber,FNumber as number,FName_" + postfix + " as orgUserName,FParentID as parentID,FIsLeaf as isLeaf,'0' as userOrOrg,FLevel as orgUserLevel").append(" FROM T_ORG_Admin");
        IRowSet rs = null;
        Connection conn = null;
        String temptable = null;
        ArrayList<OrgUserInfo> result = new ArrayList<OrgUserInfo>();
        try {
            int rowNum = 0;
            temptable = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String tempInsert = "select * into " + temptable + " from (" + sql.toString() + ") temp";
            DbUtil.execute((Context)ctx, (String)tempInsert);
            rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) as count from " + temptable));
            while (rs.next()) {
                rowNum = rs.getInt("count");
            }
            int pages = rowNum / 10000 + 1;
            PagingHelper pageHelper = new PagingHelper();
            conn = EJBFactory.getConnection((Context)ctx);
            String selectSql = "SELECT * FROM " + temptable + " ORDER BY ORGUSERLEVEL ASC,LONGNUMBER ASC";
            String querySql = null;
            for (int i = 0; i < pages; ++i) {
                querySql = pageHelper.getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), selectSql, i * 10000, 10000);
                rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
                OrgUserInfo info = null;
                while (rs.next()) {
                    info = new OrgUserInfo();
                    info.setOrgUserID(rs.getString("orgUserID"));
                    info.setOrgUserName(rs.getString("orgUserName"));
                    info.setParentID(rs.getString("parentID"));
                    info.setUserOrOrg(rs.getString("userOrOrg"));
                    info.setIsLeaf(rs.getString("isLeaf"));
                    info.setOrgUserLevel(rs.getString("orgUserLevel"));
                    info.setNumber(rs.getString("number"));
                    if ("1".equals(info.getUserOrOrg())) {
                        info.setLongNumber(rs.getString("longNumber") + "!" + info.getNumber());
                    } else {
                        info.setLongNumber(rs.getString("longNumber"));
                    }
                    result.add(info);
                }
            }
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
                if (temptable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(temptable);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (temptable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(temptable);
        }
        return result.toArray(new OrgUserInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected List _searchOrgUser(Context ctx, String displayName) throws BOSException, BaseForewarnAppException {
        String postfix = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer("SELECT b.FLongNumber as longNumber,a.FNumber as number, '1' as userOrOrg,10000 as orgUserLevel").append(" FROM T_PM_User a inner join t_org_admin b on a.FDefOrgUnitID = b.FId where a.FIsDelete != 1 and a.FForbidden != 1 and a.FType != 60 and a.FAgentUser != 1 and (a.FNumber like '%" + displayName + "%' or a.Fname_" + postfix + " like '%" + displayName + "%')").append(" union ").append(" SELECT FLongNumber as longNumber , FNumber as number, '0' as userOrOrg,FLevel as orgUserLevel").append(" FROM T_ORG_Admin  where (FNumber like '%" + displayName + "%' or Fname_" + postfix + " like '%" + displayName + "%')ORDER BY orgUserLevel,longNumber");
        IRowSet rs = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if ("1".equals(rs.getString("userOrOrg"))) {
                    result.add(rs.getString("longNumber") + "!" + rs.getString("number"));
                    continue;
                }
                result.add(rs.getString("longNumber"));
            }
        }
        catch (BOSException e) {
            this.logger.error((Object)e);
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (SQLException e2) {
            this.logger.error((Object)e2);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return result;
    }
}

