/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.forewarn.DataType;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectType;
import com.kingdee.eas.base.forewarn.ForewarnThresholdInfo;
import com.kingdee.eas.base.forewarn.MetadataType;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ForewarnRunContext {
    protected Context ctx;
    private ForewarnItemInfo forewarnItemInfo = null;
    private Map businessFacades = null;
    private Map businessCollections = null;
    private IVarInfo[] varInfos = null;

    public ForewarnRunContext() {
    }

    public ForewarnRunContext(Context ctx, ForewarnItemInfo forewarnItemInfo, Map businessCollections, Map businessFacades) {
        this(ctx, forewarnItemInfo, businessCollections, businessFacades, null);
    }

    public ForewarnRunContext(Context ctx, ForewarnItemInfo forewarnItemInfo, Map businessCollections, Map businessFacades, IVarInfo[] forewarnVars) {
        this.forewarnItemInfo = forewarnItemInfo;
        this.ctx = ctx;
        this.businessCollections = businessCollections;
        this.businessFacades = businessFacades;
        this.varInfos = forewarnVars;
    }

    public Map getFormulaContext(ArrayList units, String formula, IVarInfo[] forewarnVars) throws ParseException, BOSException {
        HashMap expressionContext = new HashMap();
        if (forewarnVars != null && forewarnVars.length > 0) {
            this.setBizObjects(units, forewarnVars, expressionContext);
            this.setBizCollections(forewarnVars, expressionContext);
            this.setBizFacades(expressionContext);
        }
        this.setThreshods(expressionContext);
        return expressionContext;
    }

    public Map getFormulaContext(ArrayList units, String formula) throws ParseException, BOSException {
        return this.getFormulaContext(units, formula, this.varInfos);
    }

    public void setBizObjects(ArrayList units, IVarInfo[] vars, Map expressionContext) {
        if (units != null) {
            int instanceSize = units.size();
            int length = vars.length;
            block0: for (int i = 0; i < instanceSize; ++i) {
                IObjectValue objectValue = (IObjectValue)units.get(i);
                for (int j = 0; j < length; ++j) {
                    if (!vars[j].getVarType().equalsIgnoreCase(objectValue.getClass().getName())) continue;
                    expressionContext.put(vars[j].getVarName(), objectValue);
                    continue block0;
                }
            }
        }
    }

    private void setBizCollections(IVarInfo[] vars, Map expressionContext) throws BOSException {
        int entitySize = this.forewarnItemInfo.getObjects().size();
        int length = vars.length;
        block0: for (int i = 0; i < entitySize; ++i) {
            ForewarnObjectInfo forewarnObjectInfo = this.forewarnItemInfo.getObjects().get(i);
            if (!forewarnObjectInfo.getType().equals((Object)ForewarnObjectType.COLLECTION_OBJECT)) continue;
            for (int j = 0; j < length; ++j) {
                if (!vars[j].getVarAlias().equalsIgnoreCase(forewarnObjectInfo.getAlias())) continue;
                expressionContext.put(vars[j].getVarName(), this.businessCollections.get(forewarnObjectInfo.getAlias()));
                continue block0;
            }
        }
    }

    private void setBizFacades(Map expressionContext) throws BOSException {
        int entitySize = this.forewarnItemInfo.getObjects().size();
        for (int i = 0; i < entitySize; ++i) {
            ForewarnObjectInfo forewarnObjectInfo = this.forewarnItemInfo.getObjects().get(i);
            if (!forewarnObjectInfo.getMetadataType().equals((Object)MetadataType.FACADE)) continue;
            FacadeInfo facadeInfo = (FacadeInfo)this.businessFacades.get(this.forewarnItemInfo.getObjects().get(i).getName());
            IBOSObject bizFacade = BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)facadeInfo.getType());
            expressionContext.put(facadeInfo.getName(), bizFacade);
        }
    }

    private void setThreshods(Map expressionContext) throws ParseException {
        int thresholdSize = this.forewarnItemInfo.getCondition().getThresholdCollection().size();
        for (int i = 0; i < thresholdSize; ++i) {
            ForewarnThresholdInfo forewarnThresholdInfo = this.forewarnItemInfo.getCondition().getThresholdCollection().get(i);
            String thresholdName = forewarnThresholdInfo.getName();
            DataType dataType = forewarnThresholdInfo.getDataType();
            String value = forewarnThresholdInfo.getValue();
            Object bizValue = null;
            if (dataType.equals((Object)DataType.STRING)) {
                bizValue = value;
            } else if (dataType.equals((Object)DataType.INT)) {
                bizValue = new Integer(value);
            } else if (dataType.equals((Object)DataType.DOUBLE)) {
                bizValue = new Double(value);
            } else if (dataType.equals((Object)DataType.LONG)) {
                bizValue = new Long(value);
            } else if (dataType.equals((Object)DataType.BIGDECIMAL)) {
                bizValue = new BigDecimal(value);
            } else if (dataType.equals((Object)DataType.BOOLEAN)) {
                bizValue = new Boolean(value);
            } else if (dataType.equals((Object)DataType.DATE)) {
                bizValue = DateTimeUtils.parseDate((String)value);
            }
            expressionContext.put(thresholdName, bizValue);
        }
    }
}

