/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.formula.api.FormulaVarUtil;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.eas.base.forewarn.BaseForewarnAppException;
import com.kingdee.eas.base.forewarn.ForewarnItemInfo;
import com.kingdee.eas.base.forewarn.ForewarnObjectCollection;
import com.kingdee.eas.base.forewarn.ForewarnObjectType;
import com.kingdee.eas.base.forewarn.ForewarnReceiverCollection;
import com.kingdee.eas.base.forewarn.ForewarnReceiverInfo;
import com.kingdee.eas.base.forewarn.ReceiverType;
import com.kingdee.eas.base.forewarn.app.ForewarnFormulaAdapter;
import com.kingdee.eas.base.forewarn.app.ForewarnRunContext;
import com.kingdee.eas.base.forewarn.app.SSCForewarnUtil;
import com.kingdee.eas.base.forewarn.app.rolereceiver.MainOrgValueUtil;
import com.kingdee.eas.base.forewarn.app.rolereceiver.UserRoleManager;
import com.kingdee.eas.base.forewarn.utils.ForewarnScheduleUtil;
import com.kingdee.eas.base.param.INantionalServiceFacade;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ForewarnUserInfo {
    Logger logger = Logger.getLogger((String)ForewarnUserInfo.class.getName());
    private static final String bizClass = "com.kingdee.eas.hr.base.timezone.TimeZoneFetcherForewarn";
    Context ctx;
    private static long betweenTime = 1800000L;
    private Map adminOrgUsers = null;
    private Map positionUsers = null;
    private IVarInfo[] forewarnVars = null;
    private Map businessEntities = null;
    private ForewarnItemInfo forewarnItemInfo = null;
    Set setUsers = new HashSet();
    Set setMobile = new HashSet();
    Set setEMail = new HashSet();
    Set setCopyEMail = new HashSet();
    Set setWeiboReceivers = new HashSet();
    Set cloudUserSet = new HashSet();
    Map<String, String> userTimeZoneMap = new HashMap<String, String>();
    Map<String, String> readyUserTimeZoneMap = new HashMap<String, String>();

    public ForewarnUserInfo() {
    }

    public ForewarnUserInfo(Context ctx, Map adminOrgUsers, Map positionUsers, IVarInfo[] forewarnVars, Map businessEntities) throws BaseForewarnAppException, BOSException {
        this.ctx = ctx;
        this.adminOrgUsers = adminOrgUsers;
        this.positionUsers = positionUsers;
        this.forewarnVars = forewarnVars;
        this.businessEntities = businessEntities;
    }

    private static String getEMail(Context ctx, String userid) throws Exception {
        String personID = ForewarnUserInfo.getPersonID(ctx, userid);
        if (personID == null || personID.equals("")) {
            return null;
        }
        SelectorItemCollection sColl = new SelectorItemCollection();
        sColl.add(new SelectorItemInfo("email"));
        IPerson person = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo pInfo = person.getPersonInfo((IObjectPK)new ObjectUuidPK(personID), sColl);
        if (pInfo != null) {
            return pInfo.getEmail();
        }
        return null;
    }

    public static String getPersonID(Context ctx, String userID) throws BOSException, EASBizException {
        IUser user = UserFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sColl = new SelectorItemCollection();
        sColl.add(new SelectorItemInfo("person"));
        UserInfo userInfo = user.getUserInfo((IObjectPK)new ObjectStringPK(userID), sColl);
        if (userInfo != null && userInfo.getPerson() != null) {
            return userInfo.getPerson().getId().toString();
        }
        return null;
    }

    public static boolean isAdmin(Context ctx) {
        return "00000000-0000-0000-0000-00000000000013B7DE7F".equals(ctx.getCaller().toString());
    }

    public static String getMobile(Context ctx, String userID) throws BOSException, EASBizException {
        String personID = ForewarnUserInfo.getPersonID(ctx, userID);
        if (personID == null || personID.equals("")) {
            return null;
        }
        SelectorItemCollection sColl = new SelectorItemCollection();
        sColl.add(new SelectorItemInfo("cell"));
        IPerson person = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo pInfo = person.getPersonInfo((IObjectPK)new ObjectUuidPK(personID), sColl);
        if (pInfo != null) {
            return pInfo.getCell();
        }
        return null;
    }

    public void dealDynReceiver(ArrayList oneUnit, ForewarnItemInfo forewarnItemInfo, Set userFilter, ForewarnRunContext runContext, Object isNotTestForewarn) throws Exception {
        String curUser;
        this.forewarnItemInfo = forewarnItemInfo;
        int size = forewarnItemInfo.getReceivers().size();
        boolean isNeedSendMobile = false;
        boolean isNeedSendEMail = false;
        boolean isNeedSendWeibo = false;
        boolean isNeedSendCloud = false;
        if (forewarnItemInfo.getMessage() != null && forewarnItemInfo.getMessage().isNeedSendMobile()) {
            isNeedSendMobile = true;
        }
        if (forewarnItemInfo.getMessage() != null && forewarnItemInfo.getMessage().isNeedSendWeibo()) {
            isNeedSendWeibo = true;
        }
        if (forewarnItemInfo.getMessage() != null && forewarnItemInfo.getMessage().isNeedSendEMail()) {
            isNeedSendEMail = true;
        }
        if (forewarnItemInfo.getMessage() != null && forewarnItemInfo.getMessage().isNeedSendCloud()) {
            isNeedSendCloud = true;
        }
        boolean isNeedMultipleTimeZoom = forewarnItemInfo.isNeedMultipleTimeZoom();
        Set formulaReceivers = this.getFormulaReceivers(oneUnit, forewarnItemInfo, userFilter, runContext);
        if (formulaReceivers != null && formulaReceivers.size() > 0) {
            Iterator fiterator = formulaReceivers.iterator();
            while (fiterator.hasNext()) {
                curUser = fiterator.next().toString();
                if (curUser.isEmpty() || this.setUsers.contains(curUser)) continue;
                this.setUsers.add(curUser);
            }
            for (String userId : this.setUsers) {
                String email;
                if (!forewarnItemInfo.getMessage().isNeedSendEMail() || (email = this.reciverEmail(userId)) == null || this.setEMail.contains(email)) continue;
                this.setEMail.add(email);
            }
        }
        this.initCommonReceivers(oneUnit, forewarnItemInfo, userFilter);
        if (isNeedMultipleTimeZoom && isNotTestForewarn != null) {
            Iterator iterator = this.setUsers.iterator();
            HashSet<String> newSetUsers = new HashSet<String>();
            while (iterator.hasNext()) {
                String curUser2 = iterator.next().toString();
                String newUser = this.getUserByTimeZoomTransform(curUser2, forewarnItemInfo);
                if (newUser == null) continue;
                newSetUsers.add(newUser);
            }
            this.setUsers = newSetUsers;
        }
        if (isNeedSendMobile) {
            Iterator it = this.setUsers.iterator();
            while (it.hasNext()) {
                curUser = it.next().toString();
                String mobile = null;
                mobile = curUser.indexOf(SSCForewarnUtil.SSC_FOREWARN) >= 0 ? SSCForewarnUtil.getOtherSySMobile(this.ctx, curUser) : ForewarnUserInfo.getMobile(this.ctx, curUser);
                if (this.setMobile.contains(mobile)) continue;
                this.setMobile.add(mobile);
            }
        }
        this.addSetWeiboReceivers(isNeedSendWeibo);
        this.addSetCloudReceivers(this.ctx, isNeedSendCloud);
    }

    private void addSetCloudReceivers(Context ctx, boolean isNeedSendCloud) {
        if (isNeedSendCloud) {
            try {
                Class<?> classObj = Class.forName("com.kingdee.eas.base.permission.app.UserControllerBean");
                Object o = classObj.newInstance();
                Method method = classObj.getMethod("getUserInfo", Context.class, IObjectPK.class);
                Iterator it = this.setUsers.iterator();
                while (it.hasNext()) {
                    String curUserId = it.next().toString();
                    UserInfo userInfo = (UserInfo)method.invoke(o, ctx, new ObjectUuidPK(curUserId));
                    this.cloudUserSet.add(userInfo);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private Map getEasXtIdByUserIds(Set userIds) {
        HashMap<String, String> userXtIdMap = new HashMap<String, String>();
        String sql = "Select fxtid,fuserid from t_pm_easxtusermap where fuserid in (" + ToolUtils.aryToStr((Collection)userIds) + ")";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                userXtIdMap.put(rs.getString("Fuserid"), rs.getString("fxtid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return userXtIdMap;
    }

    private void addSetWeiboReceivers(boolean isNeedSendWeibo) throws EASBizException, BOSException {
        if (isNeedSendWeibo) {
            Iterator it = this.setUsers.iterator();
            while (it.hasNext()) {
                String curUser = it.next().toString();
                String personId = ForewarnUserInfo.getPersonID(this.ctx, curUser);
                if (personId == null || this.setWeiboReceivers.contains(personId)) continue;
                this.setWeiboReceivers.add(personId);
            }
        }
    }

    private void initCommonReceivers(ArrayList oneUnit, ForewarnItemInfo forewarnItemInfo, Set userFilter, Object isNotTestForewarn) throws Exception {
        ForewarnReceiverCollection frColl = forewarnItemInfo.getReceivers();
        int size = frColl.size();
        boolean isNeedSendEMail = forewarnItemInfo.getMessage().isNeedSendEMail();
        boolean isNeedMultipleTimeZoom = forewarnItemInfo.isNeedMultipleTimeZoom();
        for (int i = 0; i < size; ++i) {
            ForewarnReceiverInfo receiverInfo = forewarnItemInfo.getReceivers().get(i);
            String curUser = this.getUser(receiverInfo, oneUnit, userFilter);
            if (isNeedMultipleTimeZoom && isNotTestForewarn != null && (curUser = this.getUserByTimeZoomTransform(curUser, forewarnItemInfo)) == null) continue;
            String[] userIds = null;
            if (!StringUtils.isEmpty((String)curUser)) {
                userIds = curUser.split("\\;");
            }
            if (userIds == null || userIds.length <= 0) continue;
            for (int j = 0; j < userIds.length; ++j) {
                String email;
                String userId = userIds[j];
                if (StringUtils.isEmpty((String)userId)) continue;
                if (!receiverInfo.isIsCopyReceiver()) {
                    if (!this.setUsers.contains(userId)) {
                        this.setUsers.add(userId);
                    }
                    if (!isNeedSendEMail || (email = this.reciverEmail(userId)) == null || this.setEMail.contains(email)) continue;
                    this.setEMail.add(email);
                    continue;
                }
                email = this.reciverEmail(userId);
                if (email == null || this.setCopyEMail.contains(email)) continue;
                this.setCopyEMail.add(email);
            }
        }
    }

    private void initCommonReceivers(ArrayList oneUnit, ForewarnItemInfo forewarnItemInfo, Set userFilter) throws Exception {
        ForewarnReceiverCollection frColl = forewarnItemInfo.getReceivers();
        int size = frColl.size();
        boolean isNeedSendEMail = forewarnItemInfo.getMessage().isNeedSendEMail();
        boolean isNeedMultipleTimeZoom = forewarnItemInfo.isNeedMultipleTimeZoom();
        for (int i = 0; i < size; ++i) {
            ForewarnReceiverInfo receiverInfo = forewarnItemInfo.getReceivers().get(i);
            String curUser = this.getUser(receiverInfo, oneUnit, userFilter);
            String[] userIds = null;
            if (!StringUtils.isEmpty((String)curUser)) {
                userIds = curUser.split("\\;");
            }
            if (userIds == null || userIds.length <= 0) continue;
            for (int j = 0; j < userIds.length; ++j) {
                String email;
                String userId = userIds[j];
                if (StringUtils.isEmpty((String)userId)) continue;
                if (!receiverInfo.isIsCopyReceiver()) {
                    if (!this.setUsers.contains(userId)) {
                        this.setUsers.add(userId);
                    }
                    if (!isNeedSendEMail || (email = this.reciverEmail(userId)) == null || this.setEMail.contains(email)) continue;
                    this.setEMail.add(email);
                    continue;
                }
                email = this.reciverEmail(userId);
                if (email == null || this.setCopyEMail.contains(email)) continue;
                this.setCopyEMail.add(email);
            }
        }
    }

    private String reciverEmail(String userId) throws Exception {
        String email = null;
        email = userId.indexOf(SSCForewarnUtil.SSC_FOREWARN) >= 0 ? SSCForewarnUtil.getOtherSySEmail(this.ctx, userId) : ForewarnUserInfo.getEMail(this.ctx, userId);
        return email;
    }

    public void dealReceiver(ArrayList unit, ForewarnItemInfo forewarnItemInfo, Set userFilter, Object isNotTestForewarn) throws Exception {
        int size = forewarnItemInfo.getReceivers().size();
        boolean isNeedSendMobile = false;
        boolean isNeedSendWeibo = false;
        boolean isNeedSendCloud = false;
        if (forewarnItemInfo.getMessage() != null && forewarnItemInfo.getMessage().isNeedSendMobile()) {
            isNeedSendMobile = true;
        }
        if (forewarnItemInfo.getMessage() != null && forewarnItemInfo.getMessage().isNeedSendWeibo()) {
            isNeedSendWeibo = true;
        }
        if (forewarnItemInfo.getMessage() != null && forewarnItemInfo.getMessage().isNeedSendCloud()) {
            isNeedSendCloud = true;
        }
        this.initCommonReceivers(unit, forewarnItemInfo, userFilter, isNotTestForewarn);
        if (isNeedSendMobile) {
            Iterator it = this.setUsers.iterator();
            while (it.hasNext()) {
                String curUser = it.next().toString();
                String mobile = ForewarnUserInfo.getMobile(this.ctx, curUser);
                if (this.setMobile.contains(mobile)) continue;
                this.setMobile.add(mobile);
            }
        }
        this.addSetWeiboReceivers(isNeedSendWeibo);
        this.addSetCloudReceivers(this.ctx, isNeedSendCloud);
    }

    private Set getFormulaReceivers(ArrayList unit, ForewarnItemInfo forewarnItemInfo, Set userFilter, ForewarnRunContext runContext) throws Exception {
        if (forewarnItemInfo.getDynReceivers() == null || forewarnItemInfo.getDynReceivers().size() <= 0) {
            return null;
        }
        String dynScript = forewarnItemInfo.getDynReceivers().get(0).getContentScript();
        if (dynScript == null || dynScript.equals("")) {
            return null;
        }
        Map dynContext = runContext.getFormulaContext(unit, dynScript);
        ForewarnFormulaAdapter formulaAdapter = new ForewarnFormulaAdapter(this.ctx);
        Object o = formulaAdapter.execScript(dynScript, dynContext, null);
        HashSet<String> userSet = null;
        if (o instanceof Set) {
            userSet = (HashSet<String>)o;
        } else if (o instanceof String) {
            String tmp = (String)o;
            String[] users = tmp.split(";");
            userSet = new HashSet();
            for (int i = 0; i < users.length; ++i) {
                userSet.add(users[i]);
            }
        } else if (o instanceof UserInfo) {
            userSet = new HashSet<String>();
            userSet.add((String)((UserInfo)o).getId());
        } else if (o instanceof BOSUuid) {
            userSet = new HashSet();
            userSet.add(o.toString());
        } else if (o instanceof String[]) {
            userSet = new HashSet();
            String[] userIds = (String[])o;
            for (int index = 0; index < userIds.length; ++index) {
                userSet.add(userIds[index]);
            }
        }
        if (userSet != null) {
            userSet.removeAll(userFilter);
        }
        return userSet;
    }

    public String getMailUserList() {
        return this.set2String(this.setUsers);
    }

    public String getMobileList() {
        return this.set2String(this.setMobile);
    }

    public String getEMailReceiverList() {
        return this.set2String(this.setEMail);
    }

    public String getCopyEMailReceiverList() {
        return this.set2String(this.setCopyEMail);
    }

    private String set2String(Set setUsers) {
        if (setUsers == null || setUsers.isEmpty()) {
            return "";
        }
        StringBuffer receivers = new StringBuffer();
        for (Object obj : setUsers) {
            if (obj == null) continue;
            receivers.append(obj.toString()).append(";");
        }
        String users = receivers.toString();
        if (!StringUtils.isEmpty((String)users) && users.endsWith(";") && users.trim().length() > 0) {
            users = users.substring(0, users.length() - 1);
        }
        return users;
    }

    private String getUser(ForewarnReceiverInfo receiverInfo, ArrayList unit, Set userFilter) throws Exception {
        String retString;
        block7: {
            ReceiverType recType;
            block12: {
                UserCollection coll;
                Set userSet;
                Set lastUserSet;
                block11: {
                    block10: {
                        Map dynamicUserContext;
                        block9: {
                            block8: {
                                block6: {
                                    retString = null;
                                    recType = receiverInfo.getReceiverType();
                                    if (!recType.equals((Object)ReceiverType.STATIC_ORG)) break block6;
                                    ArrayList orgUsers = this.getUserIDsByAdminOrgUnit(new String(receiverInfo.getValue()));
                                    int orgUserSize = orgUsers.size();
                                    for (int j = 0; j < orgUserSize; ++j) {
                                        String orgUserID = orgUsers.get(j).toString();
                                        if (userFilter.contains(orgUserID)) continue;
                                        retString = orgUserID;
                                    }
                                    break block7;
                                }
                                if (!recType.equals((Object)ReceiverType.STATIC_USER)) break block8;
                                String staticUserID = new String(receiverInfo.getValue());
                                if (userFilter.contains(staticUserID)) break block7;
                                retString = staticUserID;
                                break block7;
                            }
                            if (!recType.equals((Object)ReceiverType.DYNAMIC_ORG)) break block9;
                            String dynamicOrgScript = this.getDynamicReceiverScript(unit, receiverInfo);
                            Map dynamicOrgContext = this.getDynReceiverContext(unit, dynamicOrgScript);
                            ForewarnFormulaAdapter formulaAdapter = new ForewarnFormulaAdapter(this.ctx);
                            String orgID = formulaAdapter.execScript(dynamicOrgScript, dynamicOrgContext, null).toString();
                            ArrayList orgUsers = this.getUserIDsByAdminOrgUnit(orgID);
                            int orgUserSize = orgUsers.size();
                            for (int j = 0; j < orgUserSize; ++j) {
                                String orgUserID = orgUsers.get(j).toString();
                                if (userFilter.contains(orgUserID)) continue;
                                retString = orgUserID;
                            }
                            break block7;
                        }
                        if (!recType.equals((Object)ReceiverType.DYNAMIC_USER)) break block10;
                        ForewarnFormulaAdapter formulaAdapter = new ForewarnFormulaAdapter(this.ctx);
                        String dynamicUserScript = this.getDynamicReceiverScript(unit, receiverInfo);
                        String userID = formulaAdapter.execScript(dynamicUserScript, dynamicUserContext = this.getDynReceiverContext(unit, dynamicUserScript), null).toString();
                        if (userFilter.contains(userID)) break block7;
                        retString = userID;
                        break block7;
                    }
                    if (!recType.equals((Object)ReceiverType.DYNAMIC_PEOPLE)) break block11;
                    String dynamicUserScript = this.getDynamicReceiverScript(unit, receiverInfo);
                    Map dynamicUserContext = this.getDynReceiverContext(unit, dynamicUserScript);
                    ForewarnFormulaAdapter formulaAdapter = new ForewarnFormulaAdapter(this.ctx);
                    String personID = formulaAdapter.execScript(dynamicUserScript, dynamicUserContext, null).toString();
                    this.logger.info((Object)("....111111111....... personId is:" + personID));
                    if (StringUtils.isEmpty((String)personID)) break block7;
                    Set userSet2 = this.getUserByPerson(personID);
                    Set lastUserSet2 = this.filterSet(userFilter, userSet2);
                    retString = this.set2String(lastUserSet2);
                    this.logger.info((Object)("........... userid is:" + retString));
                    break block7;
                }
                if (!recType.equals((Object)ReceiverType.Role)) break block12;
                retString = "";
                String roleid = receiverInfo.getValue();
                String mainObjType = this.getMainObjectBosType();
                String orgid = null;
                if (unit != null) {
                    int instanceSize = unit.size();
                    for (int i = 0; i < instanceSize; ++i) {
                        IObjectValue objectValue = (IObjectValue)unit.get(i);
                        if (mainObjType == null || !mainObjType.equalsIgnoreCase(objectValue.getBOSType().toString()) || !(objectValue instanceof CoreBaseInfo)) continue;
                        orgid = MainOrgValueUtil.getMainOrgID((CoreBaseInfo)objectValue, this.ctx);
                        break;
                    }
                }
                UserRoleManager man = new UserRoleManager();
                if (StringUtils.isEmpty(orgid) || !StringUtils.isEmpty((String)(retString = this.set2String(lastUserSet = this.filterSet(userFilter, userSet = this.getUserSet(coll = man.getUserColl(this.ctx, orgid, roleid))))))) break block7;
                this.logger.info((Object)("no receiver in main orgid:" + orgid + " and roleid:" + roleid));
                break block7;
            }
            if (recType.equals((Object)ReceiverType.POSITION)) {
                ArrayList orgUsers = this.getUserIDsByPosition(new String(receiverInfo.getValue()));
                int orgUserSize = orgUsers.size();
                for (int j = 0; j < orgUserSize; ++j) {
                    String orgUserID = orgUsers.get(j).toString();
                    if (userFilter.contains(orgUserID)) continue;
                    retString = retString == null ? orgUserID : retString + ";" + orgUserID;
                }
            }
        }
        return retString;
    }

    private Set getUserSet(UserCollection coll) {
        HashSet<String> result = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            result.add(coll.get(i).getId().toString());
        }
        return result;
    }

    private String getMainObjectBosType() {
        ForewarnObjectCollection coll = this.forewarnItemInfo.getObjects();
        for (int i = 0; i < coll.size(); ++i) {
            if (!ForewarnObjectType.MAIN_OBJECT.equals((Object)coll.get(i).getType())) continue;
            String objectName = coll.get(i).getName();
            BusinessObjectInfo businessObjectInfo = (BusinessObjectInfo)this.businessEntities.get(objectName);
            return businessObjectInfo.getType().toString();
        }
        return null;
    }

    private Set filterSet(Set userFilter, Set userSet) {
        if (userFilter == null || userFilter.isEmpty()) {
            return userSet;
        }
        HashSet<String> retSet = new HashSet<String>();
        if (userSet != null && !userSet.isEmpty()) {
            for (String tempUserId : userSet) {
                if (userFilter.contains(tempUserId)) continue;
                retSet.add(tempUserId);
            }
        }
        return retSet;
    }

    private Set getUserByPerson(String personId) throws BOSException {
        HashSet<String> tempUserSet = new HashSet<String>();
        IUser tempUser = UserFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)personId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        UserCollection userCol = tempUser.getUserCollection(entityViewInfo);
        if (userCol != null) {
            for (int i = 0; i < userCol.size(); ++i) {
                tempUserSet.add(userCol.get(i).getId().toString());
            }
        }
        return tempUserSet;
    }

    private ArrayList getUserIDsByAdminOrgUnit(String orgID) throws Exception {
        if (this.adminOrgUsers.get(orgID) == null) {
            ArrayList<String> users = new ArrayList<String>();
            IOrgUnitCommon iOrgUnitComm = null;
            iOrgUnitComm = OrgUnitCommonFactory.getLocalInstance((Context)this.ctx);
            BOSUuid treeId = iOrgUnitComm.getBasicTree(OrgType.Admin).getId();
            IOrgStructure iOrgStructure = null;
            iOrgStructure = OrgStructureFactory.getLocalInstance((Context)this.ctx);
            OrgTreeInfo treeInfo = new OrgTreeInfo();
            treeInfo.setId(treeId);
            AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)orgID));
            OrgStructureInfo info = iOrgStructure.getValue(treeInfo, (OrgUnitInfo)orgInfo.castToFullOrgUnitInfo());
            String longNumber = info.getLongNumber();
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.UserByAdminOrgUnit");
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("OrgTree.id", (Object)treeId));
            filterInfo.getFilterItems().add(new FilterItemInfo("OrgStrucure.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("invalidationDate", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), CompareType.GREATER));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)String.valueOf(1), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isLocked", (Object)String.valueOf(1), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)String.valueOf(1), CompareType.NOTEQUALS));
            filterInfo.setMaskString(" #0 and #1 and ( #2 and #3 ) and #4 and #5 and #6");
            entityViewInfo.setFilter(filterInfo);
            queryExecutor.setObjectView(entityViewInfo);
            IRowSet rowSet = queryExecutor.executeQuery();
            while (rowSet.next()) {
                users.add(rowSet.getString("id"));
            }
            this.adminOrgUsers.put(orgID, users);
            return users;
        }
        return (ArrayList)this.adminOrgUsers.get(orgID);
    }

    private ArrayList getUserIDsByPosition(String positionID) throws BOSException, EASBizException {
        if (this.positionUsers.get(positionID) == null) {
            ArrayList<String> users = new ArrayList<String>();
            IOrgUnitCommon iOrgUnitComm = null;
            iOrgUnitComm = OrgUnitCommonFactory.getLocalInstance((Context)this.ctx);
            BOSUuid treeId = iOrgUnitComm.getBasicTree(OrgType.Admin).getId();
            OrgTreeInfo treeInfo = new OrgTreeInfo();
            treeInfo.setId(treeId);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.UserByAdminOrgUnit");
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("OrgTree.id", (Object)treeId));
            filterInfo.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), CompareType.LESS_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("invalidationDate", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), CompareType.GREATER));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)String.valueOf(1), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isLocked", (Object)String.valueOf(1), CompareType.NOTEQUALS));
            filterInfo.setMaskString(" #0 and #1 and ( #2 and #3 ) and #4 and #5");
            entityViewInfo.setFilter(filterInfo);
            queryExecutor.setObjectView(entityViewInfo);
            IRowSet rowSet = queryExecutor.executeQuery();
            try {
                while (rowSet.next()) {
                    users.add(rowSet.getString("id"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.positionUsers.put(positionID, users);
            return users;
        }
        return (ArrayList)this.positionUsers.get(positionID);
    }

    private String getDynamicReceiverScript(ArrayList units, ForewarnReceiverInfo receiverInfo) {
        StringBuffer script = new StringBuffer();
        String receiveValue = new String(receiverInfo.getValue());
        int leftIndex = receiveValue.indexOf("{");
        int rightIndex = receiveValue.indexOf("}");
        String strEntityInfo = receiveValue.substring(leftIndex + 1, rightIndex);
        int index = strEntityInfo.indexOf(",");
        String entityName = strEntityInfo.substring(0, index);
        String varType = ((EntityObjectInfo)this.businessEntities.get(entityName)).getObjectValueClass();
        String entityAlias = strEntityInfo.substring(index + 1);
        String entityVarName = null;
        String strProperty = null;
        strProperty = receiveValue.length() > rightIndex + 1 ? receiveValue.substring(rightIndex + 1) : ".id";
        if (this.forewarnVars != null && this.forewarnVars.length > 0) {
            int varLength = this.forewarnVars.length;
            for (int i = 0; i < varLength; ++i) {
                if (!this.forewarnVars[i].getVarType().equalsIgnoreCase(varType)) continue;
                entityVarName = this.forewarnVars[i].getVarName();
                break;
            }
        }
        String varResult = FormulaVarUtil.genVarStr((String)"formula_result", (String)"formula_result", (String)"", null, (String)"return", (String)"result") + "\n";
        String varCoustmer = FormulaVarUtil.genVarStr(entityVarName, (String)entityAlias, (String)varType, null, (String)"local", (String)entityAlias) + "\n";
        StringBuffer unnullExperssion = new StringBuffer();
        unnullExperssion.append(this.getUnNullExperssion(entityVarName));
        String[] strpoints = strProperty.split("\\.");
        String tmp = entityVarName;
        for (int i = 0; i < strpoints.length; ++i) {
            if (strpoints[i] == null || strpoints[i].equals("")) continue;
            tmp = tmp + "." + strpoints[i];
            unnullExperssion.append(this.getUnNullExperssion(tmp));
        }
        String varExperssion = "formula_result=" + entityVarName + strProperty + ".toString();\n";
        String returnExperssion = "return formula_result;\n";
        script.append(varResult).append(varCoustmer).append(unnullExperssion).append(varExperssion).append(returnExperssion);
        return script.toString();
    }

    private StringBuffer getUnNullExperssion(String prop) {
        StringBuffer unnullExperssion = new StringBuffer();
        unnullExperssion.append("if(").append(prop).append(" ==null)").append("{formula_result=\"\";return formula_result;\n}");
        return unnullExperssion;
    }

    private Map getReceiverContext(ArrayList units, String formula) throws ParseException, BOSException {
        HashMap expressionContext = new HashMap();
        ForewarnRunContext runContext = new ForewarnRunContext();
        IVarInfo[] vars = ForewarnFormulaAdapter.getVarInfos(formula);
        if (vars != null && vars.length > 0 && units != null) {
            int size = units.size();
            for (int i = 0; i < size; ++i) {
                ArrayList oneU = (ArrayList)units.get(i);
                runContext.setBizObjects(oneU, vars, expressionContext);
            }
        }
        return expressionContext;
    }

    private Map getDynReceiverContext(ArrayList oneU, String formula) throws ParseException, BOSException {
        HashMap expressionContext = new HashMap();
        ForewarnRunContext runContext = new ForewarnRunContext();
        IVarInfo[] vars = ForewarnFormulaAdapter.getVarInfos(formula);
        runContext.setBizObjects(oneU, vars, expressionContext);
        return expressionContext;
    }

    public String getWeiboReceivers() {
        return this.set2String(this.setWeiboReceivers);
    }

    public Set getCloudUserSet() {
        return this.cloudUserSet;
    }

    private String getUserByTimeZoomTransform(String curUser, ForewarnItemInfo forewarnItemInfo) throws ParseException, EASBizException, BOSException {
        Date date;
        TimeZoneInfo toTimeZoneInfo = null;
        try {
            Class<?> clz = Class.forName(bizClass);
            Method instance = clz.getMethod("getTimeZone", Context.class, String.class);
            toTimeZoneInfo = (TimeZoneInfo)instance.invoke(null, this.ctx, curUser);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u6ca1\u6709\u83b7\u53d6\u5230sHR\u7528\u6237\u7684\u591a\u65f6\u533a\u4fe1\u606f\uff0c" + e.getMessage()));
        }
        if (toTimeZoneInfo == null) {
            INantionalServiceFacade localInstance = NantionalServiceFacadeFactory.getLocalInstance((Context)this.ctx);
            HashMap nationalConfig = localInstance.getNationalConfig(curUser, null, null);
            toTimeZoneInfo = (TimeZoneInfo)nationalConfig.get("timezoneInfo");
        }
        double timeDiff = toTimeZoneInfo.getTimeDiff().getValue();
        String scheduleContent = forewarnItemInfo.getSchedule().getContent();
        KpdlParser parser = new KpdlParser();
        ScheduleDef parseSchedule = KpdlParser.parseSchedule((String)scheduleContent);
        String define = parseSchedule.getDefine();
        Date appServerDate = (Date)this.ctx.get((Object)"appServerDate");
        SimpleDateFormat sd1 = ForewarnScheduleUtil.sd1;
        Date beginTime = date = sd1.parse(sd1.format(appServerDate));
        boolean flag = false;
        Object forewarnPlanTimeInfoId = null;
        int timeDiffServer = appServerDate.getTimezoneOffset() / 60;
        Date nextPlanTime = ForewarnScheduleUtil.generateQuartzTrigger(beginTime, define);
        Date generateQuartzTriggerDate = ForewarnScheduleUtil.timeZoneTransfer(nextPlanTime, timeDiff, timeDiffServer);
        long time = generateQuartzTriggerDate.getTime() - appServerDate.getTime();
        boolean isStartIime = false;
        if (time > 0L && time < betweenTime) {
            isStartIime = true;
        }
        if (isStartIime) {
            this.userTimeZoneMap.put(curUser, String.valueOf(timeDiff));
            return curUser;
        }
        this.readyUserTimeZoneMap.put(curUser, String.valueOf(timeDiff) + "," + ForewarnScheduleUtil.sd.format(generateQuartzTriggerDate));
        return null;
    }
}

