/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.app.rolereceiver;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.forewarn.app.rolereceiver.MainOrgConfigInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class MainOrgValueUtil {
    private static final Logger logger = Logger.getLogger(MainOrgValueUtil.class);

    public static String getMainOrgID(CoreBaseInfo info, Context ctx) {
        String prop = MainOrgValueUtil.getMainOrgProp(info.getBOSType(), ctx);
        if (StringUtils.isEmpty((String)prop)) {
            return null;
        }
        Object o = info.get(prop);
        if (o instanceof OrgUnitInfo) {
            OrgUnitInfo ouInfo = (OrgUnitInfo)o;
            return ouInfo.getId().toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static boolean isHasMainOrgProp(String entityName, Context ctx) {
        String prop = MainOrgValueUtil.getMainOrgProp(entityName, ctx);
        return !StringUtils.isEmpty((String)prop);
    }

    private static String getMainOrgProp(String entityName, Context ctx) {
        EntityObjectInfo businessObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entityName));
        return MainOrgValueUtil.getMainOrgProp((BusinessObjectInfo)businessObjectInfo, ctx);
    }

    private static String getMainOrgProp(BOSObjectType bosType, Context ctx) {
        EntityObjectInfo businessObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        return MainOrgValueUtil.getMainOrgProp((BusinessObjectInfo)businessObjectInfo, ctx);
    }

    private static String getMainOrgProp(BusinessObjectInfo businessObjectInfo, Context ctx) {
        String className = businessObjectInfo.getBusinessImplName() + "Info";
        Object o = null;
        String prop = null;
        try {
            Class<?> cc = Class.forName(className);
            o = cc.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)"class load error", (Throwable)e);
            return prop;
        }
        if (o instanceof CoreBillBaseInfo) {
            CoreBillBaseInfo cbInfo = o;
            prop = MainOrgValueUtil.getMainOrgProp(cbInfo);
        }
        if (StringUtils.isEmpty(prop)) {
            prop = MainOrgConfigInfo.getInstance().getMainOrgPropFromConfig(businessObjectInfo.getBusinessImplName());
        }
        return prop;
    }

    public static String getMainOrgProp(CoreBillBaseInfo info) {
        return info.getBizOrgPropertyName();
    }
}

