/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.forewarn.dataDeal.forewarn;

import com.kingdee.eas.base.forewarn.dataDeal.DataBaseInfo;
import com.kingdee.eas.base.forewarn.dataDeal.forewarn.ForewarnItemInfo;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ForewarnQueryCondition {
    private static Map whereMap = new HashMap();
    private static ForewarnQueryCondition forewarnQueryCondition;

    public String getWhere(String tableName) {
        if (tableName == null || tableName.trim().length() == 0) {
            return "";
        }
        String retStr = "";
        if (whereMap.containsKey(tableName.toLowerCase())) {
            retStr = " where " + (String)whereMap.get(tableName.toLowerCase());
        }
        if ("T_FW_ForewarnItem".equalsIgnoreCase(tableName)) {
            retStr = retStr + " order by ftype desc ";
        }
        return retStr;
    }

    private static void init(String fid, Connection con) {
        ForewarnItemInfo itemInfo = ForewarnQueryCondition.getInfo(fid, con);
        if (itemInfo == null) {
            whereMap.clear();
            return;
        }
        whereMap.put("T_FW_ForewarnObject".toLowerCase(), " fitemid  in (" + fid + ")");
        whereMap.put("T_FW_Receiver".toLowerCase(), " fitemid  in (" + fid + ")");
        whereMap.put("T_FW_ForewarnItem".toLowerCase(), " fid  in (" + fid + ")");
        whereMap.put("T_FW_schedule".toLowerCase(), "  fid   in (" + DataBaseInfo.aryToStr(itemInfo.getScheduleMap()) + ")");
        whereMap.put("T_FW_Threshold".toLowerCase(), " fconditionid  in (" + DataBaseInfo.aryToStr(itemInfo.getThresholdMap()) + ")");
        whereMap.put("T_FW_Condition".toLowerCase(), " fid  in (" + DataBaseInfo.aryToStr(itemInfo.getConditionMap()) + ")");
        whereMap.put("T_FW_ForewarnMsg".toLowerCase(), " fid  in(" + DataBaseInfo.aryToStr(itemInfo.getMsgMap()) + ")");
        whereMap.put("T_FW_RightnowAction".toLowerCase(), " fforewarntemplateid in(" + fid + ")");
        whereMap.put("T_FW_DynReceivers".toLowerCase(), " ffwitemid in(" + fid + ")");
    }

    public static ForewarnItemInfo getInfo(String fid, Connection con) {
        if (StringUtils.isEmpty((String)fid)) {
            return null;
        }
        ForewarnItemInfo itemInfo = new ForewarnItemInfo();
        try {
            String sql = "select * from t_fw_forewarnitem";
            sql = sql + " where fid in (" + fid + ");";
            PreparedStatement ps = con.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            itemInfo = new ForewarnItemInfo();
            while (rs.next()) {
                itemInfo.addConditionId(rs.getString("FconditionId"));
                itemInfo.addMsgId(rs.getString("Fmessageid"));
                itemInfo.addScheduleId(rs.getString("FscheduleId"));
            }
            sql = "select fid from T_FW_Condition where fid  in (select fconditionid from t_fw_forewarnitem where fid   in (" + fid + "))";
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                itemInfo.addThresholdId(rs.getString("fid"));
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return itemInfo;
    }

    private ForewarnQueryCondition() {
    }

    public static ForewarnQueryCondition getInstance(Connection con, String fidStr) {
        if (forewarnQueryCondition == null) {
            forewarnQueryCondition = new ForewarnQueryCondition();
        }
        ForewarnQueryCondition.init(fidStr, con);
        return forewarnQueryCondition;
    }

    public static void reset() {
        if (whereMap != null) {
            whereMap.clear();
        }
    }
}

