/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessEvent;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IDataAccessListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.FindedTooMuchRecordsException;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping.impl.AbstractObjectHandler;
import com.kingdee.bos.dao.ormapping.impl.BatchConnection;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.ObjectCUDFactory;
import com.kingdee.bos.dao.ormapping.impl.ObjectCreator;
import com.kingdee.bos.dao.ormapping.impl.ObjectMatcher;
import com.kingdee.bos.dao.ormapping.impl.ObjectReader;
import com.kingdee.bos.dao.ormapping.impl.ObjectRemover;
import com.kingdee.bos.dao.ormapping.impl.ObjectUpdater;
import com.kingdee.bos.dao.ormapping.impl.RTFilter;
import com.kingdee.bos.dao.ormapping.impl.RTSelector;
import com.kingdee.bos.dao.ormapping.impl.RTSelectorBuilder;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfoCreator;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.InvalidEntityViewException;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.rule.formula.FormulaExecuteException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.util.profile.ObjectProfileInterceptor;
import com.kingdee.util.profile.ProfileConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BillORMappingDAO
implements IORMappingDAO {
    public static final String VISIBLE_FIELD = "_V";
    private final BOSObjectType bosType;
    private final Context ctx;
    protected final EntityObjectInfo bo;
    protected final SolutionInfo solution;
    protected final Connection cn;
    protected ArrayList listeners = null;
    private static Logger logger = Logger.getLogger(BillORMappingDAO.class);
    private static final String LOG_ADD = " add: ";
    private static final String LOG_DELETE = " delete: ";
    private static final String LOG_UPDATE = " update: ";
    private static final String LOG_GETCOLLECTIOM = " getCollection: ";
    private static final String LOG_GETVALUE = " getValue: ";
    private static final String LOG_EXIST = " check exist: ";
    private static final String LOG_GETPKLIST = " get PK list: ";
    private List batchParams = null;
    private static long lGetValueTimes = 0L;
    private static long lGetCollTimes = 0L;
    private static long lAcceptTimes = 0L;
    private static long lDeleteTimes = 0L;
    private static long lGetCountTimes = 0L;
    private static long lGetPKListTimes = 0L;
    private static long lAddnewTimes = 0L;
    private static long lUpdateTimes = 0L;
    private static long lGetVForUpdateTimes = 0L;
    private static long lBatchTimes = 0L;

    public static IORMappingDAO getInstance(BOSObjectType bosType, Context ctx, Connection cn, EntityObjectInfo bo) {
        BillORMappingDAO dao = new BillORMappingDAO(bosType, ctx, cn, bo);
        if (ProfileConfig.getInstance().logORMapping) {
            return (IORMappingDAO)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{IORMappingDAO.class}, (InvocationHandler)new ObjectProfileInterceptor((Object)dao));
        }
        return dao;
    }

    public BillORMappingDAO(BOSObjectType bosType, Context ctx, Connection cn, EntityObjectInfo bo) {
        this.bosType = bosType;
        this.ctx = ctx;
        this.cn = cn;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        this.bo = bo == null ? loader.getEntity(bosType) : bo;
        this.solution = loader.getSolution();
    }

    public Context getContext() {
        return this.ctx;
    }

    public BOSObjectType getType() {
        return this.bosType;
    }

    public IObjectValue getValue(IObjectPK pk) throws DataAccessException {
        SelectorItemCollection selector = null;
        if (this.bo.getDefaultView() != null) {
            selector = this.bo.getDefaultView().getSelector();
        }
        return this.getValue(pk, selector);
    }

    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector) throws DataAccessException {
        return this.getValue(pk, selector, false);
    }

    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector, boolean isBaseOnSelector) throws DataAccessException {
        FilterInfo filterData = ImplUtils.createFilter((EntityObjectInfo)this.bo, (IObjectPK)pk);
        return this.innerGetValue(filterData, selector, null, isBaseOnSelector);
    }

    public IObjectValue getValue(IObjectPK pk, SorterItemCollection sorter) throws DataAccessException {
        SelectorItemCollection selector = null;
        if (this.bo.getDefaultView() != null) {
            selector = this.bo.getDefaultView().getSelector();
        }
        return this.getValue(pk, selector, sorter, false);
    }

    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws DataAccessException {
        FilterInfo filterData = ImplUtils.createFilter((EntityObjectInfo)this.bo, (IObjectPK)pk);
        return this.innerGetValue(filterData, selector, sorter, false);
    }

    public IObjectValue getValue(IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter, boolean isBaseOnSelector) throws DataAccessException {
        FilterInfo filterData = ImplUtils.createFilter((EntityObjectInfo)this.bo, (IObjectPK)pk);
        return this.innerGetValue(filterData, selector, sorter, isBaseOnSelector);
    }

    public IObjectValue getValue(String oql) throws DataAccessException {
        return this.getValue(oql, false);
    }

    public IObjectValue getValue(String oql, boolean isBaseOnSelector) throws DataAccessException {
        EntityViewInfo view = EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.getType(), (EntityObjectInfo)this.bo);
        return this.innerGetValue(view, isBaseOnSelector);
    }

    public IObjectValue getValue(EntityViewInfo view) throws DataAccessException {
        return this.innerGetValue(view, false);
    }

    public IObjectValue getValue(EntityViewInfo view, boolean isBaseOnSelector) throws DataAccessException {
        return this.innerGetValue(view, isBaseOnSelector);
    }

    private IObjectValue innerGetValue(EntityViewInfo view, boolean isBaseOnSelector) throws DataAccessException {
        FilterInfo filterInfo = view.getFilter();
        String strFilter = filterInfo == null ? "" : filterInfo.toString();
        IObjectCollection selectData = this.innerGetCollection(view, null, false);
        this.checkSize(selectData, strFilter);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(LOG_GETVALUE + this.bo.getDisplayName()));
        }
        return selectData.getObject(0);
    }

    private IObjectValue innerGetValue(FilterInfo filterData, SelectorItemCollection selector, SorterItemCollection sorter, boolean isBaseOnSelector) throws DataAccessException {
        EntityViewInfo view = EntityViewInfo.getInstance((FilterInfo)filterData, (SelectorItemCollection)selector, (SorterItemCollection)sorter);
        return this.innerGetValue(view, isBaseOnSelector);
    }

    private IObjectValue innerGetValue(FilterInfo filterData, RTSelector rtSelector, SorterItemCollection sorter) throws DataAccessException {
        EntityViewInfo view = EntityViewInfo.getInstance((FilterInfo)filterData, null, (SorterItemCollection)sorter);
        IObjectCollection selectData = this.innerGetCollection(view, rtSelector, false);
        this.checkSize(selectData, filterData.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(LOG_GETVALUE + this.bo.getDisplayName()));
        }
        return selectData.getObject(0);
    }

    public IObjectValue getValueNoChild(IObjectPK pk) throws DataAccessException {
        FilterInfo filterData = ImplUtils.createFilter((EntityObjectInfo)this.bo, (IObjectPK)pk);
        RTSelector selectorData = RTSelectorBuilder.buildSelfPropSelector(null, (EntityObjectInfo)this.bo);
        try {
            IObjectCollection selectData = this.reader().selectNoChild(this.bo, filterData, null, selectorData);
            this.checkSize(selectData, filterData.toString());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_GETVALUE + this.bo.getDisplayName()));
            }
            return selectData.getObject(0);
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("select data error." + sqle.getMessage(), (Exception)sqle);
        }
    }

    private final void checkSize(IObjectCollection selectData, String filter) throws DataAccessException {
        if (selectData.size() != 1) {
            String msg = this.bo.getName() + " " + Utils.removeSpecialTAG((String)filter, (String)"~9^Nz");
            if (selectData.size() == 0) {
                throw new ObjectNotFoundException("MissingRecord:" + msg);
            }
            throw new InvalidEntityViewException("TooManyRecord:" + msg);
        }
    }

    public IObjectPK[] getPKList() throws DataAccessException {
        return this.getPKList(null, null);
    }

    public IObjectPK[] getPKList(String oql) throws DataAccessException {
        EntityViewInfo view = EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.bosType, (EntityObjectInfo)this.bo);
        return this.innerGetPKList(view);
    }

    public IObjectPK[] getPKList(FilterInfo filter, SorterItemCollection sorter) throws DataAccessException {
        EntityViewInfo defaultView = new EntityViewInfo();
        defaultView.setFilter(filter);
        if (sorter != null && sorter.size() != 0) {
            defaultView.getSorter().addObjectCollection((IObjectCollection)sorter);
        }
        return this.innerGetPKList(defaultView);
    }

    private IObjectPK[] innerGetPKList(EntityViewInfo defaultView) throws DataAccessException {
        IObjectPK[] pks;
        PropertyCollection props = this.bo.getLogicalKey().getKeyPropertys();
        defaultView.getSelector().clear();
        int size = props.size();
        for (int i = 0; i < size; ++i) {
            defaultView.getSelector().add(new SelectorItemInfo(props.get(i).getName()));
        }
        IObjectCollection col = this.getCollectionNoChild(defaultView);
        if (col == null) {
            pks = new IObjectPK[]{};
        } else {
            int size2 = col.size();
            pks = new IObjectPK[size2];
            for (int i = 0; i < size2; ++i) {
                pks[i] = Utils.getObjectPK((EntityObjectInfo)this.bo, (IObjectValue)col.getObject(i));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(LOG_GETPKLIST + this.bo.getDisplayName()));
        }
        return pks;
    }

    public IObjectCollection getCollection() throws DataAccessException {
        EntityViewInfo view = this.bo.getDefaultView();
        return this.innerGetCollection(view, null, false);
    }

    public IObjectCollection getCollection(String oqlExpr) throws DataAccessException {
        return this.getCollection(oqlExpr, false);
    }

    public IObjectCollection getCollection(String oql, boolean isBaseOnSelector) throws DataAccessException {
        EntityViewInfo view = EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.getType(), (EntityObjectInfo)this.bo);
        return this.innerGetCollection(view, null, isBaseOnSelector);
    }

    public IObjectCollection getCollection(EntityViewInfo view) throws DataAccessException {
        return this.innerGetCollection(view, null, false);
    }

    public IObjectCollection getCollection(EntityViewInfo view, boolean isBaseOnSelector) throws DataAccessException {
        return this.innerGetCollection(view, null, isBaseOnSelector);
    }

    private IObjectCollection innerGetCollection(EntityViewInfo view, RTSelector rtSelector, boolean isBaseOnSelector) throws DataAccessException {
        RTSelector sc;
        int topCount = Integer.MIN_VALUE;
        if (view != null && view.getTopCount() > 0) {
            topCount = view.getTopCount();
        }
        if (rtSelector != null) {
            sc = rtSelector;
        } else {
            SelectorItemCollection s = view == null ? null : view.getSelector();
            sc = isBaseOnSelector ? RTSelectorBuilder.buildSelfPropSelector((SelectorItemCollection)s, (EntityObjectInfo)this.bo) : RTSelectorBuilder.buildSelfPropAndAllPKSelector((SelectorItemCollection)s, (EntityObjectInfo)this.bo);
        }
        IObjectCollection selectData = null;
        try {
            if (view != null) {
                if (view.getEntryFilters() != null && view.getEntryFilters().size() != 0) {
                    ObjectReader reader = this.reader();
                    reader.setEntryPermCol(view.isEntryPermCol());
                    selectData = reader.selectByEntryWhere(this.bo, view.getFilter(), (IObjectCollection)view.getEntryFilters(), view.getSorter(), sc, topCount);
                } else {
                    ObjectReader reader = this.reader();
                    reader.setEntryPermCol(view.isEntryPermCol());
                    selectData = reader.select(this.bo, view.getFilter(), view.getSorter(), sc, topCount);
                }
                if (!view.isEntryPermCol() && view.isIncludeExpressFilter()) {
                    this.filterWholeObject(selectData, view);
                }
            } else {
                selectData = this.reader().select(this.bo, null, null, RTSelectorBuilder.buildSelfPropSelector(null, (EntityObjectInfo)this.bo), topCount);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_GETCOLLECTIOM + this.bo.getDisplayName()));
            }
        }
        catch (FetchedTooMuchRowsException fe) {
            throw new FindedTooMuchRecordsException((Exception)((Object)fe));
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("select data error." + sqle.getMessage(), (Exception)sqle);
        }
        return selectData;
    }

    public IObjectCollection getCollectionNoChild(EntityViewInfo view) throws DataAccessException {
        IObjectCollection selectData = null;
        try {
            selectData = view != null ? this.reader().selectNoChild(this.bo, view.getFilter(), view.getSorter(), RTSelectorBuilder.buildSelfPropAndAllPKSelector((SelectorItemCollection)view.getSelector(), (EntityObjectInfo)this.bo)) : this.reader().selectNoChild(this.bo, null, null, RTSelectorBuilder.buildSelfPropAndAllPKSelector(null, (EntityObjectInfo)this.bo));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_GETCOLLECTIOM + this.bo.getDisplayName()));
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException("select data error." + e.getMessage(), (Exception)e);
        }
        return selectData;
    }

    private void filterWholeObject(IObjectCollection selectData, EntityViewInfo view) throws DataAccessException {
        int size = selectData.size();
        for (int m = 0; m < size; ++m) {
            IObjectValue value = selectData.getObject(m);
            if (value == null) continue;
            this.processObjectValue(value, view);
        }
    }

    private void processObjectValue(IObjectValue value, EntityViewInfo view) throws DataAccessException {
        int n = view.getEntryFilters().size();
        for (int i = 0; i < n; ++i) {
            FilterInfo filter = view.getEntryFilters().get(i);
            IObjectCollection values = (IObjectCollection)value.get(filter.getEntryName());
            if (values == null || values.size() <= 0) continue;
            if (filter.getEntryFilterType().equals((Object)EntryFilterType.ENTRYALLWHERE)) {
                this.processObjectCollectionForAll(values, filter, view);
                continue;
            }
            if (filter.getEntryFilterType().equals((Object)EntryFilterType.ENTRYANYWHERE)) {
                this.processObjectCollectionForAny(values, filter, view);
                continue;
            }
            this.recursionProcessObjectValue(true, values, view);
        }
    }

    private void processObjectCollectionForAny(IObjectCollection cols, FilterInfo filter, EntityViewInfo view) throws DataAccessException {
        boolean flag = false;
        int n = cols.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue value = cols.getObject(i);
            if (!this.accept(value, filter)) continue;
            flag = true;
            break;
        }
        this.recursionProcessObjectValue(flag, cols, view);
    }

    private void processObjectCollectionForAll(IObjectCollection cols, FilterInfo filter, EntityViewInfo view) throws DataAccessException {
        boolean flag = true;
        int n = cols.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue value = cols.getObject(i);
            if (this.accept(value, filter)) continue;
            flag = false;
            break;
        }
        this.recursionProcessObjectValue(flag, cols, view);
    }

    private void recursionProcessObjectValue(boolean flag, IObjectCollection cols, EntityViewInfo view) throws DataAccessException {
        if (flag) {
            int n = cols.size();
            for (int i = 0; i < n; ++i) {
                IObjectValue value = cols.getObject(i);
                this.processObjectValue(value, view);
            }
        } else {
            cols.clear();
        }
    }

    public IObjectPK addnew(IObjectValue value) throws DataAccessException {
        return this.innerAddnew(null, value);
    }

    public void addnew(IObjectPK pk, IObjectValue value) throws DataAccessException {
        if (pk == null) {
            throw new IllegalArgumentException("parameter 'pk' can't be null");
        }
        ImplUtils.setPKValue((EntityObjectInfo)this.bo, (IObjectPK)pk, (IObjectValue)value);
        this.innerAddnew(pk, value);
    }

    private IObjectPK innerAddnew(IObjectPK pk, IObjectValue value) throws DataAccessException {
        IObjectPK objPk = pk;
        try {
            this.fireEvent(0, objPk, value, value);
            ObjectCreator oc = ObjectCUDFactory.getObjectCreator((Context)this.ctx, (Connection)this.cn, (SolutionInfo)this.solution);
            objPk = oc.create(this.bo, value);
            ObjectCUDFactory.close((AbstractObjectHandler)oc);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_ADD + this.bo.getDisplayName()));
            }
            IObjectPK iObjectPK = objPk;
            return iObjectPK;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("create data error." + sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
        }
        catch (FormulaExecuteException fee) {
            throw new DataAccessException((Throwable)fee);
        }
        finally {
            this.fireEvent(1, objPk, value, value);
        }
    }

    public void updatePartial(IObjectValue value, SelectorItemCollection selector) throws DataAccessException {
        try {
            this.fireEvent(3, value);
            ObjectUpdater updater = ObjectCUDFactory.getObjectUpdater((Context)this.ctx, (Connection)this.cn, (SolutionInfo)this.solution);
            updater.updatePartial(this.bo, value, selector);
            ObjectCUDFactory.close((AbstractObjectHandler)updater);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_UPDATE + this.bo.getDisplayName()));
            }
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("update data error." + sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
        }
        catch (FormulaExecuteException fee) {
            throw new DataAccessException((Throwable)fee);
        }
        finally {
            this.fireEvent(3, value);
        }
    }

    public void update(IObjectPK pk, IObjectValue value) throws DataAccessException {
        if (value instanceof IObjectValueAgent) {
            this.updateBigObject(pk, value);
            return;
        }
        IObjectValue oldValue = this.innerGetValueForUpdate(pk);
        try {
            this.fireEvent(3, pk, oldValue, value);
            ObjectUpdater updater = ObjectCUDFactory.getObjectUpdater((Context)this.ctx, (Connection)this.cn, (SolutionInfo)this.solution);
            updater.update(this.bo, value, oldValue);
            ObjectCUDFactory.close((AbstractObjectHandler)updater);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_UPDATE + this.bo.getDisplayName()));
            }
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("update data error." + sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
        }
        catch (FormulaExecuteException fee) {
            throw new DataAccessException((Throwable)fee);
        }
        finally {
            this.fireEvent(3, pk, oldValue, value);
        }
    }

    public void updateBigObject(IObjectPK pk, IObjectValue value) throws DataAccessException {
        IObjectValue oldValue = this.innerGetValueForUpdate(pk);
        try {
            this.fireEvent(3, pk, oldValue, value);
            ObjectUpdater updater = ObjectCUDFactory.getObjectUpdater((Context)this.ctx, (Connection)this.cn, (SolutionInfo)this.solution);
            updater.updateBigObject(this.bo, value, oldValue);
            ObjectCUDFactory.close((AbstractObjectHandler)updater);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_UPDATE + this.bo.getDisplayName()));
            }
        }
        catch (SQLException sqle) {
            throw new SQLAccessException("update data error." + sqle.getMessage(), JDBCExceptionHandler.convertException((SQLException)sqle));
        }
        catch (FormulaExecuteException fee) {
            throw new DataAccessException((Throwable)fee);
        }
        finally {
            this.fireEvent(3, pk, oldValue, value);
        }
    }

    private IObjectValue innerGetValueForUpdate(IObjectPK pk) throws DataAccessException {
        if (this.bo.hasCompositeProp()) {
            return this.innerGetValue(ImplUtils.createFilter((EntityObjectInfo)this.bo, (IObjectPK)pk), RTSelectorBuilder.buildAllPKSelector((EntityObjectInfo)this.bo), null);
        }
        IObjectValue ov = Utils.newObjectValueInstance((EntityObjectInfo)this.bo);
        ImplUtils.setPKValue((EntityObjectInfo)this.bo, (IObjectPK)pk, (IObjectValue)ov);
        return ov;
    }

    public void delete(IObjectPK pk) throws DataAccessException {
        if (pk == null) {
            throw new IllegalArgumentException("parameter 'pk' cannot be null.");
        }
        RTFilter filterData = null;
        filterData = this.bo.hasOneToOneCompsition() ? new RTFilter(this.getValue(pk)) : new RTFilter(this.bo, pk);
        try {
            this.fireEvent(4, pk, null, null);
            ObjectRemover remover = ObjectCUDFactory.getObjectRemover((Context)this.ctx, (Connection)this.cn, (SolutionInfo)this.solution);
            remover.delete(this.bo, (IObjectValue)filterData);
            ObjectCUDFactory.close((AbstractObjectHandler)remover);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_DELETE + this.bo.getDisplayName()));
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException("delete data error." + e.getMessage(), (Exception)e);
        }
        finally {
            this.fireEvent(5, pk, null, null);
        }
    }

    public IObjectPK[] delete(String oql) throws DataAccessException {
        return this.delete(EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.bosType, (EntityObjectInfo)this.bo).getFilter());
    }

    public IObjectPK[] delete(FilterInfo filter) throws DataAccessException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        IObjectPK[] arrayPK = this.innerGetPKList(view);
        try {
            if (filter == null || filter.getFilterItems().size() == 0) {
                return arrayPK;
            }
            ObjectRemover remover = ObjectCUDFactory.getObjectRemover((Context)this.ctx, (Connection)this.cn, (SolutionInfo)this.solution);
            remover.deleteBySQL(this.bo, filter);
            ObjectCUDFactory.close((AbstractObjectHandler)remover);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_DELETE + this.bo.getDisplayName()));
            }
            return arrayPK;
        }
        catch (SQLException e) {
            throw new SQLAccessException("delete data error." + e.getMessage(), (Exception)e);
        }
    }

    public void delete(IObjectPK[] arrayPK) throws DataAccessException {
        if (arrayPK == null || arrayPK.length == 0) {
            return;
        }
        for (int i = arrayPK.length - 1; i >= 0; --i) {
            this.delete(arrayPK[i]);
        }
    }

    public boolean exists(IObjectPK pk) throws DataAccessException {
        return this.exists(ImplUtils.createFilter((EntityObjectInfo)this.bo, (IObjectPK)pk));
    }

    public boolean exists(String oql) throws DataAccessException {
        return this.exists(EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.bosType, (EntityObjectInfo)this.bo).getFilter());
    }

    public boolean exists(FilterInfo filterInfo) throws DataAccessException {
        try {
            boolean ex = this.reader().exist(this.bo, filterInfo);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(LOG_EXIST + this.bo.getDisplayName()));
            }
            return ex;
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }

    public int getCount(String oql) throws DataAccessException {
        return this.getCount(EntityViewInfoCreator.create((String)oql, (BOSObjectType)this.bosType, (EntityObjectInfo)this.bo).getFilter());
    }

    public int getCount(FilterInfo filterInfo) throws DataAccessException {
        try {
            return this.reader().getCount(this.bo, filterInfo);
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }

    public boolean accept(IObjectPK pk, FilterInfo rule) throws DataAccessException {
        ObjectMatcher.ObjectPattern pattern = new ObjectMatcher.ObjectPattern(rule);
        return this.matcher().match(pk, pattern);
    }

    public boolean accept(IObjectValue value, EntityViewInfo view) throws DataAccessException {
        ObjectMatcher.ObjectPattern pattern = new ObjectMatcher.ObjectPattern(view.getFilter(), view.getEntryFilters());
        return this.matcher().match(value, pattern);
    }

    public boolean accept(IObjectValue value, FilterInfo rule) throws DataAccessException {
        ObjectMatcher.ObjectPattern pattern = new ObjectMatcher.ObjectPattern(rule);
        return this.matcher().match(value, pattern);
    }

    public boolean accept(IObjectPK pk, FilterInfo rule, boolean isExcludeRule) throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    private final ObjectMatcher matcher() {
        return new ObjectMatcher(this.ctx, this.cn, this.solution, this.bo);
    }

    private final void batchParamNullCheck() {
        if (this.batchParams == null) {
            this.batchParams = new ArrayList();
        }
    }

    public void addNewBatch(IObjectValue value) throws DataAccessException {
        if (value == null) {
            return;
        }
        this.batchParamNullCheck();
        this.batchParams.add(BatchParam.addnew(value));
    }

    public void updateBatch(IObjectPK pk, IObjectValue value) throws DataAccessException {
        if (pk == null || value == null) {
            return;
        }
        this.batchParamNullCheck();
        this.batchParams.add(BatchParam.update(pk, value));
    }

    public void deleteBatch(IObjectPK pk) throws DataAccessException {
        if (pk == null) {
            return;
        }
        this.batchParamNullCheck();
        this.batchParams.add(BatchParam.delete(pk));
    }

    public IObjectPK[] executeBatchWithReturn() throws DataAccessException {
        if (this.batchParams == null || this.batchParams.size() == 0) {
            return new IObjectPK[0];
        }
        IObjectPK[] rtn = new IObjectPK[this.batchParams.size()];
        BatchConnection batchCn = BatchConnection.getInstance((Connection)this.cn);
        ObjectCreator creator = null;
        ObjectRemover remover = null;
        ObjectUpdater updater = null;
        try {
            int n = this.batchParams.size();
            for (int i = 0; i < n; ++i) {
                BatchParam param = (BatchParam)this.batchParams.get(i);
                if (param.type == 0) {
                    IObjectPK rtn1;
                    if (creator == null) {
                        creator = ObjectCUDFactory.getObjectCreator((Context)this.ctx, (Connection)batchCn, (SolutionInfo)this.solution);
                    }
                    rtn[i] = rtn1 = creator.create(this.bo, param.objectValue);
                    continue;
                }
                if (param.type == 1) {
                    if (updater == null) {
                        updater = ObjectCUDFactory.getObjectUpdater((Context)this.ctx, (Connection)batchCn, (SolutionInfo)this.solution);
                    }
                    IObjectValue oldValue = this.innerGetValueForUpdate(param.objectPK);
                    updater.update(this.bo, param.objectValue, oldValue);
                    rtn[i] = param.objectPK;
                    continue;
                }
                if (param.type != 2) continue;
                if (remover == null) {
                    remover = ObjectCUDFactory.getObjectRemover((Context)this.ctx, (Connection)batchCn, (SolutionInfo)this.solution);
                }
                RTFilter filterData = null;
                filterData = this.bo.hasOneToOneCompsition() ? new RTFilter(this.getValue(param.objectPK)) : new RTFilter(this.bo, param.objectPK);
                remover.delete(this.bo, (IObjectValue)filterData);
                rtn[i] = param.objectPK;
            }
            batchCn.closeStatements();
            this.batchParams = null;
        }
        catch (FormulaExecuteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new DataAccessException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new DataAccessException((Throwable)JDBCExceptionHandler.convertException((SQLException)e));
        }
        return rtn;
    }

    public void executeBatch() throws DataAccessException {
        this.executeBatchWithReturn();
    }

    public void addEventListener(IDataAccessListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public IDataAccessListener[] getEventListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        return this.listeners.toArray(new IDataAccessListener[this.listeners.size()]);
    }

    public void removeEventListener(IDataAccessListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireEvent(int actionType, IObjectPK pk, IObjectValue oldValue, IObjectValue newValue) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            DataAccessEvent ev = new DataAccessEvent(actionType, (Object)this, pk, oldValue, newValue, this.ctx, this.bosType);
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                ((IDataAccessListener)this.listeners.get(i)).perform(ev);
            }
        }
    }

    private void fireEvent(int actionType, IObjectValue newValue) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            DataAccessEvent ev = new DataAccessEvent(actionType, (Object)this, newValue, this.ctx, this.bosType);
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                ((IDataAccessListener)this.listeners.get(i)).perform(ev);
            }
        }
    }

    private final ObjectReader reader() {
        return new ObjectReader(this.ctx, this.cn, this.solution);
    }

    public IObjectCollection getCollection(EntityViewInfo view, int start, int length) throws DataAccessException {
        return null;
    }

    public String getSql(EntityViewInfo view) throws DataAccessException {
        return null;
    }

    public void updatePartialBatch(IObjectPK pk, IObjectValue value, SelectorItemCollection selector) throws DataAccessException {
    }

    private static class BatchParam {
        public final int type;
        public static final int ADDNEW = 0;
        public static final int UPDATE = 1;
        public static final int DELETE = 2;
        public final IObjectPK objectPK;
        public final IObjectValue objectValue;

        private BatchParam(int type, IObjectPK pk, IObjectValue value) {
            this.type = type;
            this.objectPK = pk;
            this.objectValue = value;
        }

        public static BatchParam addnew(IObjectValue value) {
            return new BatchParam(0, null, value);
        }

        public static BatchParam update(IObjectPK pk, IObjectValue value) {
            return new BatchParam(1, pk, value);
        }

        public static BatchParam delete(IObjectPK pk) {
            return new BatchParam(2, pk, null);
        }
    }
}

