/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core;

import com.kingdee.eas.base.form.core.IReverseAction;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.metadata.AbstractElement;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.ButtonAppearance;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.List;
import org.apache.log4j.Logger;

public class PropertyUtil {
    private static final Logger logger = Logger.getLogger(PropertyUtil.class);

    public static void setPropertyValue(Object obj, String propertyName, Object value) {
        if (obj == null || value == null) {
            return;
        }
        Class<Object> classType = value.getClass();
        if (value instanceof Integer) {
            classType = Integer.TYPE;
        } else if (value instanceof BigDecimal) {
            classType = Integer.TYPE;
            value = new Integer(((BigDecimal)value).intValue());
        }
        Method md = null;
        try {
            md = obj.getClass().getMethod("set" + propertyName, classType);
        }
        catch (Exception e) {
            logger.error((Object)("\u8bbe\u7f6e\u5c5e\u6027\u65f6\uff0c\u7c7b" + obj.getClass().getName() + "\u65b9\u6cd5set" + propertyName + "\u6ca1\u6709\u627e\u5230\uff01"));
        }
        if (md == null) {
            return;
        }
        try {
            md.invoke(obj, value);
        }
        catch (Exception e) {
            logger.error((Object)("\u8bbe\u7f6e\u5c5e\u6027\u65f6\uff0c\u7c7b" + classType.getName() + "\u65b9\u6cd5set" + propertyName + ":" + e.getMessage()));
        }
    }

    public static Object getPropertyValue(Object obj, String propertyName) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method mi = null;
        if (obj != null) {
            mi = obj.getClass().getMethod("get" + propertyName, null);
        }
        if (mi != null && obj != null) {
            return mi.invoke(obj, new Object[0]);
        }
        return null;
    }

    public static void dealAction(AbstractElement element, String newKey, String oldKey) {
        String[] actionTypes = null;
        if (element instanceof Field) {
            actionTypes = new String[]{"LoadActions", "UpdateActions"};
        } else if (element instanceof ButtonAppearance) {
            actionTypes = new String[]{"ClickActions"};
        } else if (element instanceof EntityAppearance) {
            actionTypes = new String[]{"DblClickActions"};
        } else if (element instanceof Form) {
            actionTypes = new String[]{"LoadActions", "BeforeActions", "AfterActions"};
        }
        for (int i = 0; actionTypes != null && i < actionTypes.length; ++i) {
            try {
                List actionList = (List)PropertyUtil.getPropertyValue(element, actionTypes[i]);
                PropertyUtil.dealKeyInAction(newKey, oldKey, actionList);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private static void dealKeyInAction(String newKey, String oldKey, List actionList) throws JSONException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (actionList != null) {
            for (Action action : actionList) {
                String reverseActionClass = action.getReverseActionClass();
                if (StringUtils.isEmpty((String)reverseActionClass)) continue;
                ((IReverseAction)Class.forName(reverseActionClass).newInstance()).dealKeyInAction(newKey, oldKey, action);
            }
        }
    }
}

