/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.core.IBusinessService;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;

public final class BOSBusinessService
implements IBusinessService {
    @Override
    public IObjectValue createNewObject(Context ctx, String bosType) throws BOSException, EASBizException {
        EntityObjectInfo eo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType));
        String ovc = eo.getObjectValueClass();
        IObjectValue ov = null;
        try {
            ov = (IObjectValue)Class.forName(ovc).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ov;
    }

    @Override
    public IObjectValue getBaseDataByKey(Context ctx, LookUpObject lookupObj, String key, String value, String filter, String[] selectors) throws BOSException, EASBizException {
        IObjectCollection collection = this.getBaseDatasByFilter(ctx, selectors, lookupObj, new FilterItemInfo[][]{{new FilterItemInfo(key, (Object)value, CompareType.EQUALS)}});
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.getObject(0);
    }

    private IObjectCollection getBaseDatasByFilter(Context ctx, String[] selectors, LookUpObject lookupObj, FilterItemInfo[][] filterItems) throws BOSException, EASBizException {
        String bosType = lookupObj.getBosType();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (selectors != null) {
            for (int i = 0; i < selectors.length; ++i) {
                sic.add(new SelectorItemInfo(selectors[i]));
            }
        }
        viewInfo.setSelector(sic);
        IObjectCollection collection = BusinessProcessUtil.getCollectionByBosType((Context)ctx, (String)bosType, (EntityViewInfo)viewInfo, (FilterItemInfo[][])filterItems, null);
        return collection;
    }

    @Override
    public IObjectCollection getBaseDatasByKeys(Context ctx, LookUpObject lookupObj, String key, String value, String filter, String[] selectors) throws BOSException, EASBizException {
        IObjectCollection collection = this.getBaseDatasByFilter(ctx, selectors, lookupObj, new FilterItemInfo[][]{{new FilterItemInfo(key, (Object)value, CompareType.INCLUDE)}});
        return collection;
    }
}

