/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.metadata;

import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.form.core.PropertyUtil;
import com.kingdee.eas.base.form.metadata.AbstractElement;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.Element;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EnumInfo;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.metadata.FormCondition;
import com.kingdee.eas.base.form.metadata.KeyChangeListener;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.util.DataMappingUtil;
import com.kingdee.eas.base.form.util.ExpressionUtil;
import com.kingdee.eas.dynbusiness.config.Property;
import com.kingdee.eas.dynbusiness.config.PropertyCheckConfigItems;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BusinessInfo
implements Serializable,
Cloneable,
KeyChangeListener {
    private static final Log log = LogFactory.getLog(BusinessInfo.class);
    private static final String EMPTY_EXPRESSION_NULL = "@this == null";
    private HashMap mapElements;
    private HashMap lookUpObjects;
    private HashMap baseReferTables;
    private EnumInfo EnumInfo;
    private HashMap sqlComboLists;
    private HashMap trdCtrlParams = new HashMap();
    private Field mainOrgField;
    private SelectorItemCollection selector;
    private PropertyCheckConfigItems checkItems;
    private HashMap assistDataTypes = new HashMap();
    private List entitys;

    public SelectorItemCollection getSelector() {
        return this.selector;
    }

    public EnumInfo getEnumInfo() {
        return this.EnumInfo;
    }

    public HashMap getSqlComboLists() {
        return this.sqlComboLists;
    }

    public HashMap getLookUpObjects() {
        return this.lookUpObjects;
    }

    public void setLookUpObjects(HashMap lookUpObjects) {
        this.lookUpObjects = lookUpObjects;
    }

    public BusinessInfo() {
        this.mapElements = new HashMap();
        this.entitys = new ArrayList();
        this.EnumInfo = new EnumInfo();
        this.sqlComboLists = new HashMap();
    }

    public List getEntrys() {
        return this.entitys;
    }

    public List getFieldList() {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Entity entity : this.entitys) {
            for (Field field : entity.getFields()) {
                result.add(field);
            }
        }
        return result;
    }

    public Entity getEntity(int index) {
        return (Entity)this.entitys.get(index);
    }

    public int getEntryCount() {
        return this.entitys.size();
    }

    public Element getElement(String key) {
        if (key == null) {
            return null;
        }
        return (Element)this.mapElements.get(key.toUpperCase());
    }

    public Field getField(String key) {
        if (!StringUtils.isEmpty((String)key) && this.mapElements.containsKey(key.toUpperCase()) && this.mapElements.get(key.toUpperCase()) instanceof Field) {
            return (Field)this.mapElements.get(key.toUpperCase());
        }
        return null;
    }

    public Entity getEntity(String key) {
        return (Entity)this.mapElements.get(key.toUpperCase());
    }

    public Form getForm() {
        return (Form)this.mapElements.get("_BILL");
    }

    public LookUpObject getLookUpObject(String fieldKey) {
        Field field;
        LookUpObject lookupObj = null;
        if (this.lookUpObjects != null && (field = this.getField(fieldKey)).getLookUpObjectID() != -1) {
            lookupObj = (LookUpObject)this.lookUpObjects.get(String.valueOf(field.getLookUpObjectID()));
        }
        return lookupObj;
    }

    public LookUpObject getLookUpObject(int id) {
        if (this.lookUpObjects != null) {
            return (LookUpObject)this.lookUpObjects.get(String.valueOf(id));
        }
        return null;
    }

    public boolean containsKey(String key) {
        return this.mapElements.containsKey(key);
    }

    public void add(Element businessattri) {
        if (this.mapElements.containsValue(businessattri)) {
            return;
        }
        this.mapElements.put(businessattri.getKey().toUpperCase(), businessattri);
        businessattri.addKeyChangeListener(this);
        if (businessattri instanceof Entity) {
            this.entitys.add(businessattri);
            Entity entity = (Entity)businessattri;
            if (entity.isMustInput() && entity.getEntityType() == 1) {
                this.addRequiredValidation(entity.getKey(), entity.getEntryName(), 0);
            }
        } else if (businessattri instanceof Field) {
            Field fld = (Field)businessattri;
            this.parseSelector(fld);
            this.parseMustInput(fld);
            Entity entity = (Entity)this.getElement(fld.getEntityKey());
            entity.getFields().add(fld);
            if (fld.isMainOrg()) {
                this.mainOrgField = fld;
            }
        }
    }

    private void parseMustInput(Field field) {
        if (field.getMustInput() == 0 || StringUtils.isEmpty((String)field.getPropertyName())) {
            return;
        }
        String propertyName = this.getLongPropertyName(field);
        this.addRequiredValidation(field.getKey(), propertyName, field.getZeroEmpty());
    }

    private void addRequiredValidation(String key, String propertyName, int zeroEmpty) {
        if (StringUtils.isEmpty((String)propertyName)) {
            return;
        }
        if (this.checkItems == null) {
            this.checkItems = PropertyCheckConfigItems.defineForRequiredValidation((String)this.getForm().getBosType());
        }
        Property property = new Property(key, propertyName);
        if (zeroEmpty == 1) {
            property.setEmptyExpression(EMPTY_EXPRESSION_NULL);
        }
        this.checkItems.addRequiredProperty(property);
    }

    private String getLongPropertyName(Field field) {
        String propertyName = field.getPropertyName();
        String srcDisplayName = field.getSrcDisplayFieldName();
        if (StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        if (ExpressionUtil.isFieldName(propertyName)) {
            propertyName = ExpressionUtil.removeFormatSymbol(propertyName);
            field.setPropertyName(propertyName);
            return null;
        }
        Entity entity = this.getEntity(field.getEntityKey());
        String entryName = entity.getEntryName();
        if (entity.getEntityType() == 1) {
            if (!StringUtils.isEmpty((String)srcDisplayName) && field.getKey().toUpperCase().startsWith("FBASEDATAPROP")) {
                if (propertyName.indexOf(".") > 0) {
                    String ctlPropertyName = propertyName.substring(0, propertyName.indexOf("."));
                    if (srcDisplayName.startsWith("F")) {
                        srcDisplayName = srcDisplayName.substring(1);
                    }
                    if (srcDisplayName.endsWith("_L2")) {
                        srcDisplayName = srcDisplayName.substring(0, srcDisplayName.indexOf("_L2"));
                    }
                    propertyName = entryName + "." + ctlPropertyName + "." + srcDisplayName;
                }
            } else {
                propertyName = entryName + "." + propertyName;
            }
        }
        return propertyName;
    }

    public PropertyCheckConfigItems getCheckItems() {
        return this.checkItems;
    }

    public void parseSelector(Field field) {
        String propertyName = this.getSelectorPropertyName(field);
        String displayName = field.getSrcDisplayFieldName();
        if (propertyName == null) {
            return;
        }
        this.selector.add(new SelectorItemInfo(propertyName));
        if (DataMappingUtil.isDataBase(field.getElementType())) {
            if (field.getElementType() != 17 && field.getElementType() != 27) {
                this.selector.add(new SelectorItemInfo(propertyName + ".number"));
            }
            if (field.getElementType() == 30) {
                this.selector.add(new SelectorItemInfo(propertyName + ".dataValue"));
            } else {
                this.selector.add(new SelectorItemInfo(propertyName + ".name"));
            }
            try {
                if (!StringUtils.isEmpty((String)displayName)) {
                    if (displayName.indexOf("_L2") != -1) {
                        displayName = displayName.substring(1, 2).toLowerCase() + displayName.substring(2, displayName.indexOf("_L2"));
                    } else if (displayName.indexOf(".") == -1) {
                        displayName = displayName.substring(1, 2).toLowerCase() + displayName.substring(2);
                    }
                    this.selector.add(new SelectorItemInfo(propertyName + "." + displayName));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (field.getElementType() == 7) {
            this.selector.add(new SelectorItemInfo(propertyName + ".CU"));
        }
    }

    private String getSelectorPropertyName(Field field) {
        if (field.getPropertyName() == null || field.getPropertyName().trim().length() == 0) {
            return null;
        }
        if (this.selector == null) {
            this.selector = new SelectorItemCollection();
            this.selector.add(new SelectorItemInfo("*"));
        }
        String propertyName = this.getLongPropertyName(field);
        return propertyName;
    }

    public void addSelector(Field field, String selectorName) {
        String propertyName = this.getSelectorPropertyName(field);
        if (propertyName == null) {
            return;
        }
        this.selector.add(new SelectorItemInfo(propertyName + "." + selectorName));
        field.addSelector(selectorName);
    }

    public Field getMainOrgField() {
        return this.mainOrgField;
    }

    public void setMainOrgField(Field mainOrgField) {
        this.mainOrgField = mainOrgField;
    }

    public Object clone() throws CloneNotSupportedException {
        BusinessInfo cloneBusi = (BusinessInfo)ObjectUtils.createCopy((Object)this);
        if (cloneBusi.mapElements != null) {
            for (Object key : cloneBusi.mapElements.keySet()) {
                Element el = cloneBusi.getElement(key.toString());
                el.setId("");
            }
        }
        ArrayList conditions = cloneBusi.getForm().getConditions();
        for (int i = 0; conditions != null && i < conditions.size(); ++i) {
            ((FormCondition)conditions.get(i)).setId(null);
        }
        return cloneBusi;
    }

    public void remove(Element element) {
        if (element instanceof Entity) {
            this.entitys.remove(element);
            element.removeKeyChangeListener(this);
            for (Field fld : ((Entity)element).getFields()) {
                this.mapElements.remove(fld.getKey().toUpperCase());
                fld.removeKeyChangeListener(this);
            }
        } else {
            Field fld = (Field)element;
            if (fld.getElementType() == 14 && fld.getControlFieldKey() != null && fld.getPropertyName() != null) {
                this.RemoveTakeBaseBinding(fld);
            }
            Entity entity = (Entity)this.getElement(fld.getEntityKey());
            entity.getFields().remove(fld);
            fld.removeKeyChangeListener(this);
        }
        this.mapElements.remove(element.getKey().toUpperCase());
    }

    private void RemoveTakeBaseBinding(Field fld) {
        Field ctrlFld = this.getField(fld.getControlFieldKey());
        if (ctrlFld == null) {
            return;
        }
        List actionList = ctrlFld.getUpdateActions();
        if (actionList == null) {
            return;
        }
        Action action = null;
        block0: for (int i = 0; i < actionList.size(); ++i) {
            Action act = (Action)actionList.get(i);
            if (act.getActionId() != 22) continue;
            String[] param = act.getParameters();
            for (int j = 0; param != null && j < param.length; ++j) {
                if (param[j] == null || !param[j].equalsIgnoreCase(fld.getKey())) continue;
                action = (Action)actionList.get(i);
                continue block0;
            }
        }
        if (action != null) {
            String paramStr = "[";
            String[] paramOld = action.getParameters();
            for (int j = 0; paramOld != null && j < paramOld.length; ++j) {
                if (paramOld[j] != null && paramOld[j].equalsIgnoreCase(fld.getKey())) continue;
                paramStr = paramStr + paramOld[j] + ",";
            }
            paramStr = paramStr.length() <= 1 ? "" : paramStr.substring(0, paramStr.length() - 1) + "]";
            action.setParameters(paramStr);
        }
    }

    @Override
    public void keyChanged(AbstractElement element, String newKey, String oldKey) {
        Element el;
        this.mapElements.remove(oldKey.toUpperCase());
        this.mapElements.put(newKey.toUpperCase(), element);
        if (element instanceof Entity) {
            Entity entity = (Entity)element;
            for (Field field : entity.getFields()) {
                field.setEntityKey(newKey);
            }
        }
        if (element.getElementType() == 13 || element.getElementType() == 7) {
            for (Object obj : this.mapElements.keySet()) {
                el = (Element)this.mapElements.get(obj);
                if (el.getElementType() != 14 && el.getElementType() != 13 && el.getElementType() != 7 || ((Field)el).getControlFieldKey() == null || !((Field)el).getControlFieldKey().equalsIgnoreCase(oldKey)) continue;
                ((Field)el).setControlFieldKey(newKey);
            }
        }
        for (Object obj : this.mapElements.keySet()) {
            el = (Element)this.mapElements.get(obj);
            PropertyUtil.dealAction(el, newKey, oldKey);
        }
    }

    public HashMap getAssistDataTypes() {
        return this.assistDataTypes;
    }

    public void addAssistDataType(String dataType) {
        this.assistDataTypes.put(dataType, dataType);
    }

    public void setConditionSelectors() {
        if (this.selector == null) {
            this.selector = new SelectorItemCollection();
            this.selector.add(new SelectorItemInfo("*"));
        }
        Form form = this.getForm();
        ArrayList conditions = form.getConditions();
        ExpressionParser expParser = ExpressionParser.getInstance();
        for (int i = 0; conditions != null && i < conditions.size(); ++i) {
            FormCondition condition = (FormCondition)conditions.get(i);
            String strCond = condition.getConditon();
            if (StringUtils.isEmpty((String)strCond)) continue;
            String[] vars = expParser.splitBarVariables(strCond);
            for (int j = 0; j < vars.length; ++j) {
                String var = ExpressionUtil.removeFormatSymbol(vars[j]);
                String propertyName = this.getFullPropertyName(var);
                if (propertyName == null) continue;
                this.selector.add(new SelectorItemInfo(propertyName));
            }
        }
    }

    public String getFullPropertyName(String key) {
        int idx = key.indexOf(46);
        String fieldKey = null;
        fieldKey = idx > 0 ? key.substring(0, idx) : key;
        Field field = this.getField(fieldKey);
        if (field == null) {
            return null;
        }
        if (idx < 0) {
            return this.getLongPropertyName(field);
        }
        return key.replaceFirst(fieldKey, this.getLongPropertyName(field));
    }

    public HashMap getBaseReferTables() {
        return this.baseReferTables;
    }

    public void setBaseReferTables(HashMap baseReferTables) {
        this.baseReferTables = baseReferTables;
    }

    public HashMap getTrdCtrlParams() {
        return this.trdCtrlParams;
    }

    public void setTrdCtrlParams(HashMap trdCtrlParams) {
        this.trdCtrlParams = trdCtrlParams;
    }
}

