/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class DisplayPattern
implements Serializable {
    public static DisplayPattern ISO_DATE_FORMAT = new DisplayPattern("F1", 0, "yyyy-MM-dd", "");
    public static DisplayPattern STD_DATETIME_FORMAT = new DisplayPattern("F2", 0, "yyyy-MM-dd HH:mm:ss", "");
    public static DisplayPattern ISO_DATETIME_FORMAT = new DisplayPattern("F3", 0, "yyyy-MM-dd'T'HH:mm:ss", "");
    public static DisplayPattern ISO_TIME_NO_T_FORMAT = new DisplayPattern("F4", 0, "HH:mm:ss", "");
    public static DisplayPattern DATE_AM_FORMAT = new DisplayPattern("F5", 0, "dd/MM/yyyy", "");
    public static DisplayPattern DATE_CN_FORMAT = new DisplayPattern("F6", 0, "yyyy\u5e74MM\u6708dd\u65e5", "");
    public static DisplayPattern RMB_GENERAL_FORMAT = new DisplayPattern("F20", 6, "RMB/G", "");
    private static final HashMap PATTERN_BY_ID = new HashMap();
    private String id;
    private int colType;
    private String javaPattern;
    private String extPattern;

    public static final List getDisplayPatternList(int colType) {
        ArrayList<DisplayPattern> patternList = new ArrayList<DisplayPattern>();
        switch (colType) {
            case 0: {
                patternList.add(ISO_DATE_FORMAT);
                patternList.add(STD_DATETIME_FORMAT);
                patternList.add(ISO_DATETIME_FORMAT);
                patternList.add(ISO_TIME_NO_T_FORMAT);
                patternList.add(DATE_AM_FORMAT);
                patternList.add(DATE_CN_FORMAT);
                break;
            }
            case 6: {
                patternList.add(RMB_GENERAL_FORMAT);
            }
        }
        return patternList;
    }

    public static final List getAllDisplayPatternList() {
        ArrayList<DisplayPattern> patternList = new ArrayList<DisplayPattern>();
        patternList.add(ISO_DATE_FORMAT);
        patternList.add(STD_DATETIME_FORMAT);
        patternList.add(ISO_DATETIME_FORMAT);
        patternList.add(ISO_TIME_NO_T_FORMAT);
        patternList.add(DATE_AM_FORMAT);
        patternList.add(DATE_CN_FORMAT);
        patternList.add(RMB_GENERAL_FORMAT);
        return patternList;
    }

    public static DisplayPattern getDisplayPattern(String id) {
        return (DisplayPattern)PATTERN_BY_ID.get(id);
    }

    public String getJavaPattern() {
        return this.javaPattern;
    }

    public String getExtPattern() {
        return this.extPattern;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.javaPattern;
    }

    public DisplayPattern(String id, int colType, String javaPattern, String extPattern) {
        this.id = id;
        this.colType = colType;
        this.extPattern = extPattern;
        this.javaPattern = javaPattern;
    }

    static {
        PATTERN_BY_ID.put(DisplayPattern.ISO_DATE_FORMAT.id, ISO_DATE_FORMAT);
        PATTERN_BY_ID.put(DisplayPattern.STD_DATETIME_FORMAT.id, STD_DATETIME_FORMAT);
        PATTERN_BY_ID.put(DisplayPattern.ISO_DATETIME_FORMAT.id, ISO_DATETIME_FORMAT);
        PATTERN_BY_ID.put(DisplayPattern.ISO_TIME_NO_T_FORMAT.id, ISO_TIME_NO_T_FORMAT);
        PATTERN_BY_ID.put(DisplayPattern.DATE_AM_FORMAT.id, DATE_AM_FORMAT);
        PATTERN_BY_ID.put(DisplayPattern.DATE_CN_FORMAT.id, DATE_CN_FORMAT);
        PATTERN_BY_ID.put(DisplayPattern.RMB_GENERAL_FORMAT.id, RMB_GENERAL_FORMAT);
    }
}

