/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.metadata.AbstractElement;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.ButtonAppearance;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.CtrlType;
import com.kingdee.eas.base.form.metadata.Element;
import com.kingdee.eas.base.form.metadata.ElementGroup;
import com.kingdee.eas.base.form.metadata.ElementProperty;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.metadata.FormAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.RadioButtonAppearance;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ElementType
implements Serializable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.metadata.ElementType");
    public static final int ELEMENTTYPE_FILTER = 200;
    public static final int ELEMENTTYPE_BILL = 100;
    public static final int ELEMENTTYPE_CUSTOMFILTERPANEL = 201;
    public static final int ELEMENTTYPE_FILTERPANEL = 202;
    public static final int ELEMENTTYPE_SORTPANEL = 203;
    public static final int ELEMENTTYPE_GROUPPANEL = 204;
    public static final int ELEMENTTYPE_COMBINUI = 210;
    public static final int ELEMENTTYPE_COMBINUITOPPANEL = 211;
    public static final int ELEMENTTYPE_COMBINUIPLUGIN = 212;
    public static final int ELEMENTTYPE_TABCONTROL = 1005;
    public static final int ELEMENTTYPE_TABPAGE = 1004;
    public static final int ELEMENTTYPE_DIALOG = 220;
    public static final int TYPE_OPERATION = 6;
    public static final int TYPE_BARITEM = 5;
    public static final int TYPE_FIELD = 4;
    public static final int TYPE_ENTITY = 2;
    public static final int TYPE_CONTROL = 3;
    public static final int TYPE_FORM = 1;
    public static final int FIELD_TEXT = 1;
    public static final int FILTER_FIELD_TEXT = 10001;
    public static final int FIELD_DECIMAL = 2;
    public static final int FILTER_FIELD_DECIMAL = 10002;
    public static final int FIELD_INT = 3;
    public static final int FILTER_FIELD_INT = 10003;
    public static final int FIELD_DATE = 4;
    public static final int FILTER_FIELD_DATE = 10004;
    public static final int FIELD_LONGDATE = 5;
    public static final int FIELD_REMARK = 6;
    public static final int FIELD_ORG = 7;
    public static final int FILTER_FIELD_ORG = 10007;
    public static final int FIELD_CHECKBOX = 8;
    public static final int FIELD_RADIO = 25;
    public static final int FIELD_RADIOGROUP = 32;
    public static final int FILTER_FIELD_RADIO = 10008;
    public static final int FIELD_COMBOX = 9;
    public static final int FIELD_MUL_COMBOX = 29;
    public static final int FIELD_SQL_COMBOX = 36;
    public static final int FIELD_ASSISTANT_COMBOX = 30;
    public static final int FIELD_MUL_ASSISTANT_COMBOX = 31;
    public static final int FILTER_FIELD_COMBOX = 10005;
    public static final int FIELD_NUMBER = 12;
    public static final int FIELD_BASEDATA = 13;
    public static final int FILTER_FIELD_BASEDATA = 10012;
    public static final int FIELD_BASEDATAPROPERTY = 14;
    public static final int FIELD_CALCULATEITEMTYPE = 15;
    public static final int FILTER_FIELD_CALCULATEITEMTYPE = 10010;
    public static final int FIELD_CALCULATEITEM = 16;
    public static final int FILTER_FIELD_CALCULATEITEM = 10006;
    public static final int FIELD_CREATOR = 17;
    public static final int FIELD_CREATEDATE = 26;
    public static final int FIELD_UPDATOR = 27;
    public static final int FIELD_MODIFYDATE = 28;
    public static final int FIELD_USER = 18;
    public static final int FILTER_FIELD_USER = 10009;
    public static final int FIELD_LOT = 19;
    public static final int FIELD_PRICE = 20;
    public static final int FIELD_AMOUNT = 21;
    public static final int FIELD_QUANTITY = 22;
    public static final int FIELD_LINKDATAPROPERTY = 23;
    public static final int FIELD_MUL_BASEDATA = 24;
    public static final int FIELD_PICTURE = 1011;
    public static final int FIELD_AMOUNTWORDS = 1020;
    public static final int FILTER_FIELD_CURRENCY = 10011;
    public static final int FILTER_FIELD_ENUM = 10013;
    public static final int CT_RADIO_GROUP = 9;
    public static final int CT_RADIO = 10;
    public static final int CT_TOP_CONTAINER = -1;
    public static final int CTRL_LABLE = 1001;
    public static final int CTRL_BUTTON = 1002;
    public static final int CTRL_SEPARATOR = 1003;
    public static final int CTRL_TAB = 1005;
    public static final int CTRL_TABPAGE = 1004;
    public static final int CTRL_FRAME = 1006;
    public static final int CTRL_FACEPANEL = 1012;
    public static final int CTRL_LINK = 1014;
    public static final int CTRL_ATTACHMENTMANAGE = 1013;
    public static final int CTRL_MULROWS_LABLE = 1015;
    public static final int CTRL_KNOWLEDGEPANEL = 1016;
    public static final int CTRL_RECTANGLE = 1017;
    public static final int CTRL_OFFICECTRL = 1018;
    public static final int CTRL_APPROVETABLE = 1019;
    public static final int CTRL_RELATEBILL = 1021;
    public static final int CTRL_OFFICETEMPLATE = 1022;
    public static final int CTRL_SEALCTRL = 1023;
    public static final int CTRL_FTPPANEL = 1024;
    public static final int CTRL_DOCUMENTPANEL = 1025;
    public static final int CTRL_APPROVEPANEL = 1026;
    public static final int CTRL_IMGPANEL = 1027;
    public static final int BarItemElementType_MenuBar = 2000;
    public static final int BarItemElementType_ToolBar = 2001;
    public static final int BarItemElementType_PopupMenu = 2002;
    public static final int BarItemElementType_StatusBar = 2003;
    public static final int BarItemElementType_Seperator = 2004;
    public static final int BarItemElementType_Button = 2005;
    public static final int BarItemElementType_Check = 2006;
    public static final int BarItemElementType_Combox = 2007;
    public static final int BarItemElementType_DropDownButton = 2008;
    public static final int BarItemElementType_SubDropDownButton = 2009;
    public static final int BarItemElementType_TextField = 2010;
    public static final int BarItemElementType_SubItem = 2015;
    public static final int BarItemElementType_SubCategory = 2016;
    public static final int ELEMENTTYPE_BILLHEAD = 34;
    public static final int ELEMENTTYPE_BILLBODY = 35;
    private int id;
    private String name;
    private int seq;
    private ElementGroup group;
    private CtrlType ctrlType;
    private boolean isPhysicsField;
    private String imgKey;
    private int type;
    private List elementPropertyArray;
    private boolean isVisible = true;
    private String elementClass;
    private String appearanceClass;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ElementType() {
    }

    public ElementType(int id, String name, int seq, ElementGroup group, CtrlType ctrlType, boolean isPhysicsField, String imgKey, int type) {
        this.ctrlType = ctrlType;
        this.group = group;
        this.id = id;
        this.imgKey = imgKey;
        this.isPhysicsField = isPhysicsField;
        this.name = name;
        this.seq = seq;
        this.type = type;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public ElementGroup getGroup() {
        return this.group;
    }

    public void setGroup(ElementGroup group) {
        this.group = group;
    }

    public CtrlType getCtrlType() {
        return this.ctrlType;
    }

    public void setCtrlType(CtrlType ctrlType) {
        this.ctrlType = ctrlType;
    }

    public boolean isPhysicsField() {
        return this.isPhysicsField;
    }

    public void setPhysicsField(boolean isPhysicsField) {
        this.isPhysicsField = isPhysicsField;
    }

    public String getImgKey() {
        return this.imgKey;
    }

    public void setImgKey(String imgKey) {
        this.imgKey = imgKey;
    }

    public List getElementPropertyArray() {
        return this.elementPropertyArray;
    }

    public ElementProperty getElementProperty(String propertyName) {
        for (int i = 0; !StringUtils.isEmpty((String)propertyName) && this.elementPropertyArray != null && i < this.elementPropertyArray.size(); ++i) {
            ElementProperty result = (ElementProperty)this.elementPropertyArray.get(i);
            if (!result.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return result;
        }
        return null;
    }

    public void setElementPropertyArray(List elementPropertyArray) {
        this.elementPropertyArray = elementPropertyArray;
    }

    public String toString() {
        return this.name;
    }

    public List getBusinessPropertys() {
        ArrayList<ElementProperty> propertyList = new ArrayList<ElementProperty>();
        for (int i = 0; this.elementPropertyArray != null && i < this.elementPropertyArray.size(); ++i) {
            ElementProperty property = (ElementProperty)this.elementPropertyArray.get(i);
            if (property.getBindingFlags() != 2 && property.getBindingFlags() != 3) continue;
            propertyList.add(property);
        }
        return propertyList;
    }

    public List getAppearancePropertys() {
        ArrayList<ElementProperty> propertyList = new ArrayList<ElementProperty>();
        for (int i = 0; this.elementPropertyArray != null && i < this.elementPropertyArray.size(); ++i) {
            ElementProperty property = (ElementProperty)this.elementPropertyArray.get(i);
            if (property.getBindingFlags() != 1 && property.getBindingFlags() != 3) continue;
            propertyList.add(property);
        }
        return propertyList;
    }

    public ElementProperty getKeyProperty() {
        for (int i = 0; this.elementPropertyArray != null && i < this.elementPropertyArray.size(); ++i) {
            ElementProperty property = (ElementProperty)this.elementPropertyArray.get(i);
            if (property.getBindingFlags() != 3 || !property.getPropertyName().equals("Key")) continue;
            return property;
        }
        return null;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public String getElementClass() {
        return this.elementClass;
    }

    public void setElementClass(String metaDataClass) {
        this.elementClass = metaDataClass;
    }

    public String getAppearanceClass() {
        return this.appearanceClass;
    }

    public void setAppearanceClass(String appearanceClass) {
        this.appearanceClass = appearanceClass;
    }

    public Element createElement(String key) throws BOSException {
        AbstractElement el = null;
        if (this.elementClass != null) {
            el = this.createAbstractElement(this.elementClass, key);
        } else {
            switch (this.type) {
                case 2: {
                    el = new Entity(key);
                    break;
                }
                case 4: {
                    el = new Field(key);
                    break;
                }
                case 1: {
                    el = new Form(key);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return (Element)el;
    }

    public Appearance createAppearance(String key, LayoutInfo layoutInfo) throws BOSException {
        if (this.appearanceClass != null) {
            if (this.appearanceClass.equalsIgnoreCase(ButtonAppearance.class.getName())) {
                return new ButtonAppearance(layoutInfo, key);
            }
            if (this.appearanceClass.equalsIgnoreCase(RadioButtonAppearance.class.getName())) {
                return new RadioButtonAppearance(layoutInfo, key);
            }
            return this.createAppearance(key);
        }
        return this.createAppearance(key);
    }

    public Appearance createAppearance(String key) throws BOSException {
        AbstractElement el = null;
        if (this.appearanceClass != null && this.appearanceClass.trim().length() > 0) {
            try {
                el = this.createAbstractElement(this.appearanceClass, key);
            }
            catch (Exception e) {
                logger.error((Object)(this.name + "\u5b9a\u4e49\u7684\u5916\u89c2\u7c7b\u6ca1\u6709\u627e\u5230[" + this.appearanceClass.trim() + "]"));
            }
        }
        if (el == null) {
            switch (this.type) {
                case 3: {
                    el = new ControlAppearance(key);
                    break;
                }
                case 2: {
                    el = new EntityAppearance(key);
                    break;
                }
                case 4: {
                    el = new FieldAppearance(key);
                    break;
                }
                case 1: {
                    el = new FormAppearance(key);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return el;
    }

    private AbstractElement createAbstractElement(String className, String key) throws BOSException {
        AbstractElement el = null;
        try {
            Class<?> clz = Class.forName(className);
            Constructor<?> constructor = clz.getConstructor(String.class);
            el = (AbstractElement)constructor.newInstance(key);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return el;
    }
}

