/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.model.AbstractDynamicFormPlugin;
import com.kingdee.eas.base.form.model.ApplicationContext;
import com.kingdee.eas.base.form.model.DynamicFormEventsProxy;
import com.kingdee.eas.base.form.model.IDynamicFormModel;
import com.kingdee.eas.base.form.model.IDynamicFormView;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.Hashtable;
import java.util.List;

public class DynamicFormApplication {
    private IDynamicFormView dynamicFormView;
    private IDynamicFormModel dynamicFormModel;
    private Hashtable customParams;
    private ApplicationContext applicationContext;
    private ActionArgs e;
    private DynamicFormEventsProxy eventsProxy;
    private Context context;

    public ActionArgs getE() {
        return this.e;
    }

    public void setE(ActionArgs e) {
        this.e = e;
    }

    public void setCustomParameters(Hashtable customParams) {
        this.customParams = customParams;
    }

    public void setCustomParameter(String key, Object value) {
        this.customParams.put(key, value);
    }

    public Object getCustomParameter(String key) {
        return this.customParams.get(key);
    }

    public IDynamicFormModel getDynamicFormModel() {
        return this.dynamicFormModel;
    }

    public IDynamicFormView getDynamicFormView() {
        return this.dynamicFormView;
    }

    public Context getContext() {
        return this.context;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public DynamicFormApplication(IDynamicFormView dynamicFormView, IDynamicFormModel dynamicFormModel) {
        this.dynamicFormView = dynamicFormView;
        this.dynamicFormModel = dynamicFormModel;
        this.customParams = new Hashtable();
        this.init(dynamicFormModel);
    }

    private void init(IDynamicFormModel dynamicFormModel) {
        this.eventsProxy = new DynamicFormEventsProxy();
        this.dynamicFormView.setEventsProxy(this.eventsProxy.getViewEventsProxy());
        this.dynamicFormModel.setEventsProxy(this.eventsProxy.getModelEventsProxy());
        this.dynamicFormView.setApplication(this);
        this.dynamicFormModel.setApplication(this);
        this.customParams = new Hashtable();
        this.applicationContext = new ApplicationContext();
    }

    public AbstractDynamicFormPlugin registerPlugIn(String pluginClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        AbstractDynamicFormPlugin plugin = (AbstractDynamicFormPlugin)Class.forName(pluginClassName).newInstance();
        plugin.attachApplication(this);
        this.eventsProxy.addFormListener(plugin);
        return plugin;
    }

    public DynamicFormApplication(Context context, IDynamicFormView dynamicFormView, IDynamicFormModel dynamicFormModel) {
        this.context = context;
        this.dynamicFormView = dynamicFormView;
        this.dynamicFormModel = dynamicFormModel;
        this.init(dynamicFormModel);
    }

    public void registPlugIn(AbstractDynamicFormPlugin plugin) {
        plugin.attachApplication(this);
        this.eventsProxy.addFormListener(plugin);
    }

    public void registPlugIn(List plugins) throws BOSException {
        if (plugins.size() == 0) {
            return;
        }
        try {
            for (int i = plugins.size() - 1; i >= 0; --i) {
                String className = (String)plugins.get(i);
                AbstractDynamicFormPlugin plugin = (AbstractDynamicFormPlugin)Class.forName(className.trim()).newInstance();
                this.registPlugIn(plugin);
            }
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void setValue(String key, Object value, int row) throws EASBizException, BOSException {
        this.dynamicFormModel.setValue(key, value, row);
        this.dynamicFormView.updateView(key, value, row);
    }

    public void setDateValue(String key, Object value, int row) throws EASBizException, BOSException {
        this.dynamicFormModel.setValue(key, value, row);
    }

    public Object getValue(String key, int row) {
        return this.dynamicFormModel.getValue(key, row);
    }

    public void setEnabled(String key, boolean value) {
        this.dynamicFormView.setEnabled(key, value);
    }

    public void showMessage(String msg) {
        this.dynamicFormView.showMessage(msg);
    }

    public void showMessage(String operation, String msg, int result, String key) {
        this.dynamicFormView.showMessage(operation, msg, result, key);
    }

    public OrgUnitInfo getMainOrgUnit() {
        return this.dynamicFormModel.getMainOrgUnit();
    }

    public void setContentURL(String key, String url, String param) throws BOSException {
        this.dynamicFormView.setContentURL(key, url, param);
    }

    public void popupWindow(String url, String popupMode, String name, String title, int x, int y) throws BOSException {
        this.dynamicFormView.popupWindow(url, popupMode, name, title, x, y);
    }

    public void popupWindow(String url, String popupMode, String formId) throws BOSException {
        this.dynamicFormView.popupWindow(url, popupMode, formId);
    }

    public void showConfirm(String function, String msg) throws BOSException {
        this.dynamicFormView.showConfirm(function, msg);
    }

    public int showConfirm(String id, String title, String msg, int option) {
        return this.dynamicFormView.showConfirm(id, title, msg, option);
    }

    public int showConfirm(String id, String title, String msg, int option, String script) {
        return this.dynamicFormView.showConfirm(id, title, msg, option, script);
    }

    public void setEnumContents(String key, List enums) throws BOSException {
        this.dynamicFormView.setEnumContents(key, enums);
    }

    public Object searchValue(String key, int row) throws BOSException {
        return this.getValue(key, row);
    }

    public Object getSelectedRowData(String entityKey, String property) throws BOSException {
        return null;
    }

    public void setControlText(String key, String text) {
        this.dynamicFormView.setControlText(key, text);
    }

    public void setControlProperty(String key, String propertyName, Object value) {
        this.dynamicFormView.setControlProperty(key, propertyName, value);
    }

    public boolean isEnabled(String key) {
        return this.dynamicFormView.isEnabled(key);
    }

    public boolean isVisible(String key) {
        return this.dynamicFormView.isVisible(key);
    }

    public void bindDynamicField(String key, String property) {
        Field field = this.getDynamicFormModel().getBusinessInfo().getField(key);
        field.setPropertyName(property);
        this.getDynamicFormModel().getBusinessInfo().parseSelector(field);
    }

    public void setParentRefresh(boolean refreshParent) throws BOSException {
        this.dynamicFormView.setParentRefresh(refreshParent);
    }

    public void setFieldFilter(String key, String oqlFilter) throws BOSException {
        this.dynamicFormView.setFieldFilter(key, oqlFilter);
    }

    public void addError(String key, String msg) {
        this.dynamicFormView.addError(key, msg);
    }
}

