/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.extend.flow.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.extend.flow.FlowNodeCtrlApproveEntryInfo;
import com.kingdee.eas.base.form.extend.flow.plugin.ApproveActivityConfig;
import com.kingdee.eas.base.form.extend.flow.plugin.FlowApproveHelper;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.EnumSringItem;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.TabControlAppearance;
import com.kingdee.eas.base.form.model.IDynamicFormModel;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.BeforeUpdateValueArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.util.DynamicEnum;
import com.kingdee.eas.base.form.util.WorkFlowUtil;
import com.kingdee.eas.base.form.web.FormMetaCacheManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NodeControlSet
extends AbstractBillPlugin {
    private BusinessInfo businessInfo;
    private LayoutInfo layoutInfo;
    private String flowId;
    private String layoutId;
    private String formId;
    private String nodeId;
    private String newnodeId;
    private String flowName;
    private String templateId;
    private String effectiveSignCtrl;
    private boolean isAfterConfirming = false;

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        ProcessDefInfo pd;
        super.onInitialize(param);
        this.formId = (String)this.application.getCustomParameter("tempformID");
        this.flowId = (String)this.application.getCustomParameter("flowID");
        if (this.flowId != null && !this.flowId.equals("DRAFT") && (pd = WorkFlowUtil.getProcessDef((Context)this.application.getContext(), (String)this.flowId)) != null) {
            this.flowName = pd.getProcDefName(this.application.getContext().getLocale());
        }
        this.templateId = (String)this.application.getCustomParameter("templateId");
        this.nodeId = "-1";
        FormMetaData formMeta = FormMetaCacheManager.getFormMeta((Context)this.application.getContext(), (String)this.formId, null);
        if (formMeta == null) {
            this.application.showMessage("\u83b7\u53d6\u8868\u5355\u5143\u6570\u636e\u5931\u8d25\uff0cFormID=" + this.formId);
            return false;
        }
        this.businessInfo = formMeta.getBusinessInfo();
        this.layoutId = (String)this.application.getCustomParameter("tempLayoutID");
        if (this.layoutId == null) {
            this.layoutId = formMeta.getLayoutInfo().getId();
        }
        this.layoutInfo = formMeta.getLayoutInfobyID(this.layoutId);
        this.bindDynControl();
        param.billPk = this.getPk();
        return true;
    }

    private void bindDynControl() {
        this.application.bindDynamicField("FFieldEntityName", "entityName");
        this.application.bindDynamicField("FFlowNode", "flowNodeId");
        this.application.bindDynamicField("FFieldName", "fieldName");
        this.application.bindDynamicField("FContainerName", "containerName");
        this.application.bindDynamicField("FOpreateName", "opreateName");
        this.application.bindDynamicField("FFlowName", "flowName");
        this.application.bindDynamicField("FConfigStatus", "configStatus");
        ArrayList<EnumSringItem> items = new ArrayList<EnumSringItem>();
        EnumSringItem item = new EnumSringItem();
        if (this.flowId != null && !this.flowId.equals("DRAFT")) {
            try {
                IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)this.application.getContext());
                ProcessDefInfo pi = wfService.getProcessDefInfo(this.flowId);
                ProcessDef pd = wfService.getProcessDefByDefineHashValue(pi.getMd5HashValue());
                ActivityCollection acts = pd.getActivitys();
                for (int i = 0; i < acts.size(); ++i) {
                    ActivityDef act = acts.get(i);
                    if (!(act instanceof WebBillManpowerActivityDef) && !(act instanceof ApproveActivityDef)) continue;
                    item = new EnumSringItem();
                    item.setValue(act.getID());
                    item.setDisplayValueValue(act.getName(this.application.getContext().getLocale()));
                    items.add(item);
                }
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            if (items.size() > 0) {
                this.nodeId = ((EnumSringItem)items.get(0)).getValue();
            }
        } else {
            item.setValue("-1");
            item.setDisplayValueValue("\u8d77\u8349");
            items.add(item);
        }
        try {
            this.application.getView().setComboItems("FFlowNode", items);
            this.application.getView().setComboItems("FEffectiveSignCtrl", this.getSignCtrls4Combo());
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    private List getSignCtrls4Combo() {
        List signCtrls = this.layoutInfo.getSignControls();
        DynamicEnum signCtrlEnum = null;
        signCtrlEnum = new DynamicEnum();
        signCtrlEnum.addItem("", "");
        if (signCtrls.size() > 0) {
            for (ControlAppearance ca : signCtrls) {
                signCtrlEnum.addItem(ca.getKey(), ca.getCaption());
            }
            this.effectiveSignCtrl = signCtrlEnum.getInnerValue(0);
        }
        return signCtrlEnum == null ? null : signCtrlEnum.getEnumList();
    }

    private String getPk() {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("layoutId", (Object)this.layoutId);
        filter.appendFilterItem("flowId", (Object)this.flowId);
        filter.appendFilterItem("flowNodeId", (Object)this.nodeId);
        filter.appendFilterItem("templateId", (Object)this.templateId);
        try {
            IObjectPK[] pks = DAOHelper.getDAO().getPKList(this.application.getContext(), BOSObjectType.create((String)this.application.getBillModel().getBusinessInfo().getForm().getBosType()), filter, null);
            if (pks.length > 0) {
                return pks[0].toString();
            }
            return null;
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public void onLoad() {
        super.onLoad();
    }

    public void afterBindData() throws EASBizException, BOSException {
        super.afterBindData();
        if (this.nodeId.equals("-1") || this.flowId == null || this.flowId.equals("DRAFT")) {
            this.application.lockElement("FFlowNode", true);
            this.application.hideElement("FFlowName", true);
        } else {
            this.application.lockElement("FFlowNode", false);
        }
        if ("false".equalsIgnoreCase(this.application.getValue("FDelAttachment", 0).toString())) {
            this.application.lockElement("FradioGroup", true);
            this.application.lockElement("Fradio", true);
            this.application.lockElement("Fradio1", true);
        }
        if ("false".equalsIgnoreCase(this.application.getValue("FModifyAttachment", 0).toString())) {
            this.application.lockElement("FradioGroup1", true);
            this.application.lockElement("Fradio2", true);
            this.application.lockElement("Fradio3", true);
        }
        if (this.flowId == null || this.flowId.equals("DRAFT")) {
            this.application.hideElement("FIsAllowPrintOffice", false);
            this.application.lockElement("FIsAllowPrintOffice", false);
        }
    }

    public void afterCreateNewData() throws EASBizException, BOSException {
        this.application.getBillModel().beginIniti();
        IObjectValue objValue = this.application.getBillModel().getBillValue();
        objValue.setString("flowId", this.flowId);
        objValue.setString("flowNodeId", this.nodeId);
        objValue.setString("formId", this.formId);
        objValue.setString("layoutId", this.layoutId);
        objValue.setString("templateId", this.templateId);
        objValue.setString("elecSign", this.effectiveSignCtrl);
        this.application.setValue("FConfigStatus", (Object)"\u672a\u914d\u7f6e", 0);
        this.builderData();
        this.application.getBillModel().endIniti();
    }

    public void beforeUpdateValue(BeforeUpdateValueArg arg) throws EASBizException, BOSException {
        super.beforeUpdateValue(arg);
        if (arg.getKey().equalsIgnoreCase("FFlowNode") && !this.nodeId.equalsIgnoreCase(arg.getValue().toString())) {
            arg.setCancel(true);
            this.newnodeId = arg.getValue().toString();
            if (this.application.getBillModel().isChanged()) {
                this.application.showConfirm("dataChandedConfirm", "\u4fe1\u606f\u63d0\u793a", "\u5f53\u524d\u8282\u70b9\u914d\u7f6e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u4fdd\u5b58", 8189);
                return;
            }
            this.changeNodeData();
        }
    }

    private void changeNodeData() {
        try {
            this.nodeId = this.newnodeId;
            String pk = this.getPk();
            if (pk == null) {
                if (this.application.getBillView().getOperationStatus() == OperationStatus.VIEW) {
                    this.application.getBillModel().createNewData();
                    this.application.getBillView().bindData((IDynamicFormModel)this.application.getBillModel());
                } else {
                    this.application.getBillView().createNewData();
                }
            } else {
                this.application.load(pk);
            }
        }
        catch (Exception e) {
            this.application.showMessage(e.getLocalizedMessage());
        }
    }

    public void afterConfirm(String id, int returnOption) throws EASBizException, BOSException {
        if (id.equalsIgnoreCase("dataChandedConfirm")) {
            if (returnOption == 0) {
                this.isAfterConfirming = true;
                this.application.getBillModel().save();
            }
            this.nodeId = this.newnodeId;
            this.changeNodeData();
        } else {
            super.afterConfirm(id, returnOption);
        }
    }

    public void afterLoadData() throws EASBizException, BOSException {
        if (!this.isAfterConfirming) {
            this.application.getBillModel().beginIniti();
            this.application.setValue("FConfigStatus", (Object)"\u5df2\u914d\u7f6e", 0);
            this.builderData();
            this.application.getBillModel().endIniti();
        } else {
            this.isAfterConfirming = false;
        }
    }

    public boolean beforeSaveOrSubmitData() {
        return true;
    }

    private void builderData() throws EASBizException, BOSException {
        if (this.businessInfo == null) {
            return;
        }
        this.application.setValue("FFlowName", (Object)this.flowName, 0);
        IObjectCollection fieldCollection = this.application.getBillModel().getEntryData(this.application.getBillModel().getBusinessInfo().getEntity("FFields"));
        IObjectCollection containerCollection = this.application.getBillModel().getEntryData(this.application.getBillModel().getBusinessInfo().getEntity("FContainers"));
        IObjectCollection opreateCollection = this.application.getBillModel().getEntryData(this.application.getBillModel().getBusinessInfo().getEntity("FOpreates"));
        IObjectCollection officeCtrlCollection = this.application.getBillModel().getEntryData(this.application.getBillModel().getBusinessInfo().getEntity("FOfficeCtrlEntry"));
        this.createFieldsFromMetaData(fieldCollection);
        this.createContainersFromMetaData(containerCollection);
        this.createButtonsFromMetaData(opreateCollection);
        this.createOfficeControlEntryData(officeCtrlCollection);
        this.createApproveItems();
    }

    private void createApproveItems() throws EASBizException, BOSException {
        if (this.flowId == null || this.flowId.equals("DRAFT")) {
            return;
        }
        try {
            IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)this.application.getContext());
            ProcessDefInfo pi = wfService.getProcessDefInfo(this.flowId);
            ProcessDef pd = wfService.getProcessDefByDefineHashValue(pi.getMd5HashValue());
            ActivityCollection acts = pd.getActivitys();
            ActivityDef act = acts.get(this.nodeId);
            Map itemsMap = null;
            if (act instanceof WebBillManpowerActivityDef) {
                itemsMap = FlowApproveHelper.getWebBillManpowerActivityItems();
            } else if (act instanceof ApproveActivityDef) {
                itemsMap = FlowApproveHelper.getApproveActivityItems();
            }
            this.updateApproveItemsFromDB(itemsMap);
            this.updateApproveItemsFromFlowConfig(itemsMap, act);
            LinkedList entryList = new LinkedList();
            entryList.addAll(itemsMap.values());
            this.sortApproveItems(entryList);
            this.createApproveItems(entryList, (ManpowerActivityDef)act);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    private void updateApproveItemsFromFlowConfig(Map itemsMap, ActivityDef act) {
        boolean isApproveNode = false;
        if (act instanceof ApproveActivityDef) {
            isApproveNode = true;
        } else if (act instanceof WebBillManpowerActivityDef) {
            isApproveNode = false;
        }
        ApproveActivityConfig aac = FlowApproveHelper.getApproveActivityConfig((ManpowerActivityDef)act);
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_NEXTPARTICIPANT[0], aac.isNextParticipant());
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_DELIVER[0], aac.isDeliver());
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_KICKBACK[0], aac.isKickBack());
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_JUMP[0], aac.isJump());
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_ADDSIGN[0], aac.isAddSign());
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_SUBMITNEXT[0], aac.isSubmitNext());
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_MULTISIGN[0], aac.isMultiSign());
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_SENDEMAIL[0], aac.isSendEmail());
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_SENDSMS[0], aac.isSendSMS());
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_AGREE[0], true);
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_DISAGREE[0], true);
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_SAVE[0], true);
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_VIEWFLOW[0], true);
        this.updateApproveOperateItemConfig(itemsMap, FlowApproveHelper.OPERATE_PASSASSIGNMENT[0], true);
    }

    private void updateApproveOperateItemConfig(Map itemsMap, String key, boolean value) {
        if (itemsMap.containsKey(key)) {
            ((FlowNodeCtrlApproveEntryInfo)itemsMap.get(key)).setIsConfig(value);
        }
    }

    private void updateApproveItemsFromDB(Map itemsMap) {
        if (itemsMap == null) {
            return;
        }
        IObjectCollection approveCollection = this.application.getBillModel().getEntryData(this.application.getBillModel().getBusinessInfo().getEntity("FApprovePanel"));
        for (IObjectValue rowData : approveCollection) {
            Object key = rowData.get("key");
            if (key == null || itemsMap.get(key) == null) continue;
            ((FlowNodeCtrlApproveEntryInfo)itemsMap.get(key)).setDisplayName(rowData.getString("displayName"));
            ((FlowNodeCtrlApproveEntryInfo)itemsMap.get(key)).setIsConfig(rowData.getBoolean("isConfig"));
            ((FlowNodeCtrlApproveEntryInfo)itemsMap.get(key)).setIsHide(rowData.getBoolean("isHide"));
            ((FlowNodeCtrlApproveEntryInfo)itemsMap.get(key)).setSeq(rowData.getInt("seq"));
            ((FlowNodeCtrlApproveEntryInfo)itemsMap.get(key)).setOrder(rowData.getInt("order"));
        }
        for (int j = approveCollection.size() - 1; j >= 0; --j) {
            approveCollection.removeObject(j);
        }
    }

    private void sortApproveItems(List entryList) {
        Collections.sort(entryList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int result = ((FlowNodeCtrlApproveEntryInfo)arg0).getOrder() - ((FlowNodeCtrlApproveEntryInfo)arg1).getOrder();
                if (result == 0) {
                    result = ((FlowNodeCtrlApproveEntryInfo)arg0).getSeq() - ((FlowNodeCtrlApproveEntryInfo)arg1).getSeq();
                }
                return result;
            }
        });
    }

    private void createApproveItems(Collection entryInfoCol, ManpowerActivityDef actDef) throws EASBizException, BOSException {
        int i = 0;
        for (FlowNodeCtrlApproveEntryInfo entryInfo : entryInfoCol) {
            this.application.getBillModel().createNewEntryRow("FApprovePanel");
            this.application.setValue("FApproveKey", (Object)entryInfo.getKey(), i);
            this.application.setValue("FApproveSeq", (Object)Integer.valueOf(String.valueOf(i + 1)), i);
            this.application.setValue("FApproveOrder", (Object)Integer.valueOf(String.valueOf(entryInfo.getOrder() == 0 ? i + 1 : entryInfo.getOrder())), i);
            this.application.setValue("FApproveName", (Object)entryInfo.getName(), i);
            this.application.setValue("FApproveDisplayName", (Object)(StringUtils.isEmpty((String)entryInfo.getDisplayName()) ? entryInfo.getName() : entryInfo.getDisplayName()), i);
            this.application.setValue("FApproveIsConfig", (Object)entryInfo.isIsConfig(), i);
            this.application.setValue("FApproveOperateType", (Object)Integer.valueOf(String.valueOf(entryInfo.getOperateType())), i);
            this.application.setValue("FApproveIsHide", (Object)entryInfo.isIsHide(), i++);
        }
    }

    private Hashtable getControlFromObject(IObjectCollection entryCollection) {
        Hashtable<String, ControlPolicy> map = new Hashtable<String, ControlPolicy>();
        for (IObjectValue rowData : entryCollection) {
            Object key = rowData.get("key");
            if (key == null) continue;
            ControlPolicy fldCtl = new ControlPolicy(key.toString());
            fldCtl.setVisible(rowData.getBoolean("isHide"));
            fldCtl.setLock(rowData.getBoolean("isLock"));
            if (rowData.get("isMustInput") != null) {
                fldCtl.setMustInput(rowData.getBoolean("isMustInput"));
            } else {
                fldCtl.setMustInput(false);
            }
            if (rowData.get("isDefaultShow") != null) {
                fldCtl.setDefaultShow(rowData.getBoolean("isDefaultShow"));
            } else {
                fldCtl.setDefaultShow(false);
            }
            if (rowData.get("parentKey") != null) {
                fldCtl.setParentKey(rowData.getString("parentKey"));
            } else {
                fldCtl.setParentKey("");
            }
            map.put(fldCtl.getKey(), fldCtl);
        }
        return map;
    }

    private void createFieldsFromMetaData(IObjectCollection entryCollection) throws EASBizException, BOSException {
        Hashtable mapfields = this.getControlFromObject(entryCollection);
        for (int j = entryCollection.size() - 1; j >= 0; --j) {
            entryCollection.removeObject(j);
        }
        int i = 0;
        this.createFields(i, this.layoutInfo, mapfields);
    }

    private void createFields(int i, LayoutInfo layoutInfo, Hashtable mapfields) throws BOSException, EASBizException {
        for (Appearance ctl : layoutInfo.getControls()) {
            if (!(ctl instanceof EntityAppearance)) continue;
            EntityAppearance entityCtl = (EntityAppearance)ctl;
            for (Object ctlAp : entityCtl.getLayoutinfo().getControls()) {
                FieldAppearance fldAp;
                if (!(ctlAp instanceof FieldAppearance) || !(fldAp = (FieldAppearance)ctlAp).isBillVisible()) continue;
                this.createField(mapfields, i, entityCtl, fldAp);
                ++i;
            }
            if (entityCtl.getControlType() != -1) continue;
            this.createFields(i, entityCtl.getLayoutinfo(), mapfields);
        }
    }

    private void createField(Hashtable mapfields, int i, EntityAppearance entityCtl, FieldAppearance fldAp) throws BOSException, EASBizException {
        this.application.getBillModel().createNewEntryRow("FFields");
        this.application.setValue("FFieldkey", (Object)fldAp.getKey(), i);
        this.application.setValue("FFieldName", (Object)fldAp.getCaption(), i);
        this.application.setValue("FFieldEntityName", (Object)entityCtl.getCaption(), i);
        ControlPolicy fld = (ControlPolicy)mapfields.get(fldAp.getKey());
        if (fld != null) {
            this.application.setValue("FFieldLock", (Object)fld.getLock(), i);
            this.application.setValue("FFieldVisible", (Object)fld.getVisible(), i);
            if (this.businessInfo.getField(fldAp.getKey()).isMustInput()) {
                this.application.lockElement("FFieldMustInput", i, true);
                this.application.setValue("FFieldMustInput", (Object)true, i);
            } else {
                this.application.setValue("FFieldMustInput", (Object)fld.getMustInput(), i);
            }
        } else {
            boolean block = false;
            boolean bvisible = false;
            if (this.nodeId.equalsIgnoreCase("-1")) {
                block = fldAp.isNewLock();
                bvisible = fldAp.isNewVisible();
            } else {
                block = fldAp.isEditLock();
                bvisible = fldAp.isEditVisible();
            }
            this.application.setValue("FFieldLock", (Object)new Boolean(block), i);
            this.application.setValue("FFieldVisible", (Object)new Boolean(!bvisible), i);
            Field field = this.businessInfo.getField(fldAp.getKey());
            if (field.isMustInput()) {
                this.application.lockElement("FFieldMustInput", i, true);
            }
            this.application.setValue("FFieldMustInput", (Object)new Boolean(field.isMustInput()), i);
        }
    }

    private void createContainersFromMetaData(IObjectCollection entryCollection) throws EASBizException, BOSException {
        int i = 0;
        Hashtable mapfields = this.getControlFromObject(entryCollection);
        for (int j = entryCollection.size() - 1; j >= 0; --j) {
            entryCollection.removeObject(j);
        }
        for (Appearance ctl : this.layoutInfo.getControls()) {
            if (!(ctl instanceof EntityAppearance) || ctl.getControlType() != -1) continue;
            EntityAppearance entityCtl = (EntityAppearance)ctl;
            for (ControlAppearance ctlAp : entityCtl.getLayoutinfo().getControls()) {
                if (ctlAp.getControlType() != 1006 && ctlAp.getControlType() != 1004 && ctlAp.getControlType() != 1005 && ctlAp.getControlType() != 1012 && ctlAp.getControlType() != 1019 && ctlAp.getControlType() != 1026) continue;
                this.application.getBillModel().createNewEntryRow("FContainers");
                this.application.setValue("FContainerkey", (Object)ctlAp.getKey(), i);
                this.application.setValue("FContainerName", (Object)ctlAp.getCaption(), i);
                ControlPolicy fld = (ControlPolicy)mapfields.get(ctlAp.getKey());
                if (fld != null) {
                    this.application.setValue("FContainerVisible", (Object)fld.getVisible(), i);
                } else {
                    this.application.setValue("FContainerVisible", (Object)Boolean.FALSE, i);
                }
                this.application.lockElement("FContainerDefShow", i, true);
                if (ctlAp.getControlType() == 1005) {
                    TabControlAppearance tca = (TabControlAppearance)ctlAp;
                    Appearance tabApp2 = null;
                    boolean hasDefault = false;
                    int firstRow = i + 1;
                    for (Appearance tabApp2 : tca.getTabPages()) {
                        this.application.getBillModel().createNewEntryRow("FContainers");
                        this.application.setValue("FContainerkey", (Object)tabApp2.getKey(), ++i);
                        this.application.setValue("FContainerName", (Object)(ctlAp.getCaption() + "-" + tabApp2.getCaption()), i);
                        fld = (ControlPolicy)mapfields.get(tabApp2.getKey());
                        if (fld != null) {
                            this.application.setValue("FContainerVisible", (Object)fld.getVisible(), i);
                            this.application.setValue("FContainerDefShow", (Object)fld.getDefaultShow(), i);
                            if (Boolean.valueOf(fld.getDefaultShow()).booleanValue()) {
                                hasDefault = true;
                            }
                        } else {
                            this.application.setValue("FContainerVisible", (Object)Boolean.FALSE, i);
                            this.application.setValue("FContainerDefShow", (Object)Boolean.FALSE, i);
                        }
                        this.application.lockElement("FContainerDefShow", i, false);
                        this.application.setValue("FContainerParentKey", (Object)ctlAp.getKey(), i);
                    }
                    if (!hasDefault && i >= firstRow) {
                        this.application.setValue("FContainerDefShow", (Object)Boolean.TRUE, firstRow);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dataChanged(DataChangeCommandArg dataChangeCommandArg) {
        String key = dataChangeCommandArg.getKey();
        if ("FContainerDefShow".equalsIgnoreCase(key)) {
            try {
                String pKey = String.valueOf(this.application.getValue("FContainerParentKey", dataChangeCommandArg.getRow()));
                Boolean isDefaultShow = Boolean.valueOf(String.valueOf(this.application.getValue("FContainerDefShow", dataChangeCommandArg.getRow())));
                if (isDefaultShow.booleanValue()) {
                    IObjectCollection containerCollection = this.application.getBillModel().getEntryData(this.application.getBillModel().getBusinessInfo().getEntity("FContainers"));
                    boolean refreshFlag = false;
                    int size = containerCollection.size();
                    for (int j = 0; j < size; ++j) {
                        if (!pKey.equalsIgnoreCase(String.valueOf(this.application.getValue("FContainerParentKey", j))) || dataChangeCommandArg.getRow() == j || !Boolean.valueOf(String.valueOf(this.application.getValue("FContainerDefShow", j))).booleanValue()) continue;
                        this.application.setValue("FContainerDefShow", (Object)Boolean.FALSE, j);
                        refreshFlag = true;
                    }
                    if (!refreshFlag) {
                        // empty if block
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        if ("FDelAttachment".equalsIgnoreCase(key)) {
            if (dataChangeCommandArg.getNewValue() == null || StringUtils.isEmpty((String)dataChangeCommandArg.getNewValue().toString()) || "false".equalsIgnoreCase(dataChangeCommandArg.getNewValue().toString())) {
                this.application.lockElement("FradioGroup", true);
                this.application.lockElement("Fradio", true);
                this.application.lockElement("Fradio1", true);
            } else {
                this.application.lockElement("FradioGroup", false);
                this.application.lockElement("Fradio", false);
                this.application.lockElement("Fradio1", false);
            }
        }
        if ("FModifyAttachment".equalsIgnoreCase(key)) {
            if (dataChangeCommandArg.getNewValue() == null || StringUtils.isEmpty((String)dataChangeCommandArg.getNewValue().toString()) || "false".equalsIgnoreCase(dataChangeCommandArg.getNewValue().toString())) {
                this.application.lockElement("FradioGroup1", true);
                this.application.lockElement("Fradio2", true);
                this.application.lockElement("Fradio3", true);
            } else {
                this.application.lockElement("FradioGroup1", false);
                this.application.lockElement("Fradio2", false);
                this.application.lockElement("Fradio3", false);
            }
        }
        if ("FModifyFTPAttachment".equalsIgnoreCase(key)) {
            if (dataChangeCommandArg.getNewValue() == null || StringUtils.isEmpty((String)dataChangeCommandArg.getNewValue().toString()) || "false".equalsIgnoreCase(dataChangeCommandArg.getNewValue().toString())) {
                this.application.lockElement("FradioGroup2", true);
                this.application.lockElement("Fradio4", true);
                this.application.lockElement("Fradio5", true);
            } else {
                this.application.lockElement("FradioGroup2", false);
                this.application.lockElement("Fradio4", false);
                this.application.lockElement("Fradio5", false);
            }
        }
        super.dataChanged(dataChangeCommandArg);
    }

    private int addTabPage(ControlAppearance ctlAp) {
        int num = 0;
        TabControlAppearance tca = (TabControlAppearance)ctlAp;
        Iterator itPages = tca.getTabPages().iterator();
        while (itPages.hasNext()) {
        }
        return num;
    }

    private void createButtonsFromMetaData(IObjectCollection entryCollection) throws EASBizException, BOSException {
        Hashtable mapfields = this.getControlFromObject(entryCollection);
        for (int j = entryCollection.size() - 1; j >= 0; --j) {
            entryCollection.removeObject(j);
        }
        int i = 0;
        for (Appearance ctl : this.layoutInfo.getControls()) {
            if (!(ctl instanceof EntityAppearance) || ctl.getControlType() != -1) continue;
            EntityAppearance entityCtl = (EntityAppearance)ctl;
            for (ControlAppearance ctlAp : entityCtl.getLayoutinfo().getControls()) {
                if (ctlAp.getControlType() != 1002 && ctlAp.getControlType() != 1014) continue;
                this.application.getBillModel().createNewEntryRow("FOpreates");
                this.application.setValue("FOpreateKey", (Object)ctlAp.getKey(), i);
                this.application.setValue("FOpreateName", (Object)ctlAp.getCaption(), i);
                ControlPolicy fld = (ControlPolicy)mapfields.get(ctlAp.getKey());
                if (fld != null) {
                    this.application.setValue("FOpreateVisible", (Object)fld.getVisible(), i);
                    this.application.setValue("FOpreateLock", (Object)fld.getLock(), i);
                } else {
                    this.application.setValue("FOpreateVisible", (Object)Boolean.FALSE, i);
                    this.application.setValue("FOpreateLock", (Object)Boolean.FALSE, i);
                }
                ++i;
            }
        }
    }

    private void createOfficeControlEntryData(IObjectCollection entryCollection) throws EASBizException, BOSException {
        Hashtable mapfields = this.getControlFromObject(entryCollection);
        for (int j = entryCollection.size() - 1; j >= 0; --j) {
            entryCollection.removeObject(j);
        }
        Boolean isHide = Boolean.FALSE;
        Boolean isLock = Boolean.FALSE;
        ControlPolicy fld = null;
        this.application.getBillModel().createNewEntryRow("FOfficeCtrlEntry");
        fld = (ControlPolicy)mapfields.get("ShowTrace");
        if (fld != null) {
            isHide = fld.getVisible();
            isLock = fld.getLock();
        } else {
            isHide = Boolean.FALSE;
            isLock = Boolean.FALSE;
        }
        this.application.setValue("FOfficeCtrlSeq", (Object)new Integer(1), 0);
        this.application.setValue("FOfficeCtrlKey", (Object)"ShowTrace", 0);
        this.application.setValue("FOfficeCtrlName", (Object)"\u663e\u793a\u7559\u75d5", 0);
        this.application.setValue("FOfficeCtrlIsHide", (Object)isHide, 0);
        this.application.setValue("FOfficeCtrlIsLock", (Object)isLock, 0);
        this.application.getBillModel().createNewEntryRow("FOfficeCtrlEntry");
        fld = (ControlPolicy)mapfields.get("SignByHand");
        if (fld != null) {
            isHide = fld.getVisible();
            isLock = fld.getLock();
        } else {
            isHide = Boolean.FALSE;
            isLock = Boolean.FALSE;
        }
        this.application.setValue("FOfficeCtrlSeq", (Object)new Integer(2), 1);
        this.application.setValue("FOfficeCtrlKey", (Object)"SignByHand", 1);
        this.application.setValue("FOfficeCtrlName", (Object)"\u624b\u5199\u7b7e\u540d", 1);
        this.application.setValue("FOfficeCtrlIsHide", (Object)isHide, 1);
        this.application.setValue("FOfficeCtrlIsLock", (Object)isLock, 1);
        this.application.getBillModel().createNewEntryRow("FOfficeCtrlEntry");
        fld = (ControlPolicy)mapfields.get("ElectroSignBill");
        if (fld != null) {
            isHide = fld.getVisible();
            isLock = fld.getLock();
        } else {
            isHide = Boolean.FALSE;
            isLock = Boolean.FALSE;
        }
        this.application.setValue("FOfficeCtrlSeq", (Object)new Integer(3), 2);
        this.application.setValue("FOfficeCtrlKey", (Object)"ElectroSignBill", 2);
        this.application.setValue("FOfficeCtrlName", (Object)"\u7535\u5b50\u7b7e\u7ae0", 2);
        this.application.setValue("FOfficeCtrlIsHide", (Object)isHide, 2);
        this.application.setValue("FOfficeCtrlIsLock", (Object)isLock, 2);
        this.application.getBillModel().createNewEntryRow("FOfficeCtrlEntry");
        fld = (ControlPolicy)mapfields.get("PrintDoc");
        if (fld != null) {
            isHide = fld.getVisible();
            isLock = fld.getLock();
        } else {
            isHide = Boolean.FALSE;
            isLock = Boolean.FALSE;
        }
        this.application.setValue("FOfficeCtrlSeq", (Object)new Integer(4), 3);
        this.application.setValue("FOfficeCtrlKey", (Object)"PrintDoc", 3);
        this.application.setValue("FOfficeCtrlName", (Object)"\u6253\u5370\u6587\u6863", 3);
        this.application.setValue("FOfficeCtrlIsHide", (Object)isHide, 3);
        this.application.setValue("FOfficeCtrlIsLock", (Object)isLock, 3);
        this.application.getBillModel().createNewEntryRow("FOfficeCtrlEntry");
        fld = (ControlPolicy)mapfields.get("RedHead");
        if (fld != null) {
            isHide = fld.getVisible();
            isLock = fld.getLock();
        } else {
            isHide = Boolean.FALSE;
            isLock = Boolean.FALSE;
        }
        this.application.setValue("FOfficeCtrlSeq", (Object)new Integer(5), 4);
        this.application.setValue("FOfficeCtrlKey", (Object)"RedHead", 4);
        this.application.setValue("FOfficeCtrlName", (Object)"\u5957\u7ea2", 4);
        this.application.setValue("FOfficeCtrlIsHide", (Object)isHide, 4);
        this.application.setValue("FOfficeCtrlIsLock", (Object)isLock, 4);
        this.application.getBillModel().createNewEntryRow("FOfficeCtrlEntry");
        fld = (ControlPolicy)mapfields.get("AcceptRevision");
        if (fld != null) {
            isHide = fld.getVisible();
            isLock = fld.getLock();
        } else {
            isHide = Boolean.FALSE;
            isLock = Boolean.FALSE;
        }
        this.application.setValue("FOfficeCtrlSeq", (Object)new Integer(6), 5);
        this.application.setValue("FOfficeCtrlKey", (Object)"AcceptRevision", 5);
        this.application.setValue("FOfficeCtrlName", (Object)"\u6e05\u7a3f", 5);
        this.application.setValue("FOfficeCtrlIsHide", (Object)isHide, 5);
        this.application.setValue("FOfficeCtrlIsLock", (Object)isLock, 5);
        this.application.getBillModel().createNewEntryRow("FOfficeCtrlEntry");
        fld = (ControlPolicy)mapfields.get("ViewHistory");
        if (fld != null) {
            isHide = fld.getVisible();
            isLock = fld.getLock();
        } else {
            isHide = Boolean.FALSE;
            isLock = Boolean.FALSE;
        }
        this.application.setValue("FOfficeCtrlSeq", (Object)new Integer(7), 6);
        this.application.setValue("FOfficeCtrlKey", (Object)"ViewHistory", 6);
        this.application.setValue("FOfficeCtrlName", (Object)"\u5386\u53f2\u7248\u672c", 6);
        this.application.setValue("FOfficeCtrlIsHide", (Object)isHide, 6);
        this.application.setValue("FOfficeCtrlIsLock", (Object)isLock, 6);
        this.application.getBillModel().createNewEntryRow("FOfficeCtrlEntry");
        fld = (ControlPolicy)mapfields.get("saveAndClose");
        if (fld != null) {
            isHide = fld.getVisible();
            isLock = fld.getLock();
        } else {
            isHide = Boolean.TRUE;
            isLock = Boolean.FALSE;
        }
        this.application.setValue("FOfficeCtrlSeq", (Object)new Integer(8), 7);
        this.application.setValue("FOfficeCtrlKey", (Object)"saveAndClose", 7);
        this.application.setValue("FOfficeCtrlName", (Object)"\u4fdd\u5b58\u5e76\u5173\u95ed", 7);
        this.application.setValue("FOfficeCtrlIsHide", (Object)isHide, 7);
        this.application.setValue("FOfficeCtrlIsLock", (Object)isLock, 7);
    }

    private void createSignEnumItem(Appearance signCtrl) {
    }

    class ControlPolicy {
        private String key;
        private boolean lock = false;
        private boolean visible = false;
        private boolean mustInput = false;
        private boolean defaultShow = false;
        private String parentKey;

        public boolean getMustInput() {
            return this.mustInput;
        }

        public void setMustInput(boolean mustInput) {
            this.mustInput = mustInput;
        }

        public ControlPolicy(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public boolean getLock() {
            return this.lock;
        }

        public void setLock(boolean lock) {
            this.lock = lock;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean getDefaultShow() {
            return this.defaultShow;
        }

        public void setDefaultShow(boolean defaultShow) {
            this.defaultShow = defaultShow;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public void setParentKey(String parentKey) {
            this.parentKey = parentKey;
        }
    }
}

