/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.extend.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;

public class AttachmentOnlineEditorMutexPlugin
extends AbstractBillPlugin {
    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        try {
            Context ctx = this.application.getContext();
            String documentId = (String)this.application.getCustomParameter("documentBosId");
            UserInfo user = (UserInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
            String operate = (String)this.application.getCustomParameter("operate");
            if (!"view".equals(operate)) {
                HashMap aMap;
                ObjectUpdateLock lockIns;
                String userName = user.getName();
                if (!MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(documentId, userName) && (lockIns = (ObjectUpdateLock)(aMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).getObjIDForUpdateList()).get(documentId + ctx.getAIS())) != null) {
                    if (this.isOverTimeLock(lockIns.getCreatedTime(), new Date()) || userName.equals(lockIns.getUserName())) {
                        MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(documentId);
                        MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(documentId, userName);
                    } else {
                        this.application.setCustomParameter("operate", (Object)"view");
                        String message = "\u5bf9\u4e0d\u8d77\uff0c{0}\u6b63\u5728\u7f16\u8f91\u6b64\u6587\u4ef6\uff0c\u5c06\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\uff01";
                        message = MessageFormat.format(message, lockIns.getUserName());
                        this.application.showMessage(message);
                    }
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return super.onInitialize(param);
    }

    public void beforeCloseForm() throws BOSException {
        try {
            String documentId = (String)this.application.getCustomParameter("documentBosId");
            MutexServiceControlFactory.getLocalInstance((Context)this.application.getContext()).releaseObjIDForUpdate(documentId);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        super.beforeCloseForm();
    }

    private boolean isOverTimeLock(Date lockDate, Date currentDate) {
        boolean flag = false;
        long mins = 60000L;
        if ((currentDate.getTime() - lockDate.getTime()) / mins >= 60L) {
            flag = true;
        }
        return flag;
    }
}

