/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.extend.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.extend.bill.BillInfo;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.BizObjectArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class AttachmentOnlineEditorPlugin
extends AbstractBillPlugin {
    private static final String NODECONTROLBOSTYPE = "30551B26";
    private static final String OFFICEKEY = "Foffice";
    private String layoutId;
    private String nodeId;
    private String flowId;
    private String flowTemplateId = null;
    private String billPk;

    public void createNewData(BizObjectArg arg) throws EASBizException, BOSException {
        arg.setBizObject((IObjectValue)new BillInfo());
    }

    private boolean hasHistoryDoc(String billID) {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from T_BAS_BillAttachment bb");
        sql.append(" where bb.FBillId = '" + billID + "' ");
        sql.append(" and exists (");
        sql.append(" \tselect fid from t_bas_OfficeHistory oh");
        sql.append("     where oh.fattachmentid = bb.fid)");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)this.application.getContext(), (String)sql.toString());
            result = rows != null && rows.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void afterBindData() throws EASBizException, BOSException {
        this.application.setControlProperty(OFFICEKEY, "billId", null);
        StringBuffer attachInfo = new StringBuffer();
        UserInfo user = (UserInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
        attachInfo.append(new Integer(1)).append(",").append(this.application.getCustomParameter("documentBosId")).append(",").append(this.application.getCustomParameter("attachmentType")).append(",").append(this.application.getCustomParameter("billId")).append(",").append(this.application.getCustomParameter("extName")).append(",").append(user.getName()).append(",").append(this.application.getCustomParameter("officeHistoryId")).append(",").append(this.application.getCustomParameter("operate"));
        if (this.application.getCustomParameter("extName") != null && this.application.getCustomParameter("extName").toString().indexOf("doc") > -1) {
            attachInfo.append(",").append(this.hasHistoryDoc(String.valueOf(this.application.getCustomParameter("billId"))) ? 1 : 0);
        } else {
            attachInfo.append(",").append(0);
        }
        attachInfo.append(",").append("DRAFT".equalsIgnoreCase(this.flowId) ? 1 : 0);
        this.application.setControlProperty(OFFICEKEY, "attachmentInfo", (Object)attachInfo.toString());
        try {
            this.applyOfficeControlPolicy();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" try {window.moveTo(0, 0); ");
        sb.append("window.resizeTo(screen.availWidth, screen.availHeight); } catch(e){}");
        this.executeScript(sb.toString());
        super.afterBindData();
    }

    private void applyOfficeControlPolicy() throws EASBizException, BOSException, JSONException {
        String pk = this.getPk();
        IObjectValue objectValue = null;
        if (pk != null) {
            objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
            String operate = (String)this.application.getCustomParameter("operate");
            if ("edit".equalsIgnoreCase(operate)) {
                UserInfo user = (UserInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
                JSONObject officeSetting = new JSONObject();
                officeSetting.put("fileOpen", (Object)this.getSpecifiedBooleanProp(objectValue, "allowImportOtherFile", Boolean.FALSE));
                officeSetting.put("fileSaveAs", (Object)this.getSpecifiedBooleanProp(objectValue, "allowSaveAs", Boolean.FALSE));
                Boolean notAllowEdit = this.getSpecifiedBooleanProp(objectValue, "notAllowEdit", Boolean.FALSE);
                Boolean editable = Boolean.FALSE.equals(notAllowEdit) ? Boolean.TRUE : Boolean.FALSE;
                Boolean allowCopy = this.getSpecifiedBooleanProp(objectValue, "allowCopy", Boolean.FALSE);
                officeSetting.put("docEditable", (Object)editable);
                officeSetting.put("officeMenu", (Object)editable);
                officeSetting.put("userName", (Object)user.getName());
                officeSetting.put("trackRevision", true);
                officeSetting.put("noCopy", (Object)(allowCopy == true ? new Boolean(false) : new Boolean(true)));
                officeSetting.put("saveAndClose", (Object)this.getSpecifiedBooleanProp(objectValue, "saveAndClose", Boolean.FALSE));
                this.application.setControlProperty(OFFICEKEY, "officeSetting", (Object)officeSetting);
                if (objectValue != null) {
                    this.applyOfficeControlTbarPolicy(OFFICEKEY, (IObjectCollection)objectValue.get("officeControlEntrys"));
                }
            }
        }
    }

    private void applyOfficeControlTbarPolicy(String officeKey, IObjectCollection buttons) {
        JSONArray disabledButtons = new JSONArray();
        JSONArray invisibleButtons = new JSONArray();
        for (IObjectValue button : buttons) {
            Object key = button.get("key");
            if (key == null) continue;
            if (button.getBoolean("isHide")) {
                invisibleButtons.put(key);
            }
            if (!button.getBoolean("isLock")) continue;
            disabledButtons.put(key);
        }
        if (invisibleButtons.length() > 0) {
            this.application.setControlProperty(officeKey, "invisibleButtons", (Object)invisibleButtons);
        }
        if (disabledButtons.length() > 0) {
            this.application.setControlProperty(officeKey, "disabledButtons", (Object)disabledButtons);
        }
    }

    private Boolean getSpecifiedBooleanProp(IObjectValue nodeSetting, String propName, Boolean bDefault) {
        Boolean prop = bDefault;
        if (nodeSetting != null) {
            prop = (Boolean)nodeSetting.get(propName);
        }
        return prop;
    }

    private boolean isAddNew() {
        return OperationStatus.ADDNEW.equals(this.application.getBillView().getOperationStatus());
    }

    private String getPk() {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("layoutId", (Object)this.layoutId);
        if ("-1".equals(this.nodeId)) {
            this.flowId = "DRAFT";
        }
        if (this.flowId != null) {
            filter.appendFilterItem("flowId", (Object)this.flowId);
        }
        filter.appendFilterItem("flowNodeId", (Object)this.nodeId);
        filter.appendFilterItem("templateId", (Object)this.flowTemplateId);
        try {
            IObjectPK[] pks = DAOHelper.getDAO().getPKList(this.application.getContext(), BOSObjectType.create((String)NODECONTROLBOSTYPE), filter, null);
            if (pks.length > 0) {
                return pks[0].toString();
            }
            return null;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        this.billPk = param.billPk;
        if (this.billPk == null) {
            this.billPk = param.wfState.getBillID();
        }
        this.layoutId = (String)this.application.getCustomParameter("pLayoutId");
        this.nodeId = (String)this.application.getCustomParameter("nodeId");
        this.flowId = (String)this.application.getCustomParameter("flowId");
        this.flowTemplateId = (String)this.application.getCustomParameter("pflowTempId");
        if (this.flowId == null) {
            this.nodeId = "-1";
            this.flowId = "DRAFT";
        }
        if (this.nodeId == null) {
            this.nodeId = "-1";
        }
        return super.onInitialize(param);
    }
}

