/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.extend.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.util.StringUtil;
import com.kingdee.eas.base.form.util.UnifiedEnumUtils;
import com.kingdee.eas.base.form.web.DynamicWebFormState;
import com.kingdee.eas.base.form.web.WebBillEditPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DataConverter;
import java.util.List;
import java.util.Vector;

public class RedHeadDataProviderPlugin
extends AbstractBillPlugin {
    public void afterBindData() throws EASBizException, BOSException {
        JSONObject redData = new JSONObject();
        WebBillEditPanel editPanel = (WebBillEditPanel)this.application.getDynamicFormView();
        BusinessInfo businessInfo = editPanel.businessInfo;
        LayoutInfo layoutInfo = editPanel.layoutInfo;
        DynamicWebFormState state = editPanel.comState;
        List formEntity = businessInfo.getEntrys();
        for (Entity entity : formEntity) {
            if (entity.getEntityType() != 0) continue;
            Vector fields = entity.getFields();
            int j = fields.size();
            for (int i = 0; i < j; ++i) {
                Field field = (Field)fields.get(i);
                String key = field.getKey();
                Object value = this.getDisplayValue(state, layoutInfo, key);
                try {
                    redData.put(key, value);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (redData.length() <= 0) break;
            try {
                StringBuffer sb = new StringBuffer(400);
                sb.append("if(!KD.RedProvider) KD.RedProvider={};\n");
                sb.append("KD.RedProvider['data'] = '").append(redData.toString()).append("';\n");
                state.outputDynmaicAction(sb.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    private Object getDisplayValue(DynamicWebFormState state, LayoutInfo layoutInfo, String fieldKey) {
        Object disValue = null;
        WebBillEditPanel editPanel = (WebBillEditPanel)this.application.getDynamicFormView();
        BusinessInfo businessInfo = editPanel.businessInfo;
        try {
            FieldAppearance fld = layoutInfo.getFieldAppearance(fieldKey);
            JSONObject fieldState = state.getField(fieldKey);
            if (fld != null) {
                int fieldType = fld.getElementType();
                switch (fieldType) {
                    case 7: 
                    case 13: 
                    case 17: 
                    case 18: 
                    case 27: 
                    case 10007: 
                    case 10012: {
                        disValue = fieldState.get(DynamicWebFormState.FS_NAME);
                        break;
                    }
                    case 9: {
                        EnumObject enumObj = businessInfo.getEnumInfo().get(String.valueOf(businessInfo.getField(fieldKey).getEnumType()));
                        try {
                            disValue = UnifiedEnumUtils.getDisplayString((EnumObject)enumObj, (int)fieldType, (Object)fieldState.get(DynamicWebFormState.FS_VALUE));
                        }
                        catch (DataConverter.DataConvertException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 30: {
                        String vaule = fieldState.get(DynamicWebFormState.FS_VALUE) == null ? "" : fieldState.get(DynamicWebFormState.FS_VALUE).toString();
                        disValue = StringUtil.formatAssistData((String)vaule, (Context)this.application.getContext());
                        break;
                    }
                    case 14: 
                    case 23: 
                    case 24: 
                    case 32: {
                        disValue = fieldState.get(DynamicWebFormState.FS_VALUE);
                        break;
                    }
                    default: {
                        disValue = fieldState.get(DynamicWebFormState.FS_VALUE);
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return disValue;
    }
}

